/* 
 *	Test.xs
 *
 *  The SendKeys function is based on the Delphi sourcecode
 *	published by Al Williams <http://www.al-williams.com/awc/> 
 *	in Dr.Dobbs <http://www.ddj.com/ddj/1997/careers1/wil2.htm>
 *	
 *	Copyright (c) 1998 by Ernesto Guisado <erngui@acm.org>
 *
 *  You may distribute under the terms of either the GNU General Public
 *  License or the Artistic License.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif


#define WIN32_LEAN_AND_MEAN
#include <windows.h>

int cvtkey(
	const char* s,
	int i, 
	int *key,
    int *count, 
	int* len,
    int* letshift,
    int* shift, 
	int* letctrl,
    int* ctrl, 
	int* letalt,
    int* alt, 
	int* shiftlock
	);


#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


/* symbol table record */
typedef struct tokentable {
   char *token;
   int vkey;
} tokentable;


/* global symbol table */
tokentable tbl[22];
int tbllen;


/* Get a number from the input string */
int GetNum(
	const char*s ,
	int i,
	int* len
	)
{
	int res;
	int pos = 0;  
    char* tmp = (char*)safemalloc(strlen(s)+1);
    strcpy(tmp, s);
    OutputDebugString(tmp);
    OutputDebugString("GetNum2\n");
	while (s[i]>='0' && s[i]<='9') {
		tmp[pos++] = s[i++];
		(*len)++;
	}
    OutputDebugString("GetNum3\n");
	tmp[pos] = '\0';
	res = atoi(tmp);
    OutputDebugString("GetNum4\n");
	free(tmp);
    OutputDebugString("GetNum5\n");
	return res;
}



/* Process braced characters */
void procbrace(
	const char* s, 
	int i,
    int *key, 
	int *len,
    int *count, 
	int *letshift,
    int *letctrl,
	int *letalt,
    int *shift,
	int *ctrl,
    int *alt,
	int *shiftlock)
{
    int j,k,m;
	char* tmp = (char*)safemalloc(strlen(s)+1);
    strcpy(tmp, s);

    *count=1;
	/* 3 cases: x, xxx, xxx ## */
	/* if single character case */
	if (s[i+2]=='}' || s[i+2]==' ') {
		if (s[i+2]==' ') {      /* read count if present */
			*count=GetNum(s,i+3,len);
			(*len)++;
		}
		(*len)+=2;
		/* convert quoted key */
		*key= s[i+1];
		/* convert key -- pass -1 to prevent special interp. */
		cvtkey(s,-1,key,count,len,letshift,shift,
			letctrl,ctrl,letalt,alt,shiftlock);
    }
    else {  /* multicharacter sequence */
	
		*letshift=FALSE;
		*letctrl =FALSE;
		*letalt  =FALSE;
		
		/* find next brace or space */
		j=1;
		m = 0;
		while (s[i+j]!=' ' && s[i+j]!='}') {
		  tmp[m++]= s[i+j];
		  j++;
		  (*len)++;
		}
		tmp[m]='\0';
		
		if (s[i+j]==' ') {  /* read count */
		  *count=GetNum(s,i+j+1,len);
		  (*len)++;
		}
		(*len)++;
		
		/*check for special tokens*/
		for (k=0;k<(int)strlen(tmp); k++)
			tmp[k]=toupper(tmp[k]);
		
		if (tmp[0]=='F') {  /* F Keys */
			*key=GetNum(tmp,2,&j)+VK_F1-1;
		}

		/* chop token to 3 characters or less */
		if (strlen(tmp)>3) 
			tmp[3]='\0';

		/* handle pause specially */
		if (strcmp(tmp,"PAU")==0) {
            OutputDebugString("Found PAUSE\n");
			Sleep(*count);
			*key=0;
			free(tmp);
			return;
		}
		
		/* find entry in table */
		*key=0;
		for (j=0;j<tbllen;j++) {
			if (strcmp(tbl[j].token,tmp)==0) {
				*key=tbl[j].vkey;
				break;
			}
		}

		/* if key=0 here then something is bad */
	} /* end of token processing */

	free(tmp);
}

/* Wrapper around kebyd_event */
void keybd(int vk, int down)
{
	int scan;
	int flg;

	scan=MapVirtualKey(vk,0);  /* find VK */
	if (down)
		flg=0;
	else
		flg=KEYEVENTF_KEYUP;
	keybd_event(vk,scan,flg,0);
}

int cvtkey(
	const char* s,
	int i, 
	int *key,
    int *count, 
	int* len,
    int* letshift,
    int* shift, 
	int* letctrl,
    int* ctrl, 
	int* letalt,
    int* alt, 
	int* shiftlock
	)
{
	int rv;
	char c;
	int Result=FALSE;
	
	/* if i==-1 then supress special processing */
	if (i!=-1) { 
	  *len=1;
	  *count=1;
	}
	if (i!=-1)
		c=s[i];
	else 
		c=0;

	/* scan for special character */
    switch (c) {
    case '{': 
		procbrace(s,i,key,len,count,letshift,
			letctrl,letalt,shift,ctrl,alt,shiftlock);
        if (*key==0)
			return TRUE;
		break;
	case '~': *key=VK_RETURN; break;
    case '+': *shift=TRUE; Result=TRUE; break;
    case '^': *ctrl=TRUE; Result=TRUE; break;
    case '%': *alt=TRUE; Result=TRUE; break;
    case '(': *shiftlock=TRUE; Result=TRUE; break;
    case ')': *shiftlock=FALSE; Result=TRUE; break;
	default:
       if (c==0)
		   c=(char)*key;
       rv=VkKeyScan(c);  /* normal character */
       *key=rv & 0xFF;
       *letshift=((rv & 0x100)==0x100);
       *letctrl =((rv & 0x200)==0x200);
       *letalt  =((rv & 0x400)==0x400);
	};

	return Result;
}


static void init() {
  tbl[0].token="BAC";
  tbl[0].vkey=VK_BACK;
  tbl[1].token="BS";
  tbl[1].vkey=VK_BACK;
  tbl[2].token="BKS";
  tbl[2].vkey=VK_BACK;
  tbl[3].token="BRE";
  tbl[3].vkey=VK_CANCEL;
  tbl[4].token="CAP";
  tbl[4].vkey=VK_CAPITAL;
  tbl[5].token="DEL";
  tbl[5].vkey=VK_DELETE;
  tbl[6].token="DOW";
  tbl[6].vkey=VK_DOWN;
  tbl[7].token="END";
  tbl[7].vkey=VK_END;
  tbl[8].token="ENT";
  tbl[8].vkey=VK_RETURN;
  tbl[9].token="ESC";
  tbl[9].vkey=VK_ESCAPE;
  tbl[10].token="HEL";
  tbl[10].vkey=VK_HELP;
  tbl[11].token="HOM";
  tbl[11].vkey=VK_HOME;
  tbl[12].token="INS";
  tbl[12].vkey=VK_INSERT;
  tbl[13].token="LEF";
  tbl[13].vkey=VK_LEFT;
  tbl[14].token="NUM";
  tbl[14].vkey=VK_NUMLOCK;
  tbl[15].token="PGD";
  tbl[15].vkey=VK_NEXT;
  tbl[16].token="PGU";
  tbl[16].vkey=VK_PRIOR;
  tbl[17].token="PRT";
  tbl[17].vkey=VK_SNAPSHOT;
  tbl[18].token="RIG";
  tbl[18].vkey=VK_RIGHT;
  tbl[19].token="SCR";
  tbl[19].vkey=VK_SCROLL;
  tbl[20].token="TAB";
  tbl[20].vkey=VK_TAB;
  tbl[21].token="UP";
  tbl[21].vkey=VK_UP;
  tbllen=22;
}

typedef struct windowtable {
  int size;
  HWND* windows/*[1024]*/;
} windowtable; 


BOOL CALLBACK AddWindowChild(
  HWND hwnd,    // handle to child window
  LPARAM lParam // application-defined value
)
{
  HWND* grow;
  windowtable* children = (windowtable*)lParam;
  /* Need to grow the table to make space for the next entry */
  if (children->windows)
      grow = (HWND*)saferealloc(children->windows, (children->size+1)*sizeof(HWND));
  else
      grow = (HWND*)safemalloc((children->size+1)*sizeof(HWND));
  if (grow == 0)
    return FALSE;
  children->windows = grow;
  children->size++;
  children->windows[children->size-1] = hwnd;
  return TRUE;
}

MODULE = Win32::GuiTest		PACKAGE = Win32::GuiTest		

PROTOTYPES: DISABLE

void
SendKeys(s)
     char* s
     PREINIT:
	int i,j;
	char c;
	int key;
	int count;

	/* init */
	int len=1;
	int shiftlock=FALSE;
	int letalt=FALSE;
	int alt=FALSE;
	int letctrl=FALSE;
	int ctrl=FALSE;
	int letshift=FALSE;
	int shift=FALSE;
	
	static int inited = FALSE;
	
     CODE:
     	if (!inited)
		init();
	
	/* for each character in string */
	for (i = 0; i < (int)strlen(s); i++) {
		
		if (len!=1) {  /* skip characters on request */
			len--;
			continue;
		}
		c=s[i];
		
		/* convert key */
		if (cvtkey(s,i,&key,&count,&len,&letshift,&shift,
			  &letctrl,&ctrl,&letalt,&alt,&shiftlock))
		  continue;
		
		/* fake modifier keys */
		if (shift || letshift) 
			keybd(VK_SHIFT,TRUE);
		if (ctrl || letctrl)
			keybd(VK_CONTROL,TRUE);
		if (alt || letalt)
			keybd(VK_MENU,TRUE);
		
		/* do requested number of keystrokes */
		for (j=0; j<count; j++) {
		  keybd(key,TRUE);
		  keybd(key,FALSE);
		  Sleep(50); /* wait 50ms*/
		}

		/* clear modifiers unless locked */
		if (alt || letalt && !shiftlock)
		   keybd(VK_MENU,FALSE);
		if (ctrl || letctrl && !shiftlock)
		   keybd(VK_CONTROL,FALSE);
		if (shift || letshift && !shiftlock)
		   keybd(VK_SHIFT,FALSE);
		if (!shiftlock) {
		  alt=FALSE;
		  ctrl=FALSE;
		  shift=FALSE;
		}
	}



HWND
GetDesktopWindow()
    CODE:
        RETVAL = GetDesktopWindow();
    OUTPUT:
	    RETVAL


HWND
GetWindow(hwnd, uCmd)
    HWND hwnd
    UINT uCmd
    CODE:
        RETVAL = GetWindow(hwnd, uCmd);
    OUTPUT:
	    RETVAL


SV*
GetWindowText(hwnd)
    HWND hwnd
    CODE:
        SV* sv;
        char text[255];
        int r;
        r = GetWindowText(hwnd, text, 255);
        RETVAL = newSVpv(text, r);
    OUTPUT:
        RETVAL

SV*
GetClassName(hwnd)
    HWND hwnd
    CODE:
        SV* sv;
        char text[255];
        int r;
        r = GetClassName(hwnd, text, 255);
        RETVAL = newSVpv(text, r);
    OUTPUT:
        RETVAL

HWND
GetParent(hwnd)
    HWND hwnd
    CODE:
        RETVAL = GetParent(hwnd);
    OUTPUT:
        RETVAL

long
GetWindowLong(hwnd, index)
    HWND hwnd
    int index
    CODE:
        RETVAL = GetWindowLong(hwnd, index);
    OUTPUT:
        RETVAL
        
    
BOOL 
SetForegroundWindow(hWnd)
    HWND hWnd
    CODE:
        RETVAL = SetForegroundWindow(hWnd);
    OUTPUT:
        RETVAL

HWND 
SetFocus(hWnd)
    HWND hWnd
    CODE:
        RETVAL = SetFocus(hWnd);
    OUTPUT:
        RETVAL

void
GetChildWindows(hWnd)
    HWND hWnd;
    PREINIT:
	    BOOL enum_ok;          
        windowtable children;
        int i;
        char buf[512];
    PPCODE:
	    children.size    = 0;
        children.windows = 0;
        EnumChildWindows(hWnd, (WNDENUMPROC)AddWindowChild, (LPARAM)&children);
        for (i = 0; i < children.size; i++) {
	        XPUSHs(sv_2mortal(newSViv((IV)children.windows[i])));
        }
		safefree(children.windows);
        
