#!/usr/bin/perl

=pod

=head1 RandomLogo

version 1.0
by P.D. Magnus
pmagnus@fecundity.com
original script 3/99
this version 8/20/99
Copyright (c) 1999. All rights reserved.
This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

This script generates a random logo for the fecundity.com homepage.
Obviously not much use to you as is, I provide it as a sample of how the FontMonkey module can be used.

=cut

use FontMonkey::Image;
use strict;

my @layouts =
('horiz',		#0
'vert',			#1
'circle',		#2
'spiral',		#3
'spirlcc',		#4
'sine',			#5
'frame',		#6
'box',			#7
);

my @fonts =
('basic',		#0
'digital',		#1
'typewriter',	#2
'counter',		#3
'semaphore',	#4
);

my @styles =
(
# message, layout, font, transparent

['fecundity_com', 0, 0, 0],
['moc_fecundity_', 2, 0, 0],
['fecundity_com___', 3, 0, 0],
['moc_ytidnucef___', 4, 0, 0],
['_fecundity_com_', 5, 0, 0],
['fecundity_moc_tod', 6, 0, 0],
['com_ytidnucef', 6, 0, 0],
['fecundity', 7, 0, 0],

['fecundity_com', 0, 1, 0],
['_fecundity_com_', 0, 1, 1],
['fecundity-dot-com', 0, 1, 1],

['fecundity_com', 0, 2, 0],
['m_ytidnucef---co', 2, 2, 0],
['com_ytidnucef___', 3, 2, 0],
['___fecundity_moc___', 4, 2, 0],
['fecundity-dot-com', 5, 2, 0],
['fecundity_moc', 6, 2, 0],
['fecundity__dot__com_', 7, 2, 0],

['fecundity', 0, 4, 1],
['fecundity', 5, 4, 1],
['fnord', 6, 4, 1],
['0', 0, 4, 1],
);

srand;
my $n = int(rand($#styles + 1));

(FontMonkey::Image->newmsg($styles[$n][0], $layouts[$styles[$n][1]], $fonts[$styles[$n][2]], $styles[$n][3]))->render;
