/*
 *	cleanps.c
 *
 *  Program to clean up System 7.0 (LaserPrep 71) (and other) PostScript files.
 *  Current functions:
 *	Delete LaserPrep section (the "ProcSet")
 *	Delete all font definitions (optional)
 *	Delete %%EOF lines
 *	Is wary of very long lines
 *	Breaks long lines at spaces (if possible)
 *  Future Functions:
 *	Delete specific font definitions (optional)
 *	Insert a bounding box
 *	Translate weird (non-printing) characters
 *
 *  Written  08/16/91 asf - (Adam Fedor) fedor@boulder.colorado.edu
 *
 *  Copyright (C) 1991 Adam S. Fedor.  This program may be freely copied
 *	modified or inserted into other programs provided proper credit is
 *	given to the author(s).  There is no expressed or implied warrenty for
 *	this program.
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <string.h>

#define VERSION		1.0
#define FALSE		0
#define TRUE		~FALSE
#define MAXARRAY	30
#define MAXLINE		300
#define BeginProc	"%%BeginProcSet"
#define EndProc		"%%EndProcSet"
#define BeginFont	"%%BeginFont"
#define EndFont		"%%EndFont"
#define Eof		"%%EOF"
#define BoundingBox	"%%BoundingBox"

FILE                    *outfp, *infp;

main(argc, argv)
int argc;
char *argv[];
{
char	ch, *nl, buffer[MAXLINE];
char	*filename, outfile[MAXARRAY], ext[MAXARRAY];
int	count, printing, breakit, cleanfonts;

  cleanfonts = FALSE;
  while (--argc > 0 && (*++argv)[0] == '-')
    while (ch = *++argv[0])
      switch (ch) {
      case 'f':
 	cleanfonts = TRUE;	
	break;
      case 'h':
	help();
	return 0;
	break;
      default:
	fprintf(stderr, "CLEANPS: unknown option: %c\n", ch);
	help();
	return -1;
	break;
      }
  filename = argv[0];

  strcpy(ext, ".clean");
  strcpy(outfile, filename);
  if (! strchr(outfile, '.') == NULL)
    strcpy(strchr(outfile, '.'), ext);
  else
    strcat(outfile, ext);
  if ((infp = fopen(filename, "r")) == NULL) {
    printf ("CLEANPS: can't open %s \n", filename);
    return -1;
  }
  if ((outfp = fopen(outfile, "w")) == NULL) {
    printf ("CLEANPS: can't create output file %s \n", outfile);
    return -1;
  }

  /* main loop */
  printing = TRUE;
  breakit = FALSE;
  while ((fgets(buffer, MAXLINE, infp)) != NULL) {
    /* suppress all unwanted lines */
    if (strncmp(buffer, BeginProc, strlen(BeginProc)) == 0)
      printing = FALSE;
    if (strncmp(buffer, EndProc, strlen(EndProc)) == 0) {
      printing = TRUE;
      fgets(buffer, MAXLINE, infp);
    }
    if (cleanfonts && (strncmp(buffer, BeginFont, strlen(BeginFont)) == 0))
      printing = FALSE;
    if (cleanfonts && (strncmp(buffer, EndFont, strlen(EndFont)) == 0)) {
      printing = TRUE;
      /* fputs("bn\n", outfp); */
      fgets(buffer, MAXLINE, infp);
    }

    /* if we didn't find a newline, try to break the line */
    if (strchr(buffer, '\n') == NULL) {
      if ((nl = strrchr(buffer, ' ')) != NULL) {
	nl[0] = '\n';
      } else {
	/* can't find a break point, break it anywhere */
        breakit = TRUE; 
      }
    }
      
    if (printing && (strncmp(buffer, Eof, strlen(Eof)) != 0)) {
      fputs(buffer, outfp);
      if (breakit) {
	fputc('\n', outfp);
	printf ("CLEANPS: Line to long - line broken: %s\n", buffer);
      }
    }
    breakit = FALSE;
  } /* while */
} /* main */


help(){
  fprintf(stderr, "Usage: cleanps [-hf] file\n");
  fprintf(stderr, "  -f  clean out all loaded fonts\n");
  fprintf(stderr, "  -h  print help \n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Output has extention '.clean' \n");  
}


/********************************** eof *********************************/
