---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, \appendix
---

# Comment obtenir des annexes ?

## Avec les commandes de base

LaTeX fournit un mécanisme extrêmement simple pour les annexes : la commande 
`\appendix`. Celle-ci fait passer le document de la génération de sections 
(dans la classe <ctanpkg:article>) ou de chapitres (dans les classes 
<ctanpkg:report> et <ctanpkg:book>) à la génération d'annexes. La numérotation
des sections ou chapitres est réinitialisée et la représentation du compteur 
passe en mode alphabétique. Voici un exemple pour la classe <ctanpkg:article>.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\tableofcontents
\section{L'idée}
(...)
\section{Conséquences}
(...)
\appendix
\section{Génèse de l'idée}
(...)
\end{document}
```

Cette méthode suffit pour des besoins ordinaires. Notez cependant qu'une fois
que vous êtes passé dans les annexes, LaTeX ne vous offre aucun moyen 
de revenir en arrière : une fois que vous avez une annexe, vous ne pouvez plus
avoir une commande `\section` ou `\chapter` ordinaire.


## Avec l'extension <ctanpkg:appendix>

L'extension <ctanpkg:appendix> propose plusieurs fonctionnalités 
un peu plus avancées. Elle permet par défaut d'avoir un titre introduisant 
les annexes, à la fois dans le corps du document et dans la table des matières.
Ceci s'obtient par :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{appendix}

  \renewcommand{\appendixpagename}{Annexes}
  \renewcommand{\appendixtocname}{Annexes}
  
\begin{document}
\tableofcontents
\section{L'idée}
(...)
\section{Conséquences}
(...)
\appendix
\appendixpage
\addappheadtotoc
\section{Génèse de l'idée}
(...)
\end{document}
```

La commande `\appendixpage` ajoute par défaut le titre "Appendices" 
au-dessus de la première annexe, tandis que la commande `\addappheadtotoc` 
insère ce titre dans la table des matières. Ces modifications simples 
couvrent les besoins de nombreuses personnes en matière d'annexes. 
Toutefois, pour un utilisateur français, il convient d'ajouter 
les deux redéfinitions pour franciser (ou modifier) les titres par défaut.

L'extension fournit également un environnement `appendices`. 
L'environnement est en particulier contrôlé par les options de l'extension. 
L'exemple précédent serait obtenu avec le code suivant :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[toc,page]{appendix} 

  \renewcommand{\appendixpagename}{Annexes}
  \renewcommand{\appendixtocname}{Annexes}
  
\begin{document}
\tableofcontents
\section{L'idée}
(...)
\section{Conséquences}
(...)
\begin{appendices}
\section{Génèse de l'idée}
(...)
\end{appendices}
\end{document}
```

Mais voici le point le plus intéressant de cet environnement : une fois 
qu'il est clos, vous pouvez reprendre votre utilisation normale 
des sections ou des chapitres. La numérotation n'est pas affectée 
par les annexes intermédiaires.

L'extension propose une manière alternative de définir des annexes, 
en tant que divisions inférieures dans le document. L'environnement 
`subappendices` vous permet de placer des annexes séparées 
pour une section particulière, codée à l'image de la commande 
`\subsection`, ou pour un chapitre particulier, codée à l'image de 
`\section`. On pourrait donc écrire :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{appendix}

\begin{document}
\section{L'idée}
(...)
\begin{subappendices}
\subsection{Génèse de l'idée}
(...)
\end{subappendices}
\section{Conséquences}
(...)
\end{document}
```

Cette extension offre d'autres possibilités : la 
[documentation](texdoc:appendix) de l'extension apporte 
plus d'informations.


## Avec les classes <ctanpkg:memoir> et <ctanpkg:KOMA-script>

:::{todo} Ajouter un exemple
:::

La classe <ctanpkg:memoir> inclut les fonctionnalités de l'extension 
<ctanpkg:appendix> et les classes <ctanpkg:KOMA-script> proposent 
une commande `\appendixprefix` pour modifier l'apparence des annexes.


:::{sources}
[Appendixes](faquk:FAQ-appendix)
:::