/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.Predictor;

public class FlateFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(FlateFilter.class);
    private static final int BUFFER_SIZE = 16384;

    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase baseObj = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary dict = null;
        if (baseObj instanceof COSDictionary) {
            dict = (COSDictionary)baseObj;
        } else if (baseObj instanceof COSArray) {
            COSArray paramArray = (COSArray)baseObj;
            if (filterIndex < paramArray.size()) {
                dict = (COSDictionary)paramArray.getObject(filterIndex);
            }
        } else if (baseObj != null) {
            throw new IOException("Error: Expected COSArray or COSDictionary and not " + baseObj.getClass().getName());
        }
        int predictor = -1;
        if (dict != null) {
            predictor = dict.getInt(COSName.PREDICTOR);
        }
        try {
            if (predictor > 1) {
                int colors = Math.min(dict.getInt(COSName.COLORS, 1), 32);
                int bitsPerPixel = dict.getInt(COSName.BITS_PER_COMPONENT, 8);
                int columns = dict.getInt(COSName.COLUMNS, 1);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.decompress(compressedData, baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                Predictor.decodePredictor(predictor, colors, bitsPerPixel, columns, bais, result);
                result.flush();
                baos.reset();
                bais.reset();
            } else {
                this.decompress(compressedData, result);
            }
        }
        catch (DataFormatException exception) {
            LOG.error((Object)"FlateFilter: stop reading corrupt stream due to a DataFormatException");
            IOException io = new IOException();
            io.initCause(exception);
            throw io;
        }
    }

    private void decompress(InputStream in, OutputStream out) throws IOException, DataFormatException {
        byte[] buf = new byte[2048];
        in.read(buf, 0, 2);
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater(true);
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[1024];
            boolean dataWritten = false;
            while (true) {
                int resRead = 0;
                try {
                    resRead = inflater.inflate(res);
                }
                catch (DataFormatException exception) {
                    if (dataWritten) {
                        LOG.warn((Object)"FlateFilter: premature end of stream due to a DataFormatException");
                        break;
                    }
                    throw exception;
                }
                if (resRead != 0) {
                    out.write(res, 0, resRead);
                    dataWritten = true;
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
            inflater.end();
        }
        out.close();
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(result);
        int amountRead = 0;
        int mayRead = rawData.available();
        if (mayRead > 0) {
            byte[] buffer = new byte[Math.min(mayRead, 16384)];
            while ((amountRead = rawData.read(buffer, 0, Math.min(mayRead, 16384))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        result.flush();
    }
}

