import java.util.ArrayList;
import java.util.Arrays;

import com.sun.javadoc.*;

/**
 * In einer Tabelle mit Vererbungen werden diejenigen Felder und Methoden aufgelistet, die eine Klasse von ihren Superclassen vererbt bekommt.
 * @author Jolle
 * @since 13.05.2008
 * @version 1.0
 * 
 */
public class InhTable {

	/**
	 * In dieser Liste werden die einzelnen Eintrge abgelegt.
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	private ArrayList<InhEntry> tabelle = new ArrayList<InhEntry>();
	
	/**
	 * Erstellt die Tabelle aus den public und protected Elementen einer bergeordneten Klasse
	 * @param parent die bergeordenete Klasse
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	public void addEntries( ClassDoc parent ){
		for( FieldDoc fd : parent.fields(false) ){
			if( fd.isProtected() || fd.isPublic() ){
				tabelle.add( new InhEntry(fd, parent) );		
			}
		}
		for( MethodDoc md : parent.methods(false) ){
			if( md.isProtected() || md.isPublic() ){
				tabelle.add( new InhEntry(md, parent) );		
			}
		}
	}
	
	/**
	 * Sortiert die Tabelle zuerst nach Feld/Methode, dann nach Vererber, dann nach alphanumerischer Ordnung
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	public void sortTable(){
		InhEntry[] arrayFromTable = tabelle.toArray(new InhEntry[0]);
		Arrays.sort(arrayFromTable);
		tabelle.clear();
		for( InhEntry ie : arrayFromTable ){
			tabelle.add(ie);
		}
	}
	
	/**
	 * Gibt eine Zeichenkette mit allen Eintrgen zurck
	 * @author Jolle
	 * @since Version 1.0 vom 13.05.2008
	 * @return der ganze Tabelleninhalt als String
	 */
	public String getTexTableEntries(){
		StringBuffer allTableEntries = new StringBuffer();
		for(InhEntry ie : tabelle ){
			allTableEntries.append( ie.getTexTableEntry() +"\n");
		}
		return allTableEntries.toString();
	}
	
}
