/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FillUnit;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import java.io.IOException;

public class TeXGlue
extends AbstractTeXObject
implements TeXDimension,
Expandable {
    private TeXDimension fixed = new UserDimension();
    private TeXDimension stretch;
    private TeXDimension shrink;

    public TeXGlue() {
        this.shrink = null;
        this.stretch = null;
    }

    public TeXGlue(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        this.setDimension(teXParser, teXDimension);
    }

    public TeXGlue(TeXParser teXParser, TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3) throws TeXSyntaxException {
        this.setFixed(teXParser, teXDimension);
        this.setStretch(teXParser, teXDimension2);
        this.setShrink(teXParser, teXDimension3);
    }

    @Override
    public Object clone() {
        TeXGlue teXGlue = new TeXGlue();
        try {
            teXGlue.setFixed(null, this.fixed);
            teXGlue.setShrink(null, this.shrink);
            teXGlue.setStretch(null, this.stretch);
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
        return teXGlue;
    }

    @Override
    public float getValue() {
        return this.fixed.getValue();
    }

    @Override
    public TeXUnit getUnit() {
        return this.fixed.getUnit();
    }

    @Override
    public void setDimension(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        if (teXDimension instanceof DimenRegister) {
            this.setDimension(teXParser, ((DimenRegister)teXDimension).getDimension());
        } else if (teXDimension instanceof TeXGlue) {
            TeXGlue teXGlue = (TeXGlue)teXDimension;
            this.fixed.setDimension(teXParser, teXGlue.fixed);
            if (this.shrink == null) {
                this.shrink = teXGlue.shrink == null ? null : (TeXDimension)teXGlue.shrink.clone();
            } else if (teXGlue.shrink == null) {
                this.shrink = null;
            } else {
                this.shrink.setDimension(teXParser, teXGlue.shrink);
            }
            if (this.stretch == null) {
                this.stretch = teXGlue.stretch == null ? null : (TeXDimension)teXGlue.stretch.clone();
            } else if (teXGlue.stretch == null) {
                this.stretch = null;
            } else {
                this.stretch.setDimension(teXParser, teXGlue.stretch);
            }
        } else {
            this.setFixed(teXParser, teXDimension);
            this.shrink = null;
            this.stretch = null;
        }
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.fixed.advance(teXParser, numerical);
        if (numerical instanceof TeXGlue) {
            TeXGlue teXGlue = (TeXGlue)numerical;
            if (teXGlue.stretch != null) {
                if (this.stretch == null) {
                    this.stretch = (TeXDimension)teXGlue.stretch.clone();
                } else {
                    this.stretch.advance(teXParser, teXGlue.stretch);
                }
            }
            if (teXGlue.shrink != null) {
                if (this.shrink == null) {
                    this.shrink = (TeXDimension)teXGlue.shrink.clone();
                } else {
                    this.shrink.advance(teXParser, teXGlue.shrink);
                }
            }
        }
    }

    @Override
    public void divide(int n) {
        this.fixed.divide(n);
        if (this.shrink != null) {
            this.shrink.divide(n);
        }
        if (this.stretch != null) {
            this.stretch.divide(n);
        }
    }

    @Override
    public void multiply(int n) {
        this.fixed.multiply(n);
        if (this.shrink != null) {
            this.shrink.multiply(n);
        }
        if (this.stretch != null) {
            this.stretch.multiply(n);
        }
    }

    @Override
    public void multiply(float f) {
        this.fixed.multiply(f);
        if (this.shrink != null) {
            this.shrink.multiply(f);
        }
        if (this.stretch != null) {
            this.stretch.multiply(f);
        }
    }

    public void setFixed(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        if (teXDimension instanceof DimenRegister) {
            this.setFixed(teXParser, ((DimenRegister)teXDimension).getDimension());
        } else if (teXDimension instanceof TeXGlue) {
            this.setFixed(teXParser, ((TeXGlue)teXDimension).getFixed());
        } else {
            if (teXDimension.getUnit() instanceof FillUnit) {
                throw new TeXSyntaxException(teXParser, "tex.error.missing_unit", teXDimension.getUnit().toString());
            }
            this.fixed.setDimension(teXParser, teXDimension);
        }
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.fixed.number(teXParser);
    }

    @Override
    public String toString(TeXParser teXParser) {
        String string = this.fixed.toString(teXParser);
        if (this.stretch != null) {
            string = string + " plus " + this.stretch.toString(teXParser);
        }
        if (this.shrink != null) {
            string = string + " minus " + this.shrink.toString(teXParser);
        }
        return string;
    }

    @Override
    public String format() {
        String string = this.fixed.format();
        if (this.stretch != null) {
            string = string + " plus " + this.stretch.format();
        }
        if (this.shrink != null) {
            string = string + " minus " + this.shrink.format();
        }
        return string;
    }

    public String toString() {
        return String.format("%s[fixed:%s,stretch=%s,shrink=%s]", this.getClass().getName(), this.fixed, this.stretch, this.shrink);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.string(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.string(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.string(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.addAll(0, this.string(teXParser));
    }

    public TeXDimension getStretch() {
        return this.stretch;
    }

    public TeXDimension getShrink() {
        return this.shrink;
    }

    public void setShrink(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        if (teXDimension == null) {
            this.shrink = null;
        } else if (teXDimension instanceof DimenRegister) {
            this.setShrink(teXParser, ((DimenRegister)teXDimension).getDimension());
        } else if (teXDimension instanceof TeXGlue) {
            TeXGlue teXGlue = (TeXGlue)teXDimension;
            this.setShrink(teXParser, teXGlue.fixed);
        } else if (this.shrink == null) {
            this.shrink = (TeXDimension)teXDimension.clone();
        } else {
            this.shrink.setDimension(teXParser, teXDimension);
        }
    }

    public void setStretch(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        if (teXDimension == null) {
            this.stretch = null;
        } else if (teXDimension instanceof DimenRegister) {
            this.setStretch(teXParser, ((DimenRegister)teXDimension).getDimension());
        } else if (teXDimension instanceof TeXGlue) {
            TeXGlue teXGlue = (TeXGlue)teXDimension;
            this.setStretch(teXParser, teXGlue.fixed);
        } else if (this.stretch == null) {
            this.stretch = (TeXDimension)teXDimension.clone();
        } else {
            this.stretch.setDimension(teXParser, teXDimension);
        }
    }

    public TeXDimension getFixed() {
        return this.fixed;
    }
}

