/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import java.io.IOException;

public class L2HFontShapeDeclaration
extends FontShapeDeclaration {
    public L2HFontShapeDeclaration(String string, int n) {
        super(string, n);
    }

    public L2HFontShapeDeclaration(String string, TeXFontShape teXFontShape) {
        super(string, teXFontShape);
    }

    @Override
    public Object clone() {
        return new L2HFontShapeDeclaration(this.getName(), this.getShape());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        String string = "";
        switch (this.getShape()) {
            case UP: {
                string = "font-style: normal; font-variant: normal; ";
                break;
            }
            case IT: {
                string = "font-style: italic; font-variant: normal; ";
                break;
            }
            case SL: {
                string = "font-style: oblique; font-variant: normal; ";
                break;
            }
            case EM: {
                TeXFontShape teXFontShape;
                TeXSettings teXSettings = teXParser.getSettings();
                TeXSettings teXSettings2 = teXSettings.getParent();
                string = teXSettings2 != null ? ((teXFontShape = teXSettings2.getFontShape()) == TeXFontShape.UP || teXFontShape == TeXFontShape.INHERIT ? (teXSettings.getFontFamily() == TeXFontFamily.SF ? string + "font-style: oblique; " : string + "font-style: italic; ") : string + "font-style: normal; ") : (teXSettings.getFontFamily() == TeXFontFamily.SF ? string + "font-style: oblique; " : string + "font-style: italic; ");
                string = string + "font-variant: normal; ";
                break;
            }
            case SC: {
                string = string + "font-style: normal; font-variant: small-caps; ";
            }
        }
        teXParser.getListener().getWriteable().writeliteral("<span style=\"" + string + "\">");
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getWriteable().writeliteral("</span>");
        super.end(teXParser, teXObjectList);
    }
}

