unit ch_ppgn;

interface

uses
  crt, dos, ch_files, ch_parse, ch_chess;

procedure read_pgn(VAR f1: filetype; VAR game: gametype);

implementation

procedure read_pgn(VAR f1: filetype; VAR game: gametype);
const
  illegal_move : boolean = false;
  comment_mode : boolean = false;
  eol_comment : boolean = false;
  parsing_game : boolean = false;
  last_line : string = '';
  p_comment : integer = 0;


var
  board : boardtype;

  procedure read_one_line(VAR f1: filetype; VAR line: string);
  var
    p1 : integer;
    b : longint;
  begin
    line:='';
    while (length(line)=0) and (not f1.eof) do
    begin
      b:=get_next_byte(f1);
      while (b in [10,13]) and (not f1.eof) do
        b:=get_next_byte(f1);
      if not (b in [10,13]) then
      begin
        eol_comment:=false;
        repeat
          p1:=pos(chr(b),'(){};');
          if (p1=0) and (p_comment=0) and not comment_mode and
             not eol_comment then
          begin
            line:=line+chr(b and 255);
          end
          else
          begin
            if not comment_mode and parsing_game then
            begin
              if (p1=3) and (p_comment=0) then
                comment_mode:=true;
              if (p1=1) then
                inc(p_comment);
              if (p1=2) then
                dec(p_comment);
              if (p1=5) then
                eol_comment:=true;
            end
            else
            begin
              if (p1=4) and parsing_game then
                comment_mode:=false;
            end;
          end;
          b:=get_next_byte(f1);
        until (b in [10,13]) or (f1.eof);
      end;
    end;
  end;

  procedure read_pgn_gamehead(VAR f1:filetype; VAR game: gametype);
  const
    tag_names : string =
    'EVENT     ' +
    'SITE      ' +
    'DATE      ' +
    'ROUND     ' +
    'WHITE     ' +
    'BLACK     ' +
    'RESULT    ' +
    'WHITETITLE' +
    'BLACKTITLE' +
    'WHITEELO  ' +
    'BLACKELO  ';


  var
    line : string;
    stop : boolean;
    p1, p2, p3 : integer;
    tag_val: integer;
    tag_name, tempstr : string;
    tag_numb : integer;
    this_is_gamehead : boolean;

  begin
    this_is_gamehead:=false;
    while (not f1.eof) and (not this_is_gamehead) do
    begin
      read_one_line(f1,line);
      remove_spaces(line);
      p1:=pos('[',line);
      p2:=pos(']',line);
      p3:=pos('"',line);
      this_is_gamehead:=(p1>0) and (p2>0) and (p3>0) and (p1<p3) and
                        (p2>p3);
    end;
    stop:=false;
    while (not f1.eof) and (not stop) and (this_is_gamehead) do
    begin

      p1:=pos(']',line);
      p2:=pos(';',line);
      if (p2>p1) and (p1>0) then
        line:=copy(line,1,p2-1);

      if (not stop) then
      begin
        line:=copy(line,2,p1-2);
        remove_spaces(line);
        tag_name:=upcasestr(copy(line,1,pos(' ',line)-1));
        if pos(tag_name,tag_names)>0 then
        begin
          tag_numb:=((pos(tag_name,tag_names)-1) div 10)+1;
          p1:=pos('"',line);
          line:=copy(line,p1+1,length(line)-p1);
          p2:=pos('"',line);
          line:=copy(line,1,p2-1);

          stop:=stop  or (p1=0) or (p2=0);
          val(line,tag_val,p3);
          if (tag_numb=4) then
          begin
            if p3=0 then
              game.round:=tag_val;
          end
          else
          if (tag_numb=3) then
          begin
            val(copy(line,1,pos('.',line)-1),tag_val,p3);
            if p3=0 then
              game.year:=tag_val;
          end
          else
          begin
            if pos('?',line)>0 then
            line:='';
            case tag_numb of
            1: game.event:=line;
            2: game.site:=line;
            5: game.w_name:=line;
            6: game.b_name:=line;
            7: begin
                 if pos('1-0',line)>0 then
                   game.result:='1-0'
                 else
                 if pos('0-1',line)>0 then
                   game.result:='0-1'
                 else
                 if pos('1/2',line)>0 then
                   game.result:='1/2'
                 else
                   game.result:=' L ';
               end;

            8: game.w_title:=upcasestr(line);
            9: game.b_title:=upcasestr(line);

            10: begin
                  if p3=0 then
                    game.w_elo:=tag_val;
                end;
            11: begin
                  if p3=0 then
                    game.w_elo:=tag_val;
                end;
            end;
          end;
        end;
      end;
      read_one_line(f1,line);
      remove_spaces(line);
      stop:=(pos('[',line)<>1);
    end;
    if (length(game.event)>0) then
      game.place:=game.event
    else
    if (length(game.site)>0) then
      game.place:=game.site
    else
      game.place:='';

    game.cb_players:=game.w_name;
    if (length(game.b_name)>0) then
      game.cb_players:=game.cb_players+' - '+game.b_name;
    game.cb_source:=game.place;
    if (game.round<>0) then
    begin
      str(game.round,tempstr);
      game.cb_source:=game.cb_source+' ('+ tempstr +')';
    end;
    if stop then
      last_line:=line
    else
      last_line:='';
  end;

  procedure read_pgn_moves(VAR f1:filetype; VAR game: gametype);
  type
    tokentype = string[8];

  var
    token_numb : array[0..500] of tokentype;

  function parse_pgn_move(in_move: string): string;
  var
    out_move, new_move: string[10];
    promotion: string[1];
    moving_to : string[2];
    moving_from, maybe_moving_from: string[2];
    piece: string[1];
    current_square: string[2];
    color_wanted: string[1];
    moves_string: string;
    i, j : byte;
    moving_from_found, moving_from_empty : boolean;
    moving_from_maybe_found : boolean;
    in_check_after_correct_move : boolean;

  begin
    in_check_after_correct_move:=(pos('+',in_move)>0);
    if (pos('O-O',in_move)>0) then
    begin
      out_move:=in_move;
    end
    else
    begin
      if (pos(in_move[1],'QRBNK')=0) then
        piece:='P'
      else
      begin
        piece:=in_move[1];
        in_move:=copy(in_move,2,length(in_move)-1);
      end;
      while (pos(in_move[length(in_move)],'12345678QRBN')=0) and
            (length(in_move)>0) do
        in_move:=copy(in_move,1,length(in_move)-1);

      if (pos(in_move[length(in_move)],'QRBN')>0) then
      begin
        promotion:=in_move[length(in_move)];
        in_move:=copy(in_move,1,length(in_move)-1);
        while (pos(in_move[length(in_move)],'12345678abcdefghABCDEFGH')=0)
              and (length(in_move)>0) do
          in_move:=copy(in_move,1,length(in_move)-1);
      end
      else
        promotion:='';

      moving_to:=copy(in_move,length(in_move)-1,2);
      in_move:=copy(in_move,1,length(in_move)-2);
      while (pos(in_move[length(in_move)],'12345678abcdefghABCDEFGH')=0)
            and (length(in_move)>0) do
        in_move:=copy(in_move,1,length(in_move)-1);
      moving_from:=in_move;
      if length(moving_from)>2 then
      begin
        writeln('Error in parse_pgn_move');
        halt;
      end
      else
      begin
        if length(moving_from)<2 then
        begin
          i:=1;
          j:=1;
          moving_from_found:=false;
          moving_from_maybe_found:=false;
          moving_from_empty:=(length(moving_from)=0);
          if board.white_to_move then
              color_wanted:='W'
            else
              color_wanted:='B';
          repeat
            current_square:=chr(i+96)+chr(j+48);
            if moving_from_empty then
              moving_from:=current_square;

            if (board.square[i,j].rank=piece) and
               (board.square[i,j].color=color_wanted) and
               (pos(moving_from,current_square)>0) then
            begin
              moves_string:=nic_gen_moves(board,current_square);
              moves_string:=copy(moves_string,5,length(moves_string)-4);
              if (pos(moving_to,moves_string)>0) then
              begin
                if moving_from_empty then
                begin
                  new_move:=piece+current_square+moving_to+promotion;
                  if (not in_check_after(board,new_move)) then
                  begin
                    if (in_check_after_correct_move=
                        giving_check_after(board,new_move)) then
                    begin
                      moving_from_found:=true;
                      moving_from:=current_square;
                    end
                    else
                    begin
                      moving_from_maybe_found:=true;
                      maybe_moving_from:=current_square;
                    end;
                  end;
                end
                else
                begin
                  moving_from_found:=true;
                  moving_from:=current_square;
                end;
              end;
            end;
            inc(j);
            if j>8 then
            begin
              j:=1;
              inc(i);
            end;
          until moving_from_found or (i>8);
          if not (moving_from_found or moving_from_maybe_found) then
          begin
            writeln('  Illegal Move!!');
            game.illegal_move:=true;
          end
          else if not moving_from_found and moving_from_maybe_found then
            moving_from:=maybe_moving_from;
        end;
      end;
      out_move:=piece+moving_from+moving_to+promotion;
    end;
    parse_pgn_move:=out_move;
  end;

  function min_int(x,y: integer): integer;
  var
    i : integer;
  begin
    if x>=y then
      i:=y
    else
      i:=x;
    min_int:=i;
  end;

  function next_token(VAR line: string): string;
  var
    p1, p2, p3, p4, min_p : integer;
    s: string;

  begin
    p1:=pos(' ',line);
    if p1=0 then
      p1:=length(line)+1;
    p2:=pos('.',line);
    if p2=0 then
      p2:=length(line)+1;
    p3:=pos(',',line);
    if p3=0 then
      p3:=length(line)+1;
    p4:=length(line);
    min_p:=min_int(p1,min_int(p2,min_int(p3,p4)));
    if min_p=0 then
    begin
      while (length(line)=0) and (not f1.eof) do
      begin
        read_one_line(f1,line);
        remove_spaces(line);
      end;
      if (not f1.eof) then
        s:=next_token(line);
    end
    else
    begin
      if min_p<length(line) then
        s:=copy(line,1,min_p-1)
      else
        s:=line;
    end;
    remove_spaces(s);
    next_token:=s;
  end;

  function next_token_is_gamehead(line: string): boolean;
  begin
    next_token_is_gamehead:=(pos('[',next_token(line))>0);
  end;

  function next_token_and_delete(VAR line: string): string;
  var
    token: string;

  begin
    token:=next_token(line);
    line:=copy(line,length(token)+2,length(line)-length(token));
    remove_spaces(line);
    next_token_and_delete:=token;
  end;

  function this_token_is_result(VAR token: tokentype): boolean;
  var b: boolean;

  begin
    b:=(pos('1-0',token)>0) or
       (pos('0-1',token)>0) or
       (pos('1/2',token)>0) or
       (pos('*',token)>0);
    this_token_is_result:=b;
  end;


  function next_token_is_result(VAR line : string): boolean;
  var
    token : string;
    b: boolean;

  begin
    token:=next_token(line);
    b:=(pos('1-0',token)>0) or
       (pos('0-1',token)>0) or
       (pos('1/2',token)>0) or
       (pos('*',token)>0);
    next_token_is_result:=b;
  end;

  var
    line, tempstr1 : string;
    p1,p2, p3, move_numb, i, numb_of_tokens : integer;
    stop, end_of_game : boolean;


  begin
    init_board(board);
    move_numb:=0;
    line:=last_line;
    i:=0;

    while (not f1.eof) and (pos('.',line)=0) and (pos('[',line)=0) and
    (length(line)=0) do
    begin
      read_one_line(f1,line);
      remove_spaces(line);
    end;
    end_of_game:=(next_token_is_result(line)) or
                 (length(next_token(line))=0) or
                 (pos('[',line)>0) or (f1.eof);
    parsing_game:=not end_of_game;
    if (not f1.eof) then
    begin
      if (pos('[',line)>0) or end_of_game then
      begin
        last_line:=line;
      end
      else
      if (not f1.eof) then
      begin
        end_of_game:=(next_token_is_result(line)) or
                     (length(next_token(line))=0) or
                     (pos('[',line)>0) or (f1.eof);
        parsing_game:=not end_of_game;
        while not end_of_game do
        begin
          tempstr1:=next_token_and_delete(line);
          if pos(tempstr1[1],'PNBRQKabcdefghO')>0 then
          begin
            inc(i);
            token_numb[i]:=tempstr1;
          end
          else
            token_numb[0]:=tempstr1;
          end_of_game:=(next_token_is_result(line)) or
                       (length(next_token(line))=0) or
                       (pos('[',line)>0) or (f1.eof);
          parsing_game:=not end_of_game;
        end;
        if this_token_is_result(token_numb[i]) then
          dec(i);
        numb_of_tokens:=i;
        move_numb:=0;

        i:=1;
        while (i<=numb_of_tokens) and (not game.illegal_move) do
        begin
          inc(move_numb);
          game.move[move_numb]:=parse_pgn_move(token_numb[i]);
          game.illegal_move:=game.illegal_move or board.illegal_move;
          if not game.illegal_move then
          begin
            do_move(board,game.move[move_numb]);
            game.illegal_move:=board.illegal_move;
            if not game.illegal_move then
              inc(game.numb_of_moves);
          end
          else
          begin
            write('');
          end;
          inc(i);
        end;
      end;
    end;
  end;

begin
  init_game(game);
  parsing_game:=false;
  read_pgn_gamehead(f1,game);
  parsing_game:=true;
  read_pgn_moves(f1,game);
  game.numb_of_moves:=board.move_numb;
  game.numb_of_w_moves:=((game.numb_of_moves-1) div 2)+1;
end;

begin
end.