program ETToTeX;
{ C  John Collins. 1989-95
     Converts ET file to TeX format.

12 Feb 95 JCC  Fix up filter operation: switch /filt*er or /s.
               See note below on where the output should go.
28 Jul 92 JCC  Report length of longest output line.
 3 Jan 92 JCC  Beginnings of allowing use as filter
26 Mar 91 JCC  DefMaxLen = MaxMaxLen
 6 Feb 91 JCC  Correct infinite loop in reading argchar.
27 Jan 91 JCC  Misc. clean up
11 Oct 90 JCC  \perp
19 Sep 90 JCC  Prevent line breaks in bad places -- CS, comments, \defs
 6 Sep 90 JCC  Improvements on line splitting.
 5 Sep 90 JCC  Start on arbitrarily long lines.  v 1.08.
 2 Aug 90 JCC  Fraction support.
15 Jun 90 JCC  Parse command line; allow variable width of output line.
}

{
   Output: In normal running, something should be sent to the console in
           such a way that the program can be stopped by ctrl/C.  That is,
           something should go regularly to stdout or stderr.  Moreover,
           on a long file, it is nice for the user to know something is
           happening.  Thus, we will send a list of running line numbers.

           The error messages and status messages should appear on the
           console and not as part of the file.  Thus they should all
           go to stderr, when ettotex is running as a filter.

           The error messages and help messages should be redirectable,
           at least when ettotex is not running as a filter.  This is to
           enable a user to capture them.  A naive user and COMMAND.COM
           will only know how to redirect stdout, not stderr.  Thus when
           ettotex is NOT running as a filter or is giving help, it should
           send the relevant output to stdout, not to stderr.

           RESULTS OF THIS ANALYSIS:

           The running line numbers should not be part of this output that
           is meant to be redirected.  Hence they always go to stderr.

           If the program is running as a filter, errors, status messages,
           and summaries should go to stderr.
           But if the program is not running as a filter, then these
           messages go to stdout.

           The sign-on message cannot be output until it is known whether
           ettotex is running as a filter or not.
}

{$I etdirect.inc}            {Directives shared by all units}
Uses conv, utils, stderr, ETSyms, TeXETDef, ETTeXSub;

const
   SignOn = 'ET to TeX converter 1.13.  JCC 12 Feb 95.';

const
   {Global variable}
   OperateAsFilter: boolean = false;


procedure help (level: integer);
  begin
    {All this goes to stdout, so that the user can capture it easily by
     redirection to a file.}
    writeln ('Usage:');
    writeln ('      ETTOTEX  switches NAME [NAME1 ..]');
    writeln ('   Makes TeX file NAME.TEX from ET file NAME.ET, NAME1.ET, ....');
    writeln ('      ETTOTEX ?');
    writeln ('   for detailed help.');
    if (level <= 0) then
       exit;
    writeln ('    ');
    writeln ('Switches are obeyed in order of occurence.  Upper and lower case');
    writeln ('are equivalent.  Legal switches:');
    writeln ('    /width=n          max width of output line is n');
    write   ('                      (Default=', defMaxlen);
           writeln (', range is ',MinMaxLen,' to ',MaxMaxLen,')');
    writeln ('    /filter or /s     run as filter: e.g.,');
    writeln ('                      ettotex /filt <file.et >file.tex');
    writeln ('    /help             for this message.');
  end;

procedure ObeyCmdLine (var CmdLine: ParsedCmdLine;
                       var InitParams: Params; var Error: boolean);
    function nint (r: real): integer;
       begin nint := trunc(0.5+r); end;
    var i, valcode: integer;
        value: real;
  begin
    with CmdLine, InitParams do begin
      for i := 1 to NumSw do begin
         Val (Tail[i], Value, valcode);
         if GoodAbbrev (switch[i], 'WIDTH', 2) then begin
            if (Value >= MinMaxLen) and (Value <= MaxMaxLen) then
               MaxLen := nint (Value)
            else begin
               writeln (LogOutput^, 'Maxlen=', value, ' is out of range.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'HELP', 1) then begin
            help (1);
         end else if GoodAbbrev (switch[i], 'FILTER', 4)
                     or GoodAbbrev (switch[i], 'S', 1)
         then begin
            { Operate as filter.}
            OperateAsFilter := true;
            LogOutput := @err;
         end else begin
            writeln (LogOutput^, 'Bad switch name in ''', SwOrigin[i], '''.');
            Error := true;
         end;
      end {for};
      if OperateAsFilter and (Numfiles > 0) then begin
         write   (LogOutput^, 'You have asked me to operate as a filter, ');
         writeln (LogOutput^, 'but you have given me names of ');
         writeln (LogOutput^, 'files to process.');
         Error := true;
      end;
    end {with};
  end;     {ObeyCmdLine}

var
   CmdLine : ParsedCmdLine;
   InitParams, MyParams : Params;
   sn, dn : FileName;
   i : integer;
   Error : boolean;

begin { main program.  }

   {N.B.: Delay typing sign-on message until I know whether I am operating
          as a filter.}
   Error := false;
   DefaultSettings (InitParams);
   if ParamCount = 0 then begin
      writeln (SignOn);
      help (0);
      halt (1);
   end;
   if (ParamCount = 1) and (ParamStr(1) = '?') then begin
      writeln (SignOn);
      help (1);
      halt (1);
   end;

   ParseCmd (CmdLine);
   ObeyCmdLine (CmdLine, InitParams, Error);
   writeln (InitParams.LogOutput^, SignOn);
   if Error then begin
      writeln (InitParams.LogOutput^, 'Errors.  I will not continue.');
      halt(10);
   end;

   if OperateAsFilter then begin
      MyParams := InitParams;
      MyParams.SourceName := '';
      MyParams.DestName := '';
      ProcessETFile (MyParams);
   end else if CmdLine.NumFiles = 0 then
      writeln (InitParams.LogOutput^, 'No files to process.');
   for i := 1 to CmdLine.NumFiles do begin
      MyParams := InitParams;
      sn := CmdLine.files[i];
      dn := sn;
      if sn <> '' then begin
         {Real files for i/o}
         sn := sn + '.ET';
         dn := dn + '.TEX';
      end;
      if sn = '' then begin
         {Run as filter.  We shouldn't get to this code.}
         MyParams.SourceName := '';
         MyParams.DestName := '';
         ProcessETFile (MyParams);
      end else if not exist (sn) then begin
         writeln ('File ''', sn, ''' does not exist.');
      end else if exist (dn) and (FileTime(dn) > FileTime(sn)) then begin
         write ('The destination TeX file ''', dn, ''' already exists, ');
         writeln ('and it is more recent than ');
         writeln ('the source ET file ''', sn, '''.  I will not convert it.  ');
      end else begin
         MyParams.SourceName := sn;
         MyParams.DestName := dn;
         ProcessETFile (MyParams);
      end;
    end; {for}
end.

