/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pencil.commands;

import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFReal;
import de.tu_darmstadt.sp.pencil.commands.ColorCmd;
import java.io.IOException;
import java.io.Writer;

public abstract class ColorNameCmd
extends ColorCmd {
    PDFName patternName;

    public ColorNameCmd(float c1, float c2, float c3, float c4, PDFName patternName) {
        super(c1, c2, c3, c4);
        this.patternName = patternName;
    }

    public float getC1() {
        if (this.c1 == Float.NaN) {
            throw new UnsupportedOperationException("c1 has no value");
        }
        return this.c1;
    }

    public PDFName getPatternName() {
        if (this.patternName == null) {
            throw new UnsupportedOperationException("patternName has no value");
        }
        return this.patternName;
    }

    public void write(Writer wr) throws IOException {
        this.writeNonNaN(wr, this.c1);
        this.writeNonNaN(wr, this.c2);
        this.writeNonNaN(wr, this.c3);
        this.writeNonNaN(wr, this.c4);
        if (this.patternName != null) {
            this.patternName.write(wr);
            wr.write(" ");
        }
        super.write(wr);
    }

    void writeNonNaN(Writer wr, float val) throws IOException {
        if (val != Float.NaN) {
            new PDFReal(val).write(wr);
            wr.write(" ");
        }
    }
}

