# Copyright (C) 2000 - Martin Strauss - under terms of GPL
##################################################################################
# version info
proc InitVersion {} {
 global T Tcltexed_Version
 if ![winfo exists .wversion] then {
  toplevel .wversion
  wm title .wversion $T(wversion-titel)
  label .wversion.version -text $T(wversion-text)
  pack .wversion.version
 }
}
##################################################################################
# latex - command - listing
proc InitListen {} {
 global I_befehl I_back T wlatex_max
 if ![winfo exists .wlatex] then {
  toplevel .wlatex
  wm title .wlatex $T(wlatex-titel)
  frame .wlatex.e
  scrollbar .wlatex.e.scroll -command {.wlatex.e.list yview}
  pack .wlatex.e.scroll -side right -fill y
  listbox .wlatex.e.list -yscroll ".wlatex.e.scroll set" -relief sunken -width 20 -height $wlatex_max -setgrid yes
  pack .wlatex.e.list  -fill both -expand yes
  set LISTE [lsort [array names I_befehl]]
  foreach i $LISTE {.wlatex.e.list insert end $i}
  button .wlatex.butQ -text $T(quit) -command {destroy .wlatex}
  pack .wlatex.e .wlatex.butQ -fill x
  wm minsize . 1 1
  bind .wlatex <<Help>> {
   if {[.wlatex.e.list curselection] != ""} then {
    Help [selection get]
   } else {
    Help $T(wlatex-Help)
   }
  }
  bind .wlatex <Return> {
   set ksp [.wlatex.e.list curselection]
   if {$ksp != ""} then {
    Help [selection get]
    focus .wlatex
    if {$ksp < [.wlatex.e.list size]} then {incr ksp}
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <Double-Button-1> {
   if {[.wlatex.e.list curselection] != ""} then {
    Help [selection get]
    focus .wlatex
   }
  }
  bind .wlatex <Double-Button-3> {
   if {[.wlatex.e.list curselection] != ""} then {
    if $FocusEditorFlag then {
     focus $FocusEditor.te.edit1
     switch_Undo $FocusEditor.te.edit1 UndoBegin
     $FocusEditor.te.edit1 insert insert $I_befehl([selection get])
     switch_Undo $FocusEditor.te.edit1 UndoEnd
     switch_undo $FocusEditor.te.edit1 insert
     $FocusEditor.te.edit1 mark set insert "insert - $I_back([selection get]) chars"
     event generate $FocusEditor.te.edit1 <<Modified>>
    }
   }
  }
  bind .wlatex <Prior> {
   set ksp [.wlatex.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp > $wlatex_max} then {set ksp [expr $ksp - $wlatex_max]}
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <Next> {
   set ksp [.wlatex.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp < [expr $wlatex_max + [.wlatex.e.list size]]} then {set ksp [expr $ksp + $wlatex_max]}
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <Up> {
   set ksp [.wlatex.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp > 0} then {set ksp [expr $ksp - 1]}
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <Down> {
   set ksp [.wlatex.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp < [.wlatex.e.list size]} then {incr ksp}
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <KeyPress> {
   set ksp [lsearch -exact $ABC %A]
   if {$ksp != -1} {
    set ksp [lindex $wlatex_LISTE $ksp]
    .wlatex.e.list selection clear 0 end
    .wlatex.e.list selection set $ksp $ksp
    .wlatex.e.list see $ksp
   }
  }
  bind .wlatex <Control-c> {
   destroy .wlatex
  }
  COLOR .wlatex
 } else {focus .wlatex}
}
##################################################################################
# Tcltexed - manual - listing
proc InitTcltexed {} {
 global Tcltexed_help T wTcltexed_max
 if ![winfo exists .wTcltexed] then {
  toplevel .wTcltexed
  wm title .wTcltexed $T(wTcltexed-titel)
  frame .wTcltexed.e
  scrollbar .wTcltexed.e.scroll -command {.wTcltexed.e.list yview}
  pack .wTcltexed.e.scroll -side right -fill y
  listbox .wTcltexed.e.list -yscroll ".wTcltexed.e.scroll set" -relief sunken -width 20 -height $wTcltexed_max -setgrid yes
  pack .wTcltexed.e.list  -fill both -expand yes
  foreach {i f} $T(wTcltexed-manual) {
   .wTcltexed.e.list insert end $i
   set Tcltexed_help($i) $f
  }
  button .wTcltexed.butQ -text $T(quit) -command {destroy .wTcltexed}
  pack .wTcltexed.e .wTcltexed.butQ -fill x
  wm minsize . 1 1

  bind .wTcltexed <<Help>> {
   if {[.wTcltexed.e.list curselection] != ""} then {
    Help $Tcltexed_help([selection get]) 
   } else {
    Help $T(wTcltexed-Help)
   }
  }
  bind .wTcltexed <Return> {
   set ksp [.wTcltexed.e.list curselection]
   if {$ksp != ""} then {
    Help $Tcltexed_help([selection get])
    focus .wTcltexed
    if {$ksp < [.wTcltexed.e.list size]} then {incr ksp}
    .wTcltexed.e.list selection clear 0 end
    .wTcltexed.e.list selection set $ksp $ksp
    .wTcltexed.e.list see $ksp
   }
  }
  bind .wTcltexed <Double-Button-1> {
   if {[.wTcltexed.e.list curselection] != ""} then {
    Help $Tcltexed_help([selection get]) 
    focus .wTcltexed
   }
  }
  bind .wTcltexed <Double-Button-3> {
   if {[.wTcltexed.e.list curselection] != ""} then {
    Help $Tcltexed_help([selection get]) 
    focus .wTcltexed
   }
  }
  bind .wTcltexed <Prior> {
   set ksp [.wTcltexed.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp > $wTcltexed_max} then {set ksp [expr $ksp - $wTcltexed_max]}
    .wTcltexed.e.list selection clear 0 end
    .wTcltexed.e.list selection set $ksp $ksp
    .wTcltexed.e.list see $ksp
   }
  }
  bind .wTcltexed <Next> {
   set ksp [.wTcltexed.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp < [expr $wTcltexed_max + [.wTcltexed.e.list size]]} then {set ksp [expr $ksp + $wTcltexed_max]}
    .wTcltexed.e.list selection clear 0 end
    .wTcltexed.e.list selection set $ksp $ksp
    .wTcltexed.e.list see $ksp
   }
  }
  bind .wTcltexed <Up> {
   set ksp [.wTcltexed.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp > 0} then {set ksp [expr $ksp - 1]}
    .wTcltexed.e.list selection clear 0 end
    .wTcltexed.e.list selection set $ksp $ksp
    .wTcltexed.e.list see $ksp
   }
  }
  bind .wTcltexed <Down> {
   set ksp [.wTcltexed.e.list curselection]
   if {$ksp != ""} then {
    if {$ksp < [.wTcltexed.e.list size]} then {incr ksp}
    .wTcltexed.e.list selection clear 0 end
    .wTcltexed.e.list selection set $ksp $ksp
    .wTcltexed.e.list see $ksp
   }
  }
  bind .wTcltexed <Control-c> {
   destroy .wTcltexed
  }
  COLOR .wTcltexed
 } else {focus .wTcltexed}
}

