/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexAutoIndentStrategy;
import net.sourceforge.texlipse.editor.TexEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class TexWordWrapAction
implements IEditorActionDelegate,
IActionDelegate2 {
    private IEditorPart targetEditor;
    private boolean off = !TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("wrapDefault");

    public TexWordWrapAction() {
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new WrapPropertyChangeListener());
    }

    public void init(IAction action) {
        action.setChecked(!this.off);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
        action.setEnabled(this.targetEditor instanceof TexEditor);
        if (action.isEnabled()) {
            this.run(action);
        }
    }

    public void run(IAction action) {
        ISourceViewer viewer = this.getTextEditor().getViewer();
        if (action.isChecked()) {
            this.off = false;
            this.setType();
        } else {
            this.off = true;
            TexAutoIndentStrategy.setHardWrap(false);
            viewer.getTextWidget().setWordWrap(false);
        }
    }

    private void setType() {
        String wrapStyle = TexlipsePlugin.getPreference("wrapType");
        ISourceViewer viewer = this.getTextEditor().getViewer();
        if (wrapStyle.equals("soft")) {
            if (viewer != null) {
                TexAutoIndentStrategy.setHardWrap(false);
                viewer.getTextWidget().setWordWrap(true);
            }
        } else if (wrapStyle.equals("hard") && viewer != null) {
            viewer.getTextWidget().setWordWrap(false);
            TexAutoIndentStrategy.setHardWrap(true);
        }
    }

    private TexEditor getTextEditor() {
        if (this.targetEditor instanceof TexEditor) {
            return (TexEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    private class WrapPropertyChangeListener
    implements IPropertyChangeListener {
        private WrapPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String ev = event.getProperty();
            if (ev.equals("wrapType") && !TexWordWrapAction.this.off) {
                TexWordWrapAction.this.setType();
            }
        }
    }
}

