/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class BibStringRule
implements IPredicateRule {
    protected IToken fToken;

    public BibStringRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int count = 0;
        int charsRead = 0;
        int c = scanner.read();
        if ((char)c == '\"') {
            do {
                c = scanner.read();
                ++charsRead;
                if (c == -1) {
                    this.unwind(scanner, charsRead);
                    return Token.UNDEFINED;
                }
                if ((char)c == '{') {
                    ++count;
                    continue;
                }
                if ((char)c != '}') continue;
                if (count == 0) {
                    this.unwind(scanner, charsRead);
                    return Token.UNDEFINED;
                }
                --count;
            } while ((char)c != '\"');
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private void unwind(ICharacterScanner scanner, int numChars) {
        int i = 0;
        while (i < numChars) {
            scanner.unread();
            ++i;
        }
    }
}

