/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import net.sourceforge.texlipse.builder.AbstractBuilder;
import net.sourceforge.texlipse.builder.Builder;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.ProgramRunner;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DviBuilder
extends AbstractBuilder {
    private Builder dvi;
    private ProgramRunner ps;
    private String output;
    private boolean stopped;

    public DviBuilder(int i, String outputFormat) {
        super(i);
        this.output = outputFormat;
        this.isValid();
    }

    public void reset(IProgressMonitor monitor) {
        super.reset(monitor);
        this.dvi.reset(monitor);
    }

    public boolean isValid() {
        if (this.dvi == null) {
            this.dvi = BuilderRegistry.get(null, "dvi");
        }
        if (this.ps == null || !this.ps.isValid()) {
            this.ps = BuilderRegistry.getRunner("dvi", this.output, 0);
        }
        return this.dvi != null && this.dvi.isValid() && this.ps != null && this.ps.isValid();
    }

    public String getOutputFormat() {
        return this.ps.getOutputFormat();
    }

    public String getSequence() {
        return String.valueOf(this.dvi.getSequence()) + '+' + this.ps.getProgramName();
    }

    public void stopRunners() {
        this.dvi.stopRunners();
        this.ps.stop();
        this.stopped = true;
    }

    public void buildResource(IResource resource) throws CoreException {
        this.stopped = false;
        this.dvi.buildResource(resource);
        if (this.stopped) {
            return;
        }
        this.monitor.subTask("Converting dvi to " + this.output);
        this.ps.run(resource);
        this.monitor.worked(15);
    }
}

