/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.AbstractEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class TexCommandEntry
extends AbstractEntry {
    public static final int MAND_PARAMETER = 1;
    public static final int BRACE_PARAMETER = 2;
    public static final int OPT_PARAMETER = 3;
    public static final int NORMAL_CONTEXT = 1;
    public static final int PREAMBLE_CONTEXT = 2;
    public static final int MATH_CONTEXT = 3;
    public static final int NUMBER_OF_CONTEXTS = 3;
    public String info;
    public int arguments;
    public int[] parameter;
    public int context;
    public String depend;
    public ImageDescriptor imageDesc;
    private Image image;

    public TexCommandEntry(String _key, String _info, int _arguments, int[] _parameter, int _context) {
        this.key = _key;
        this.info = _info;
        this.arguments = _arguments;
        this.parameter = _parameter;
        this.context = _context;
    }

    public TexCommandEntry(String _key, String _info, int _arguments) {
        this.key = _key;
        this.info = _info;
        this.arguments = _arguments;
        this.context = 1;
        this.parameter = new int[_arguments];
        int i = 0;
        while (i < _arguments) {
            this.parameter[i] = 1;
            ++i;
        }
    }

    public TexCommandEntry(String _key, String _info, int _arguments, int _context) {
        this(_key, _info, _arguments);
        this.context = _context;
    }

    public TexCommandEntry(String _key, String _info, String _imageName) {
        this(_key, _info, 0, 3);
        this.imageDesc = TexlipsePlugin.getImageDescriptor(_imageName);
    }

    public TexCommandEntry(String _key, String _info, int _arguments, String _imageName) {
        this(_key, _info, _arguments, 3);
        this.imageDesc = TexlipsePlugin.getImageDescriptor(_imageName);
    }

    public TexCommandEntry(TexCommandEntry c) {
        this(c.key, c.info, c.arguments, c.context);
        this.parameter = (int[])c.parameter.clone();
        this.depend = c.depend;
        this.imageDesc = c.imageDesc;
    }

    public boolean equals(Object object) {
        if (object instanceof TexCommandEntry) {
            TexCommandEntry obj = (TexCommandEntry)object;
            return obj.key.equals(this.key) && obj.info.equals(this.info) && obj.arguments == this.arguments && (obj.depend == null && this.depend == null || obj.depend.equals(this.depend)) && obj.imageDesc == this.imageDesc && obj.parameter.length == this.parameter.length;
        }
        return super.equals(object);
    }

    public int compareTo(Object ae) {
        int c = this.context - ((TexCommandEntry)ae).context;
        if (c != 0) {
            return c;
        }
        return this.key.compareTo(((AbstractEntry)ae).key);
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.imageDesc != null) {
            this.image = this.imageDesc.createImage();
        }
        return this.image;
    }
}

