/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.spelling.SpellChecker;
import net.sourceforge.texlipse.spelling.SpellingMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;

public class SpellingResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (!SpellChecker.SPELLING_ERROR_MARKER_TYPE.equals(marker.getType())) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        String[] proposals = SpellChecker.getProposals(marker);
        if (proposals == null || proposals.length == 0) {
            return null;
        }
        IDocument doc = this.getProviderDocument();
        IMarkerResolution[] res = new IMarkerResolution[proposals.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new SpellingMarkerResolution(proposals[i], doc);
            ++i;
        }
        return res;
    }

    public boolean hasResolutions(IMarker marker) {
        String[] proposals = SpellChecker.getProposals(marker);
        return proposals != null && proposals.length > 0;
    }

    protected IDocument getProviderDocument() {
        IEditorPart editor = TexlipsePlugin.getCurrentWorkbenchPage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            return textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        return null;
    }
}

