/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import com.swabunga.spell.event.AbstractWordFinder;
import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TexlipseWordFinder
extends AbstractWordFinder {
    private static final Pattern MAND_ARG = Pattern.compile("\\A\\s*\\{[^\\}]+\\}");
    private static final Pattern OPT_MAND_ARG = Pattern.compile("\\A\\s*(\\[[^\\]]+\\])?\\s*\\{[^\\}]+\\}");
    private boolean IGNORE_COMMENTS = true;
    private boolean IGNORE_MATH = true;

    public TexlipseWordFinder(String st) {
        super(st);
    }

    public TexlipseWordFinder() {
    }

    public Word next() {
        if (!this.hasNext()) {
            throw new WordNotFoundException("No more words found.");
        }
        this.currentWord.copy(this.nextWord);
        this.setSentenceIterator(this.currentWord);
        int i = this.currentWord.getEnd();
        boolean finished = false;
        boolean started = false;
        while (i < this.text.length() && !finished) {
            if (!started && this.isWordChar(i)) {
                this.nextWord.setStart(i++);
                started = true;
                continue;
            }
            if (started) {
                if (this.isWordChar(i)) {
                    ++i;
                    continue;
                }
                this.nextWord.setText(this.text.substring(this.nextWord.getStart(), i));
                finished = true;
                break;
            }
            int j = i;
            if (this.IGNORE_COMMENTS) {
                j = this.ignore(j, '%', '\n');
            }
            if (j < this.text.length() && this.text.charAt(j) == '\\') {
                j = this.ignore(j, "\\documentclass", OPT_MAND_ARG);
                j = this.ignore(j, "\\usepackage", OPT_MAND_ARG);
                j = this.ignore(j, "\\newcounter", MAND_ARG);
                j = this.ignore(j, "\\setcounter", MAND_ARG);
                j = this.ignore(j, "\\addtocounter", MAND_ARG);
                j = this.ignore(j, "\\value", MAND_ARG);
                j = this.ignore(j, "\\arabic", MAND_ARG);
                j = this.ignore(j, "\\stepcounter", MAND_ARG);
                j = this.ignore(j, "\\newenvironment", MAND_ARG);
                j = this.ignore(j, "\\renewenvironment", MAND_ARG);
                j = this.ignore(j, "\\ref", MAND_ARG);
                j = this.ignore(j, "\\vref", MAND_ARG);
                j = this.ignore(j, "\\eqref", MAND_ARG);
                j = this.ignore(j, "\\pageref", MAND_ARG);
                j = this.ignore(j, "\\label", MAND_ARG);
                j = this.ignore(j, "\\cite", OPT_MAND_ARG);
                j = this.ignore(j, "\\tag", MAND_ARG);
                j = this.ignore(j, "\\begin", MAND_ARG);
                j = this.ignore(j, "\\end", MAND_ARG);
                j = this.ignore(j, '\\');
            }
            if (i != j) {
                i = j;
                continue;
            }
            ++i;
        }
        if (!started) {
            this.nextWord = null;
        } else if (!finished) {
            this.nextWord.setText(this.text.substring(this.nextWord.getStart(), i));
        }
        return this.currentWord;
    }

    public void setIgnoreComments(boolean ignore) {
        this.IGNORE_COMMENTS = ignore;
    }

    public void setIgnoreMath(boolean ignore) {
        this.IGNORE_MATH = ignore;
    }

    public int ignore(int index, String command, Pattern p) {
        int i = 0;
        while (i < command.length()) {
            if (index + i >= this.text.length()) {
                return index;
            }
            if (command.charAt(i) != this.text.charAt(i + index)) {
                return index;
            }
            ++i;
        }
        Matcher m = p.matcher(this.text.substring(i += index));
        if (m.find()) {
            return i + m.end() - 1;
        }
        return index;
    }
}

