/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.DocumentReference;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.texparser.LatexLexer;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TCbegin;
import net.sourceforge.texlipse.texparser.node.TCbib;
import net.sourceforge.texlipse.texparser.node.TCbibstyle;
import net.sourceforge.texlipse.texparser.node.TCchapter;
import net.sourceforge.texlipse.texparser.node.TCcite;
import net.sourceforge.texlipse.texparser.node.TCend;
import net.sourceforge.texlipse.texparser.node.TCinclude;
import net.sourceforge.texlipse.texparser.node.TCinput;
import net.sourceforge.texlipse.texparser.node.TClabel;
import net.sourceforge.texlipse.texparser.node.TCnew;
import net.sourceforge.texlipse.texparser.node.TCommentline;
import net.sourceforge.texlipse.texparser.node.TCpackage;
import net.sourceforge.texlipse.texparser.node.TCparagraph;
import net.sourceforge.texlipse.texparser.node.TCpart;
import net.sourceforge.texlipse.texparser.node.TCpbib;
import net.sourceforge.texlipse.texparser.node.TCpindex;
import net.sourceforge.texlipse.texparser.node.TCref;
import net.sourceforge.texlipse.texparser.node.TCsection;
import net.sourceforge.texlipse.texparser.node.TCssection;
import net.sourceforge.texlipse.texparser.node.TCsssection;
import net.sourceforge.texlipse.texparser.node.TCword;
import net.sourceforge.texlipse.texparser.node.TLBrace;
import net.sourceforge.texlipse.texparser.node.TOptargument;
import net.sourceforge.texlipse.texparser.node.TRBrace;
import net.sourceforge.texlipse.texparser.node.TStar;
import net.sourceforge.texlipse.texparser.node.TTaskcomment;
import net.sourceforge.texlipse.texparser.node.TVtext;
import net.sourceforge.texlipse.texparser.node.TWhitespace;
import net.sourceforge.texlipse.texparser.node.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatexParser {
    public static final int TYPE_LABEL = 1000;
    private static final Pattern PART_RE = Pattern.compile("\\\\part(?:[^a-zA-Z]|$)");
    private static final Pattern CHAPTER_RE = Pattern.compile("\\\\chapter(?:[^a-zA-Z]|$)");
    private static final Pattern SECTION_RE = Pattern.compile("\\\\section(?:[^a-zA-Z]|$)");
    private static final Pattern SSECTION_RE = Pattern.compile("\\\\subsection(?:[^a-zA-Z]|$)");
    private static final Pattern SSSECTION_RE = Pattern.compile("\\\\subsubsection(?:[^a-zA-Z]|$)");
    private static final Pattern PARAGRAPH_RE = Pattern.compile("\\\\paragraph(?:[^a-zA-Z]|$)");
    private static final Pattern LABEL_RE = Pattern.compile("\\\\label(?:[^a-zA-Z]|$)");
    private List<ReferenceEntry> labels;
    private List<DocumentReference> cites;
    private List<DocumentReference> refs;
    private ArrayList<TexCommandEntry> commands;
    private List<ParseErrorMessage> tasks;
    private List<String> bibs;
    private String bibstyle;
    private List<OutlineNode> inputs;
    private ArrayList<OutlineNode> outlineTree;
    private List<ParseErrorMessage> errors;
    private OutlineNode documentEnv;
    private boolean biblatexMode;
    private String biblatexBackend;
    private boolean localBib;
    private boolean index;
    private boolean fatalErrors;

    private void initializeDatastructs() {
        this.labels = new ArrayList<ReferenceEntry>();
        this.cites = new ArrayList<DocumentReference>();
        this.refs = new ArrayList<DocumentReference>();
        this.commands = new ArrayList();
        this.tasks = new ArrayList<ParseErrorMessage>();
        this.inputs = new ArrayList<OutlineNode>(2);
        this.outlineTree = new ArrayList();
        this.errors = new ArrayList<ParseErrorMessage>();
        this.bibs = new ArrayList<String>();
        this.biblatexMode = false;
        this.biblatexBackend = null;
        this.localBib = false;
        this.index = false;
        this.fatalErrors = false;
    }

    private int addSectionNode(StackUnsynch<OutlineNode> blocks, StackUnsynch<OutlineNode> envBlocks, int startLine, int level, String text) {
        int parentLevel = -1;
        OutlineNode on = new OutlineNode(text, level, startLine, null);
        if (!blocks.empty()) {
            boolean traversing = true;
            while (traversing && !blocks.empty()) {
                OutlineNode prev = blocks.peek();
                int prevType = prev.getType();
                if (prevType == 13) {
                    OutlineNode parent;
                    OutlineNode topEnv;
                    do {
                        topEnv = blocks.pop();
                        if (!blocks.empty()) {
                            parent = blocks.peek();
                            prevType = parent.getType();
                            continue;
                        }
                        parent = null;
                        prevType = -1;
                    } while (prevType == 13);
                    int upperLevel = level - 1;
                    if (prevType > upperLevel) {
                        parent.deleteChild(topEnv);
                        int envBegin = topEnv.getBeginLine();
                        do {
                            parent.setEndLine(envBegin);
                            blocks.pop();
                        } while ((parent = parent.getParent()) != null && parent.getType() > upperLevel);
                        if (parent != null) {
                            prevType = parent.getType();
                            parent.addChild(topEnv);
                        } else {
                            prevType = -1;
                            this.outlineTree.add(topEnv);
                        }
                        topEnv.setParent(parent);
                    }
                    prev = parent;
                }
                if (prevType >= -1 && prevType < level) {
                    parentLevel = prevType;
                    if (prev != null) {
                        prev.addChild(on);
                    }
                    on.setParent(prev);
                    traversing = false;
                    continue;
                }
                prev.setEndLine(startLine);
                blocks.pop();
            }
        }
        if (blocks.empty()) {
            this.outlineTree.add(on);
        }
        blocks.push(on);
        return parentLevel;
    }

    private static String findBiblatexBackend(String options) {
        int beIdx = options.indexOf("backend=");
        if (beIdx > 0) {
            int startIdx = beIdx + 8;
            int endIdx = options.indexOf(44, startIdx);
            if (endIdx > startIdx) {
                return options.substring(startIdx, endIdx).trim();
            }
            if (endIdx == -1) {
                return options.substring(startIdx).trim();
            }
            return null;
        }
        return null;
    }

    public void parse(LatexLexer lex, boolean checkForMissingSections) throws LexerException, IOException {
        this.parse(lex, null, checkForMissingSections);
    }

    public void parse(LatexLexer lexer, OutlineNode preamble, boolean checkForMissingSections) throws LexerException, IOException {
        this.initializeDatastructs();
        StackUnsynch<OutlineNode> blocks = new StackUnsynch<OutlineNode>();
        StackUnsynch<OutlineNode> envBlocks = new StackUnsynch<OutlineNode>();
        StackUnsynch<Token> braces = new StackUnsynch<Token>();
        boolean expectArg = false;
        boolean expectArg2 = false;
        Token prevToken = null;
        String packageOptions = null;
        TexCommandEntry currentCommand = null;
        int argCount = 0;
        HashMap<String, Integer> sectioning = new HashMap<String, Integer>();
        if (preamble != null) {
            this.outlineTree.add(preamble);
            blocks.push(preamble);
        }
        int accumulatedLength = 0;
        Token t = lexer.next();
        while (!(t instanceof EOF)) {
            if (expectArg) {
                if (t instanceof TArgument) {
                    int n;
                    String[] stringArray;
                    if (prevToken instanceof TClabel) {
                        ReferenceEntry l = new ReferenceEntry(t.getText());
                        l.setPosition(t.getPos(), t.getText().length());
                        l.startLine = t.getLine();
                        this.labels.add(l);
                        OutlineNode on = new OutlineNode(t.getText(), 20, t.getLine(), t.getPos(), t.getText().length());
                        on.setEndLine(t.getLine());
                        if (!blocks.empty()) {
                            OutlineNode prev = blocks.peek();
                            prev.addChild(on);
                            on.setParent(prev);
                        } else {
                            this.outlineTree.add(on);
                        }
                    } else if (prevToken instanceof TCref) {
                        this.refs.add(new DocumentReference(t.getText(), t.getLine(), t.getPos(), t.getText().length()));
                    } else if (prevToken instanceof TCcite) {
                        if (!"*".equals(t.getText())) {
                            String[] cs;
                            stringArray = cs = t.getText().split(",");
                            n = cs.length;
                            int prev = 0;
                            while (prev < n) {
                                String c = stringArray[prev];
                                this.cites.add(new DocumentReference(c.trim(), t.getLine(), t.getPos(), t.getText().length()));
                                ++prev;
                            }
                        }
                    } else if (prevToken instanceof TCbegin) {
                        OutlineNode on = new OutlineNode(t.getText(), 13, t.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length());
                        if ("document".equals(t.getText())) {
                            if (preamble != null) {
                                preamble.setEndLine(t.getLine());
                            }
                            blocks.clear();
                            this.documentEnv = on;
                        } else {
                            if (!blocks.empty()) {
                                OutlineNode prev = blocks.peek();
                                prev.addChild(on);
                                on.setParent(prev);
                            } else {
                                this.outlineTree.add(on);
                            }
                            blocks.push(on);
                            envBlocks.push(on);
                        }
                    } else if (prevToken instanceof TCend) {
                        int endLine = t.getLine();
                        OutlineNode prev = null;
                        if ("document".equals(t.getText())) {
                            this.documentEnv.setEndLine(endLine + 1);
                            while (!blocks.empty()) {
                                prev = blocks.pop();
                                prev.setEndLine(endLine);
                                if (prev.getType() != 13) continue;
                                this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "\\end{" + prev.getName() + "} expected, but \\end{document} found; at least one unbalanced begin-end", 2));
                                this.fatalErrors = true;
                            }
                        } else if (!envBlocks.empty()) {
                            prev = envBlocks.pop();
                            prev.setEndLine(endLine + 1);
                            if (!prev.getName().equals(t.getText())) {
                                this.fatalErrors = true;
                                this.errors.add(new ParseErrorMessage(prev.getBeginLine(), prev.getOffsetOnLine(), prev.getDeclarationLength(), "\\end{" + prev.getName() + "} expected, but \\end{" + t.getText() + "} found; unbalanced begin-end", 2));
                                this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "\\end{" + prev.getName() + "} expected, but \\end{" + t.getText() + "} found; unbalanced begin-end", 2));
                            }
                            if (!blocks.empty() && blocks.peek().getType() == 13) {
                                blocks.pop();
                            }
                        } else {
                            this.fatalErrors = true;
                            this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "\\end{" + t.getText() + "} found with no preceding \\begin", 2));
                        }
                    } else if (prevToken instanceof TCpart) {
                        this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 0, t.getText());
                    } else if (prevToken instanceof TCchapter) {
                        this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 1, t.getText());
                    } else if (prevToken instanceof TCsection) {
                        this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 2, t.getText());
                    } else if (prevToken instanceof TCssection) {
                        boolean foundSection;
                        boolean bl = foundSection = this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 3, t.getText()) >= 2;
                        if (!foundSection && checkForMissingSections) {
                            this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "Subsection " + prevToken.getText() + " has no preceding section", 1));
                        }
                    } else if (prevToken instanceof TCsssection) {
                        boolean foundSsection;
                        boolean bl = foundSsection = this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 4, t.getText()) >= 3;
                        if (!foundSsection && checkForMissingSections) {
                            this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "Subsubsection " + prevToken.getText() + " has no preceding subsection", 1));
                        }
                    } else if (prevToken instanceof TCparagraph) {
                        boolean foundSssection;
                        boolean bl = foundSssection = this.addSectionNode(blocks, envBlocks, prevToken.getLine(), 5, t.getText()) >= 4;
                        if (!foundSssection && checkForMissingSections) {
                            this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "Paragraph " + prevToken.getText() + " has no preceding subsubsection", 1));
                        }
                    } else if (prevToken instanceof TCbib) {
                        if (this.biblatexMode) {
                            this.bibs.add(t.getText().trim());
                        } else {
                            String[] sBibs;
                            stringArray = sBibs = t.getText().split(",");
                            n = sBibs.length;
                            int prev = 0;
                            while (prev < n) {
                                String bib = stringArray[prev];
                                this.bibs.add(bib.trim());
                                ++prev;
                            }
                            int startLine = prevToken.getLine();
                            while (!blocks.empty()) {
                                OutlineNode prev2 = blocks.pop();
                                if (prev2.getType() == 13) {
                                    blocks.push(prev2);
                                    break;
                                }
                                prev2.setEndLine(startLine);
                            }
                        }
                    } else if (prevToken instanceof TCbibstyle) {
                        this.bibstyle = t.getText();
                        int startLine = prevToken.getLine();
                        while (!blocks.empty()) {
                            OutlineNode prev = blocks.pop();
                            if (prev.getType() == 13) {
                                blocks.push(prev);
                                break;
                            }
                            prev.setEndLine(startLine);
                        }
                    } else if (prevToken instanceof TCinput || prevToken instanceof TCinclude) {
                        if (!blocks.empty()) {
                            OutlineNode prev = blocks.peek();
                            OutlineNode on = new OutlineNode(t.getText(), 45, t.getLine(), prev);
                            on.setEndLine(t.getLine());
                            prev.addChild(on);
                            this.inputs.add(on);
                        } else {
                            OutlineNode on = new OutlineNode(t.getText(), 45, t.getLine(), null);
                            on.setEndLine(t.getLine());
                            this.outlineTree.add(on);
                            this.inputs.add(on);
                        }
                    } else if (prevToken instanceof TCnew) {
                        currentCommand = new TexCommandEntry(t.getText().substring(1), "", 0);
                        currentCommand.startLine = t.getLine();
                        lexer.registerCommand(currentCommand.key);
                        expectArg2 = true;
                    } else if (prevToken instanceof TCpackage && t.getText().equals("biblatex")) {
                        this.biblatexMode = true;
                        if (packageOptions != null) {
                            this.biblatexBackend = LatexParser.findBiblatexBackend(packageOptions);
                            packageOptions = null;
                        }
                    }
                    accumulatedLength = 0;
                    prevToken = null;
                    expectArg = false;
                } else if (t instanceof TCword && prevToken instanceof TCnew) {
                    currentCommand = new TexCommandEntry(t.getText().substring(1), "", 0);
                    currentCommand.startLine = t.getLine();
                    lexer.registerCommand(currentCommand.key);
                    expectArg2 = true;
                    accumulatedLength = 0;
                    prevToken = null;
                    expectArg = false;
                } else if (t instanceof TOptargument) {
                    if (prevToken instanceof TCpackage) {
                        packageOptions = t.getText();
                    }
                    accumulatedLength += t.getText().length();
                } else if (!(t instanceof TWhitespace || t instanceof TStar || t instanceof TCommentline || t instanceof TTaskcomment)) {
                    this.errors.add(new ParseErrorMessage(prevToken.getLine(), prevToken.getPos(), prevToken.getText().length() + accumulatedLength + t.getText().length(), "No argument following " + prevToken.getText(), 1));
                    accumulatedLength = 0;
                    prevToken = null;
                    expectArg = false;
                } else {
                    accumulatedLength += t.getText().length();
                }
            } else if (expectArg2) {
                if (t instanceof TArgument) {
                    currentCommand.info = t.getText();
                    this.commands.add(currentCommand);
                    if (PART_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 0);
                    } else if (CHAPTER_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 1);
                    } else if (SECTION_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 2);
                    } else if (SSECTION_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 3);
                    } else if (SSSECTION_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 4);
                    } else if (PARAGRAPH_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 5);
                    } else if (LABEL_RE.matcher(currentCommand.info).find()) {
                        sectioning.put("\\" + currentCommand.key, 1000);
                    }
                    argCount = 0;
                    expectArg2 = false;
                } else if (t instanceof TOptargument) {
                    if (argCount == 0) {
                        try {
                            currentCommand.arguments = Integer.parseInt(t.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errors.add(new ParseErrorMessage(prevToken.getLine(), t.getPos(), t.getText().length(), "The first optional argument of newcommand must only contain the number of arguments", 2));
                            expectArg2 = false;
                        }
                    }
                    ++argCount;
                } else if (!(t instanceof TWhitespace || t instanceof TCommentline || t instanceof TTaskcomment)) {
                    this.errors.add(new ParseErrorMessage(t.getLine(), t.getPos(), t.getText().length(), "No 2nd argument following newcommand", 1));
                    argCount = 0;
                    expectArg2 = false;
                }
            } else if (t instanceof TClabel || t instanceof TCref || t instanceof TCcite || t instanceof TCbib || t instanceof TCbibstyle || t instanceof TCbegin || t instanceof TCend || t instanceof TCinput || t instanceof TCinclude || t instanceof TCpart || t instanceof TCchapter || t instanceof TCsection || t instanceof TCssection || t instanceof TCsssection || t instanceof TCparagraph || t instanceof TCpackage || t instanceof TCnew) {
                prevToken = t;
                expectArg = true;
            } else if (t instanceof TCword) {
                if (sectioning.containsKey(t.getText())) {
                    int nodeType = (Integer)sectioning.get(t.getText());
                    switch (nodeType) {
                        case 0: {
                            prevToken = new TCpart(t.getLine(), t.getPos());
                            break;
                        }
                        case 1: {
                            prevToken = new TCchapter(t.getLine(), t.getPos());
                            break;
                        }
                        case 2: {
                            prevToken = new TCsection(t.getLine(), t.getPos());
                            break;
                        }
                        case 3: {
                            prevToken = new TCssection(t.getLine(), t.getPos());
                            break;
                        }
                        case 4: {
                            prevToken = new TCsssection(t.getLine(), t.getPos());
                            break;
                        }
                        case 5: {
                            prevToken = new TCparagraph(t.getLine(), t.getPos());
                            break;
                        }
                        case 1000: {
                            prevToken = new TClabel(t.getLine(), t.getPos());
                            break;
                        }
                    }
                    expectArg = true;
                }
            } else if (t instanceof TCpindex) {
                this.index = true;
            } else if (t instanceof TCpbib) {
                int startLine = t.getLine();
                while (!blocks.empty()) {
                    OutlineNode prev = blocks.pop();
                    if (prev.getType() == 13) {
                        blocks.push(prev);
                        break;
                    }
                    prev.setEndLine(startLine);
                }
                this.localBib = true;
            } else if (t instanceof TTaskcomment) {
                int severity = 2;
                int start = t.getText().indexOf("FIXME");
                if (start == -1) {
                    severity = 1;
                    start = t.getText().indexOf("TODO");
                    if (start == -1) {
                        start = t.getText().indexOf("XXX");
                    }
                }
                String taskText = t.getText().substring(start).trim();
                this.tasks.add(new ParseErrorMessage(t.getLine(), t.getPos(), taskText.length(), taskText, severity));
            } else if (t instanceof TVtext) {
                OutlineNode on = new OutlineNode(t.getText(), 13, t.getLine(), t.getPos(), t.getText().length());
                String[] lines = t.getText().split("\\r\\n|\\n|\\r");
                on.setEndLine(t.getLine() + lines.length);
                if (!blocks.empty()) {
                    OutlineNode prev = blocks.peek();
                    prev.addChild(on);
                    on.setParent(prev);
                } else {
                    this.outlineTree.add(on);
                }
            }
            if (t instanceof TLBrace) {
                braces.push(t);
            } else if (t instanceof TRBrace) {
                if (braces.empty()) {
                    this.errors.add(new ParseErrorMessage(t.getLine(), t.getPos() - 1, 1, TexlipsePlugin.getResourceString("parseErrorMissingLBrace"), 2));
                } else {
                    braces.pop();
                }
            }
            t = lexer.next();
        }
        while (!braces.empty()) {
            Token mt = (Token)braces.pop();
            this.errors.add(new ParseErrorMessage(mt.getLine(), mt.getPos() - 1, 1, TexlipsePlugin.getResourceString("parseErrorMissingRBrace"), 2));
        }
        int endLine = t.getLine() + 1;
        while (!blocks.empty()) {
            OutlineNode prev = (OutlineNode)blocks.pop();
            prev.setEndLine(endLine);
            if (prev.getType() != 13) continue;
            envBlocks.pop();
        }
        while (!envBlocks.empty()) {
            OutlineNode prev = (OutlineNode)envBlocks.pop();
            prev.setEndLine(endLine);
            this.fatalErrors = true;
            this.errors.add(new ParseErrorMessage(prev.getBeginLine(), 0, prev.getName().length(), "\\begin{" + prev.getName() + "} does not have matching end; at least one unbalanced begin-end", 2));
        }
    }

    public List<ReferenceEntry> getLabels() {
        return this.labels;
    }

    public List<DocumentReference> getCites() {
        return this.cites;
    }

    public List<DocumentReference> getRefs() {
        return this.refs;
    }

    public String[] getBibs() {
        return this.bibs.toArray(new String[0]);
    }

    public String getBibstyle() {
        return this.bibstyle;
    }

    public List<OutlineNode> getInputs() {
        return this.inputs;
    }

    public ArrayList<OutlineNode> getOutlineTree() {
        return this.outlineTree;
    }

    public List<ParseErrorMessage> getErrors() {
        return this.errors;
    }

    public boolean isBiblatexMode() {
        return this.biblatexMode;
    }

    public String getBiblatexBackend() {
        return this.biblatexBackend;
    }

    public boolean isLocalBib() {
        return this.localBib;
    }

    public boolean isIndex() {
        return this.index;
    }

    public OutlineNode getDocumentEnv() {
        return this.documentEnv;
    }

    public boolean isFatalErrors() {
        return this.fatalErrors;
    }

    public ArrayList<TexCommandEntry> getCommands() {
        return this.commands;
    }

    public List<ParseErrorMessage> getTasks() {
        return this.tasks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StackUnsynch<E> {
        private static final int INITIAL_SIZE = 10;
        private static final int GROWTH_FACTOR = 2;
        private int capacity = 10;
        private int size = 0;
        private Object[] stack = new Object[10];

        public boolean empty() {
            return this.size == 0;
        }

        public E peek() {
            return (E)this.stack[this.size - 1];
        }

        public E pop() {
            --this.size;
            Object top = this.stack[this.size];
            this.stack[this.size] = null;
            return (E)top;
        }

        public void push(E item) {
            if (this.size >= this.capacity) {
                this.capacity *= 2;
                Object[] newStack = new Object[this.capacity];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
            this.stack[this.size] = item;
            ++this.size;
        }

        public void clear() {
            --this.size;
            while (this.size >= 0) {
                this.stack[this.size] = null;
                --this.size;
            }
            this.size = 0;
        }
    }
}

