0 [IDENT('18JN92'), INHERIT('sys$library:starlet',' 			  'sys$library:pascal$lib_routines', 7 			  'sys$library:pascal$smg_routines')] PROGRAM Spell  9     (document, commonfile, persdict, dict1, dict2, dict3, C      listing, goodfile,	logfile, bannerfile, guidanceFile, output);    { N ******************************************************************************N *                                                                            *N *                              SPELL Program                                 *N *                              ***** *******                                 *N *                                                                            *N *  Version:                 2.2-1                                            *N *                                                                            *N *  Revision Date:           23-MAY-1985                                      *N *                                                                            *N *  Written by:              Mark Resmer - Academic Computer Center Manager   *N *                           Box 248                                          *N *                           Vassar College                                   *N *                           Poughkeepsie                                     *N *                           NY 12601                                         *N *                                                                            *N *                           (914) 452-7000 Ext 2437                          *N *                                                                            *N *                           (RESMER@VASSAR on BITnet or CCnet)               *N *                                                                            *N *  Based on:                PROOFREAD program written by Matthew Temple      *N *                           Smith College, Northampton Mass. His ideas       *N *                           and permission to use them are gratefully        *N *                           acknowledged.                                    *N *                                                                            *D *  Language:		    PASCAL version 3.0                               *N *                                                                            *N *  Operating System:        VMS version 4.1                                  *N *                                                                            *N *  Copyright (C) 1985 Mark Resmer - permission is hereby  granted for the    *N *  reproduction of this software, on condition that this copyright notice    *N *  is included in the reproduction, and that such reproduction is not for    *N *  purposes of profit or material gain.                                      *N *                                                                            *N *  v2.1  Robin Fairbairns, Laser-Scan, Cambridge, UK                         *N *        Incorporates most Laser-Scan improvements to v1, plus               *N *        balanced-binary-tree based sorting of the IgnoreList                *N *  v2.2  Robin Fairbairns, Laser-Scan                                        *N *        Added improved TeX/LaTeX syntax checking (following tips from       *N *        Earle Ake of SAIC) and asynchronous `guess' operation               *N *  v2.2-1 Robin Fairbairns, Laser-Scan                                       *H *	 Incorporating recommendations (and bug mends) following \beta test  *N *                                                                            *N ****************************************************************************** }  LABEL 99;			{panic button}   CONST version='2.2';       sys_uic=8;       screen_rows=24;        screen_cols=80; )       NumberOfWords = 203;	{common words} "       Maxword =	32;		{word length}+       MaxLine 	= maxword+255;	{line length}   K (**  If compiling with VAX Pascal, you will need to uncomment the following       lines. !       cli$_present =%X'0003fd19'; !       cli$_negated =%X'000381f8'; !       cli$_absent  =%X'000381f0'; !       cli$_normal  =%X'00030001';  *)C       pdfile   = 'persdict.dat';	{filename for personal dictionary} M       gdfile   = 'newgood.file_name'; {filename for new good word dictionary} A       filedir  = 'spell_dict:';	{logical for master dictionaries} 5       help_logical='spell_help:';{and for help files} ;       ast_mask=(2**3)+(2**23)+(2**25);	{trap ^C, ^W and ^Y} :       max_tree_depth = 60;	{maximum acceptable tree depth}       ctrl_c=chr(3);       ctrl_w=chr(23);        ctrl_y=chr(25); ,       line_break_flag = '`';		{the diamond?}       line_break_flag_len = 1;    F TYPE unsigned_word = [WORD]0..65535;		{for all sorts of odds and ends}9      wordtype 	= VARYING [maxword] OF CHAR;	{word format} 5      Line 	= VARYING [MaxLine] OF CHAR;	{line format} @      clisym 	= PACKED ARRAY[1..5] OF CHAR;	{token names for CLI}C      linefix 	= PACKED ARRAY [1..80] OF CHAR;	{fixed length string} $      Word1 	= RECORD			{short words}. 		    item:[key(0)]PACKED ARRAY [1..8] OF CHAR 		  END;%      Word2 	= RECORD			{medium words} / 		    item:[key(0)]PACKED ARRAY [1..16] OF CHAR  		  END;#      Word3 	= RECORD			{long words} / 		    item:[key(0)]PACKED ARRAY [1..32] OF CHAR  		  END;3      Word3s	= RECORD			{long words with statistics} 0 		    item:[key(0)]PACKED ARRAY [1..32] OF CHAR;A 		    user:PACKED ARRAY [1..32] OF CHAR; {[s]he who put this word  		      					into the goodfile} A 		    date:PACKED ARRAY [1..23] OF CHAR; {when the deed was done} @ 		    fnam:PACKED ARRAY [1..32] OF CHAR; {the file it came from} 		  END;  <      BalanceFactor = -1..1;			{(experimental) balance state}-      Tree 	= ^Leaf;			{tree for word storage}       Leaf 	= RECORD  		    Name: wordtype;  		    Left,Right: Tree;  		    SerialNo: INTEGER; 		    Balance: BalanceFactor;  		  END;  0      listptr 	= ^list;			{list for text storage}      list 	= RECORD % 		    Name: wordtype;		{text of word} / 		    next: listptr;		{pointer to next element} + 		    startpos:INTEGER;		{position in line} 1 		    length:INTEGER;		{length of unaltered word}  		  END;  ;      DoubleTree = ^DoubleLeaf;			{tree for corrected words}         DoubleLeaf = RECORD% 		    FirstWord,SecondWord: wordtype;  		    Left,Right: DoubleTree 		  END;  .      commontype = ARRAY [1..NumberOfWords] OF : 		   PACKED ARRAY [1..32] OF CHAR;{array for common words}  ?      esctype 	= (runoff,scribe,tex,issue,nroff,vaxdoc,unknown);  							{known word-processors}G      mainttype  = (normal,personal,checking,system);	{maint mode flags} .      param_type = PACKED ARRAY [1..12]OF CHAR;       wrd 	= [WORD]-32768..32767;      keystroke  = RECORD 		  CASE BOOLEAN OF  		  true:	 (ch : CHAR); ' 		  false: (term_code : unsigned_word);  		  END;*      addr_arr 	= ARRAY [1..2] OF unsigned;       unsafe_text= [unsafe] TEXT;      ptr_to_rab = ^rab$type;    8 VAR CommonFile : TEXT;			{File of the most common words}8     Document : unsafe_text;		{The thing we are checking}4     Listing : [VOLATILE]TEXT;		{The revised version}B     using_listing : BOOLEAN:=true;	{set FALSE by /NOOUTPUT switch}<     named_listing : BOOLEAN:=false;	{set TRUE by /OUTPUT=fn}:     work_file:line;			{name of of the work (listing) file}?     every_word_ok : BOOLEAN:=false;	{set TRUE by /BUILD switch} I     do_single_letter_words : BOOLEAN:=false; {set TRUE by /SINGLE switch} )     Logfile : TEXT;			{Optional log file} 2     logging:BOOLEAN:=false;		{logging option flag}@     logged_something:BOOLEAN:=false;	{put something in the file}E     test_version:BOOLEAN:=true;		{edit to false for running version - (   					 controls debug info on log file}7     test_run:BOOLEAN:=false;		{reflects qualifier TEST} #     Bannerfile: TEXT;			{Help file} 8     guidanceFile : TEXT;		{file of guidance information}9     guidanceNeeded : BOOLEAN:=false;	{from /GUIDE switch} J     guidanceOpen : BOOLEAN:=false;	{/GUIDE given, open for writing output}<     namedGuidanceFile : BOOLEAN:=false;	{/GUIDE had a value}5     guidanceFileName : line;		{name of guidance file} ;     Dict1 : [unsafe] FILE OF word1;	{short word dictionary} <     Dict2 : [unsafe] FILE OF word2;	{medium word distionary}:     Dict3 : [unsafe] FILE OF word3;	{long word dictionary}3     dict1_rab : ptr_to_rab;		{ RABs for the above } )     dict2_rab : ptr_to_rab;		{	...	     } )     dict3_rab : ptr_to_rab;		{	...	     } A     Goodfile : FILE OF word3s;		{list of unchecked "right" words} 0     goodfile_rab : ptr_to_rab;		{ RAB for that }4     Persdict : FILE OF word3;		{personal dictionary}G     persdict_rab : ptr_to_rab;		{and (last but not least) RAB for that} E     using_persdict : BOOLEAN:=true;	{set false by /NOPERSONAL switch} E     main_ok_chars : SET OF CHAR;	{characters acceptable in main menu} 3     NewGoodWords : tree;		{words marked as "right"} *     IgnoreList : tree;			{words to ignore};     Misspelled : Doubletree;		{wrong words and corrections} :     Textline : listptr;			{current line broken into words}A     Currline,prevline:line;		{raw text of current and last lines} >     First_tmp : Word3s;			{initial word for calling WriteTree}.     LineNumber: INTEGER;		{current line count}/     wordcount:INTEGER:=0;		{current word count} 1     errorcount:INTEGER:=0;		{current error count} 3     lettertotal:INTEGER:=0;		{current letter count} $     Quit : BOOLEAN;			{flag to quit})     ThisWord:wordtype;			{text of a word} .     CorrectWord :wordtype;		{a corrected word}8     CommonWordList : commontype;	{array of common words}G     escapemode : esctype := unknown;	{what word processor are we using} G     cmd_index, cmd_lastnb : INTEGER;	{used finding end of command line} 0     cmdline:linefix;			{the entire command line}1     param:linefix;			{VMS command line parameter} D     maintmode:mainttype:=normal;	{operating mode (default is spell)}(     filnam:line;			{filename to process}:     usable_file_name:line;		{"external" version of filnam}B     file_name_len:INTEGER;		{effective length of usable_file_name}+     trim_file:linefix;			{trimmed filename} +     dev:line;				{name of device/directory} B     print_tree_flags : ARRAY [1..max_tree_depth] OF BalanceFactor;( 					{shows how one got to where one is}C     tree_serial_no : INTEGER:=0;	{counts entries in balanced trees} 8     document_size : REAL;		{`byte number' of FFB in EBK}G     document_is_open : BOOLEAN:=false;	{whether or no document is open} "     pasteboard:[VOLATILE]unsigned;      keyboard:[VOLATILE]unsigned;     context_display:unsigned;      error_display:unsigned;      header_display:unsigned;     help_display:unsigned;     message_display:unsigned; $     menu_display:[VOLATILE]unsigned;>     guess_display:unsigned;		{SMG display for guess selection}     personal_display:unsigned;     status_display:unsigned;#     top_display:[VOLATILE]unsigned;      gigi:BOOLEAN;      stat:INTEGER; H     upper_casing:[VOLATILE]BOOLEAN:=true; {controls behaviour of getkey}     selection:keystroke;     pasted:BOOLEAN;      grp: [VOLATILE] INTEGER;D     had_unsol_input : [VOLATILE] BOOLEAN; {TRUE if unsolicited input=                                            has been received} O     NextLineTeXescape : BOOLEAN := FALSE; {TRUE=>still in (e.g.) \documentstyle 4     	    	    	    	    	   at end of previous line}L     NextLineVAXDocArg : BOOLEAN := FALSE; {TRUE=>still in VAXDoc argument at@                                            end of previous line}E     currline_row : INTEGER := 3;	{where lines appear in the context } 3     prevline_row : INTEGER := 2;	{ virtual display} K     alphabetic_chars : SET OF CHAR := ['A'..'Z','a'..'z',''..'',''..'', " 				       '',''..'',''..''];C     upper_case_chars : SET OF CHAR := ['A'..'Z',''..'',''..'']; N     lower_case_chars : [VOLATILE] SET OF CHAR := ['a'..'z',''..'',''..''];( 					{actually, this is a read-only set,* 					 but it's referred to by ASYNCHRONOUS, 					 routine getkey, so has to be volatile:, 					 perhaps all these ought to be CONSTs?}G     all_lower_case   : SET OF CHAR := ['a'..'z','',''..'',''..''];   " [asynchronous,EXTERNAL(lib$spawn)]:    FUNCTION do_dcl(%STDESCR cmd:linefix):INTEGER;EXTERNAL; 					{execute a VMS command}  - [EXTERNAL] PROCEDURE Spell_CLItable;EXTERNAL;    [asynchronous,EXTERNAL] M    FUNCTION cli$dcl_parse(%STDESCR command:PACKED ARRAY[a..b:INTEGER]OF CHAR;  			   PROCEDURE Spell_CLItable; $ 			  %REF param_r:INTEGER:=%IMMED 0;% 			  %REF prompt_r:INTEGER:=%IMMED 0; 7 			  %REF prompt_s:INTEGER:=%IMMED 0):INTEGER;EXTERNAL;      [asynchronous,EXTERNAL] @    FUNCTION cli$present(%STDESCR param:clisym):INTEGER;EXTERNAL;   [asynchronous,EXTERNAL] 1    FUNCTION cli$get_value(%STDESCR param: clisym; 0 			  %STDESCR retval: linefix):INTEGER;EXTERNAL;    @ FUNCTION pas$rab ( VAR f : unsafe_text ) : ptr_to_rab; EXTERNAL;   {<FF> P ================================================================================ }   , FUNCTION open_document ( VAR fab : fab$type; 			 VAR rab : rab$type; ! 			 VAR   f : TEXT)    : INTEGER;   " TYPE pxab	= RECORD CASE INTEGER OF 		    0: (u: unsigned);  		    1: (x: ^xab$type); 		  END;  ; VAR status	: INTEGER;	(* Status return from the function *) :     xab		: pxab;		(* a XAB to hold the file header guff *)   BEGIN    xab.u := fab.fab$l_xab; 
 IF xab.u=0 THEN    BEGIN					(* no XABs at all *)   new(xab.x);				(* get one *)4   fab.fab$l_xab:=xab.u;			(* point to it from FAB *)1   xab.x^.xab$l_nxt:=0;			(* null forward chain *) H   xab.x^.xab$b_cod:=xab$c_fhc;		(* define `file header characteristic *)   END  ELSE   BEGIN #   WHILE xab.x^.xab$b_cod<>xab$c_fhc    DO-     BEGIN				(* this one isn't the FHC XAB *)      IF xab.x^.xab$l_nxt=0      THEN.       BEGIN				(* and there isn't any other *))       new(xab.x);			(* get another one *) :       xab.x^.xab$l_nxt:=fab.fab$l_xab;	(* chain to head *)       fab.fab$l_xab:=xab.u; K       xab.x^.xab$b_cod:=xab$c_fhc;	(* define `file header characteristic *) 	       END      ELSE:       xab.u:=xab.x^.xab$l_nxt;		(* follow chain of XABs *)     END;   END;   status := $open(fab);    IF odd(status) THEN   status := $connect(rab);   IF odd(status) THEN   BEGIN =   document_size:=(xab.x^.xab$l_ebk-1)*512.0+xab.x^.xab$w_ffb;    document_is_open:=true;    END;  : open_document := status;		(* return result of operation *)   END;    - FUNCTION current_document_position : INTEGER;   B (* returns the position (defined by rfa0, rfa4 in document_rab) *)   VAR position	 : INTEGER;1     document_rab : ptr_to_rab;		{RAB of document}    BEGIN    IF document_is_open  THEN   BEGIN "   document_rab:=pas$rab(document);  8   position := round(((document_rab^.rab$l_rfa0-1)*512.0+7 		      document_rab^.rab$w_rfa4)*100.0/document_size);    IF position<0    THEN     position:=100;   END  ELSE   position:=-1;   & current_document_position := position;   END;     {<FF> P ================================================================================ }   ) PROCEDURE get_uic;			{obtain and set UIC}  VAR /   items: [VOLATILE] RECORD		{getjpi descriptor}  		     length: unsigned_word;  		     code  : unsigned_word;  		     adr   : ^INTEGER; 		     junk  : INTEGER; 
 		    END; BEGIN *   items.length:=4;			{set JPI descriptors}   items.code:=jpi$_grp;    items.adr:=address(grp);1   $getjpi(itmlst:=items);		{get the group number}  END;     {<FF> O ===============================================================================  }   ) [asynchronous]FUNCTION getkey: keystroke;    VAR key : keystroke;     read_return : INTEGER;   BEGIN    REPEAT<   read_return := smg$read_keystroke(keyboard,key.term_code);? UNTIL ((read_return<>ss$_cancel) AND (read_return<>ss$_abort));   C (* this check was inserted to find the bug whereby the system would B    fail to wait for a response about broadcast messages. Turns outF    that, despite cancelling any previous input before asking for theirA    own, these routines still fail by virtue of the fact that they ?    would otherwise multi-thread the SMG keyboard input routines A    (presumably the non-AST code has to run to completion, despite     having been cancelled) 8 if (not(odd(read_return))) then lib$signal(read_return); *)   IF key.term_code=smg$k_trm_pf2 THEN   key.term_code:=smg$k_trm_helpa# ELSE IF key.term_code=smg$k_trm_pf3r THEN   key.term_code:=smg$k_trm_find  ELSE IF upper_casing THEN   BEGIN,   IF key.ch IN lower_case_charsi   THEN$     key.term_code:=key.term_code-32;   END;   getkey:=key;   END;  3 PROCEDURE myreadln(VAR txt : VARYING[upper]OF CHAR;* 		   numbers : BOOLEAN:=false);  VAR locstr:linefix; 
     str:line;      len:unsigned_word;     i:INTEGER;   BEGIN 6 smg$read_string(keyboard,locstr,resultant_length:=len, 		  display_id:=menu_display); * str:=substr(locstr,1,len); IF numbers   THEN   readv(str,i,error:=continue);  IF (NOT numbers) OR (statusv=0)  THEN
   txt:=str ELSE   txt:='0';  END;     {<FF> P ================================================================================ }    [asynchronous,unbound]< PROCEDURE write_menu(title,options:line;vers:BOOLEAN:=true); BEGIN #    smg$erase_display(menu_display);     IF length(title)>0 THENA     smg$put_chars(menu_display,title+chr(0),1,1,1,smg$m_reverse);m.    smg$put_chars(menu_display,options+chr(0));    IF vers THEN4A     smg$put_chars(menu_display,'(v'+version+') ',1,screen_cols-7)  END;   [asynchronous,unbound]" PROCEDURE write_top(options:line); BEGIN "    smg$erase_display(top_display);E    smg$paste_virtual_display(top_display,pasteboard,screen_rows-1,1); "    smg$erase_display(top_display);-    smg$put_chars(top_display,options+chr(0));  END;     {<FF> P ================================================================================ }   E FUNCTION yesanswer ( prompt : line ) : BOOLEAN;	{get a Y or N answer}    VAR key:keystroke;   BEGIN   + write_menu('',prompt+'? (Y or N): ',false);    REPEAT   key:=getkey;   yesanswer:= (key.ch = 'Y');    IF NOT (key.ch IN ['Y','N'])     THEN o      smg$ring_bell(menu_display); UNTIL key.ch IN ['Y','N'];  
 IF key.ch='Y'  THEN7   smg$put_chars(menu_display,'Yes',1,length(prompt)+13)  ELSE6   smg$put_chars(menu_display,'No',1,length(prompt)+13)   END;   {<FF> P ================================================================================ }    PROCEDURE banner;  BEGIN #  smg$erase_display(header_display);   IF gigi   THEN%    smg$put_chars_wide(header_display, ! 	'Spell',1,(screen_cols DIV 2)-2,  	smg$m_bold)   ELSE)    smg$put_chars_highwide(header_display,*	 	'Spell',i 	1,s 	(screen_cols DIV 2)-4,.
 	smg$m_bold);  END;     {<FF> P ================================================================================ }   " PROCEDURE put_help(filename:line);
 VAR str:line;y     display:unsigned;  BEGINo  display:=help_display; J  open(bannerfile,help_logical+filename,history:=readonly,error:=continue);  IF status(bannerfile)>0 THENn    BEGINL     write_menu('','Unable to open help file! Press any key to continue...');     getkey;      GOTO 99;    END;   reset(bannerfile);   smg$erase_display(display);3  smg$paste_virtual_display(display,pasteboard,3,1);   smg$put_line(display,' ',2);   WHILE NOT eof(bannerfile) DO     BEGIN     readln(bannerfile,str);*%     smg$put_line(display,str+chr(0));o    END;t#  close(bannerfile,error:=continue);./  write_menu('','Press any key to continue...');   getkey;1  smg$unpaste_virtual_display(display,pasteboard);t END;  F [asynchronous,unbound]PROCEDURE out_of_band_handler(param:param_type);   VAR key : keystroke;   BEGIN    CASE param[9] OF
    ctrl_y,    ctrl_c: BEGIN  	    smg$cancel_input(keyboard);8 	    write_top('Do you really want to quit? (Y or N):'); 	    key:=getkey;  	    IF key.ch = 'Y' THEN 4 	      BEGIN {note that listing may not be open here? 	             (if NOT using_listing) - however, Pascal requires*; 		     using_listing to be volatile if we were to use it in23 		     this procedure.  I chose simply to leave the " 		     `error:=continue' there...}; 	      close (listing,disposition:=delete,error:=continue);  	      GOTO 99;m 	      END;l9 	    smg$unpaste_virtual_display(top_display,pasteboard);  	   END;?    ctrl_w: smg$repaint_screen(pasteboard);	{refresh the screen}f   END  END;  2 [asynchronous,unbound]PROCEDURE broadcast_handler; VAR H   MessageStr : PACKED ARRAY [1..256] OF CHAR;	{not always just one line}   str:line;e   len:unsigned_word;   key:keystroke;   temp_display:unsigned; BEGINm6  smg$get_broadcast_message(pasteboard,MessageStr,len);  str:=substr(MessageStr,1,len);tG  smg$create_virtual_display(5,screen_cols-2,temp_display,smg$m_border); ,  smg$put_chars(temp_display,str+chr(0),3,2);8  smg$put_chars(temp_display,'Incoming message received'," 	       1,(screen_cols DIV 2)-14);  smg$put_chars(temp_display,A 	       'Press Q to quit, or any other key to continue...',5,15); D  smg$paste_virtual_display(temp_display,pasteboard,screen_rows-8,2);  smg$ring_bell(temp_display);   smg$cancel_input(keyboard);
  key:=getkey;w  IF key.ch = 'Q' THEN GOTO 99;*  smg$delete_virtual_display(temp_display); END;  2 PROCEDURE outerror;		{overlong line or over quota} BEGINn$  smg$erase_display(message_display);<  smg$paste_virtual_display(message_display,pasteboard,18,2);   smg$ring_bell(message_display);  smg$put_line(message_display,P 'I seem to be having problems writing my output file. Perhaps you have a very');  smg$put_line(message_display,P 'long line in your input file, or you have run out of disk space. I am afraid');  smg$put_line(message_display,H 'that you will have to start checking your spelling all over again...');4  write_menu('','Press any key to return to VMS...');  getkey;  IF using_listing THENK    close(listing,disposition:=delete,error:=continue);	{clear up your mess}   IF logging THEN6    close(logfile,disposition:=delete,error:=continue);  GOTO 99;			{and get out}	 END;  : PROCEDURE quoterror;		{insufficient space for output file} BEGINa$  smg$erase_display(message_display);<  smg$paste_virtual_display(message_display,pasteboard,18,2);   smg$ring_bell(message_display);  smg$put_line(message_display,P 'I seem to have run out of disk space for my output file.  Please  check your');  smg$put_line(message_display,Q 'quota and delete some files if necessary. I''m afraid that you will then have');e  smg$put_line(message_display,5 'to start checking your spelling all over again...');	4  write_menu('','Press any key to return to VMS...');  getkey;  IF using_listing THENK    close(listing,disposition:=delete,error:=continue);	{clear up your mess}1  IF logging THEN7     close(logfile,disposition:=delete,error:=continue);o  GOTO 99;			{and get out}n END;  2 PROCEDURE ofile_error;		{illegal output file type} BEGINo$  smg$erase_display(message_display);<  smg$paste_virtual_display(message_display,pasteboard,18,2);   smg$ring_bell(message_display);  smg$put_line(message_display,U 'It seems you are trying to  check the output from a word-processor (or the like).');e  smg$put_line(message_display,L 'This is not good sense, as you could probably damage the file''s layout.');  6     IF NOT yesanswer('Do you really want to carry on')     THEN        BEGIN	{clear up your mess}       IF using_listing
       THEN4 	close(listing,disposition:=delete,error:=continue);         IF logging         THEN  4 	close(logfile,disposition:=delete,error:=continue);         IF guidanceOpenf
       THEN% 	close(guidanceFile,error:=continue);	         GOTO 99;			{and get out}       END; {endif} END;  E PROCEDURE persdicterror;	{old personal dictionaries (from the Temple}:' BEGIN				{program) don't work any more}t$  smg$erase_display(message_display);<  smg$paste_virtual_display(message_display,pasteboard,18,2);   smg$ring_bell(message_display);  smg$put_line(message_display,S 'I don''t seem  to  be  able to  open your  personal dictionary  (PERSDICT.DAT).');t  smg$put_line(message_display,R 'Perhaps you  have done the unmentionable,  and tried editing it,  or you still');  smg$put_line(message_display,R 'have one left from the old version of SPELL. Please delete it, then try again.');4  write_menu('','Press any key to return to VMS...');  getkey;	  GOTO 99;i END;  I PROCEDURE openerror(tex:line);	{general routine for missing system files}n BEGINa$  smg$erase_display(message_display);<  smg$paste_virtual_display(message_display,pasteboard,18,2);   smg$ring_bell(message_display);  smg$put_line(message_display,4    'I don''t seem to be able to open the '+tex+'.');  smg$put_line(message_display,J     'Please find a friendly system manager, and tell them about this...');4  write_menu('','Press any key to return to VMS...');  getkey;	  GOTO 99;f END;     {<FF>"P ================================================================================ }r   PROCEDURE set_gigi;r* VAR gigi_string:PACKED ARRAY[1..1]OF CHAR; BEGINn%  lib$get_symbol('GIGI$',gigi_string);s%  gigi:=(gigi_string[1] IN ['T','Y']);P END;     {<FF> O ===============================================================================o }r  ) PROCEDURE analyse_leaf ( VAR leaf : tree;g 		    VAR max_depth : INTEGER; 			    depth : INTEGER;u 			VAR chars : INTEGER;d 			VAR words : INTEGER;i  		VAR rounded_bytes : UNSIGNED);  , { process one leaf of the tree for summary }  A VAR word_length : INTEGER;	{ the length of the word in question }l   BEGIN    IF depth>max_depth THEN&   max_depth := depth;	{evaluate depth}   words := words+1;: IF index(leaf^.name,' ')=0 THEN   word_length := 32	 ELSE)   word_length := index(leaf^.name,' ')-1;0   chars := chars+word_length; ? rounded_bytes := rounded_bytes+uand(word_length+6, %xfffffffc);o   IF leaf^.left<>NIL THENL   analyse_leaf(leaf^.left, max_depth, depth+1, chars, words, rounded_bytes);   IF leaf^.right<>NILo THENM   analyse_leaf(leaf^.right, max_depth, depth+1, chars, words, rounded_bytes);n   END;      . PROCEDURE summarise_tree (VAR print_to : TEXT; 			  VAR goodtree : tree);   { summarise the state of tree }   9 VAR max_depth 	: INTEGER;	{ the maximum depth we get to }p:     total_chars : INTEGER;	{ count of characters in tree }5     total_words : INTEGER;	{ count of words in tree } B     rounded_bytes : UNSIGNED;	 { count of bytes needed to allocate1     	    	    	    	  to characters in the tree }e   BEGINe   max_depth := 0;	 total_chars := 0;r total_words := 0;_ rounded_bytes := 0;.  N analyse_leaf(goodtree, max_depth, 1, total_chars, total_words, rounded_bytes);  L writeln(print_to, total_chars:1, ' characters (requiring ', rounded_bytes:1,8 		' bytes to store them) in ', total_words:1, ' words');1 writeln(print_to, 'Tree depth is ', max_depth:1);    END;    P PROCEDURE print_tree (VAR print_to: TEXT; VAR goodtree : tree; depth : INTEGER);  * (* print a tree, indented appropriately *)  = VAR i		: INTEGER;	(* for use in printing the tree branches *)s   BEGINa   IF goodtree^.left<>NIL THEN   BEGINu"   print_tree_flags[depth+1] := -1;0   print_tree(print_to, goodtree^.left, depth+1);   END;  
 IF depth>0 THEN   BEGINy   IF depth>1   THEN	     BEGINT     FOR i:=1 TO depth-1B     DO       BEGINT2       IF print_tree_flags[i]=print_tree_flags[i+1]
       THEN 	write(print_to, '  ')
       ELSE 	write(print_to, '| ');N
       END;     END;   write(print_to, '|>');   END;   IF index(goodtree^.name,' ')=0 THEN!   write(print_to, goodtree^.name)  ELSEH   write(print_to, substr(goodtree^.name,1,index(goodtree^.name,' ')-1));D writeln(print_to, ' ',goodtree^.balance:0,' ',goodtree^.SerialNo:0);   IF goodtree^.right<>NILe THEN   BEGIN "   print_tree_flags[depth+1] := +1;1   print_tree(print_to, goodtree^.right, depth+1);    END;   END;     {<FF>lP ================================================================================ }v  Q PROCEDURE Insert (ThisWord : WordType; VAR GoodTree : Tree); {put word into tree}'  5 VAR father : tree;		{the father of pivot (Knuth's T)}.?     pivot  : tree;		{the point at which balancing may be needed     						     (Knuth's S)}_.     chaser : tree;		{for chasing down the tree     						     (Knuth's P)}c5     qTree  : tree;		{spare tree variable (Knuth's Q)}e-     rTree  : tree;		{ditto		     (Knuth's R)}h?     aBalance : BalanceFactor;	{a balance factor    (Knuth's a)}   	 LABEL 43;_   BEGINS   IF (GoodTree = NIL)  THEN   BEGIN'   NEW(GoodTree);   GoodTree^.Name := ThisWord;    GoodTree^.Left := NIL;   GoodTree^.Right := NIL;A   GoodTree^.Balance := 0;m   END  ELSE A   BEGINU9   father := NIL;		{signals that father is, in fact, root}    pivot  := GoodTree;(   chaser := GoodTree;      WHILE chaser<>NILH   DO	     BEGIND     IF ThisWord<chaser^.Name     THEN       BEGINE       qTree:=chaser^.Left;       IF qTree=NIL
       THEN 	BEGIN 	NEW(qTree); 	chaser^.Left:=qTree;   	chaser:=NIL;			{need to insert} 	END
       ELSE 	BEGIN 	IF qTree^.Balance<>0E 	THEN; 	  BEGIN 	  Father:=chaser; 	  Pivot:=qTree; 	  END;S 	chaser:=qTree;s 	END;		       END !     ELSE IF ThisWord>chaser^.Name      THEN       BEGINV       qTree:=chaser^.Right;_       IF qTree=NIL
       THEN 	BEGIN 	NEW(qTree); 	chaser^.Right:=qTree;
 	chaser:=NIL;= 	END
       ELSE 	BEGIN 	IF qTree^.Balance<>0f 	THENb 	  BEGIN 	  Father:=chaser; 	  Pivot:=qTree; 	  END;: 	chaser:=qTree;E 	END; 	       END      ELSE       BEGIN:       IF logging AND test_run$
       THEN 	BEGIN 	writeln(LogFile);= 	writeln(LogFile, '--- Duplicate name for tree: ', ThisWord);a 	logged_something := true; 	END;)(       GOTO 43;			{oops! already in tree}       END;			{extended IF}     END;			{WHILE chaser}(  ! {found the right place to insert}_   qTree^.Name := ThisWord;   qTree^.Left := NIL;x   qTree^.Right := NIL;   qTree^.Balance := 0;  %   tree_serial_no := tree_serial_no+1; $   qTree^.SerialNo := tree_serial_no;     IF ThisWord<Pivot^.Nameb   THEN	     BEGIN      rTree:=Pivot^.Left;s     chaser:=rTree;%     aBalance:=-1;			{from Knuth's A7}      END    ELSE	     BEGINh     rTree:=Pivot^.Right;     chaser:=rTree;%     aBalance:=+1;			{from Knuth's A7}l     END;     WHILE chaser<>qTree DO	     BEGINa     IF ThisWord<chaser^.Name     THEN       BEGINh       chaser^.Balance:=-1;       chaser:=chaser^.Left; 	       END      ELSE       BEGIN_       chaser^.Balance:=+1;       chaser:=chaser^.Right;
       END;     END;     IF Pivot^.Balance=0t   THEN     Pivot^.Balance:=aBalance   ELSE	     BEGIN      IF Pivot^.Balance=-aBalancek     THEN       Pivot^.Balance:=0u     ELSE       BEGIN         IF rTree^.Balance=aBalance
       THEN 	BEGIN				{single rotation}  	IF logging AND test_run 	THENi 	  BEGIN 	  writeln(logfile);D 	  writeln(logfile, 'Single rotation at pivot ', Pivot^.SerialNo:0); 	  logged_something:=true; 	  END;t 	chaser:=rTree;o 	IF aBalance>0 	THENF 	  BEGIN 	  Pivot^.Right:=rTree^.Left;u 	  rTree^.Left:=Pivot; 	  END 	ELSEi 	  BEGIN 	  Pivot^.Left:=rTree^.Right;* 	  rTree^.Right:=Pivot;r 	  END;_ 	Pivot^.Balance:=0;s 	rTree^.Balance:=0;< 	END
       ELSE 	BEGIN				{double rotation}  	IF logging AND test_run 	THENt 	  BEGIN 	  writeln(logfile);D 	  writeln(logfile, 'Double rotation at pivot ', Pivot^.SerialNo:0); 	  logged_something:=true; 	  END;R 	IF aBalance>0 	THENd 	  BEGIN 	  chaser:=rTree^.Left;E 	  rTree^.Left:=chaser^.Right; 	  chaser^.Right:=rTree; 	  Pivot^.Right:=chaser^.Left; 	  chaser^.Left:=Pivot;E 	  END 	ELSEn 	  BEGIN 	  chaser:=rTree^.Right; 	  rTree^.Right:=chaser^.Left; 	  chaser^.Left:=rTree;= 	  Pivot^.Left:=chaser^.Right; 	  chaser^.Right:=Pivot; 	  END;{ 	IF chaser^.Balance=aBalance 	THENF 	  BEGIN 	  Pivot^.Balance:=-aBalance;= 	  rTree^.Balance:=0;= 	  END 	ELSE= 	  BEGIN 	  Pivot^.Balance:=0;g 	  IF chaser^.Balance=0  	  THENs 	    rTree^.Balance:=0 	  ELSE; 	    rTree^.Balance:=aBalance; 	  END;g 	chaser^.Balance:=0; 	END;t  (       IF father<>NIL			{Finishing touch}
       THEN 	BEGIN 	IF Pivot=Father^.Righth 	THEN  	  Father^.Right:=chaser 	ELSEt 	  Father^.Left:=chaser; 	END
       ELSE 	GoodTree:=chaser;
       END;       END;     END;   {done} IF logging AND test_runb THEN s   BEGINt   writeln(logfile);o4   writeln(logfile, '--- inserted name: ', ThisWord);#   print_tree(logfile, goodtree, 0);    logged_something:=true;    END;  * 43: {duplicate name joins here - to exit!}   END;      O PROCEDURE InsertDouble (WrongWord, CorrectWord : WordType; {insert wrong/right};4 			      VAR BadTree : DoubleTree); {pair in a tree} BEGIN:   IF (BadTree = NIL)    THENe
      BEGIN        NEW(BadTree);'        BadTree^.FirstWord := WrongWord;e*        BadTree^.SecondWord := CorrectWord;        BadTree^.Left := NIL;        BadTree^.Right := NIL      END    ELSE )      IF (WrongWord < BadTree^.FirstWord) :
       THEN:        InsertDouble(WrongWord, CorrectWord, BadTree^.Left)       ELSE  +        IF (WrongWord > BadTree^.FirstWord) E 	THEN 7 	  InsertDouble(WrongWord, CorrectWord, BadTree^.Right)= END;  : PROCEDURE AddWord (NewWord : WordType; position : INTEGER;! 			      VAR thisword : listptr);r! BEGIN				{add a word to the list}O   IF (thisword = NIL)     THEN 	     BEGIN:       new(thisword);,       thisword^.Name :=	pad(NewWord,' ',32);*       thisword^.length := length(NewWord);%       thisword^.startpos := position;t       thisword^.next :=	NIL;       wordcount:=wordcount+1;g     ENDs    ELSE { Call Recursively }.     AddWord(NewWord, position, thisword^.next) END;     {<FF>,P ================================================================================ }4  & PROCEDURE openfiles;		{open all files}  3 CONST maxexts=7;		{number of meaningful extensions}n   VAR logfilnam,tmpfil:line;<     colonpos,scolonpos,dotpos,bracpos,i,tmpstat,ext:INTEGER;1     extensions:PACKED ARRAY [1..maxexts] OF line;r   BEGIN   D   open(CommonFile,filedir+'Commonwrd.dat',readonly,error:=continue);C   IF status(commonfile)>0 THEN openerror('common word dictionary');=   reset(CommonFile);  I   open (dict1,filedir+'LEXIC08.DAT',history:=readonly,sharing:=readwrite,g= 	access_method:=KEYED,organization:=INDEXED,error:=continue);e=   IF status(dict1)>0 THEN openerror('short word dictionary');    dict1_rab:=pas$rab(dict1);M   dict1_rab^.rab$l_rop := uor(dict1_rab^.rab$l_rop,uor(rab$m_nlk,rab$m_rrl));   I   open (dict2,filedir+'LEXIC16.DAT',history:=readonly,sharing:=readwrite,l= 	access_method:=KEYED,organization:=INDEXED,error:=continue);l>   IF status(dict2)>0 THEN openerror('medium word dictionary');   dict2_rab:=pas$rab(dict2);M   dict2_rab^.rab$l_rop := uor(dict2_rab^.rab$l_rop,uor(rab$m_nlk,rab$m_rrl));e  I   open (dict3,filedir+'LEXIC32.DAT',history:=readonly,sharing:=readwrite,s= 	access_method:=KEYED,organization:=INDEXED,error:=continue);E<   IF status(dict3)>0 THEN openerror('long word dictionary');   dict3_rab:=pas$rab(dict3);M   dict3_rab^.rab$l_rop := uor(dict3_rab^.rab$l_rop,uor(rab$m_nlk,rab$m_rrl));=      open (goodfile,filedir+gdfile,= 	access_method:=KEYED,organization:=INDEXED,history:=UNKNOWN,p% 	sharing:=readwrite,error:=continue);d8   IF status(goodfile)>0	THEN openerror('new word file');"   goodfile_rab:=pas$rab(goodfile);9   goodfile_rab^.rab$l_rop := uor(goodfile_rab^.rab$l_rop,  					uor(rab$m_nlk,rab$m_rrl));t     IF using_persdicte   THEN	     BEGIN;K     open (persdict,'sys$login:'+pdfile,history:=unknown,sharing:=readwrite,r? 	  access_method:=KEYED,organization:=INDEXED,error:=continue);,-     IF status(persdict)>0 THEN persdicterror; $     persdict_rab:=pas$rab(goodfile);;     persdict_rab^.rab$l_rop := uor(persdict_rab^.rab$l_rop,r 					uor(rab$m_nlk,rab$m_rrl));'     END;  '    extensions[1]:='RNO';	{runoff files}s$    extensions[2]:='TEX';	{TeX files}'    extensions[3]:='MSS';	{Scribe files}R-    extensions[4]:='TXT';	{plain vanilla text} +    extensions[5]:='ISSUE';	{CGI issue file}F(    extensions[6]:='LATEX';	{LaTeX files}.    extensions[7]:='SDML';	{VAX Document files}3    filnam:=param;		{wasn't one on the command line} . 				{now we parse the filename - tried to use}/ 				{system services for this - found some odd}i1 				{VMS bugs - decided to do it myself - sigh..}	D    IF length(filnam)>0		{get first word on command line if anything}     THEN			{was there}
      BEGIN;       WHILE (index(filnam,' ')=1) AND (length(filnam)>0) DOt? 	filnam:=substr(filnam,2,length(filnam)-1);	{strip leading " "} *       IF length(filnam)>0	{anything left?}        THENsC 	 filnam:=substr(filnam,1,index(filnam,' ')-1)	{strip trailing " "}r	      END;eF    IF length(filnam)=0		{this is NOT an ELSE! - I fell into this trap}2     THEN			{while trying to clean up the program!}
      BEGIN3       write_menu('','File to check: ',vers:=false); 3       myReadln(Filnam);		{get a filespec from user}s	      END;dA    IF Length(Filnam)=0 THEN GOTO 99;	{user pressed return - exit},/    dotpos:=0;			{position of file.ext type dot}-,    bracpos:=0;			{position of ] in filespec}-    colonpos:=0;			{position of : in filespec}t    ext:=1;			{extension index}2    FOR i := 1 TO length(Filnam) DO	{scan filename}	     BEGINm%      IF filnam[i]='.' THEN dotpos:=i;r&      IF filnam[i]=']' THEN bracpos:=i;'      IF filnam[i]=':' THEN colonpos:=i;a@      IF (filnam[i] IN ['a'..'z'])	{we really do mean letters w/o       					 diacritics only here}	      THENe-        filnam[i] := chr(ord(filnam[i]) - 32);i     END;5    IF ((dotpos=0) OR (dotpos<bracpos))	{no extension}        AND (index(filnam,';')=0)e	     THEN s       BEGIN;( 	filnam:=filnam+'.';		{provide a period}' 	dotpos:=length(filnam)		{fudge dotpos}a
       END;     {evaluate usable_file_name} @   i := max(bracpos,colonpos);		{where "useful" filename starts}	5   scolonpos := index(filnam,';');	{where it must end}i   IF scolonpos>0   THEN.     BEGIN				{there's a semicolon - end on it}<     file_name_len := scolonpos-1-i;	{externally usable part}     ENDo   ELSE     BEGIN				{no semicolon}i?     file_name_len := length(filnam)-i;	{externally usable part}s  6     IF ((dotpos=0) OR (dotpos<bracpos))	{no extension}	     THEN e       BEGINy-       filnam:=filnam+'.';		{provide a period}d,       dotpos:=length(filnam)		{fudge dotpos}
       END;       END;     IF file_name_len>32	   THEN	     BEGIN      file_name_len := 32;9     usable_file_name := substr(filnam,i+1,file_name_len);s     ENDa   ELSEG     usable_file_name := pad(substr(filnam,i+1,file_name_len), ' ', 32);s  0   Open(Document,Filnam,ReadOnly,Error:=Continue,A        user_action:=open_document); {try opening with given name}i"   Reset(Document,Error:=Continue);3   tmpstat:=status(Document);		{see if we succeeded}e     IF tmpstat=0 s   THEN					{we did!}	     BEGINy     IF escapemode=unknown THEN4       BEGIN				{we don't know the file type, but...}A       IF (dotpos=length(filnam)-3) OR	{we have a legal extension}= 	 (dotpos=index(filnam,';')-4)#       THEN				{check if we know it}  	BEGIN' 	IF (substr(filnam,dotpos,4)='.MEM') OR)' 	   (substr(filnam,dotpos,4)='.DVI') ORR' 	   (substr(filnam,dotpos,4)='.POD') ORe' 	   (substr(filnam,dotpos,4)='.EXE') ORe' 	   (substr(filnam,dotpos,4)='.IMP') ORs$ 	   (substr(filnam,dotpos,4)='.DOC') 	THEN ofile_error;  # 	IF substr(filnam,dotpos,4)='.RNO'   	THEN  	  escapemode:=runoff  	ELSEo% 	  IF substr(filnam,dotpos,4)='.TEX' e 	THEN  	  escapemode:=tex _ 	ELSE,% 	  IF substr(filnam,dotpos,4)='.MSS'   	  THEN  	    escapemode:=scribe  	  ELSE # 	    escapemode:=unknown	{we don't}t 	  ENDG 	ELSE IF (dotpos=length(filnam)-4) OR (dotpos=index(filnam,';')-5) THEN  	  BEGIN, 	  IF (substr(filnam,dotpos,5)='.SDML') THEN 	    escapemode := vaxdoc; 	  END% 	ELSE IF (dotpos=length(filnam)-5) ORe 		(dotpos=index(filnam,';')-6) F 	THENc 	  BEGIN) 	  IF (substr(filnam,dotpos,6)='.ISSUE') u 	  THEN  	    escapemode := issue- 	  ELSE IF (substr(filnam,dotpos,6)='.LATEX')i 	  THEN{ 	    escapemode := tex;  	  END;  	END	       END	     ELSE       BEGINn;       IF dotpos=length(filnam)		{a filename without an ext}r
       THEN 	BEGIN 	REPEAT 				{try known exts}" 	  tmpfil:=filnam+extensions[ext];1 	  Open(Document,tmpfil,ReadOnly,Error:=Continue, $ 	       user_action:=open_document);# 	  Reset(Document,Error:=Continue);( 	  tmpstat:=status(Document);  	  ext:=ext+1;$ 	UNTIL (ext>maxexts) OR (tmpstat=0);" 	IF tmpstat=0				{found extension} 	THENa 	  BEGIN, 	  filnam:=tmpfil;			{set filename and mode} 	  CASE ext OF 	  2: escapemode:=runoff;( 	  3: escapemode:=tex; 	  4: escapemode:=scribe;  	  6: escapemode:=issue; 	  7: escapemode:=tex; 	  8: escapemode:=vaxdoc;n! 	  OTHERWISE escapemode:=unknown;e 	  END;m 	  END 	ELSE; 	  BEGIN 	  smg$ring_bell(menu_display);y. 	  write_menu('','Sorry, I can''t find file "') 		+filnam+'". Press any key to quit...'); 
 	  getkey;
 	  GOTO 99 	  END 	END
       ELSE 	BEGIN 	smg$ring_bell(menu_display);s, 	write_menu('','Sorry, I can''t find file "', 		   +filnam+'". Press any key to quit...'); 	getkey; 	GOTO 99 	END
       END;  ;    IF (colonpos>0) OR (bracpos>0)	{device or dir specified}=    THEN=
      BEGIN'      IF colonpos>bracpos		{device only} 	      THEN %        dev:=substr(filnam,1,colonpos)A       ELSE				{device and/or dir}$        dev:=substr(filnam,1,bracpos)      END    ELSE        dev:='';				{filename only}     IF using_listing   THEN	     BEGIN=     IF NOT named_listing THENR@       work_file := substr(filnam,1,dotpos-1)+'.SPELL_WORK_FILE';@     Open(listing,work_file,New,error:=continue);	{open workfile}%     Rewrite(listing,error:=continue);      IF status(listing)>0 n	     THEN h       BEGINm)       smg$erase_display(message_display);lA       smg$paste_virtual_display(message_display,pasteboard,18,2);H%       smg$ring_bell(message_display);t#       smg$put_line(message_display,a: 	      'I don''t seem to be able to open my output file "' 	      +filnam+'"');#       smg$put_line(message_display,gN     'Perhaps you are running out of disk space - please check your quota...');9       write_menu('','Press any key to return to VMS...');e
       getkey;o
       GOTO 99t
       END;     END;  
   IF logging n   THEN	     BEGINgB     logfilnam:=substr(filnam,1,dotpos-1)+'.ERR';	{create filename}@     Open(logfile,logfilnam,New,error:=continue);	{open log file}%     rewrite(logfile,error:=continue);t     END;     IF guidanceNeededR   THEN2     BEGIN				{to use/make records of words ignored+       					 on previous scans of this file}_!     IF NOT namedGuidanceFile THENn)       guidanceFileName:='.GUIDANCE_FILE';c0     open(guidanceFile,guidanceFileName,Readonly,# 	 default:=filnam,error:=continue); (     reset(guidanceFile,error:=continue);  !     IF NOT namedGuidanceFile THENe       BEGINnF       IF status(guidanceFile)>0		{<file>.guidance_file doesn't exist:}3       THEN				{try the generic spell.guidance_file}  	BEGIN2 	open(guidanceFile,'SPELL.GUIDANCE_FILE',Readonly,' 	     default:=filnam,error:=continue);n% 	reset(guidanceFile,error:=continue);   	IF status(guidanceFile)<=0 THEN+ 	  guidanceFileName:='SPELL.GUIDANCE_FILE';h 	END;G
       END;       IF status(guidanceFile)<=02     THEN				{one already exists - we must read it}       BEGINs"       WHILE NOT(eof(guidanceFile))       DO 	BEGIN/ 	readln(guidanceFile,ThisWord,error:=continue);r 	IF ThisWord<>'' 	THENf# 	  Insert ( ThisWord, IgnoreList );H 	END;E+       close(guidanceFile, error:=continue);OJ       open(guidanceFile, guidanceFileName, default:=filnam, history:=old);       extend(guidanceFile);        guidanceOpen := true; 	       ENDe     ELSE       guidanceOpen := false;     END;  +   lib$trim_filespec((filnam),trim_file,30);n;   smg$paste_virtual_display(status_display,pasteboard,4,2); L   smg$put_chars(status_display,substr('Processing file  : '+trim_file,1,50),	 		1,2,1);    CASE escapemode OFJ   runoff :smg$put_chars(status_display,'Embedded commands: Runoff',2,2,1);F   tex 	 :smg$put_chars(status_display,'Embedded commands: TeX',2,2,1);J   scribe :smg$put_chars(status_display,'Embedded commands: Scribe',2,2,1);H   unknown:smg$put_chars(status_display,'Embedded commands: None',2,2,1);K   nroff  :smg$put_chars(status_display,'Embedded commands: n/troff',2,2,1);:I   issue  :smg$put_chars(status_display,'Embedded commands: Issue',2,2,1);aK   vaxdoc :smg$put_chars(status_display,'Embedded commands: VAX Doc',2,2,1);t   END; END;  2 PROCEDURE closefiles;			{close without any errors} BEGIN:    close (dict1,error:=continue);    close (dict2,error:=continue);    close (dict3,error:=continue);%   close (commonfile,error:=continue); #   close (goodfile,error:=continue);S   IF using_persdictL   THEN%     close (persdict,error:=continue);e<   close (document,error:=continue); document_is_open:=false;*   IF using_listing AND (maintmode=normal)    THEN	     BEGINI     IF errorcount=0	     THEN9       close (listing,disposition:=delete,error:=continue)h     ELSE       BEGIN &       close (listing,error:=continue);       IF status(listing)>0  
       THEN 	quoterror;        IF NOT named_listing THENq" 	rename_file(work_file, (filnam));       END; {endif errorcount}      END; {endif using_listing}  
   IF logging E   THEN  	     BEGINB     IF logged_somethingG(     THEN close (logfile,error:=continue)<     ELSE close (logfile,disposition:=delete,error:=continue)     END; END;  9 PROCEDURE ReadInCommonWrds;		{fill the common word array}  VAR I : INTEGER; BEGINH  FOR I := 1 TO NumberOfWords DO^8     Readln(CommonFile,CommonWordList[I],error:=continue) END;  K PROCEDURE PersAdd (WordToAdd : wordtype); {put a word in the personal dict}D VAR tmp:word3; BEGINE   tmp.item:=WordToAdd;'   write(persdict,tmp,error:=continue)  s END;  M FUNCTION Occurs (WordToFind : wordtype) : BOOLEAN; {checks main dictionaries}o   VAR wordlen : INTEGER;     tmp1 : word1;t     tmp2 : word2;      tmp3 : word3;l     found:BOOLEAN;   BEGIN{   IF every_word_ok THEN   occurs:=true ELSE   BEGINg   found:=false;t%   wordlen := index(WordToFind,' ')-1;^1   IF wordlen <= 8		{check appropriate dictionary}l   THEN	     BEGINe&     tmp1.item:=substr(WordToFind,1,8);     findk(dict1,0,tmp1);     found:=NOT ufb(dict1);#     unlock(dict1, error:=continue);:     occurs:=found      ENDT   ELSE       IF wordlen <=16      THEN       BEGIN )       tmp2.item:=substr(WordToFind,1,16);;       findk(dict2,0,tmp2);       found:=NOT ufb(dict2);%       unlock(dict2, error:=continue);O       occurs:=foundT	       ENDs     ELSE       BEGIN        tmp3.item:=WordToFind;       findk(dict3,0,tmp3);       found:=NOT ufb(dict3);%       unlock(dict3, error:=continue);+       occurs:=founds
       END;   IF using_persdict    THEN	     BEGINc3     IF NOT found			{check personal dictionary last}      THEN       BEGIN.       tmp3.item:=WordToFind;       findk(persdict,0,tmp3);L"       occurs := NOT ufb(persdict);(       unlock(persdict, error:=continue);
       END;     END;   END; END;      < FUNCTION find_in_goodfile ( ThisWord : WordType ) : BOOLEAN;   VAR tmp : word3s;o   BEGINt   tmp.item := ThisWord;_  / findk (goodfile, 0, tmp.item, error:=continue);B IF ufb(goodfile) THEN   find_in_goodfile := falsee ELSE   BEGIN.   find_in_goodfile := true;    END;" unlock(goodfile, error:=continue);   END;    H PROCEDURE Check(VAR WordToCheck : wordtype ); {checks spellings in dict}# VAR oldword:wordtype;found:BOOLEAN;  BEGINo   WordToCheck:='';   found:=false;    REPEATN     write_menu('','Spelling to check (press <return> to quit): ',vers:=false);0     oldword:=WordToCheck;			{keep previous word}     myreadln(WordToCheck);     IF length(WordToCheck)>0	      THENs)       IF occurs(pad(WordToCheck,' ',32)) v 	THENh 	 BEGIN^# 	   write_menu('','"'+WordToCheck+ E> 		   '" is in the dictionary - press any key to continue...'); 	   getkey;; 	   found:=true; 	 END= 	ELSEv 	 BEGIN= 	  write_menu('',cG 	    '"'+WordToCheck+'" was not found - press any key to continue...');B	 	  getkeyv 	 END;*    UNTIL (length(WordToCheck)=0) OR found;K    IF NOT found THEN WordToCheck:=oldword;	{only change word if it's there}T END;  J FUNCTION iscommonword (key : wordtype) : BOOLEAN;	{check for common words} VAR^  found : BOOLEAN;t  low, high, mid : INTEGER; BEGINn  found := false; N  low := 1;    high := NumberOfWords;E'  WHILE (low <= high) AND (NOT found) DOF   BEGINf    mid := (low + high) DIV 2;G    IF key = CommonWordList[mid] 
      THEN        found := trueg	      ELSEs"       IF key < CommonWordList[mid]        THEN  	high := mid - 1        ELSE  	low := mid + 1;   END; _   IF found      THEN      IsCommonWord := true r    ELSE      IsCommonWord := false; END;    B PROCEDURE status_line(number:INTEGER);	{tell user what's going on}0 VAR temp_string1,temp_string2,temp_string3:line;     average:REAL;T     temp_position : INTEGER;   BEGINa IF NOT every_word_ok THEN   BEGIN    IF wordcount>0     THEN$     average:=lettertotal / wordcount   ELSE     average:=0.0;o  #   writev(temp_string1,average:3:1);;L   smg$put_chars(status_display,substr('Processing file  : '+trim_file,1,50)+& 		'Word length: '+temp_string1,1,2,1);     CASE escapemode OFA     runoff:temp_string1:=pad('Embedded commands: Runoff',' ',50);r>     tex   :temp_string1:=pad('Embedded commands: TeX',' ',50);A     scribe:temp_string1:=pad('Embedded commands: Scribe',' ',50);p?    unknown:temp_string1:=pad('Embedded commands: None',' ',50);{B     nroff :temp_string1:=pad('Embedded commands: n/troff',' ',50);@     issue :temp_string1:=pad('Embedded commands: Issue',' ',50);B    vaxdoc :temp_string1:=pad('Embedded commands: VAX Doc',' ',50);
   END; {CASE}i  $   writev(temp_string2,errorcount:1);I   smg$put_chars(status_display,temp_string1+'Error count: '+temp_string2,W 								2,2,1);t      writev(temp_string1,number:1);#   writev(temp_string3,wordcount:1);=+   temp_position:=current_document_position;=   IF temp_position>=0i   THEN	     BEGINe5     writev(temp_string2,current_document_position:1);sH     smg$put_chars(status_display,pad('Processing line  : '+temp_string1+& 				   ' ('+temp_string2+'%)',' ',50)+( 		  'Word count : '+temp_string3,3,2,1);     ENDn   ELSEP     smg$put_chars(status_display,pad('Processing line  : '+temp_string1,' ',50)+( 		  'Word count : '+temp_string3,3,2,1);   END;   END;    O PROCEDURE RecordGuidance ( ThisWord : WordType ); {put word into guidance file}    BEGINe   IF NOT guidanceOpenn THEN   BEGIN:8   open(guidanceFile, guidanceFileName, default:=filnam, &        history:=new, error:=continue);)   rewrite(guidanceFile, error:=continue);t   IF status(guidanceFile)<=0   THEN     guidanceOpen:=true;i   END;   IF guidanceOpen: THEN"   writeln(guidanceFile, ThisWord);   END;    = PROCEDURE ReadTextLine;			{build a tree of words from a line}T VAR InLine : Line;      Count, LineLength : INTEGER;     ScratchWord : wordtype;^2     TeXkwdstart : INTEGER;		{start of TeX keyword}M     State : (BetweenWords, InWord, escape, TeXescape, VAXDocArg, apostrophe);:  M FUNCTION checkescape(count:INTEGER):BOOLEAN; {check for embedded WP commands}F   BEGINi   checkescape:=false;l1 CASE escapemode OF			     {select appropriate WP};
 runoff:	BEGINr: 	IF (count=1) AND (inline[count]='.')	{does <ret>.NF type} 	THEN  	  checkescape:=true= 	ELSE IF (count>1) AND (count<linelength) {does .NF .AP type}: 	THENN( 	  IF (inline[count-1] IN [';',' ']) AND2 	     (inline[count+1] IN ['A'..'Z','a'..'z']) AND$ 						{we really do mean letters w/o!      						 diacritics only here}u 	     (inline[count]='.')  	  THENr 	    checkescape:=true 	END;F  , tex:	BEGIN					{the only simple thing about}1 	IF inline[count]='\'			{TeX! FSAs are such fun!}n 	THENw 	  BEGIN 	  TeXkwdstart := count+1; 	  checkescape:=true;c 	  END;, 	END;F  
 scribe:	BEGIN>7 	IF inline[count]='@'			{this part is simple in scribe}e 	THEN  	  checkescape:=true;  	END;p  + nroff:	IF (count=1) AND (inline[count]='.')b 	THEN  	  checkescape := true;i  + issue:	IF (count=1) AND (inline[count]='&')] 	THEN  	  checkescape := true;n  6 vaxdoc: IF inline[count]='<' THEN checkescape := true;   unknown: {do nothing};   END;   END;  7 PROCEDURE processescape;			{get out of WP command mode}i' VAR tmpcol:INTEGER;				{column pointer}m      diff:INTEGER;				{temporary}!     TeXkwd:line;				{TeX keyword}	   BEGIN						{if necessary}t   CASE escapemode OF? runoff:	IF inline[count] IN [';',' '] THEN state:=betweenwords;    tex:	IF count = TeXkwdstartI 	THENh 	  BEGIN4 	  IF NOT (inline[count] IN ['@','A'..'Z','a'..'z']) 	  THEN  	    state := BetweenWords;L 	  END3 	ELSE IF inline[count] IN [' ','	','{','}','[',']']s 	THENi 	  BEGIN< 	  TeXkwd := substr(inline, TeXkwdstart, count-TeXkwdstart);- 	  IF (TeXkwd='begin ') OR (TeXkwd='end ') ORs" 	     (TeXkwd='documentstyle ') OR; 	     (TeXkwd='pagestyle ') OR (TeXkwd='thispagestyle ') OR # 	     (TeXkwd='bibliographystyle ')a 	  THENH 	    state:=TeXescapel 	  ELSEe 	    state:=BetweenWords;  	  END;e  N scribe: {apparently Scribe does not have anything which might be described as H 	  a parser - hence it is almost impossible to escape all legal commandsB 	  without writing Scribe all over, however this does for most...}  7 	IF inline[count] IN [' ','(','<','{','"','''','[','`']0 	THENs 	  BEGIN1 	  tmpcol:=count-1;			{don't check the delimiter}F 	  IF count>1 & 	  THEN					{only if there's anything} 	    WHILE (tmpcol>1) AND  		  (NOT (inline[tmpcol] IN + 		    ['@','(','<','{','"','''','[','`'])) : 	    DOl9 	      tmpcol:=tmpcol-1;			{find the @ or previous delim} 4 	  diff:=count-tmpcol;			{save invariant expression}# 	  IF diff >= 4				{could be @end(}( 	  THEN					{keep trying if so}I' 	    IF substr(inline,tmpcol,4)<>'@end't
 	    THEN  	      state:=betweenwords;e% 	  IF diff >= 6				{could be @begin(}l 	  THEN					{ditto}p) 	    IF substr(inline,tmpcol,6)<>'@begin'p
 	    THEN  	      state:=betweenwords;l  " 	  IF diff < 4				{something else} 	  THEN 7 	    state:=betweenwords;		{whatever it was, it's over}; 	  END;					{thank God!}   issue:	IF inline[count]=' '  	THEN  	  state := betweenwords;n  , nroff:	IF (inline[count]=' ') OR (count>=3)  	THEN  	  state := betweenwords;E  " vaxdoc: IF inline[count]='>' THEN  	  BEGIN 	  IF count<linelength THENn
 	    BEGIN  	    IF inline[count+1]='(' THEN 	      state := VAXDocArgo	 	    ELSEN 	      state := betweenwords;= 	    END 	  ELSEd 	    state := betweenwords;e 	  END;a  & unknown: {how did we get here anyway?} 	  state:=betweenwords;	    END END;     PROCEDURE processTeXescape;  BEGINb. IF inline[count]='}' THEN state:=BetweenWords; END;     PROCEDURE processVAXDocArg;a   BEGIN(2     IF inline[count]=')' THEN state:=BetweenWords;   END; {processVAXDocArg},    7 PROCEDURE processbetween;	{we're in between-words mode}e BEGINt5  IF checkescape(count)		{see if this is a WP command}m   THEN    state:=escape   ELSE    BEGINI     IF (InLine[Count] IN all_lower_case) {we found a new word beginning -d-     					  NB, words can't start with esszet,h 					  but there we are ;-}F	      THENn       BEGIN)*        IF (Length(ScratchWord) < maxword)  	THENi 	  BEGIN9 	    ScratchWord := ScratchWord + substr(InLine,Count,1);t  	    lettertotal:=lettertotal+1; 	  END;	        State := InWord
       END;)    END;					{else throw away punctuation}b END;  , PROCEDURE processin;		{we're reading a word} BEGIN)?   IF (InLine[Count] IN all_lower_case)	{we still have a letter}r$     THEN				{tack it on to the word}
      BEGIN)       IF (Length(ScratchWord) < maxword) u 	THENl 	  BEGIN9 	    ScratchWord := ScratchWord + substr(InLine,Count,1);u  	    lettertotal:=lettertotal+1; 	  END;	      END     ELSE				{we have non-alpha}p5      IF (inline[count] = '''') AND (count<linelength)n       THEN				{we have a "'"}(
        BEGIN T' 	IF inline[count+1] IN alphabetic_charso 	THEN ; 	 state:=apostrophe		{"can't" or "Mark's" is an apostrophe}p! 	ELSE				{'quote' is a quotation}=! 	 BEGIN				{quotations end words}B> 	   AddWord(ScratchWord, count-length(ScratchWord), TextLine);) 	   ScratchWord := '';			{clear the word}l6 	   IF checkescape(count)	{change state appropriately}
 	    THEN  	     state:=escape 	 	    ELSE  	     State := BetweenWords; 	 END; 	END,        ELSE				{this is the end of the word}0 	 BEGIN				{add it to textline and change state}> 	   AddWord(ScratchWord, count-length(ScratchWord), TextLine); 	   ScratchWord := ''; 	   IF checkescape(count) 
 	    THEN  	     state:=escape 	 	    ELSEt 	     State := BetweenWords; 	 END; END;  B PROCEDURE ProcessApostrophe;		{how to deal with those darned "'"s}  > VAR possessive : BOOLEAN;		{too complicated to write out in an!   					 IF statement's condition}    BEGINa  5 IF inline[count] = 's'			{this could be a possessive}e THEN   BEGIN    IF count<linelength    THEN9     possessive:=(NOT (inline[count+1] IN all_lower_case))   					{is it "<word>'s<letters>"? 					 - MUST be a typo!}   ELSE     possessive:=true;'   ENDf ELSE   possessive:=false;  
 IF possessive. THEN					{throw it away}   BEGIND>   AddWord(ScratchWord, count-length(ScratchWord)-1, TextLine);   ScratchWord := '';-   State := BetweenWords;		{end the word here}k   ENDu ELSE'   BEGIN					{this is a real apostrophe} 8   ScratchWord:=ScratchWord+''''+inline[count];	{keep it})   state:=inword			{we're still in a word}s   END;   END;   BEGIN {ReadTextLine}4    LineNumber := LineNumber + 1;	{update line count}?    IF linenumber MOD 10 = 0 THEN	{update status every 10 lines}        status_line(linenumber);(    TextLine := NIL;			{start a new list}B    readln(document, inline, error:=continue);	{get a line of text}     LineLength := length(inline);&    prevline:=currline;			{set globals}    currline:=inline;  /    { Make sure the whole line is lower case.  } "    FOR Count := 1 TO LineLength DO/     IF (InLine[Count] IN upper_case_chars) THEN_4       inline[count] := chr(ord(inline[count]) + 32); {     ^ ^	See?	}  5    ScratchWord := '';				{start up line analysis FSA}$    IF NextLineTeXescapea    THEN'
      BEGIN      State := TeXescape;       NextLineTeXescape := FALSE;      END!    ELSE IF NextLineVAXDocArg THENP
      BEGIN      State := VAXDocArg;       NextLineVAXDocArg := FALSE;      END    ELSE'      State := BetweenWords;   "    FOR Count := 1 TO LineLength DO      CASE State OF$        BetweenWords: processbetween;        InWord:	     processin;"        escape:	     processescape;&        TeXescape:    processTeXescape;&        VAXDocArg:    processVAXDocArg;'        apostrophe:   ProcessApostrophe;;	      END;i4    IF (State = InWord)			{process last word on line}    THENsE      AddWord(ScratchWord, linelength-length(ScratchWord)+1, TextLine)d    ELSEi
      BEGIN      IF (State=TeXescape) THEN         NextLineTeXescape := TRUE#      ELSE IF (State=VAXDocArg) THENf!        NextLineVAXDocArg := TRUE;(	      END;e END;  I FUNCTION OccursInTree ( WordToFind : wordtype; WordList: Tree) : BOOLEAN;a  ! BEGIN					{find a word in a tree}_   IF (WordList = NIL)  THEN   OccursInTree := FALSEe ELSE a!   IF (WordList^.Name = ThisWord)	i   THEN     OccursInTree := TRUE   ELSE e#     IF (WordList^.Name < ThisWord)	s     THEN=       OccursInTree := OccursInTree(ThisWord, WordList^.Right)g	     ELSE N=       OccursInTree := OccursInTree(ThisWord, WordList^.Left);u   END;    G PROCEDURE SearchDouble (WordToFind : wordtype; Misspelled : Doubletree; 4 			VAR Found : BOOLEAN; VAR CorrectWord : wordtype);, 			{look for a word in the wrong/right list} BEGIN    IF (Misspelled = NIL)      THEN        Found := FALSE 	     ELSE  /        IF (Misspelled^.FirstWord = WordToFind) p 	 THEN	 	   BEGINi 	     Found := TRUE;+ 	     CorrectWord := Misspelled^.SecondWordc 	   END  	 ELSE d* 	   IF Misspelled^.FirstWord < WordToFind 	 	    THENeG 	       SearchDouble(WordToFind, Misspelled^.Right, Found, CorrectWord) 
 	    ELSE F 	       SearchDouble(WordToFind, Misspelled^.Left, Found, CorrectWord) END;    ? PROCEDURE querycase;		{makes sure that case of corrected words}e  - VAR ch:CHAR;			{is right - asks if necessary}l     i:INTEGER;K     allupper,alllower,capital:BOOLEAN;	{knows about normal capitalizations}n     tmpword:wordtype;i  @ PROCEDURE getnewcase;		{get proper case if necessary - only for}   VAR key : keystroke;!     cursor_col, wd_ptr : INTEGER;:  ! BEGIN				{weird words like "TeX"}r  = IF NOT yesanswer('Are you happy with the capitalization of "': 						+correctword+'"')l THEN   BEGINmO {==============================================================================:G   write_menu('','Please type the word the way you want it to appear: ',t 	       vers:=false);    myreadln(correctword)nO ==============================================================================} <   write_menu('Correct case:', ' '+correctword, vers:=false);   cursor_col:=15; wd_ptr:=1;2   smg$set_cursor_abs(menu_display, 1, cursor_col);   REPEAT     key:=getkey;     CASE key.term_code OF;     smg$k_trm_left:	IF wd_ptr=1d 			THEN   			  smg$ring_bell(menu_display) 			ELSE 
 			  BEGIN 			  wd_ptr:=wd_ptr-1;8 			  smg$set_cursor_rel(menu_display, delta_column:=-1);	 			  END; 2     smg$k_trm_right:	IF wd_ptr=length(correctword) 			THEN   			  smg$ring_bell(menu_display) 			ELSEs
 			  BEGIN 			  wd_ptr:=wd_ptr+1;7 			  smg$set_cursor_rel(menu_display, delta_column:=1);i	 			  END;t     smg$k_trm_bs,g     smg$k_trm_f12:	IF wd_ptr=1 			THENo  			  smg$ring_bell(menu_display) 			ELSEn
 			  BEGIN 			  wd_ptr:=1;l5 			  smg$set_cursor_abs(menu_display, 1, cursor_col); 	 			  END;      smg$k_trm_ctrle,0     smg$k_trm_kp2:	IF wd_ptr=length(correctword) 			THENI  			  smg$ring_bell(menu_display) 			ELSEo
 			  BEGIN! 			  wd_ptr:=length(correctword); 4 			  smg$set_cursor_abs(menu_display, 1, cursor_col+ 							      wd_ptr-1); 	 			  END;dA     smg$k_trm_up:	IF correctword.body[wd_ptr] IN upper_case_charst 			THEN   			  smg$ring_bell(menu_display) 			ELSEy
 			  BEGIN 			  correctword.body[wd_ptr]:= - 			    chr(ord(correctword.body[wd_ptr])-32); ! 			  smg$put_chars(menu_display,  " 					substr(correctword,wd_ptr,1), 					1, cursor_col+wd_ptr-1);r" 			  IF wd_ptr=length(correctword)	 			  THEN 6 			    smg$set_cursor_abs(menu_display, 1, cursor_col+ 								wd_ptr-1)a	 			  ELSEN 			    wd_ptr:=wd_ptr+1;	 			  END;oC     smg$k_trm_down:	IF correctword.body[wd_ptr] IN lower_case_chars  			THENk  			  smg$ring_bell(menu_display) 			ELSEn
 			  BEGIN 			  correctword.body[wd_ptr]:= - 			    chr(ord(correctword.body[wd_ptr])+32);(! 			  smg$put_chars(menu_display, t" 					substr(correctword,wd_ptr,1), 					1, cursor_col+wd_ptr-1);:" 			  IF wd_ptr=length(correctword)	 			  THEN 6 			    smg$set_cursor_abs(menu_display, 1, cursor_col+ 								wd_ptr-1)m	 			  ELSE  			    wd_ptr:=wd_ptr+1;	 			  END;d       smg$k_trm_help:	BEGIN % 			put_help('CHECK_CASE.SPELL_HELP');g0 			write_menu('Correct case:', ' '+correctword,  								vers:=false);n2 			smg$set_cursor_abs(menu_display, 1, cursor_col+ 								wd_ptr-1); 			END;s       smg$k_trm_cr,      smg$k_trm_f10,6     smg$k_trm_enter:	{do nothing - these take us out};+     OTHERWISE		smg$ring_bell(menu_display);N     END;H   UNTIL (key.term_code=smg$k_trm_cr) OR (key.term_code=smg$k_trm_f10) OR% 					(key.term_code=smg$k_trm_enter);o   END;   END;     BEGIN {querycase} A    tmpword:=substr(currline,textline^.startpos,textline^.length);.2    allupper:=true; alllower:=true; capital:=false;:    IF textline^.length=1	{original word was single letter}     THEN
      BEGINL       IF length(correctword)=1	{set one-letter replacement to original case} 	THENc 	 BEGIN * 	  IF (tmpword[1] IN lower_case_chars) AND* 	     (correctword[1] IN upper_case_chars) 	  THENf; 	    correctword.body[1]:=chr(ord(correctword.body[1])+32); * 	  IF (tmpword[1] IN upper_case_chars) AND* 	     (correctword[1] IN lower_case_chars) 	  THEN,; 	    correctword.body[1]:=chr(ord(correctword.body[1])-32);c 	 END	3 	ELSE			{don't know case if original is one letter}e) 	 getnewcase		{and replacement is longer}N      END"     ELSE			{multi letter original}"      IF length(correctword)>0 THEN       BEGIN -        IF tmpword.body[1] IN upper_case_charsL*        THEN capital:=true;			{initial Cap}7        FOR i:=1 TO textline^.length DO		{get word type}t 	BEGIN' 	IF tmpword.body[i] IN upper_case_charsw 	 THEN	 	   BEGIN	 	   alllower:=false;			{not lc}f* 	   IF i>1 THEN capital:=false;		{not Cap} 	   END;( 	 IF tmpword.body[i] IN lower_case_chars" 	 THEN allupper:=false;			{not UC} 	END;(4        IF capital 				{this is a "Capitalized" word} 	THENI 	 BEGINo2 	  IF correctword.body[1] IN lower_case_chars THEN> 	       correctword.body[1]:=chr(ord(correctword.body[1])-32);% 	  FOR i:=2 TO length(correctword) DO 2 	  IF correctword.body[i] IN upper_case_chars THEN> 	       correctword.body[i]:=chr(ord(correctword.body[i])+32); 	 ENDC 	ELSEt0 	 IF alllower				{this word is all "lower" case} 	  THEN 	 	   BEGIN1' 	    FOR i:=1 TO length(correctword) DOr6 	      IF correctword.body[i] IN upper_case_chars THEN8 		 correctword.body[i]:=chr(ord(correctword.body[i])+32) 	   ENDv 	  ELSEt2 	   IF allupper				{this word is all "UPPER" case}	 	    THENm 	     BEGINr) 	      FOR i:=1 TO length(correctword) DOs6 	      IF correctword.body[i] IN lower_case_chars THEN8 		 correctword.body[i]:=chr(ord(correctword.body[i])-32)	 	     END_	 	    ELSEd. 	     getnewcase				{ask user to specify case}
       END; END;  6 PROCEDURE updateline;				{fix line after a correction} 						{updates global currline}b VAR tmproot:listptr;     secpos,diff:INTEGER;     part1,part2:line;'   BEGIN   , errorcount:=errorcount+1;			{fixed an error} IF logging 0 THEN     BEGINmL   writeln(logfile,'line ',linenumber:4,': "',ThisWord:index(ThisWord,' ')-1,D 	    '" --> "',correctword:length(correctword),'"',error:=continue);   logged_something :=true;   END;  2 tmproot:=textline;				{remember root of word list}K diff:=index(ThisWord,' ')-length(correctword)-1;{get difference in lengths}t  2 IF textline^.startpos>1				{split currline in two} THENC   part1:=substr(currline,1,textline^.startpos-1){part1 up to error}t ELSE   part1:='';  @ secpos:=textline^.startpos+textline^.length;	{part2 after error} IF secpos<=length(currline)  THEN:   part2:=substr(currline,secpos,length(currline)-secpos+1) ELSE   part2:='';  & currline:='';					{clear current line} IF length(part1)>0 THEN3   currline:=part1+correctword			{assemble new line}s ELSE   currline:=correctword; IF length(part2)>0 THEN   currline:=currline+part2;p( textline^.length:=textline^.length-diff;  / WHILE textline<>NIL 				{patch word-list start}c DO'   BEGIN						{positions for subsequent} C   textline^.startpos:=textline^.startpos-diff;	{fixes on same line}c   textline:=textline^.next   END;  1 textline:=tmproot;				{restore word-list pointer}g   END;  ' PROCEDURE update_disposition(str:line);d VAR temp_string:line;R   BEGINt  ! writev(temp_string,linenumber:5);  smg$put_chars(error_display,F 	      temp_string+'         '+pad(ThisWord,' ',32)+'>>>   '+str,3,1);   END;    M {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++aK Expand_line expands all tabs in the input line to spaces, then extracts the{M relevant bit of the line into the output line, setting clipleft and cliprightmK to indicate where the line had to be truncated for contextscreen's use (thelL position and size of the word (if any) that needs to be highlit are given inN duffpos and dufflen; expand_line updates duffpos if necessary to show movement arising from tabs.  M Expand_line may be used for both currline and prevline (for which set duffposl to 1 in call).N -----------------------------------------------------------------------------}= PROCEDURE expand_line (VAR inputline : line;		{in: line to beb 							 processed}6 		       VAR outputline : line;		{out: processed line}5 		       VAR duffpos : INTEGER;		{in: the position ofE 							     the problem word 							     in inputline 							 out: ditto in  							      outputline}1 		       dufflen : INTEGER;		{in: length of same}i9 		       VAR clipleft : BOOLEAN;		{out: clipped at left?}u: 		       VAR clipright : BOOLEAN);	{out:           right?}  . VAR char_cols : ARRAY [1..maxline] OF INTEGER;     i : INTEGER;     lstr : INTEGER;n     col : INTEGER;@     lastnb : INTEGER := 0;	{last non-blank position on the line}     optr : INTEGER := 1;     iptr : INTEGER := 1;     newleftmarg : INTEGER;     tmplen, tmppos : INTEGER;      opos : INTEGER;s     ch : CHAR;     hadtab : BOOLEAN := FALSE;   BEGIN    lstr := length(inputline);	 col := 1;e   FOR i := 1 TO lstr DOI   BEGIN    char_cols[i] := col;$   IF inputline.body[i] = chr(9) THEN4     BEGIN				{The hacker's instinct here is to mask;( 					 however, VAX Pascal makes one jump* 					 through so many hoops it's not worth 					 (Wirth?) it!},'     col := (((col + 7) DIV 8) * 8) + 1;n     hadtab := TRUE;)     END    ELSE$     BEGIN {normal character advance}1     IF inputline.body[i] <> ' ' THEN lastnb := i;      col := col+1;a     END;5   END; {calculate column positions of each character}a   IF lastnb = 0 THENM   BEGIN {it's a totally empty line (presumably we're looking at prevline ;-)}r   outputline := '';    clipleft := FALSE;   clipright := FALSE;    ENDo1 ELSE IF char_cols[lastnb] <= (screen_cols-2) THEN $   BEGIN {we can fit the entire line}   clipleft := FALSE;   clipright := FALSE;    newleftmarg := 1;t   IF NOT hadtab THEN4     BEGIN {no tabs: dead simple (duffpos unchanged)}H     outputline := inputline;	{let the compiler optimise the common case}     END    ELSE	     BEGIN'     FOR i := 1 TO lastnb DO &       BEGIN {expand tabs as necessary}(       IF inputline.body[i] = chr(9) THEN& 	BEGIN {insert spaces to expand a tab} 	WHILE optr < char_cols[i+1] DO( 	  BEGIN  	  outputline.body[optr] := ' '; 	  optr := optr+1; 	  END;e 	END
       ELSE 	BEGIN {simply copy character}, 	outputline.body[optr] := inputline.body[i]; 	optr := optr+1; 	END;s
       END;  "     duffpos := char_cols[duffpos];      outputline.length := optr-1;     END;   ENDi ELSE#   BEGIN {can't fit the entire line}s0   tmplen := (screen_cols-2)-line_break_flag_len;/   tmppos := char_cols[duffpos]+(dufflen DIV 2); "   IF tmppos <= (tmplen DIV 2) THEN	     BEGIN[     clipleft := FALSE;     clipright := TRUE;     newleftmarg := 1;c"     duffpos := char_cols[duffpos];     END 9   ELSE IF tmppos >= char_cols[lastnb]-(tmplen DIV 2) THEN=9     BEGIN			   {duff word is sufficiently near the end ofa. 				    the line that we can display up to the0       	      	      	      	    end of the line}     clipleft := TRUE;}     clipright := FALSE;	2     newleftmarg := char_cols[lastnb] - tmplen + 1;4     duffpos := char_cols[duffpos] - newleftmarg + 2;     END    ELSE3     BEGIN			   {really short of space - neither the'N                                     left nor the right margin of the line will:       	      	      	      	    fit on the context screen}     clipleft := TRUE;s     clipright := TRUE;  G     {there is a break at beginning and end of the line, so it loses yetc-      another character to the dread diamonds}	)     tmplen := tmplen-line_break_flag_len;	  9     {fix the middle of the duff word in the middle of the       displayed bit of the line} E     newleftmarg := char_cols[duffpos]+(dufflen DIV 2)-(tmplen DIV 2);,4     duffpos := char_cols[duffpos] - newleftmarg + 2;     END;  (   {now copy what's needed to the output}(   WHILE char_cols[iptr] < newleftmarg DO     iptr := iptr+1;i     opos := newleftmarg;   WHILE optr <= tmplen DOc	     BEGINi!     WHILE opos<char_cols[iptr] DOc       BEGINe#       outputline.body[optr] := ' ';S       optr := optr+1;u       opos := opos+1; 
       END;     ch := inputline.body[iptr];o     iptr := iptr+1;t      IF ch=CHR(9) THEN ch := ' ';      outputline.body[optr] := ch;     optr := optr+1;n     opos := opos+1;(     END;   outputline.length := optr-1;   END; END; {procedure expand_line}    M {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++aF Write out the `context' of a spelling error we've detected, prompt for action if `pr' is TRUE  0 Uses expand_line for all the _really_ dirty workN -----------------------------------------------------------------------------}D PROCEDURE contextscreen(pr:BOOLEAN:=true);	{writes error in context}# 						{also prompts if "pr" is set}   # VAR tmppos,tmpstart,tmplen:INTEGER;f     temp_string:line;{     duff_word_len : INTEGER;     duff_word_pos : INTEGER;:     context_line : line;		{the line to output for context}<     rendition_set : line;		{the rendition string for output}>     context_column : INTEGER := 1;	{where context_line starts}"     i : INTEGER;			{loop variable}-     cl, cr : BOOLEAN;			{clipping indicators}e   BEGINN  ( smg$begin_pasteboard_update(pasteboard); status_line(linenumber); IF pr  THEN   BEGINl8   smg$unpaste_virtual_display(error_display,pasteboard);#   smg$erase_display(error_display);N:   smg$paste_virtual_display(error_display,pasteboard,9,2);#   writev(temp_string,linenumber:5);	   smg$put_line(error_display, F 	       ' Line Number  Word Not Found                  Disposition  ', 	       2);	   smg$put_line(error_display,d? 	       temp_string+'         '+pad(ThisWord,' ',32)+'>>>   ');a   END;  # smg$erase_display(context_display);t IF NOT pasted  THEN=   smg$paste_virtual_display(context_display,pasteboard,14,2);:
 pasted:=true;'  ? expand_line(prevline, context_line, context_column, 0, cl, cr);d> smg$put_chars(context_display, context_line, prevline_row, 1);
 IF cr THEN0   smg$put_chars(context_display,line_break_flag,& 		prevline_row,79-line_break_flag_len,& 		character_set:=smg$c_spec_graphics);  " duff_word_len := textline^.length;< duff_word_pos := textline^.startpos;	{initial conditions...}# expand_line(currline, context_line,p+ 	    duff_word_pos, duff_word_len, cl, cr);n
 IF cl THEN"   BEGIN {clipped at start of line}B   smg$put_chars(context_display, line_break_flag, currline_row, 1,& 		character_set:=smg$c_spec_graphics);*   context_column := 1+line_break_flag_len;   END  ELSE   context_column := 1;  K smg$put_chars(context_display, context_line, currline_row, context_column);   
 IF cr THEN;   BEGIN {clipped at end of line (possibly both, of course)}E=   smg$put_chars(context_display,line_break_flag,currline_row,: 		79-line_break_flag_len,V& 		character_set:=smg$c_spec_graphics);   END;  % smg$change_rendition(context_display, # 		     currline_row, duff_word_pos,  		     1, duff_word_len,' 		     rendition_set := smg$m_reverse);;  & smg$end_pasteboard_update(pasteboard);   END;  L PROCEDURE judge(VAR textline:listptr);	{main judgement procedure for errors}   VAR Count : INTEGER;     Verdict : CHAR;I     key : keystroke;     oldword : listptr;    = FUNCTION guess:BOOLEAN;			{guess a spelling - add any clever}r" 					{guessing algorithms in here}  1 LABEL 88,89;				{no real excuse here - the logic}X( 					{actually seemed clearer with them}   VAR i,col:INTEGER;;     oldword,tmpword:wordtype;		{...to the author at least!}I     ch:CHAR;     go_on,guessed:BOOLEAN;D     guess_key_awaits : BOOLEAN := FALSE; {for asynchronous keyboard}@     guesses : ARRAY ['a'..'z'] OF wordtype; {accumulated so far}1     guess_index : CHAR := 'a';		{next one to add}E9     guess_display_row : INTEGER := 1;	{where to display } 7     guess_display_col : INTEGER := 1;	{ the next guess}g      : [asynchronous,unbound] PROCEDURE unsol_input_notification;   BEGINf   had_unsol_input := TRUE;   END;      9 FUNCTION display_guess (next_guess : wordtype) : BOOLEAN;u  ; {Display a guess in the asynchronous guess virtual display}   > VAR guess_length : INTEGER;	{for calculating position of next}'     guess_scan : CHAR;		{loop variable} O     already_guessed : BOOLEAN := FALSE; {is there an existing guess of the same=3                                          spelling?}    BEGIN    guess_scan := 'a';9 WHILE ((guess_scan<='z') AND (guess_scan<guess_index) ANDo 			     (NOT already_guessed)) DO   BEGINr#   IF next_guess=guesses[guess_scan]h   THEN     already_guessed := TRUE;!   guess_scan := succ(guess_scan);D   END;   IF (NOT already_guessed) THEN   BEGINw*   guess_length := index(next_guess,' ')-1;,   IF guess_length<0 THEN guess_length := 32;  5   IF guess_display_col+guess_length+3 > screen_cols-2s   THEN	     BEGINd+     guess_display_row:=guess_display_row+1;c     guess_display_col:=1;}     END;  =   smg$put_chars(guess_display, chr(ord(guess_index)-32)+': '+e, 			       substr(next_guess,1,guess_length),( 		guess_display_row, guess_display_col);   smg$flush_buffer(pasteboard);   8   guess_display_col :=	guess_display_col+guess_length+5;  K   {the following check won't be necessary when confirmguess responds to ouro"    function result being FALSE...}   IF guess_index<='z'n   THEN'     guesses[guess_index] := next_guess;=#   guess_index := succ(guess_index);=   END;   IF guess_index>'z' THEN display_guess:=FALSEv ELSE display_guess:=TRUE;=   END;    3 PROCEDURE get_guess_disposition (max_guess : CHAR);;  " VAR got_ok_key : BOOLEAN := FALSE;     key_return : INTEGER;$     key : keystroke;   BEGINE   REPEATL   key_return := smg$read_keystroke(keyboard,key.term_code); {ignores return,E                                                              pro tem}mF   IF ((key.term_code=SMG$K_TRM_CTRLZ) OR (key.term_code=smg$k_trm_pf4)3 				      OR (key.term_code=smg$k_trm_next_screen))w   THEN,     GOTO 89				{request to abandon guessing}K   ELSE IF ((key.term_code=smg$k_trm_pf2) OR (key.term_code=smg$k_trm_help))    THEN      put_help('guess.spell_help')   ELSE	     BEGING!     IF key.ch IN upper_case_charsc     THEN$       key.ch := chr(ord(key.ch)+32);+     IF ((key.ch<'a') OR (key.ch>max_guess)):     THEN       BEGINc#       smg$ring_bell(guess_display);m!       smg$cancel_input(keyboard); 	       END:     ELSE       BEGIN        got_ok_key:=true;e!       tmpword := guesses[key.ch];        GOTO 88;
       END;     END; UNTIL got_ok_key;t   END;  D FUNCTION confirmguess:BOOLEAN;		{see if synthesized spelling exists}  + VAR We_have_it : BOOLEAN;	{look-up success}[3     key : keystroke;		{for determining what's what}33     key_return : INTEGER;	{have we read something?}(   BEGINr  2 We_have_it :=	OccursInTree( tmpword, IgnoreList );= IF NOT We_have_it THEN We_have_it := IsCommonWord( tmpword );b7 IF NOT We_have_it THEN We_have_it := occurs( tmpword );E  5 IF We_have_it				{same check as for any word in text}_ THEN   BEGINtB   IF (NOT display_guess(tmpword))	{get the thing into the display}   THEN	     BEGINEC     write_menu('','Guessing done - please make your selection...');r9     get_guess_disposition('z');		{guess display is full -a:     	    	    	    	    	 do we need to cancel unsolicited* 					 input now, or can we just leave it?}     END;%   END;					{guess entered in display}d   IF had_unsol_input THEN   BEGINr9   had_unsol_input := FALSE;		{SMG seems to guarantee that    					 this is safe} F   key_return := smg$read_keystroke(keyboard,key.term_code,timeout:=0);   IF key_return=smg$_eof THENs	     BEGIN :     key_return := 1;			{this is `odd', if not `puckah' ;-}%     key.term_code := smg$k_trm_ctrlz;r     END;.   IF odd(key_return)			{read something puckah}   THEN	     BEGIN;K     IF ((key.term_code=smg$k_trm_ctrlz) OR (key.term_code=smg$k_trm_pf4) ORo, 					 (key.term_code=smg$k_trm_next_screen))     THEN.       GOTO 89				{request to abandon guessing}M     ELSE IF ((key.term_code=smg$k_trm_pf2) OR (key.term_code=smg$k_trm_help))x     THEN"       put_help('guess.spell_help')     ELSE       BEGIN #       IF key.ch IN upper_case_charsr
       THEN 	key.ch := chr(ord(key.ch)+32); 0       IF ((key.ch<'a') OR (key.ch>=guess_index))
       THEN 	BEGIN 	smg$ring_bell(guess_display); 	smg$cancel_input(keyboard); 	END
       ELSE 	BEGIN 	guessed:=true;h 	tmpword := guesses[key.ch];	 	GOTO 88;= 	END;(
       END;     END;   END;  5 confirmguess := FALSE;			{function result is a relic}o   END;  > PROCEDURE guess_reversals;		{try reversals - e.g. teh for the} BEGINr   IF textline^.length>1     THENd(     FOR col:=1 TO textline^.length-1 DO	
      BEGIN       ch:=tmpword[col];o#       tmpword[col]:=tmpword[col+1];e       tmpword[col+1]:=ch;g#       IF confirmguess THEN GOTO 88;        ch:=tmpword[col]; #       tmpword[col]:=tmpword[col+1];i       tmpword[col+1]:=ch; 	      END;i END;  2 PROCEDURE guess_vowels;			{try vowel replacements}   BEGINy  " FOR col:=1 TO textline^.length DO	( IF tmpword[col] IN ['a','e','i','o','u'] THEN   BEGIN    ch:=tmpword[col]; 
   IF ch<>'a'     THEN BEGIN     tmpword[col]:='a';!     IF confirmguess THEN GOTO 88;U     END;   IF ch<>'e'   THEN BEGIN     tmpword[col]:='e';!     IF confirmguess THEN GOTO 88;w     END;   IF ch<>'i'   THEN BEGIN     tmpword[col]:='i';!     IF confirmguess THEN GOTO 88;2     END;
   IF ch<>'o' (   THEN BEGIN     tmpword[col]:='o';!     IF confirmguess THEN GOTO 88;      END;   IF ch<>'u'   THEN BEGIN     tmpword[col]:='u';!     IF confirmguess THEN GOTO 88;s     END;   tmpword[col]:=ch;T   END; END;  ; PROCEDURE guess_minus;			{try eliding one letter at a time}w   BEGINi'    FOR col := 1 TO textline^.length DO	d
      BEGIN       oldword:=tmpword;)(       FOR i:= col TO textline^.length DO$ 	tmpword.body[i]:=tmpword.body[i+1];#       IF confirmguess THEN GOTO 88;=       tmpword:=oldword;D	      END;I END;    D PROCEDURE guess_apostrophe;		{try adding apostrophe between trailing+ 					 "nt", or try stripping a trailing "s"S* 					 off a word and see if we can make it 					 a posessive}  + VAR We_have_it : BOOLEAN;	{look-up success}r   BEGINt   oldword := tmpword;o  * IF (tmpword[textline^.length-1] = 'n') AND$    (tmpword[textline^.length]	= 't') THEN   BEGIN #   tmpword[textline^.length+1]:='t'; "   tmpword[textline^.length]:='''';   IF confirmguessl   THEN     GOTO 88;   tmpword := oldword;h   END;  / (* Now, try to convert "zorros" to "zorro's" *)r  ! IF tmpword[textline^.length]='s' m THEN :   BEGIN !   tmpword[textline^.length]:=' ';m  4   We_have_it := OccursInTree( tmpword, IgnoreList );   IF NOT We_have_it    THEN  *     We_have_it := IsCommonWord( tmpword );   IF NOT We_have_it    THEN  $     We_have_it := occurs( tmpword );     IF We_have_it    THEN
     BEGIN $     tmpword[textline^.length]:='''';&     tmpword[textline^.length+1]:='s';   ,     {code copied from confirmguess (almost)}#     IF (NOT display_guess(tmpword))s     THEN       BEGIN:E       write_menu('','Guessing done - please make your selection...');N!       get_guess_disposition('z');a
       END;     END;   tmpword:=oldword;c   END;   END;      = PROCEDURE guess_plus;			{add one letter anywhere in the word}t  D VAR no_u: BOOLEAN;	{suppress adding "u" between "o" and "r", as it's   			 been done once already}    BEGINt     oldword:=tmpword;s  2   {make a gap: will propagate up through the word})   FOR col := textline^.length DOWNTO 1 DO=-     tmpword.body[col+1]	:= tmpword.body[col];;     {add in each position}-   FOR col := 1 TO textline^.length+1 DO BEGINI       IF col>1 THEN BEGINn  /       tmpword.body[col-1] := tmpword.body[col];t       IF col>textline^.lengthW       THEN no_u:=false+       ELSE IF (tmpword.body[col-1]='o')	AND+  	      (tmpword.body[col+1]='r')       THEN no_u:=truea       ELSE no_u:=false;i       END 7     ELSE no_u:=false;	{can't have happened in column 1}i  !     FOR ch := 'a' TO 'z' DO BEGINl+       IF (NOT no_u) OR (ch<>'u') THEN BEGINe 	tmpword.body[col] := ch;n 	IF confirmguess THEN GOTO 88;
       END;     END;     END;     tmpword := oldword;r   END;  < PROCEDURE guess_consonants;	{replacement for all characters}   BEGIN '     FOR col := 1 TO textline^.length DOn
      BEGIN       oldword:=tmpword;r       FOR ch:='a' TO 'z' DOl 	BEGIN 	 tmpword.body[col]:=ch; 	 IF confirmguess THEN GOTO 88;- 	END;-       tmpword:=oldword;C	      END;d END;  - PROCEDURE guess_zs;			{try swapping zs to ss}    VAR i :	INTEGER;   BEGINu     oldword := tmpword;e)   FOR i := 1 TO textline^.length DO BEGIN	  '     IF tmpword.body[i] = 'z' THEN BEGINb         tmpword.body[i] := 's';e#       IF confirmguess THEN GOTO 88;        tmpword := oldword;l       END;     END;   END;    4 PROCEDURE guess_cst;			{try swapping cs to ss to ts}  2 {this is for the benefit of Paul Hardy's hangups!}   VAR i :	INTEGER;   BEGINl   oldword := tmpword;O  FOR i := 2 TO textline^.length-1 DO :   BEGINn     IF tmpword.body[i+1] = 'i'   THEN	     BEGINa       IF tmpword.body[i] = 'c' }	     THEN :       BEGIN;         tmpword.body[i] := 's';e       IF confirmguess        THEN p	 	GOTO 88;R       tmpword.body[i] := 't';h       IF confirmguess        THEN S	 	GOTO 88;        tmpword := oldword;e  
       END;       IF tmpword.body[i] = 's'	     THEN r       BEGINo         tmpword.body[i] := 'c';9       IF confirmguess        THEN s	 	GOTO 88;i       tmpword.body[i] := 't';P       IF confirmguess        THEN o	 	GOTO 88;        tmpword := oldword;h  
       END;       IF tmpword.body[i] = 't' 1	     THEN t       BEGIN          tmpword.body[i] := 'c';a       IF confirmguess        THEN e	 	GOTO 88;        tmpword.body[i] := 's';        IF confirmguess        THEN t	 	GOTO 88;s       tmpword := oldword;   
       END;       END;     END;   END;    0 PROCEDURE guess_qu;			{try adding "u" after "q"}   VAR i, j : INTEGER;    BEGINe   oldword := tmpword;h FOR i := 2 TO textline^.length r DO   BEGIN   "   IF (tmpword.body[i-1] = 'q') AND      (tmpword.body[i]  <> 'u')   THEN	     BEGINl  '     FOR j := textline^.length DOWNTO i       DO+       tmpword.body[j+1] := tmpword.body[j];d       tmpword.body[i] := 'u';i     IF confirmguess 	     THEN r       GOTO 88;     tmpword := oldword;L       END;     END;   END;      . PROCEDURE guess_or;			{try adding "u" to "or"}   VAR i, j : INTEGER;d   BEGINr   oldword := tmpword;t FOR i := 2 TO textline^.length o DO   BEGINl  "   IF (tmpword.body[i-1] = 'o') AND      (tmpword.body[i]	= 'r')   THEN	     BEGINE  '     FOR j := textline^.length DOWNTO i e     DO+       tmpword.body[j+1] := tmpword.body[j];t       tmpword.body[i] := 'u';;     IF confirmguess 	     THEN p       GOTO 88;     tmpword := oldword;        END;     END;   END;   BEGIN					{guess}    had_unsol_input := FALSE;oB smg$enable_unsolicited_input(pasteboard,unsol_input_notification); smg$cancel_input(keyboard);l! smg$erase_display(guess_display);pD smg$paste_virtual_display(guess_display,pasteboard,screen_rows-8,2);  <   write_menu('','Guessing - please make your selection...');   guess:=false;p   guessed:=false; 9   tmpword:=ThisWord;			{don't mess around with real word}	$   guess_zs;				{guess 'z's for 's's}0   guess_cst;				{guess 'c's for 's's for 't's -  								for Paul}t%   guess_or;				{guess 'our' for 'or'} /   guess_qu;				{guess 'u' after 'q' - for Paul}   B { and no, I don't think Paul's a particularly bad typist - he just=   takes the trouble to ask for improvements to the algorithms  }   7   guess_apostrophe;			{guess "'" between trailing "nt"}n*   guess_reversals;			{guess for reversals}/   guess_vowels;				{guess for incorrect vowels} +   guess_minus;				{guess for extra letters} +   guess_plus;				{add one letter at a time} 5   guess_consonants;			{substitute for all consonants}    IF guess_index='a'   THEN"     GOTO 89				{no guesses at all}   ELSEC     write_menu('','Guessing done - please make your selection...');e#   guess_index := pred(guess_index);lB   get_guess_disposition(guess_index);	{establish results, if any!}    8 88: guess:=true;		{we managed to guess - even though we}D    IF index(tmpword,' ')>0	{immediately destroyed our reputation by}:     THEN			{doing a GOTO - but then the users never know!}9       correctword:=substr(tmpword,1,index(tmpword,' ')-1)      ELSE       correctword:=tmpword;    89:					{real exit}   * smg$disable_unsolicited_input(pasteboard);6 smg$unpaste_virtual_display(guess_display,pasteboard);   END;    ( PROCEDURE edit_word(ThisWord : wordtype;! 	     VAR correctWord : wordtype;s 		  cursor_col : INTEGER);  8 VAR ins_repl : BOOLEAN;			{True=>insert, false=>replace}     wd_ptr   : INTEGER;+     key      : keystroke;++     ch_arr   : PACKED ARRAY [1..1] OF CHAR;n   BEGINa  6 CorrectWord:=substr(ThisWord,1,index(ThisWord,' ')-1);  ? upper_casing:=false;			{don't upper-case letters from keyboard}-6 ins_repl:=true;				{start by inserting, not replacing}& wd_ptr:=1;				{start at start of word}   REPEAT   key:=getkey;   IF key.term_code=smg$k_trm_leftr THEN   BEGINs
   IF wd_ptr=1m   THEN t     smg$ring_bell(menu_display)r   ELSE {	     BEGINw     wd_ptr:=wd_ptr-1; 7     smg$set_cursor_rel(menu_display, delta_column:=-1);l     END;   END   % ELSE IF key.term_code=smg$k_trm_right  THEN   BEGINg   IF wd_ptr>length(correctword):   THEN :     smg$ring_bell(menu_display)    ELSE	     BEGIN{4     IF (wd_ptr=length(correctword)) AND NOT ins_repl     THEN       BEGINm       ins_repl:=true;tO       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword),i$ 			   smg$m_reverse, smg$m_reverse);
       END;6     smg$set_cursor_rel(menu_display, delta_column:=1);     wd_ptr:=wd_ptr+1;a     END;   ENDv  & ELSE IF key.term_code=smg$k_trm_delete THEN   BEGIN	{delete a character}
   IF wd_ptr=1    THEN     smg$ring_bell(menu_display)    ELSE	     BEGINu!     IF wd_ptr>length(CorrectWord)p	     THEN  >       CorrectWord:=substr(CorrectWord,1,length(CorrectWord)-1)	     ELSE x3       CorrectWord:=substr(CorrectWord,1,wd_ptr-2) +a# 			      substr(CorrectWord,wd_ptr,1' 				     length(CorrectWord)-wd_ptr+1);v     wd_ptr:=wd_ptr-1;t>     smg$delete_chars(menu_display, 1, 1, cursor_col+wd_ptr-1);     END; {endif}   END   ' ELSE IF (key.term_code=smg$k_trm_ctrln), THEN   BEGIN,   IF wd_ptr<=2   THEN     smg$ring_bell(menu_display):   ELSE	     BEGINs!     IF wd_ptr>length(CorrectWord)n     THEN       BEGINt       IF wd_ptr=3{
       THEN= 	CorrectWord:=substr(CorrectWord,2,1)+substr(CorrectWord,1,1)d
       ELSE- 	CorrectWord:=substr(CorrectWord,1,wd_ptr-3)+d& 		     substr(CorrectWord,wd_ptr-1,1)+& 		     substr(CorrectWord,wd_ptr-2,1);	       ENDh     ELSE IF wd_ptr=3
       THEN> 	CorrectWord:=substr(CorrectWord,2,1)+substr(CorrectWord,1,1)+2 		     substr(CorrectWord,3,length(CorrectWord)-2)
       ELSE- 	CorrectWord:=substr(CorrectWord,1,wd_ptr-3)+N& 		     substr(CorrectWord,wd_ptr-1,1)+& 		     substr(CorrectWord,wd_ptr-2,1)+? 		     substr(CorrectWord,wd_ptr,length(CorrectWord)-wd_ptr+1);lB     smg$put_chars(menu_display, substr(CorrectWord,wd_ptr-2,2), 1, 						cursor_col+wd_ptr-3);      END;   END_  H ELSE IF (key.term_code=smg$k_trm_ctrla) OR (key.term_code=smg$k_trm_f14) THEN   BEGIN    IF wd_ptr>length(CorrectWord)a   THEN N     smg$ring_bell(menu_display)e   ELSE	     BEGINd     ins_repl :=	NOT ins_repl;      IF ins_replE     THENO       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword),B# 			   smg$m_reverse, smg$m_reverse)      ELSEO       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword),l 			   smg$m_reverse);s     END;   ENDh  E ELSE IF (key.term_code=smg$k_trm_bs) OR (key.term_code=smg$k_trm_f12)u THEN   BEGINI
   IF wd_ptr=1    THEN     smg$ring_bell(menu_display)_   ELSE	     BEGIN      wd_ptr:=1;4     smg$set_cursor_abs(menu_display, 1, cursor_col);     END;   ENDl  K ELSE IF (key.term_code=smg$k_trm_remove) OR (key.term_code=smg$k_trm_comma)p THEN   BEGINE   IF wd_ptr>length(correctword)    THEN     smg$ring_bell(menu_display)e$   ELSE IF wd_ptr=length(correctword)   THEN	     BEGINi=     correctword:=substr(CorrectWord,1,length(correctword)-1);;     IF NOT ins_repll     THEN       BEGINw       ins_repl:=true; O       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword),:$ 			   smg$m_reverse, smg$m_reverse);
       END;     ENDn   ELSE IF wd_ptr=1   THEN<     CorrectWord:=substr(CorrectWord,2,length(CorrectWord)-1)   ELSE1     CorrectWord:=substr(CorrectWord,1,wd_ptr-1) + ; 		 substr(CorrectWord,wd_ptr+1,length(CorrectWord)-wd_ptr);c<   smg$delete_chars(menu_display, 1, 1, cursor_col+wd_ptr-1);   ENDs  H ELSE IF (key.term_code=smg$k_trm_ctrle) OR (key.term_code=smg$k_trm_kp2) THEN   BEGINU   IF wd_ptr>length(CorrectWord)a   THEN N     smg$ring_bell(menu_display)H   ELSE	     BEGINs"     wd_ptr:=length(CorrectWord)+1;=     smg$set_cursor_abs(menu_display, 1, cursor_col+wd_ptr-1);s     IF NOT ins_repl+     THEN       BEGINH       ins_repl:=true;sO       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword),m$ 			   smg$m_reverse, smg$m_reverse);       END; {endif}     END; {endif, too}_   END,  $ ELSE IF key.term_code=smg$k_trm_help THEN   BEGIN;   put_help('EDIT.SPELL_HELP');K   write_menu('Edit spelling:',' '+substr(ThisWord,1,index(ThisWord,' ')-1),o 					vers:=false);;   smg$set_cursor_abs(menu_display, 1, cursor_col+wd_ptr-1);u   ENDg  @ ELSE IF key.ch IN [' '..'~']	{any printable character, or space} THEN   BEGIN=   ch_arr[1]:=key.ch;
   IF ins_repl=   THEN     BEGIN	{add a character}d     IF length(correctword)=32l     THEN!       smg$ring_bell(menu_display)u     ELSE       BEGINe       IF wd_ptr=1        THEN B  	CorrectWord:=key.ch+CorrectWord(       ELSE IF wd_ptr>length(CorrectWord)       THEN    	CorrectWord:=CorrectWord+key.ch       ELSE e. 	CorrectWord:=substr(CorrectWord,1,wd_ptr-1) + 		     key.ch + @ 		     substr(CorrectWord,wd_ptr,length(CorrectWord)-wd_ptr+1);  	{endif}  5       {and now stuff it into the display of the word}=E       smg$insert_chars(menu_display, ch_arr, 1, cursor_col+wd_ptr-1);e       END; {endif}     ENDc   ELSE     BEGIN	{replace one}o%     CorrectWord.body[wd_ptr]:=key.ch;e  2     {this way, too, it needs to be in the display}R     smg$put_chars(menu_display, ch_arr, 1, cursor_col+wd_ptr-1, 0, smg$m_reverse);  !     IF wd_ptr=length(CorrectWord) 	     THEN         BEGIN        ins_repl:=true;iO       smg$change_rendition(menu_display, 1, cursor_col, 1, length(correctword), $ 			   smg$m_reverse, smg$m_reverse);
       END;     END; {endif}     wd_ptr := wd_ptr+1;    ENDN  L ELSE IF (key.term_code<>smg$k_trm_cr) AND (key.term_code<>smg$k_trm_f10) AND! 	(key.term_code<>smg$k_trm_enter): THEN   smg$ring_bell(menu_display);  F UNTIL (key.term_code=smg$k_trm_cr) OR (key.term_code=smg$k_trm_f10) OR* 				      (key.term_code=smg$k_trm_enter);  % upper_casing:=true;  {restore getkey}    END;      D PROCEDURE checkorwrong;		{handles Check and Wrong options from menu}   VAR lcWord : WordType;     word_not_split : BOOLEAN;	     in_dictionary : BOOLEAN;     col : INTEGER;     our_ok_chars : SET OF CHAR;m   BEGIN 	t  6 IF (Verdict = 'C')		{fiddles with semi-global verdict}2 THEN 				{very kludgy - probably needs a complete})   BEGIN				{recode from top to bottom...}{   Check(CorrectWord);a   IF length(correctword)=0   THEN     verdict:='N'   ELSE	     BEGIN =     IF yesanswer('Is the new word "'+CorrectWord+'" correct')e     THEN       verdict:='Y'     ELSE       verdict:='N';_     END;   IF (verdict = 'N')     THEN	     BEGIN *     IF yesanswer('Is the original word "'+8 		 substr(ThisWord,1,index(ThisWord,' ')-1)+'" correct')     THEN       verdict:='Y'     ELSE       verdict:='N';{     IF (verdict='Y') p     THEN       BEGINm       verdict:='I';r&       Insert (ThisWord, NewGoodWords);&       Insert ( ThisWord, IgnoreList );       IF guidanceNeedede
       THEN 	RecordGuidance ( ThisWord );r	       END      END;   END; e    H IF (NOT (verdict IN ['Y','I']))		{i.e. "Wrong", "Edit" or "No" to Check} THEN   BEGINI   IF verdict='E'   THEN	     BEGINkM     write_menu('Edit spelling:',' '+substr(ThisWord,1,index(ThisWord,' ')-1),  					vers:=false);,     smg$set_cursor_abs(menu_display, 1, 16);)     edit_word(ThisWord, correctWord, 16);      ENDy   ELSE	     BEGIN>4     write_menu('','Correct spelling: ',vers:=false);     myReadln(correctWord);     END;  =   IF length(correctword)=0 THEN verdict:='@'	{return to menu}s   END; h     IF verdict<>'@'(   THEN	     BEGINN  2     lcword := CorrectWord; word_not_split := true;#     FOR col := 1 TO length(lcword) u     DO s       BEGINv(       IF lcword[col] IN upper_case_chars       THEN t) 	lcword[col] := chr(ord(lcword[col])+32);.G       IF (NOT(lcword[col] IN lower_case_chars)) AND (lcword[col]<>'''')m 						 {has he split the word?}+       THEN   	word_not_split := false; 
       END;       IF word_not_split 	     THEN ]       BEGIN+  ;       in_dictionary := OccursInTree ( lcWord, IgnoreList );        IF NOT in_dictionary       THEN  * 	in_dictionary := IsCommonWord ( lcWord );       IF NOT in_dictionary       THEN u2 	in_dictionary := occurs ( pad(lcWord, ' ', 32) );       IF NOT in_dictionary       THEN ;. 	in_dictionary := find_in_goodfile ( lcWord );         IF NOT in_dictionary       THEN ] 	BEGIN   	IF using_persdict 	THEN , 	  our_ok_chars := ['R','W','I','P','S','H'] 	ELSEr) 	  our_ok_chars := ['R','W','I','S','H'];    	IF using_persdict 	THEN(I 	  write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Personal Help')  	ELSE;A 	  write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Help');m   	REPEATG 	  key := getkey; H 	  IF (NOT (key.ch IN our_ok_chars)) AND (key.term_code<>smg$k_trm_help) 	  THEN ! 	    smg$ring_bell(menu_display);l  B 	UNTIL (key.ch IN our_ok_chars) OR (key.term_code=smg$k_trm_help);    	IF key.term_code=smg$k_trm_help 	THENt 	  BEGIN' 	  put_help('CHANGED_WORD.SPELL_HELP');m 	  IF using_persdict 	  THENwK 	    write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Personal Help')g 	  ELSEhC 	    write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Help');	 	  END 	ELSEd 	  BEGIN 	  CASE key.ch OF 
 	  'H': BEGIN , 	       put_help('CHANGED_WORD.SPELL_HELP'); 	       IF using_persdicto 	       THENI 		 write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Personal Help')  	       ELSEA 		 write_menu('`'+lcWord+''':', ' Right Wrong Ignore Skip Help');: 	       END;
 	  'R': BEGIN $ 	       update_disposition('Right');% 	       insert(lcWord, NewGoodWords);"1 	       {added_to_newgood := added_to_newgood+1;}n$ 	       insert(lcWord, IgnoreList ); 	       END; 	  'P': IF using_persdictt 	       THEN 		 BEGIN" 		 update_disposition('Personal'); 		 persadd(lcWord);h 		 END; 
 	  'W': BEGINm$ 	       update_disposition('Wrong'); 	       verdict:='@';c 	       END;
 	  'I': BEGINa% 	       update_disposition('Ignore');[$ 	       insert(lcWord, IgnoreList ); 	       IF guidanceNeeded  	       THEN 		 RecordGuidance ( lcWord );} 	       END;# 	  'S': update_disposition('Skip');  	  END; {endcase}r 	  END; {endif}s   	END;-  
       END;       END;  ? IF (NOT (verdict IN ['I','@'])) THEN	{we did make a correction}    BEGIN:/   querycase;				{check the case of replacement}_L   InsertDouble(ThisWord, CorrectWord, Misspelled); {put in wrong/right list}    updateline;				{fix text line}3   verdict:='C'				{part with an acceptable verdict}    END:   END;  = PROCEDURE confirmquit;			{make sure that quit is intentional}o   VAR option:keystroke;N   BEGIN   : write_menu('Quit options:',' Abandon Save Continue Help');   REPEAT   option:=getkey;T   CASE option.ch OFD   'A': GOTO 99;F   'S': quit:=true;   'C': {do nothing};#   'H': put_help('QUIT.SPELL_HELP');F     OTHERWISE BEGINW! 	    smg$ring_bell(menu_display);E 	    option.term_code:=7;'	 	    END;    END; UNTIL option.term_code<>7    END;    8 PROCEDURE EvalType;			{evaluate a new type for the file}  . VAR key		: keystroke;	(* prompted character *)+     newtype	: esctype;	(* new type value *)    BEGIN( write_menu('Available types:',6 	   ' Runoff Scribe Tex Issue Nroff vaxDoc Unknown '); REPEAT   key := getkey;4   IF (NOT (key.ch IN ['R','S','T','I','N','D','U']))   THEN      smg$ring_bell(menu_display);0 UNTIL (key.ch IN ['R','S','T','I','N','D','U']);   CASE key.ch OF   'R':	NewType := Runoff;    'S':	NewType := Scribe;B   'T':	NewType := Tex;   'I':	NewType := Issue;   'N':	NewType := Nroff;   'U':	NewType := Unknown;   'D':	NewType := VAXDoc;u END;   IF NewType=escapemodes THEN<   write_menu('','That''s no change, of course!',vers:=false) ELSE   BEGINe   escapemode := NewType;     CASE escapemode OFJ   runoff :smg$put_chars(status_display,'Embedded commands: Runoff',2,2,1);F   tex 	 :smg$put_chars(status_display,'Embedded commands: TeX',2,2,1);J   scribe :smg$put_chars(status_display,'Embedded commands: Scribe',2,2,1);H   unknown:smg$put_chars(status_display,'Embedded commands: None',2,2,1);K   nroff  :smg$put_chars(status_display,'Embedded commands: n/troff',2,2,1);bI   issue  :smg$put_chars(status_display,'Embedded commands: Issue',2,2,1);HK   vaxdoc :smg$put_chars(status_display,'Embedded commands: VAX Doc',2,2,1);    END;     END;   END;     BEGIN 					{judge - finally...} '   REPEAT				{main repeat loop for menu}     contextscreen;o    IF using_persdict    THENF      write_menu('Options:',HF 	 ' Right Wrong Personal Ignore Junk Check Guess Quit Help Edit Skip', 	 vers:=false)    ELSE       write_menu('Options:',== 	 ' Right Wrong Ignore Junk Check Guess Quit Help Edit Skip',  	 vers:=false);d    key:=getkey; "    IF key.term_code=smg$k_trm_down    THEN 
      BEGIN!      WHILE textline^.next<>NIL DO         BEGIN        oldword:=textline;T         textline:=textline^.next;        dispose(oldword);        END;N      verdict:='S';      END'    ELSE IF key.term_code=smg$k_trm_help     THEN       verdict := 'H'u    ELSE IF key.term_code>255    THEN       verdict := chr(0)    ELSE       verdict := key.ch;        CASE verdict OF			{main menu}%     'H': put_help('MAIN.SPELL_HELP');)     'G': BEGIN 	 update_disposition('Guess');  	 IF guess 			{successful guess} 	 THEN O	 	   BEGIN ( 	   querycase;		{check for correct case}4 	   insertdouble(ThisWord, correctword, misspelled);$ 	   updateline;		{fix the text line} 	   ENDr 	 ELSE				{guessing failed} " 	   BEGIN			{go back to main menu}* 	   verdict:='@';		{kluge to loop to menu} 	   END; 	 END;$     'Q': BEGIN				{quit the program} 	 update_disposition('Quit');  	 confirmquit; 	 END;     'P': IF using_persdict 	 THEN( 	   BEGIN			{put in personal dictionary}# 	   update_disposition('Personal');  	   persadd(ThisWord); 	   END= 	 ELSE  	   smg$ring_bell(menu_display);!     'R': BEGIN				{word is right}  	 update_disposition('Right');" 	 Insert (ThisWord, NewGoodWords);! 	 Insert ( ThisWord, IgnoreList )  	 END;!     'W': BEGIN				{word is wrong}l 	 update_disposition('Wrong'); 	 checkorwrong;; 	 END;'     'C': BEGIN				{check in dictionary}( 	 update_disposition('Check'); 	 checkorwrong;_ 	 END;7     'E': BEGIN				{correct the word, rather than start} A 	 update_disposition('Edit');	{  all over again, as with `wrong'}l 	 checkorwrong;T 	 END;?     'S': update_disposition('Skip');	{forget the word entirely}s#     'I': BEGIN				{ignore the word}' 	 update_disposition('Ignore');o 	 insert(ThisWord,ignorelist); 	 IF guidanceNeededu 	 THEN  	   RecordGuidance ( ThisWord ); 	 END;8     'J': BEGIN				{a junk word -  a serious problem in }7 	 update_disposition('Junk');	{Robin's standards work!}e 	 IF logging 	 THEN	 	   BEGINr/ 	   writeln(logfile,'line ',linenumber:4,': "',s$ 		   thisword:index(thisword,' ')-1,# 		   '" declared to be ''junk''!');c 	   logged_something:=true;	 	   END; 	 END;     'T': BEGIN 	 update_disposition('Type');  	 EvalType;s- 	 Verdict:='@';			{fudge return to this menu}  	 END;     '!': BEGIN 	 writeln('IgnoreList is:');$ 	 print_tree(output, IgnoreList, 0);	 	 getkey;  	 END;     '?': BEGIN( 	 writeln('IgnoreList statistics are:');% 	 summarise_tree(output, IgnoreList);u	 	 getkey;	 	 END;    OTHERWISE,      smg$ring_bell(menu_display);	{complain}    END;   { case }C    smg$flush_buffer(pasteboard);	{ensure any changes are displayed}b.   UNTIL (quit) OR  (verdict IN main_ok_chars);   write_menu('','Checking...');: END;  Q FUNCTION Unchecked (WordToFind : wordtype) : BOOLEAN; {checks newgood dictionary}	   VAR temp_display:unsigned;   BEGIN_  ! IF NOT find_in_goodfile(ThisWord)a THEN a   unchecked:=false   ELSE     BEGIN    contextscreen;H   smg$create_virtual_display(2,screen_cols-2,temp_display,smg$m_border);:   smg$paste_virtual_display(temp_display,pasteboard,19,2);G   smg$put_line(temp_display,'  This word has been entered by a user, '+ ' 		  'but has not yet been checked in');    smg$put_line(temp_display,8 		  '  the main dictionary.  Use it at your own risk!');   smg$ring_bell(temp_display);5   IF yesanswer('Do you want to accept it as correct')    THEN	     BEGINp     unchecked:=true;      update_disposition('Right');#     Insert (WordToFind,IgnoreList);f!     write_menu('','Checking...');      END    ELSE     unchecked:=false;r-     smg$delete_virtual_display(temp_display);      END;   END;  2 PROCEDURE CheckWord;			{check in all dictionaries} VAR     Found :BOOLEAN;    Oldword:listptr;H  = PROCEDURE repeaterror;			{for errors that were already fixed}$   VAR temp_string:line;    BEGIN    contextscreen(pr:=false);t6 smg$unpaste_virtual_display(error_display,pasteboard);! smg$erase_display(error_display);$8 smg$paste_virtual_display(error_display,pasteboard,9,2);! writev(temp_string,linenumber:5);s0 smg$put_line(error_display,'Line: '+temp_string+4 	     '     '+ThisWord+'  Change to: '+Correctword);/ IF yesanswer('Do you want to make this change')$ THEN   BEGINH   querycase;
   updateline;e   ENDF ELSE   BEGINH<   IF yesanswer('Do you want to change it to something else')   THEN	     BEGINr4     write_menu('','Correct spelling: ',vers:=false);     myReadln(correctWord);     querycase;     updateline     ENDt   END;   write_menu('','Checking...');b   END;   BEGIN	{checkword}	   IF (textline^.length>1) OR    do_single_letter_words 
 THEN BEGIN   ThisWord:=textline^.Name; G   IF NOT OccursInTree(ThisWord,IgnoreList) {have we checked it before?}o=   THEN IF NOT (IsCommonWord(ThisWord))	{is it a common word?} 7   THEN IF (Occurs(ThisWord))		{is it in any dictionary}F9   THEN insert ( ThisWord, IgnoreList )	{put it into tree}    ELSE =2     BEGIN				{check if already in MisSpelled List}  ;     SearchDouble(ThisWord, Misspelled, Found, CorrectWord);r     IF Found.     THEN repeaterror			{It's definitely wrong}8     ELSE IF unchecked(ThisWord)		{look at newgood words}(     THEN insert ( ThisWord, IgnoreList )3     ELSE judge(textline)		{needs user intervention}		     END; (   END;  <   Oldword:=textline;			{take word off the front of wordlist}   TextLine := TextLine^.next; 0   dispose(oldword);			{clean up after ourselves}   END;      H PROCEDURE WriteTree ( TreeName : Tree;		{write the newgood tree to disk}6 		     got_a_tmp : BOOLEAN;	{i.e. update newgood file} 		       VAR tmp : word3s );   {types for use with getjpi}   TYPE pointer_integer = ^INTEGER;3      username_array = PACKED ARRAY [1..12] OF CHAR;I.      pointer_username_array = ^username_array;       integer_32 = -32768..32767;      jpi_item	= PACKED RECORDl/ 		    buffer_length,		(* length of buffer we're  		    				   offering *)$ 		    item_code	: [WORD] integer_32;+ 		    buffer_addr	: pointer_username_array;v& 		    return_length : pointer_integer; 		  END;  / VAR jpi_list	: PACKED ARRAY [1..2] OF jpi_item;	     i,duff	: INTEGER; $     name_length	: [WORD] integer_32;  $ {our infamous procedure definitions}6 [asynchronous,EXTERNAL(sys$getjpiw)] FUNCTION getjpi (# 	%IMMED efn : unsigned := %IMMED 0; . 	VAR pidadr : [VOLATILE] unsigned := %IMMED 0;H 	prcnam : [class_s] PACKED ARRAY [$l1..$u1:INTEGER] OF CHAR := %IMMED 0;D 	%REF itmlst : [unsafe] PACKED ARRAY [$l2..$u2:INTEGER] OF jpi_item;G 	VAR iosb : [VOLATILE] ARRAY [$l3..$u3:INTEGER] OF INTEGER := %IMMED 0;l" 					{in STARLET, this is a $QUAD}< 	%IMMED [unbound,asynchronous] PROCEDURE astadr := %IMMED 0;; 	%IMMED astprm : unsigned := %IMMED 0) : INTEGER; EXTERNAL;    BEGINI   IF NOT got_a_tmp THEN4   BEGIN					{not recursing - things need setting up}  A   {to kick off, let's get some sort of name for who's running us} @   duff := lib$get_symbol ( 'real_name', tmp.user, name_length );   IF NOT (odd(duff))   THEN)     BEGIN				{ah well - use process name}t$     jpi_list[1].buffer_length := 15;+     jpi_list[1].item_code := jpi$_username;_!     new(jpi_list[1].buffer_addr);p#     new(jpi_list[1].return_length);N  G     jpi_list[2].buffer_length := 0;	{these two provide a "terminating }pD     jpi_list[2].item_code := 0;		{ zero longword" for the item list}  %     duff := getjpi(itmlst:=jpi_list);E  )     tmp.user := jpi_list[1].buffer_addr^; .     name_length := jpi_list[1].return_length^;     END;     FOR i := name_length+1 TO 32   DO     tmp.user[i] := ' ';r  H   duff := $asctim (timbuf:=tmp.date);	{this gets a date and time for us}  5   tmp.fnam := usable_file_name;		{save file name too}N     END;   IF (TreeName <> NIL) THENN BEGINL   tmp.item:=treename^.Name;_&   write(goodfile,tmp,error:=continue);   IF (TreeName^.Left<>NIL)   THEN+     WriteTree( TreeName^.Left, true, tmp );'   IF (TreeName^.Right<>NIL)    THEN,     WriteTree( TreeName^.Right, true, tmp );   END;   END;    2 PROCEDURE init;				{miscellaneous initializations}   VAR stat  : INTEGER;4     ftype : linefix;		{used in evaluating file type}=     file_param : linefix;	{used in reading file names (surelyH) 				 cli$get_value needn't be defined the  				 way it is?} BEGIN 
   get_uic;   NewGoodWords := NIL;   Quit := FALSE;:   stat:=cli$present('PERSO');		{personal dict update mode}/   IF (stat=cli$_present) OR (stat=cli$_negated)e   THEN	     BEGINs+     using_persdict := (stat<>cli$_negated); 3     IF NOT using_persdict THEN maintmode:=personal;)     END;     IF maintmode<>personal THENu	     BEGINt:     stat:=cli$present('UPDAT');		{system dict update mode}     IF stat=cli$_present     THEN maintmode:=system     ELSE       BEGIN 5       stat:=cli$present('CHECK');	{check a word mode}e4       IF stat=cli$_present THEN maintmode:=checking;
       END;     END;  :   stat:=cli$present('FILES');		{see if we have a filename}   IF stat=cli$_present   THEN&     stat:=cli$get_value('FILES',param)   ELSE     param:=pad(' ',' ',80);n     stat := cli$present('OUPUT');r   IF stat=cli$_negated THEN      using_listing := false    ELSE IF stat=cli$_present THEN	     BEGIN /     stat := cli$get_value('OUPUT', file_param);_     IF odd(stat) THEN        BEGINe0       work_file := file_param;	{fix up types...}       named_listing := true;
       END;     END;     stat := cli$present('FTYPE');k   IF stat=cli$_present THENR	     BEGIN '     stat:=cli$get_value('FTYPE',ftype);_0     IF ftype='RUNOFF' THEN escapemode := runoff;?     IF (ftype='TEX') OR (ftype='LATEX') THEN escapemode := tex;}C     IF (ftype='MSS') OR (ftype='SCRIBE') THEN escapemode := scribe;cC     IF (ftype='NROFF') OR (ftype='TROFF') THEN escapemode := nroff;R.     IF ftype='ISSUE' THEN escapemode := issue;H     IF (ftype='VAXDOC') OR (ftype='DOCUMENT') THEN escapemode := vaxdoc;     END;7   stat:=cli$present('LOGGI');		{see if we want logging})   logging:=(stat=cli$_present);   :   stat:=cli$present('TESTI');		{see if we want a test run}   IF stat=cli$_present   THEN(     test_run:=true;			{mark a test run}	  A   stat := cli$present('BUILD');        {to build a news section?} '   every_word_ok := (stat=cli$_present);e  <   stat := cli$present('SINGL');	{to do single letter words?}0   do_single_letter_words := (stat=cli$_present);     IF using_persdict{   THEN<     main_ok_chars:=['P','R','S','E','I','W','C','G','J','T']   ELSE9     main_ok_chars:=['R','S','E','I','W','C','G','J','T'];I  0   stat := cli$present('GUIDE');	{guidance file?}(   guidanceNeeded := (stat=cli$_present);-   stat := cli$get_value('GUIDE', file_param);'   IF odd(stat) THENn	     BEGINo3     guidanceFileName := file_param;  {fix up types}      namedGuidanceFile := true;     END;     set_gigi;s(   smg$create_virtual_keyboard(keyboard);  $   smg$create_pasteboard(pasteboard);L   smg$control_mode(pasteboard,smg$m_minupd+smg$m_clear_screen+smg$m_notabs);  =   smg$create_virtual_display(2,screen_cols-2,header_display);fJ   smg$create_virtual_display(3,screen_cols-2,status_display,smg$m_border);<   smg$create_virtual_display(3,screen_cols-2,error_display);K   smg$create_virtual_display(3,screen_cols-2,context_display,smg$m_border);;K   smg$create_virtual_display(3,screen_cols-2,message_display,smg$m_border);rF   smg$create_virtual_display(1,screen_cols,menu_display,smg$m_border);I   smg$create_virtual_display(5,screen_cols-2,guess_display,smg$m_border);oE   smg$create_virtual_display(screen_rows-5,screen_cols,help_display);pI   smg$create_virtual_display(screen_rows-5,screen_cols,personal_display);IE   smg$create_virtual_display(1,screen_cols,top_display,smg$m_border); ;   smg$paste_virtual_display(header_display,pasteboard,1,2);mE   smg$paste_virtual_display(menu_display,pasteboard,screen_rows-1,1);o  F   smg$label_border(status_display,'Status',rendition_set:=smg$m_bold);H   smg$label_border(context_display,'Context',rendition_set:=smg$m_bold);<   smg$label_border(guess_display,'Guesses (ctrl-Z to stop)',& 					      rendition_set:=smg$m_bold);  G   smg$set_out_of_band_asts(pasteboard,control_character_mask:=ast_mask,e. 			  ast_routine:=%IMMED out_of_band_handler);B   smg$set_broadcast_trapping(pasteboard,%IMMED broadcast_handler); END;  . PROCEDURE byebye;				{prints final statistics}   BEGIN   8 smg$unpaste_virtual_display(message_display,pasteboard); status_line(linenumber);   IF every_word_ok THEN   BEGINm(   writeln('IgnoreList statistics are:');%   summarise_tree(output, IgnoreList);p	   getkey;e   END;  G write_menu('','Spell checking finished. Press any key to continue...');) getkey; 7 smg$unpaste_virtual_display(status_display,pasteboard);'6 smg$unpaste_virtual_display(error_display,pasteboard);8 smg$unpaste_virtual_display(context_display,pasteboard);   END;  7 PROCEDURE flushrest;		{dumps rest of file after a quit}E BEGIN    IF NOT(eof(document)) THEN	     BEGIN;     IF using_listing THENo       BEGINN       write_menu('',> 	 'I''m copying the rest of the file without checking it...');!       WHILE NOT(eof(document)) DO' 	BEGIN+ 	readln(document,currline,error:=continue); + 	writeln(listing,currline,error:=continue);h# 	IF status(listing)>0 THEN outerroro 	END; 	       ENDd     ELSE=       write_menu('','I''m ignoring the rest of the file...');      END; END;  1 PROCEDURE maintain;		{maintenance mode utilities}   7 PROCEDURE nopriv;		{complain if insufficient privilege}	 BEGIN     write_menu('', J      'You do not have enough privilege to update the main dictionaries!');
    getkey;    GOTO 99;e END;  $ PROCEDURE updatedict;		{update mode} VAR done,deleteok:BOOLEAN;     dummy:word1;     temp_display:unsigned;  / PROCEDURE correct;		{update words from newgood}o   VAR thisword : word3s;     tmpword : wordtype;f     ch : CHAR;     key : keystroke;     i,userlen : INTEGER;     wordlen : INTEGER;     filelen : INTEGER;     tmp1 : word1;	     tmp2 : word2;f     tmp3 : word3;n.     duff : INTEGER;		{for return from $asctim}5     time_word : PACKED ARRAY [1..23] OF CHAR; {ditto}n  B PROCEDURE rightword;		{insert word into main dict and delete from}   BEGIN				{newgood file};   IF wordlen <= 8q THEN   BEGINn!   tmp1.item:=substr(tmpword,1,8);E$   write(dict1,tmp1,error:=continue);   ENDS ELSE IF wordlen <=16   THEN   BEGINn"   tmp2.item:=substr(tmpword,1,16);$   write(dict2,tmp2,error:=continue);   ENDo ELSE   BEGINH   tmp3.item:=thisword.item;)$   write(dict3,tmp3,error:=continue);   END;   delete(goodfile);o   END;    : PROCEDURE deletemain;		{delete words from main dictionary}   VAR tmplen	: INTEGER;y     abandoned	: BOOLEAN;#     successfully_deleted : BOOLEAN;e   BEGINp   REPEAT  A   write_menu('','What word do you want to delete: ',vers:=false);_   myreadln(tmpword);   tmplen:=length(tmpword);  
   IF tmplen=0c   THEN     abandoned:=true=   ELSE BEGIN     abandoned:=false;S       IF tmplen<32 ]	     THEN  #       tmpword:=pad(tmpword,' ',32);I     IF tmplen <= 8     THEN       BEGIN;%       tmp1.item:=substr(tmpword,1,8);u       findk(dict1,0,tmp1.item);B-       successfully_deleted := NOT ufb(dict1);u       IF successfully_deleted 
       THEN 	delete(dict1,error:=continue)
       ELSE  	unlock(dict1, error:=continue);	       ENDe     ELSE IF tmplen <=16      THEN       BEGIN)&       tmp2.item:=substr(tmpword,1,16);       findk(dict2,0,tmp2.item);o-       successfully_deleted := NOT ufb(dict2);a       IF successfully_deleteds
       THEN 	delete(dict2,error:=continue)
       ELSE  	unlock(dict2, error:=continue);	       END'     ELSE       BEGINb       tmp3.item:=tmpword;u       findk(dict3,0,tmp3.item);c-       successfully_deleted := NOT ufb(dict3);(       IF successfully_deletedd
       THEN 	delete(dict3,error:=continue)
       ELSE  	unlock(dict3, error:=continue);
       END;       IF NOT successfully_deleted'     THEN       BEGINDF       write_menu('','`'+tmpword+''' isn''t in the dictionary in the '+= 		    'first place; press any key to continue', vers:=false);n
       getkey;_
       END;       END;   UNTIL abandoned;  E write_menu('Update Options:',' Right Wrong Ignore Delete Quit Help');p   END;   BEGIN			{correct}   8 smg$paste_virtual_display(temp_display,pasteboard,20,2);   REPEAT   thisword:=goodfile^;   tmpword:=thisword.item;e"   wordlen := index(tmpword,' ')-1;   FOR i := 1 TO 32   DO     IF thisword.user[i]<>' '     THEN       userlen := i;o(   filelen := index(thisword.fnam,' ')-1;   IF filelen<0   THEN     filelen := 32;  "   smg$erase_display(temp_display);C   smg$put_chars(temp_display,' '+pad(tmpword,' ',32)+'>>>   ',1,1);H   key:=getkey;   CASE key.ch OF   'R': BEGIN+        smg$put_chars(temp_display,'Right');         rightword;         END;{   'W': BEGIN+        smg$put_chars(temp_display,'Wrong');:        delete(goodfile);        IF loggingg        THENe 	 BEGINs 	 IF NOT logged_something  	 THEN 	   BEGIN				{open log file}C 	   Open(logfile,'spell_dict:newgood.err',Unknown,error:=continue);e$ 	   extend(logfile,error:=continue);' 	   duff := $asctim(timbuf:=time_word); G 	   writeln(logfile,'=================================== ', time_word);  	   logged_something := true;  	   END;G 	 writeln(logfile, '"', tmpword:wordlen, '" deleted from NEWGOOD file',s1 		 ' (inserted by user ''',thisword.user:userlen,d+ 		 ''' from file ''',thisword.fnam:filelen,)" 		 ''' on ',thisword.date:17,')'); 	 END;        END;g   'I': BEGIN,        smg$put_chars(temp_display,'Ignore');        deleteok:=false;'        END;(   'D': BEGIN,        smg$put_chars(temp_display,'Delete');        deletemain;        END;    'Q': BEGIN*        smg$put_chars(temp_display,'Quit');0        smg$delete_virtual_display(temp_display);        done:=true;        deleteok:=false;w        END;;   'H': BEGIN%        put_help('UPDATE.SPELL_HELP');aL        write_menu('Update Options:',' Right Wrong Ignore Delete Quit Help');        END;    END;  & UNTIL key.ch IN ['R','W','I','Q','H'];   IF key.ch<>'Q' THEN   BEGINB%   get( goodfile, error := continue );s   IF (ufb(goodfile))   THEN T	     BEGINoB     write_menu('',' ... No more words in NEWGOOD file ...',false);     END;   END; END;   BEGIN	{updatedict}    done:=false;e    deleteok:=true;2    open (dict1,filedir+'LEXIC08.DAT',history:=old,? 	access_method:=KEYED,organization:=INDEXED,sharing:=readwrite,r 	error:=continue);"    IF status(dict1)>0 THEN nopriv;    dummy.item:='@       ';    dict1^:=dummy;t    put(dict1,error:=continue);"    IF status(dict1)>0 THEN nopriv;    findk(dict1,0,'@       ');d!    delete(dict1,error:=continue);e2    open (dict2,filedir+'LEXIC16.DAT',history:=old,? 	access_method:=KEYED,organization:=INDEXED,sharing:=readwrite,  	error:=continue);"    IF status(dict2)>0 THEN nopriv;2    open (dict3,filedir+'LEXIC32.DAT',history:=old,? 	access_method:=KEYED,organization:=INDEXED,sharing:=readwrite,i 	error:=continue);"    IF status(dict3)>0 THEN nopriv;!    open (goodfile,filedir+gdfile,b> 	 access_method:=keyed,organization:=INDEXED,history:=UNKNOWN,& 	 sharing:=readwrite,error:=continue);9    IF status(goodfile)>0 THEN openerror('new word file');i&    resetk(goodfile,0,error:=continue);H    write_menu('Update Options:',' Right Wrong Ignore Delete Quit Help');I    smg$create_virtual_display(1,screen_cols-2,temp_display,smg$m_border);r0    WHILE (NOT(done)) AND (NOT(ufb(goodfile))) DO     correct;    IF deleteok THENe	     BEGIN;&       close(goodfile,error:=continue);$       open (goodfile,filedir+gdfile,= 	    access_method:=keyed,organization:=INDEXED,history:=NEW,p) 	    sharing:=readwrite,error:=continue);t<       IF status(goodfile)>0 THEN openerror('new word file');&       close(goodfile,error:=continue);A       do_dcl(pad('set protection=w:rwe '+filedir+gdfile,' ',80));i     END;    close(goodfile,error:=continue); close(dict1,error:=continue);n close(dict2,error:=continue);  close(dict3,error:=continue);e   IF logging AND logged_something  THEN ;"   close (logfile,error:=continue);   END;  & PROCEDURE checkmode;		{VMS check mode} VAR tmpline:line;p     tmpstr:wordtype;     i:INTEGER; BEGINt7    open (dict1,filedir+'LEXIC08.DAT',history:=readonly,I< 	access_method:=KEYED,organization:=INDEXED,error:=continue, 	sharing:=readwrite);d>    IF status(dict1)>0 THEN openerror('short word dictionary');7    open (dict2,filedir+'LEXIC16.DAT',history:=readonly,n< 	access_method:=KEYED,organization:=INDEXED,error:=continue, 	sharing:=readwrite);'?    IF status(dict2)>0 THEN openerror('medium word dictionary');h7    open (dict3,filedir+'LEXIC32.DAT',history:=readonly,e< 	access_method:=KEYED,organization:=INDEXED,error:=continue, 	sharing:=readwrite);)=    IF status(dict3)>0 THEN openerror('long word dictionary');r    IF using_persdict    THENt
      BEGIN9      open (persdict,'sys$login:'+pdfile,history:=unknown,'? 	   access_method:=KEYED,organization:=INDEXED,error:=continue,. 	   sharing:=readwrite);      IF status(persdict)>0  
      THEN         persdicterror;T	      END;e    tmpline:=param;:    WHILE (index(tmpline,' ')=1) AND (length(tmpline)>1) DO7        tmpline:=substr(tmpline,2,length(tmpline)-1);   h    IF length(tmpline)=1i	      THEN        BEGIN N        write_menu('','Please enter the word you want to check: ',vers:=false);        myreadln(tmpline);         IF length(tmpline)<=32s 	THEN, 	 tmpline:=pad(tmpline,' ',33);u
       END;"    tmpstr:=(substr(tmpline,1,32));    FOR i:=1 TO 32 DO.     IF tmpstr.body[i] IN upper_case_chars THEN2       tmpstr.body[i]:=chr(ord(tmpstr.body[i])+32);    IF occurs(tmpstr) e     THEN<      write_menu('','"'+substr(tmpstr,1,index(tmpstr,' ')-1)+1 	    '" was found. Press any key to continue...')t     ELSE<      write_menu('','"'+substr(tmpstr,1,index(tmpstr,' ')-1)+6 	    '" was not found. Press any key to continue...');
    getkey;     close(dict1,error:=continue);     close(dict2,error:=continue);     close(dict3,error:=continue);    IF using_persdict    THENi%      close(persdict,error:=continue);  END;  4 PROCEDURE updatepers;			{update personal dictionary} VAR key:keystroke;     ch:CHAR;  0 PROCEDURE listpers;			{list personal dictionary} VAR wordnum:INTEGER;     part1,part2:wordtype;      i:INTEGER; BEGIN)<    smg$unpaste_virtual_display(personal_display,pasteboard);'    smg$erase_display(personal_display);t>    smg$paste_virtual_display(personal_display,pasteboard,3,1);    wordnum:=1;J    IF ufb(persdict) THEN resetk(persdict,0,error:=continue);	{wrap around}9    WHILE (wordnum MOD 17 <> 0) AND (NOT ufb(persdict)) DOt       BEGINO4        part1:=persdict^.item;		{two column printing}%        get(persdict,error:=continue);         IF NOT ufb(persdict)  	THEN[ 	 part2:=persdict^.item  	ELSEE 	 part2:='';%        get(persdict,error:=continue);ID        smg$put_chars(personal_display,part1+'  '+part2,wordnum+1,2);        wordnum:=wordnum+1	
       END; END;  7 PROCEDURE delpers;			{delete a word from personal dict}t VAR thisword:wordtype;     tmpword:word3; BEGINEC   write_menu('','Enter the word you want to delete: ',vers:=false);I   myreadln(thisword);t   IF length(thisword)>0     THENk      IF length(thisword)<32n
       THEN        BEGIN$ 	tmpword.item:=pad(thisword,' ',32);  	findk(persdict,0,tmpword.item);" 	delete(persdict,error:=continue); 	get(persdict,error:=continue); 
        END
       ELSE        BEGIN 	 write_menu('',G 	  'Word is not in personal dictionary! Press any key to continue...');p 	 getkey
        END END;   BEGIN {updatepers}7    open (persdict,'sys$login:'+pdfile,history:=unknown, = 	 access_method:=KEYED,organization:=INDEXED,error:=continue,} 	 sharing:=readwrite);,    IF status(persdict)>0 THEN persdicterror;    listpers;	    REPEATaN      write_menu('Personal Dictionary Options:',' List Delete Menu Quit Help');      key:=getkey; ch:=key.ch;'      CASE ch OF        'L':listpers;d       'D':delpers;       'M':;{nothing}       'Q':GOTO 99;*       'H':put_help('PERSONAL.SPELL_HELP');	      END;r    UNTIL ch = 'M';<    smg$unpaste_virtual_display(personal_display,pasteboard); END;   BEGIN {maintain}   CASE maintmode OF      system:updatedict;     checking:checkmode;'     personal:updatepers;      normal:{should never happen}   END;  closefiles; END;   PROCEDURE proofread; BEGINt   pasted:=false;   Openfiles;   ReadInCommonWrds;N   LineNumber := 0;   write_menu('','Checking...');e   status_line(0);r-   WHILE (NOT eof(document)) AND (NOT quit) DOl	     BEGINi     ReadTextLine;b-     WHILE (textline <> NIL) AND (NOT quit) DO_       checkword;     IF using_listing THEN;       BEGIN$0       writeln(listing,currline,error:=continue);)       IF status(listing)>0 THEN outerror;d
       END;     END;   flushrest;/   WriteTree ( NewGoodWords, false, First_tmp );g
   closefiles;m	   byebye;e END;   BEGIN	{main program}! stat := LIB$Get_Foreign(cmdline);  cmd_lastnb := -1;nK FOR cmd_index := 1 TO length(cmdline) DO {find last `significant' characteri 					  in command line} 	     BEGIN G     IF substr(cmdline, cmd_index, 1)<>' ' THEN cmd_lastnb := cmd_index;l     END; IF cmd_lastnb < 0 THEN     cmdline := 'Spell' ELSE9     cmdline := 'Spell ' + Substr(cmdline, 1, cmd_lastnb); 6 stat := CLI$DCL_Parse(cmdline, %IMMED Spell_CLItable);   IF stat=CLI$_normal THEN    BEGIN    Init;
    banner;1    IF maintmode=normal		{we want to check a file}T     THEN
      BEGIN>       stat:=cli$present('FILES');		{see if we have a filename}       IF stat=cli$_present        THEN_
 	proofread        ELSE   
        REPEAT  	IF grp<=sys_uic 	 THEND 	  write_menu('Top level:',' Spell Check Update Personal Help Quit') 	 ELSE> 	  write_menu('Top level:',' Spell Check Personal Help Quit'); 	selection:=getkey;$ 	CASE selection.ch OF) 	 'S':proofread;/ 	 'C':BEGIN maintmode:=checking; maintain; END;=B 	 'U':IF grp<=sys_uic THEN BEGIN maintmode:=system; maintain; END;/ 	 'P':BEGIN maintmode:=personal; maintain; END;e! 	 'H':put_help('TOP.SPELL_HELP');e 	 'Q':{do nothing};m 	END;n        UNTIL selection.ch = 'Q'       END     ELSE(      maintain;			{maintenance utilities}     END;& 99: smg$delete_pasteboard(pasteboard);     IF using_listing THENeJ       close(listing,disposition:=delete,error:=continue);   {just in case} END.