## -*-Tcl-*- (install)
 # ###################################################################
 # 
 #  FILE: "macros.tcl"
 #                                    created: 27/7/97 {11:39:46 pm} 
 #                                last update: 23/2/98 {10:57:27 am} 
 # ###################################################################
 ##
alpha::extension macros 0.2.2 {
	menu::buildProc KbdMacros rebuildMacroMenu
	menu::insert Utils submenu end KbdMacros
} disable {
	menu::uninsert Utils submenu end KbdMacros
}


proc dumpNamedMacro {} {
	global macroArr
	set name [listpick -p "Macro name?" [array names macroArr]]
	regsub -all ";\r" $macroArr($name) "\r" text
	insertText $text
}

proc nameLastMacro {} {
	global macroArr modifiedArrVars
	set name [prompt "Macro name?" ""]
	regsub macroName [keyboardMacro] $name macro
	regsub -all "\r" $macro ";\r" macro
	eval $macro
	set macroArr($name) $macro
	lappend modifiedArrVars macroArr
	rebuildMacroMenu
}

proc deleteNamedMacro {} {
	global macroArr modifiedArrVars
	
	set which [listpick -p "Delete which macro?" [lsort [array names macroArr]]]
	unset macroArr($which)
	lappend modifiedArrVars macroArr
	rebuildMacroMenu
}

proc rebuildMacroMenu {} {
	Menu -n KbdMacros {
		"/qstartKeyboardMacro"
		"/rendKeyboardMacro"
		"/sexecuteKeyboardMacro"
		"(-"
		"nameLastMacro"
		"deleteNamedMacro"
		"dumpNamedMacro"
		"(-"
		"Menu -n macros {}"
	}	
	global macroArr
	
	set l {}
	foreach f [lsort [array names macroArr]] {
		eval $macroArr($f)
		lappend l $f
	}
	eval Menu -m -n macros [list $l]
}


