/* ioctl1.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __ioctl1(int fd, int request)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD type;
    int res;

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);

    if (request != 0)
        return _rsxnt_errno(EINVAL);

    type = GetFileType(p->file[fd].f_handle);

    switch (type) {

        /*
        * disk file
        *  15    file is remote (DOS 3+)
        *  14    don't set file date/time on closing (DOS 3+)
        *  11    media not removable
        *   8    (DOS 4 only) generate INT 24 if no disk space on write or read past
        *          end of file
        *   7    clear (indicates file)
        *   6    file has not been written
        *  5-0   drive number (0 = A:)
        */
        case FILE_TYPE_DISK:
            res = 0;
            break;

        /*
        * character device
        *  14    device driver can process IOCTL requests (see AX=4402h)
        *  13    output until busy supported
        *  11    driver supports OPEN/CLOSE calls
        *   7    set (indicates device)
        *   6    EOF on input
        *   5    raw (binary) mode
        *   4    device is special (uses INT 29)
        *   3    clock device
        *   2    NUL device
        *   1    standard output
        *   0    standard input
        */
        case FILE_TYPE_CHAR:
            if (p->file[fd].f_handle == GetStdHandle(STD_INPUT_HANDLE))
                res = 0x81;
            else if (p->file[fd].f_handle == GetStdHandle(STD_OUTPUT_HANDLE))
                res = 0x82;
            else if (p->file[fd].f_handle == GetStdHandle(STD_ERROR_HANDLE))
                res = 0x82;
            else
                res = 0xf0;
            break;

        case FILE_TYPE_PIPE:
            res = 0x80;
            break;

        case FILE_TYPE_UNKNOWN:
        default:
            return _rsxnt_errno(EINVAL);
    }
    return res;
}
