/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.Command;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Log;

public abstract class CharToken
extends Token {
    protected CharCode code;

    public final CharCode charCode() {
        return this.code;
    }

    public Token makeCharToken(CharCode code) {
        Maker maker = this.getMaker();
        return maker != null ? maker.make(code) : null;
    }

    public CharCode nonActiveCharCode() {
        return this.code;
    }

    public int numValue() {
        return this.code.numValue();
    }

    public void addOn(Log log) {
        log.add(this.code);
    }

    public final boolean match(Token tok) {
        return tok instanceof CharToken && this.match((CharToken)tok);
    }

    public final boolean match(CharCode chr) {
        return this.code.match(chr);
    }

    public abstract boolean match(CharToken var1);

    public Token category() {
        return this;
    }

    public abstract Maker getMaker();

    public String toString() {
        return "<Char: " + this.code + ">";
    }

    public CharToken(CharCode code) {
        this.code = code;
    }

    public abstract class Meaning
    extends Command {
        public final CharCode charCode() {
            return CharToken.this.code;
        }

        public final void addOn(Log log) {
            log.add(this.description()).add(' ').add(CharToken.this.code);
        }

        public boolean sameAs(Command cmd) {
            return this.getClass() == cmd.getClass() && CharToken.this.code.match(((Meaning)cmd).charCode());
        }

        public final Token origin() {
            return CharToken.this;
        }

        public final String toString() {
            return "[" + this.description() + " " + CharToken.this.code + "]";
        }

        protected abstract String description();
    }

    public static interface Maker {
        public Token make(CharCode var1);
    }
}

