/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.base.BytePar;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.ContextDisplay;
import nts.command.CtrlSeqToken;
import nts.command.Expandable;
import nts.command.InpTokChecker;
import nts.command.ScanToksChecker;
import nts.command.Token;
import nts.command.TokenList;
import nts.command.Tokenizer;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.Loggable;

public class Macro
extends Expandable {
    private static final Token PAR_TOKEN = new CtrlSeqToken("par");
    public static final int BOOLP_TRACING_MACROS = CommandBase.newBoolParam();
    private static final byte REJECT_AND_COMPLAIN = 0;
    private static final byte REJECT_ONLY = 1;
    private static final byte ACCEPT = 2;
    private TokenList[] mask;
    private CharCode[] matchCodes;
    private TokenList body;
    private int prefixes;

    public void doExpansion(Token src) {
        if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_MACROS)) {
            src.addProperlyOn(CommandBase.diagLog.endLine());
            this.addMask(CommandBase.diagLog).add(this.body).startLine();
        }
        TokenList[] params = null;
        if (this.mask.length > 0) {
            try {
                params = this.scanParameters(src);
            }
            catch (DoesNotMatch d) {
                return;
            }
        }
        CommandBase.getTokStack().cleanFinishedLists();
        Macro macro = this;
        if (macro == null) {
            throw null;
        }
        CommandBase.getTokStack().push(macro.new Expansion(params, src));
    }

    private TokenList[] scanParameters(Token src) throws DoesNotMatch {
        BytePar parReact = new BytePar((this.prefixes & 1) != 0 ? (byte)2 : 0);
        if (this.mask[0].length() != 0) {
            this.scanCompulsory(src, this.mask[0], parReact);
        }
        if (this.mask.length > 1) {
            TokenList[] params = new TokenList[this.mask.length - 1];
            int i = 1;
            while (i < this.mask.length) {
                TokenList param;
                Object var9_8;
                TokenList.Buffer buf = new TokenList.Buffer(10, 10);
                MatchChecker mchk = new MatchChecker(buf, src, parReact);
                InpTokChecker savedChk = CommandBase.setTokenChecker(mchk);
                try {
                    block10: {
                        try {
                            if (this.mask[i].length() != 0) {
                                this.scanParam(src, buf, this.mask[i], parReact);
                                break block10;
                            }
                            this.scanParam(src, buf, parReact);
                        }
                        catch (ParAbort a) {
                            if (parReact.get() == 0) {
                                CommandBase.runAway("argument", buf);
                                CommandBase.backToken(a.tok);
                                CommandBase.error("RunawayArg", src);
                            }
                            throw new DoesNotMatch();
                        }
                    }
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    CommandBase.setTokenChecker(savedChk);
                    throw throwable;
                }
                CommandBase.setTokenChecker(savedChk);
                params[i - 1] = param = buf.toTokenList();
                if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_MACROS)) {
                    CommandBase.diagLog.startLine().add(this.matchCodes[i - 1]);
                    CommandBase.diagLog.add(Character.forDigit(i, 10)).add("<-");
                    param.addOn(CommandBase.diagLog, 1000);
                    CommandBase.diagLog.startLine();
                }
                ++i;
            }
            return params;
        }
        return null;
    }

    private void scanCompulsory(Token src, TokenList compulsory, BytePar parReact) throws DoesNotMatch {
        TokenList.Buffer buf = new TokenList.Buffer(0);
        MatchChecker mchk = new MatchChecker(buf, src, parReact);
        InpTokChecker savedChk = CommandBase.setTokenChecker(mchk);
        try {
            int i = 0;
            while (i < compulsory.length()) {
                Token tok = CommandBase.nextRawToken();
                if (!tok.match(compulsory.tokenAt(i))) {
                    CommandBase.error("UseDoesntMatch", src);
                    throw new DoesNotMatch();
                }
                ++i;
            }
        }
        finally {
            Object var8_9 = null;
            CommandBase.setTokenChecker(savedChk);
        }
    }

    private void scanParam(Token src, TokenList.Buffer buf, BytePar parReact) throws ParAbort {
        block4: {
            Token tok;
            do {
                if (PAR_TOKEN.match(tok = CommandBase.nextRawToken()) && parReact.get() != 2) {
                    throw new ParAbort(tok);
                }
                if (tok.matchLeftBrace()) {
                    buf.append(tok);
                    this.addGroup(buf, parReact);
                    buf.removeLastToken();
                    buf.removeTokenAt(0);
                } else {
                    if (!tok.matchRightBrace()) continue;
                    this.reportExtraRightBrace(tok, src);
                    parReact.set((byte)0);
                }
                break block4;
            } while (tok.matchSpace());
            buf.append(tok);
        }
    }

    private void scanParam(Token src, TokenList.Buffer buf, TokenList separator, BytePar parReact) throws ParAbort {
        int matchLen = separator.length();
        Token[] matchBuf = new Token[matchLen];
        int matchIdx = 0;
        int groupCnt = 0;
        while (true) {
            Token tok;
            block7: {
                int j;
                if ((tok = CommandBase.nextRawToken()).match(separator.tokenAt(matchIdx))) {
                    matchBuf[matchIdx++] = tok;
                    if (matchIdx < matchLen) continue;
                    if (tok.matchLeftBrace()) {
                        CommandBase.adjustBraceNesting(-1);
                    }
                    if (groupCnt != true || buf.length() < 2) break;
                    Token first = buf.tokenAt(0);
                    Token last = buf.lastToken();
                    if (!first.matchLeftBrace() || !last.matchRightBrace()) break;
                    buf.removeLastToken();
                    buf.removeTokenAt(0);
                    break;
                }
                matchBuf[matchIdx++] = tok;
                int i = 0;
                do {
                    buf.append(matchBuf[i++]);
                    if (i >= matchIdx) break block7;
                    j = i;
                    while (j < matchIdx && matchBuf[j].match(separator.tokenAt(j - i))) {
                        ++j;
                    }
                } while (j < matchIdx);
                System.arraycopy(matchBuf, i, matchBuf, 0, matchIdx -= i);
                continue;
            }
            matchIdx = 0;
            if (PAR_TOKEN.match(tok) && parReact.get() != 2) {
                buf.removeLastToken();
                throw new ParAbort(tok);
            }
            if (tok.matchLeftBrace()) {
                this.addGroup(buf, parReact);
                ++groupCnt;
                continue;
            }
            if (!tok.matchRightBrace()) continue;
            buf.removeLastToken();
            this.reportExtraRightBrace(tok, src);
            parReact.set((byte)0);
        }
    }

    private void addGroup(TokenList.Buffer buf, BytePar parReact) throws ParAbort {
        int balance = 1;
        while (true) {
            Token tok;
            if (PAR_TOKEN.match(tok = CommandBase.nextRawToken()) && parReact.get() != 2) {
                CommandBase.adjustBraceNesting(-balance);
                throw new ParAbort(tok);
            }
            buf.append(tok);
            if (tok.matchLeftBrace()) {
                ++balance;
                continue;
            }
            if (tok.matchRightBrace() && --balance == 0) break;
        }
    }

    private void reportExtraRightBrace(Token tok, Token src) {
        CommandBase.backToken(tok);
        CommandBase.insertToken(PAR_TOKEN);
        CommandBase.adjustBraceNesting(1);
        CommandBase.error("ExtraRightBrace", src);
    }

    private Log addMask(Log log) {
        if (this.mask.length > 0) {
            log.add(this.mask[0]);
            int i = 1;
            while (i < this.mask.length) {
                log.add(this.matchCodes[i - 1]).add(Character.forDigit(i, 10)).add(this.mask[i]);
                ++i;
            }
        }
        return log;
    }

    public void addMaxOn(Log log, int maxCount) {
        maxCount += log.getCount();
        if (this.mask.length > 0) {
            this.mask[0].addOn(log, maxCount - log.getCount());
            int i = 1;
            while (i < this.mask.length && log.getCount() < maxCount) {
                log.add(this.matchCodes[i - 1]).add(Character.forDigit(i, 10));
                this.mask[i].addOn(log, maxCount - log.getCount());
                ++i;
            }
        }
        this.body.addOn(log, maxCount - log.getCount());
    }

    public boolean isOuter() {
        return (this.prefixes & 2) != 0;
    }

    public void addExpandable(Log log, int maxCount) {
        this.addPrefix(log);
        log.add(':');
        this.addMaxOn(log, maxCount);
    }

    public void addExpandable(Log log, boolean full) {
        this.addPrefix(log);
        if (full) {
            log.add(':').endLine();
            this.addMask(log).add(this.body);
        }
    }

    private void addPrefix(Log log) {
        if ((this.prefixes & 1) != 0) {
            log.addEsc("long");
        }
        if ((this.prefixes & 2) != 0) {
            log.addEsc("outer");
        }
        if ((this.prefixes & 3) != 0) {
            log.add(' ');
        }
        log.add("macro");
    }

    /*
     * Unable to fully structure code
     */
    public boolean sameAs(Command cmd) {
        block1: {
            if (!(cmd instanceof Macro)) break block1;
            mac = (Macro)cmd;
            if (this.prefixes != mac.prefixes || (len = this.mask.length) != mac.mask.length) break block1;
            if (--len < 0 || this.mask[len].match(mac.mask[len])) ** GOTO lbl8
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.matchCodes[len].match(mac.matchCodes[len]) && this.mask[len].match(mac.mask[len])) continue;
                return false;
lbl8:
                // 2 sources

                ** while (--len >= 0)
            }
lbl9:
            // 1 sources

            return this.body.match(mac.body);
        }
        return false;
    }

    static /* synthetic */ byte access$1() {
        return REJECT_ONLY;
    }

    public Macro(TokenList[] mask, CharCode[] matchCodes, TokenList body, int prefixes) {
        this.mask = mask;
        this.matchCodes = matchCodes;
        this.body = body;
        this.prefixes = prefixes;
    }

    public Macro(TokenList body, int prefixes) {
        this.mask = new TokenList[0];
        this.matchCodes = null;
        this.body = body;
        this.prefixes = prefixes;
    }

    private static class ParAbort
    extends Exception {
        public Token tok;

        public ParAbort(Token tok) {
            this.tok = tok;
        }
    }

    private static class DoesNotMatch
    extends Exception {
        DoesNotMatch() {
        }
    }

    private static class MatchChecker
    extends ScanToksChecker {
        private BytePar parReact;

        protected void reportError(String ident) {
            this.parReact.set((byte)1);
            super.reportError(ident);
        }

        public MatchChecker(TokenList.Buffer buf, Loggable src, BytePar pr) {
            super("OuterInMatch", "EOFinMatch", "argument", buf, src, PAR_TOKEN);
            this.parReact = pr;
        }
    }

    private class Expansion
    extends Tokenizer {
        private TokenList[] params;
        private int pos = 0;
        private Token src;

        public Token nextToken(BoolPar canExpand) {
            if (this.pos < Macro.this.body.length()) {
                Token tok = Macro.this.body.tokenAt(this.pos++);
                if (tok.isMacroParameter()) {
                    TokenList param = this.params[tok.macroParameterNumber()];
                    CommandBase.pushList(param, "argument");
                    return this.getStack().nextToken(canExpand);
                }
                canExpand.set(true);
                return tok;
            }
            canExpand.set(false);
            return null;
        }

        public boolean finishedList() {
            return this.pos >= Macro.this.body.length();
        }

        public int show(ContextDisplay disp, boolean force, int lines) {
            this.src.addProperlyOn(disp.normal().endLine());
            Log left = disp.left();
            int count = left.getCount();
            Macro.this.body.addContext(left, disp.right(), this.pos, count += 100000 - Macro.this.addMask(left).getCount());
            disp.show();
            return 1;
        }

        public Expansion(TokenList[] params, Token src) {
            this.params = params;
            this.src = src;
        }
    }
}

