/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import nts.builder.Builder;
import nts.builder.PageBuilder;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.CondPrim;
import nts.command.FileName;
import nts.command.InputLineTokenizer;
import nts.command.InteractionPrim;
import nts.command.SequenceTokenizer;
import nts.command.Token;
import nts.command.Tokenizer;
import nts.command.TokenizerStack;
import nts.io.InputLine;
import nts.io.LineInput;
import nts.io.LineOutput;
import nts.io.WriterLineOutput;
import nts.math.MathPrim;
import nts.tex.EditException;
import nts.tex.FatalError;
import nts.tex.KpseFileOpener;
import nts.tex.Primitives;
import nts.tex.TeXCharMapper;
import nts.tex.TeXFontHandler;
import nts.tex.TeXIOHandler;
import nts.typo.Page;
import nts.typo.TypoCommand;

public final class TeX {
    public static void main(String[] args) {
        FileOutputStream stdout = new FileOutputStream(FileDescriptor.out);
        Writer stdWr = TeXIOHandler.makeWriter(stdout);
        PrintWriter out = new PrintWriter(stdWr, true);
        out.println("This is NTS, Version 1.00-beta");
        out.println("NTS comes with ABSOLUTELY NO WARRANTY.");
        out.println("This is free software, and you are welcome to redistribute");
        out.println("it under certain conditions; for details see the file");
        out.println("COPYING in the distribution");
        TeXCharMapper mapper = new TeXCharMapper();
        Token.setCharCodeMaker(mapper);
        Reader stdin = TeXIOHandler.makeReader(System.in);
        LineInput input = new LineInput(stdin, (InputLine.Mapper)mapper);
        InputLine firstLine = null;
        String fmtName = System.getProperty("nts.fmt");
        String progName = System.getProperty("nts.progname");
        if (progName == null) {
            progName = fmtName;
        }
        if (progName == null) {
            progName = "nts";
        }
        KpseFileOpener opener = new KpseFileOpener(progName);
        if (args.length > 0) {
            StringBuffer buf = new StringBuffer(args[0]);
            int i = 1;
            while (i < args.length) {
                buf.append(' ').append(args[i]);
                ++i;
            }
            firstLine = new InputLine(buf.toString(), (InputLine.Mapper)mapper);
        }
        while (true) {
            if (firstLine != null) {
                firstLine.skipSpaces();
                if (!firstLine.empty()) break;
                out.println("Please type the name of your input file.");
            }
            out.write("**");
            out.flush();
            firstLine = input.readLine();
            if (firstLine != null) continue;
            out.println();
            out.println("! End of file on the terminal... why?");
            System.exit(1);
        }
        Primitives config = null;
        Object fontSeed = null;
        if (fmtName != null) {
            TeXCharMapper.TeXFileName name = new TeXCharMapper.TeXFileName();
            name.setPath(fmtName);
            name.addDefaultExt("nfmt");
            try {
                ObjectInputStream format = new ObjectInputStream(opener.openForReading(name, "fmt", true));
                long time = System.currentTimeMillis();
                config = (Primitives)format.readObject();
                fontSeed = format.readObject();
                time = System.currentTimeMillis() - time;
                System.err.println(name.getPath() + " loaded in " + time + " milliseconds");
                format.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(2);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(2);
            }
        } else {
            config = new Primitives();
        }
        CommandBase.setConfig(config.getCommandConfig());
        TypoCommand.setTypoConfig(config.getTypoConfig());
        MathPrim.setMathConfig(config.getMathConfig());
        TeXCharMapper.setConfig(config.getCharMapConfig());
        firstLine = firstLine.addEndOfLineChar();
        InputLine savedFirstLine = new InputLine(firstLine);
        WriterLineOutput terminal = new WriterLineOutput(stdWr, mapper, true, 79);
        TeXIOHandler ioHand = new TeXIOHandler(config.getIOHandConfig(), savedFirstLine, mapper, opener);
        TeXFontHandler fontHand = new TeXFontHandler(config.getFontHandConfig(), ioHand, fontSeed);
        TokenizerStack tokstack = new TokenizerStack();
        tokstack.push(new StdinTokenizer(ioHand.getTokenMaker(), firstLine));
        EditException edit = null;
        int status = 0;
        CommandBase.setIOHandler(ioHand);
        CommandBase.setInput(input);
        CommandBase.setTerminal(terminal);
        CommandBase.setTokStack(tokstack);
        Builder.push(new PageBuilder(0, Page.getPageSplit()));
        TypoCommand.setTypoHandler(fontHand);
        try {
            if (ioHand.getTokenMaker().scanCat(firstLine.peekNextRawCode()) != 0) {
                CommandBase.startInput();
            }
            boolean dumping = Command.mainLoop();
            ioHand.setAfterEnd();
            Command.cleanUp();
            CondPrim.cleanUp();
            if (dumping) {
                try {
                    config.preparePatterns();
                    ObjectOutputStream dumper = ioHand.getDumper();
                    long time = System.currentTimeMillis();
                    dumper.writeObject(config);
                    dumper.writeObject(fontHand.getSeed());
                    time = System.currentTimeMillis() - time;
                    System.err.println("format file stored in " + time + " milliseconds");
                    dumper.close();
                }
                catch (IOException e) {
                    status = 2;
                    System.err.println(e);
                }
            }
        }
        catch (FatalError e) {
            status = 1;
        }
        catch (EditException e) {
            edit = e;
        }
        catch (OutOfMemoryError e) {
            status = 2;
            System.err.println(e);
        }
        ioHand.finishDvi();
        FileName logName = ioHand.getLogName();
        ioHand.closeLogFile();
        terminal.startLine();
        if (logName != null && !InteractionPrim.isSilent()) {
            ((LineOutput)terminal).add("Transcript written on " + logName.getPath() + ".");
            ((LineOutput)terminal).endLine();
        }
        ((LineOutput)terminal).close();
        if (edit != null) {
            edit.exec();
        }
        System.exit(status);
    }

    private TeX() {
    }

    private static final class StdinTokenizer
    extends SequenceTokenizer {
        private InputLineTokenizer.TokenMaker maker;
        private InputLine line = null;

        public Tokenizer nextTokenizer() {
            CommandBase.ensureOpenLog();
            if (!InteractionPrim.isInteractive()) {
                CommandBase.fatalError("NoEnd");
            }
            if (this.line != null && this.line.wasEmpty(true)) {
                CommandBase.normLog.startLine().add("(Please type a command or say `\\end')");
            }
            CommandBase.normLog.endLine();
            this.line = CommandBase.promptInput("*");
            if (this.line != null) {
                this.line = this.line.addEndOfLineChar();
                return new InputLineTokenizer(this.line, this.maker, "<*> ");
            }
            return null;
        }

        public StdinTokenizer(InputLineTokenizer.TokenMaker maker, InputLine first) {
            super(first == null ? null : new InputLineTokenizer(first, maker, "<*> "));
            this.maker = maker;
            this.line = first;
        }
    }
}

