/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.Builder;
import nts.builder.ParBuilder;
import nts.command.CommandBase;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Log;
import nts.node.BoxSizes;
import nts.node.Breaker;
import nts.node.FontMetric;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.HyphenNodeEnum;
import nts.node.Language;
import nts.node.LinesShape;
import nts.node.NamedHSkipNode;
import nts.node.NetDimen;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.PenaltyNode;
import nts.node.VShiftNode;
import nts.typo.TypoCommand;

public abstract class Paragraph
extends TypoCommand {
    public static final int DIMP_PAR_INDENT = CommandBase.newDimParam();
    public static final int TOKSP_EVERY_PAR = CommandBase.newToksParam();
    public static final int INTP_INTER_LINE_PENALTY = CommandBase.newIntParam();
    public static final int INTP_BROKEN_PENALTY = CommandBase.newIntParam();
    public static final int INTP_CLUB_PENALTY = CommandBase.newIntParam();
    public static final int INTP_WIDOW_PENALTY = CommandBase.newIntParam();
    public static final int GLUEP_PAR_SKIP = CommandBase.newGlueParam();
    public static final int BOOLP_TRACING_PARAGRAPHS = CommandBase.newBoolParam();
    public static final int BOOLP_UC_HYPH = CommandBase.newBoolParam();
    public static final int INTP_PRETOLERANCE = CommandBase.newIntParam();
    public static final int INTP_TOLERANCE = CommandBase.newIntParam();
    public static final int INTP_LOOSENESS = CommandBase.newIntParam();
    public static final int INTP_LINE_PENALTY = CommandBase.newIntParam();
    public static final int INTP_HYPHEN_PENALTY = CommandBase.newIntParam();
    public static final int INTP_EX_HYPHEN_PENALTY = CommandBase.newIntParam();
    public static final int INTP_ADJ_DEMERITS = CommandBase.newIntParam();
    public static final int INTP_DOUBLE_HYPHEN_DEMERITS = CommandBase.newIntParam();
    public static final int INTP_FINAL_HYPHEN_DEMERITS = CommandBase.newIntParam();
    public static final int DIMP_EMERGENCY_STRETCH = CommandBase.newDimParam();
    public static final int GLUEP_LEFT_SKIP = CommandBase.newGlueParam();
    public static final int GLUEP_RIGHT_SKIP = CommandBase.newGlueParam();
    public static final int GLUEP_PAR_FILL_SKIP = CommandBase.newGlueParam();

    public static void makeIndent(Builder bld) {
        bld.addBox(new HBoxNode(new BoxSizes(Dimen.ZERO, CommandBase.getConfig().getDimParam(DIMP_PAR_INDENT), Dimen.ZERO, Dimen.ZERO), GlueSetting.NATURAL, NodeList.EMPTY));
    }

    public static void start(boolean indent) {
        CommandBase.Config cfg = CommandBase.getConfig();
        Builder old = TypoCommand.getBld();
        old.setPrevGraf(0);
        if (old.needsParSkip()) {
            old.addSkip(cfg.getGlueParam(GLUEP_PAR_SKIP), cfg.getGlueName(GLUEP_PAR_SKIP));
        }
        ParBuilder par = new ParBuilder(CommandBase.currLineNumber(), TypoCommand.getTypoConfig().getLanguage());
        Builder.push(par);
        if (indent) {
            Paragraph.makeIndent(par);
        }
        cfg.getToksInserter(TOKSP_EVERY_PAR).insertToks();
        old.buildPage();
    }

    public static void finish() {
        Builder parBld = TypoCommand.getBld();
        NodeList list = parBld.getParagraph();
        if (list != null) {
            Paragraph.lineBreak(list, parBld.getStartLine(), CommandBase.getConfig().getIntParam(INTP_WIDOW_PENALTY), parBld.getInitLang(), null);
            TypoCommand.getTypoConfig().resetParagraph();
            CommandBase.getIOHandler().resetErrorCount();
        }
    }

    public static void lineBreak(NodeList list, int startingLine, int widowPenalty, Language initLang, Dimen.Par lastVisibleWidth) {
        if (list.isEmpty()) {
            Builder.pop();
        } else {
            int threshold;
            CommandBase.Config cfg = CommandBase.getConfig();
            TypoCommand.Config tcfg = TypoCommand.getTypoConfig();
            Node last = list.lastNode();
            if (last.isSkip()) {
                list.removeLastNode();
            }
            list.append(new PenaltyNode(Num.valueOf(10000)));
            list.append(new NamedHSkipNode(cfg.getGlueParam(GLUEP_PAR_FILL_SKIP), cfg.getGlueName(GLUEP_PAR_FILL_SKIP)));
            Builder.pop();
            boolean marginSkipHadInfiniteShrink = false;
            boolean tracing = cfg.getBoolParam(BOOLP_TRACING_PARAGRAPHS);
            Glue left = cfg.getGlueParam(GLUEP_LEFT_SKIP);
            Glue right = cfg.getGlueParam(GLUEP_RIGHT_SKIP);
            if (left.getShrOrder() != 0 && !left.getShrink().isZero() || right.getShrOrder() != 0 && !right.getShrink().isZero()) {
                marginSkipHadInfiniteShrink = true;
                tcfg.setMarginSkipsShrinkFinite();
                left = cfg.getGlueParam(GLUEP_LEFT_SKIP);
                right = cfg.getGlueParam(GLUEP_RIGHT_SKIP);
            }
            NamedHSkipNode leftSkip = left.isZero() ? null : new NamedHSkipNode(left, cfg.getGlueName(GLUEP_LEFT_SKIP));
            NamedHSkipNode rightSkip = new NamedHSkipNode(right, cfg.getGlueName(GLUEP_RIGHT_SKIP));
            NetDimen background = new NetDimen(cfg.getGlueParam(GLUEP_LEFT_SKIP));
            background.add(cfg.getGlueParam(GLUEP_RIGHT_SKIP));
            LinesShape shape = tcfg.linesShape();
            Builder bld = TypoCommand.getBld();
            int lineNo = bld.getPrevGraf();
            ParBreaker breaker = new ParBreaker(list.nodes(), shape, lineNo, cfg.getIntParam(INTP_LOOSENESS), cfg.getIntParam(INTP_LINE_PENALTY), cfg.getIntParam(INTP_HYPHEN_PENALTY), cfg.getIntParam(INTP_EX_HYPHEN_PENALTY), cfg.getIntParam(INTP_ADJ_DEMERITS), cfg.getIntParam(INTP_DOUBLE_HYPHEN_DEMERITS), cfg.getIntParam(INTP_FINAL_HYPHEN_DEMERITS), cfg.getBoolParam(BOOLP_TRACING_PARAGRAPHS));
            if (marginSkipHadInfiniteShrink) {
                breaker.infiniteShrinkageError();
            }
            if ((threshold = cfg.getIntParam(INTP_PRETOLERANCE)) >= 0) {
                if (tracing) {
                    CommandBase.diagLog.startLine().add("@firstpass");
                }
                breaker.breakToLines(background, threshold, false);
                if (!breaker.successfullyBroken() && tracing) {
                    CommandBase.diagLog.startLine().add("@secondpass");
                }
            }
            if (!breaker.successfullyBroken()) {
                Dimen emergStr = cfg.getDimParam(DIMP_EMERGENCY_STRETCH);
                threshold = cfg.getIntParam(INTP_TOLERANCE);
                tcfg.preparePatterns();
                breaker.refeed(new HyphNodeEnum(list.nodes(), initLang, cfg.getBoolParam(BOOLP_UC_HYPH)));
                breaker.breakToLines(background, threshold, !emergStr.moreThan(0));
                if (!breaker.successfullyBroken()) {
                    if (tracing) {
                        CommandBase.diagLog.startLine().add("@emergencypass");
                    }
                    background.addStretch((byte)0, emergStr);
                    breaker.breakToLines(background, threshold, true);
                }
            }
            if (tracing) {
                CommandBase.diagLog.startLine().endLine();
            }
            if (breaker.hasMoreLines()) {
                Dimen lastIndent;
                HBoxNode lastHBox;
                LinePacker packer = new LinePacker(startingLine);
                boolean club = true;
                boolean hyph = breaker.nextLineWasHyphenated();
                NodeList line = breaker.getNextLine();
                while (true) {
                    line.append(rightSkip);
                    if (leftSkip != null) {
                        NodeList old = line;
                        line = new NodeList(leftSkip);
                        line.append(old);
                    }
                    NodeEnum mig = bld.wantsMigrations() ? line.extractedMigrations().nodes() : NodeList.EMPTY_ENUM;
                    Node box = lastHBox = packer.packHBox(line, shape.getWidth(lineNo), true);
                    lastIndent = shape.getIndent(lineNo);
                    box = VShiftNode.shiftingRight(box, lastIndent);
                    TypoCommand.appendBox(bld, box, mig, false);
                    ++lineNo;
                    if (!breaker.hasMoreLines()) break;
                    int pen = cfg.getIntParam(INTP_INTER_LINE_PENALTY);
                    if (club) {
                        pen += cfg.getIntParam(INTP_CLUB_PENALTY);
                    }
                    if (hyph) {
                        pen += cfg.getIntParam(INTP_BROKEN_PENALTY);
                    }
                    club = false;
                    hyph = breaker.nextLineWasHyphenated();
                    line = breaker.getNextLine();
                    if (!breaker.hasMoreLines()) {
                        pen += widowPenalty;
                    }
                    if (pen == 0) continue;
                    bld.addPenalty(Num.valueOf(pen));
                }
                bld.setPrevGraf(lineNo);
                if (lastVisibleWidth != null) {
                    Dimen visible = lastHBox.allegedlyVisibleWidth();
                    if (visible != null) {
                        visible = visible.plus(lastIndent);
                    }
                    lastVisibleWidth.set(visible);
                }
            }
        }
    }

    public abstract void addOn(Log var1);

    private static class ParBreaker
    extends Breaker {
        private final boolean tracing;
        private int lastPrinted;
        private FontMetric lastMetric;
        private boolean infiniteShrinkageSeen;

        protected void reset() {
            super.reset();
            this.lastPrinted = -1;
            this.lastMetric = null;
        }

        protected void traceBreak(int idx, int serial, int bad, int pen, int dem, boolean artificial) {
            if (this.tracing) {
                if (this.lastPrinted < idx) {
                    CommandBase.diagLog.startLine();
                    do {
                        if (!this.stillNodeAt(++this.lastPrinted)) continue;
                        this.lastMetric = this.nodeAt(this.lastPrinted).addShortlyOn(CommandBase.diagLog, this.lastMetric);
                    } while (this.lastPrinted < idx);
                }
                CommandBase.diagLog.startLine().add('@');
                if (this.stillNodeAt(idx)) {
                    this.nodeAt(idx).addBreakDescOn(CommandBase.diagLog);
                } else {
                    CommandBase.diagLog.addEsc("par");
                }
                CommandBase.diagLog.add(" via @@").add(serial).add(" b=");
                if (bad > 10000) {
                    CommandBase.diagLog.add('*');
                } else {
                    CommandBase.diagLog.add(bad);
                }
                CommandBase.diagLog.add(" p=").add(pen).add(" d=");
                if (artificial) {
                    CommandBase.diagLog.add('*');
                } else {
                    CommandBase.diagLog.add(dem);
                }
            }
        }

        protected void traceBreak(Breaker.Break brk) {
            if (this.tracing) {
                CommandBase.diagLog.startLine().add("@@").add(brk.serial).add(": line ").add(brk.lineNo).add('.').add(brk.fitness);
                if (brk.hyphenated) {
                    CommandBase.diagLog.add('-');
                }
                CommandBase.diagLog.add(" t=").add(brk.demerits).add(" -> @@").add(brk.prev.serial);
            }
        }

        protected void infiniteShrinkageError() {
            if (!this.infiniteShrinkageSeen) {
                CommandBase.error("InfShringInPar");
                this.infiniteShrinkageSeen = true;
            }
        }

        public ParBreaker(NodeEnum nodeEnum, LinesShape shape, int firstLineNo, int looseness, int linePen, int hyphPen, int exHyphPen, int adjDem, int dblHyphDem, int finHyphDem, boolean tracing) {
            super(nodeEnum, shape, firstLineNo, looseness, linePen, hyphPen, exHyphPen, adjDem, dblHyphDem, finHyphDem);
            this.tracing = tracing;
        }
    }

    private static class LinePacker
    extends TypoCommand.HBoxPacker {
        protected final int startLine;

        protected void reportLocation(Log log) {
            log.add("in paragraph at lines ").add(this.startLine).add("--").add(CommandBase.currLineNumber());
        }

        public LinePacker(int startLine) {
            this.startLine = startLine;
        }
    }

    private static class HyphNodeEnum
    extends HyphenNodeEnum {
        protected CharCode hyphenChar(FontMetric metric) {
            Num num = metric.getNumParam(0);
            return num != null ? Token.makeCharCode(num.intVal()) : null;
        }

        protected void complain(FontMetric metric, CharCode code) {
            TypoCommand.charWarning(metric, code);
        }

        public HyphNodeEnum(NodeEnum in, Language lang, boolean ucHyph) {
            super(in, lang, ucHyph);
        }
    }
}

