/* REXX */
/*
   File makevplain.cmd  2004-05-17  (WaS)
   Creating the plain eTeX format file for VTeX/2 8.31+
*/
call setlocal

/* Load REXXUTIL */
ret = RxFuncAdd("SysLoadFuncs", "REXXUTIL", "SysLoadFuncs")
call SysLoadFuncs

/* determine full path of VTeX program */
vtexprog = SysSearchPath("PATH", "vtex.exe")

if vtexprog = "" then
   /* stop here, if the VTeX program does not exist */
   say "I cannot find the VTeX program."
else do

   /* the formats directory: */
   fmtdir = filespec("D", vtexprog) || "\vtex\fmt"
   
   /* execute this script in the formats directory */
   call directory(fmtdir)
   
   /* run IniTeX */
   "vtex -i -2 plain.fid"
   
end

exit

