./#=========
.TH o2linker 1 "" "1.0"
./#=========
.SH NAME
o2linker \(em o2's companion program to link together all your threaded grammars.
./"=========
.SH SYNOPSIS
[
file containing listing of all  grammars fsc files
]
./"=========
.SH OPTIONS
If no fsc type file is inputted, o2linker will ask for one.
This file is hand written by the compiler writer and contains
a list of all the emitted grammars fsc files. 
See 
.B ``/usr/local/yacco2/compiler/grammars/yacco2.fsc'' 
file as an example to write your own fsc file. 
./"========
.SH DESCRIPTION
.B o2linker
emits the ``thread bit'' map object file required for your compiler to reference the threaded grammars.
Then all your object files are inputted for the system linker 
.B ld
to make an executable program of your compiler.
Please read
.B ``/usr/local/yacco2/compiler/o2/bld_bash_APPLE''
script paying particular attention to the ld script line detailing the objects and libraries used. 
This should guide u in creating your own ``fsc'' type file.


./"========
.PP
.SH ``o2linker outputed files''
.TP
thread bit map c++ code 
.TP
Pdf document:
.B o2linker_doc.pdf 
cross reference of all your grammars defined and their referenced threads 


./"========
.PP
.SH EXAMPLES
1) Creating o2's threads bit map
.RS
.nf
\&\fCcd /usr/local/yacco2/compiler/grammars
/usr/local/yacco2/bin/o2linker yacco2.fsc
.fi
.RE

./"========
.SH "SEE ALSO by man"
.BR yacco2(1), 
.BR o2(1), 
.BR CWEB(1),
.BR cweave(1),
.BR ctangle(1),
.BR mpost(1),
.BR TeX(1)
.PP
In 
.B /usr/local/yacco2/docs/ 
.RS
.nf
o2linker.pdf \(em linker documentated ``literate program''
o2linker_doc.pdf \(em example of o2/o2linker's grammars cross reference document produced by o2linker 
o2book.pdf \(em reference manual 
.fi
.RE

In 
.B /usr/local/yacco2/compiler/grammars
.RS
.nf
yacco2.fsc \(em example of handcrafted input file of yacco2's grammars for o2linker digestion.
These grammars are used by o2 and o2linker programs.
.fi
.RE

In 
.B /usr/local/yacco2/
.RS
.nf
READMEvx.y.pdf - installation guide where x: version number and y: minor adjustment number 
gives a more detailed explanation. 
bld_bash_APPLE \(em install script referencing other scripts building libraries and programs. 
.fi
.RE

In 
.B /usr/local/yacco2/o2linker 
and 
.B /usr/local/yacco2/compiler/o2
.RS
.nf
bld_bash_APPLE \(em  script to create a program using libraries yacco2, pthread, and c++.
.fi
.RE

./"========
.SH "NOTE"
The bld_bash_APPLE script is used as an example. There are other bash scripts
for
.B GNU
and
.B SOLARIS.
See READMEvx.y.pdf. 


./"=========
.SH "OTHER LINKS"
.TP
.B www.tug.org
\(em website to download the 
.B CWEB 
"Literate programming" system,
.I mpost
Metapost graphics program
and possibly the
.B TeX
typesetting system. These are open source. Please consider joining
.B
Tug. 


./"=========
.SH AUTHOR
Dave Bone

 
