/*
 File: o2_err_hdlr.h
 Date and Time: Fri Jan 30 18:55:16 2015 
*/
#ifndef __o2_err_hdlr_h__
#define __o2_err_hdlr_h__ 1
#include "yacco2.h"
#include "yacco2_T_enumeration.h"
#include "yacco2_k_symbols.h"
#include "yacco2_err_symbols.h"
#include "yacco2_terminals.h"
#include "yacco2_characters.h"
// monolithic grammar: no thread
extern yacco2::State S1_Co2_err_hdlr;
namespace NS_o2_err_hdlr {
using namespace NS_yacco2_T_enum;// enumerate
using namespace yacco2;
struct fsm_rules_reuse_table_type{
 fsm_rules_reuse_table_type();
 int no_rules_entries_;
 Per_rule_s_reuse_table* per_rule_s_table_[3];
};
class Co2_err_hdlr: public yacco2::CAbs_fsm {
 public:
  enum rules_and_subrules{
   start_of_rule_list = NS_yacco2_T_enum::T_Enum::sum_total_T
   ,R_Ro2_err_hdlr_ = 569//start_of_rule_list + 0
    ,rhs1_Ro2_err_hdlr_ = 1
    ,rhs2_Ro2_err_hdlr_ = 2
   ,R_Rerrors_ = 570//start_of_rule_list + 2
    ,rhs1_Rerrors_ = 3
    ,rhs2_Rerrors_ = 4
   ,R_Rerror_ = 571//start_of_rule_list + 4
    ,rhs1_Rerror_ = 5
    ,rhs2_Rerror_ = 6
    ,rhs3_Rerror_ = 7
    ,rhs4_Rerror_ = 8
    ,rhs5_Rerror_ = 9
    ,rhs6_Rerror_ = 10
    ,rhs7_Rerror_ = 11
    ,rhs8_Rerror_ = 12
    ,rhs9_Rerror_ = 13
    ,rhs10_Rerror_ = 14
    ,rhs11_Rerror_ = 15
    ,rhs12_Rerror_ = 16
    ,rhs13_Rerror_ = 17
    ,rhs14_Rerror_ = 18
    ,rhs15_Rerror_ = 19
    ,rhs16_Rerror_ = 20
    ,rhs17_Rerror_ = 21
    ,rhs18_Rerror_ = 22
  };
  //no of la sets = 2
  //no of states = 25
  Co2_err_hdlr();
  ~Co2_err_hdlr();
  void op();
  bool failed();
  void reduce_rhs_of_rule
      (yacco2::UINT Sub_rule_no,yacco2::Rule_s_reuse_entry** Recycled_rule);
  fsm_rules_reuse_table_type fsm_rules_reuse_table;
  static int rhs_to_rules_mapping_[23];
 };
struct Ro2_err_hdlr;
struct Rerrors;
struct Rerror;
struct Ro2_err_hdlr:public yacco2::CAbs_lr1_sym {
  Ro2_err_hdlr(yacco2::Parser* P);
  public:
};

struct Rerrors:public yacco2::CAbs_lr1_sym {
  Rerrors(yacco2::Parser* P);
  public:
};

struct Rerror:public yacco2::CAbs_lr1_sym {
  Rerror(yacco2::Parser* P);

  void error_where(CAbs_lr1_sym* E_sym){
    std::string& ext_fle = yacco2::FILE_TBL__[E_sym->tok_co_ords__.external_file_id__];
    std::string line_of_data;
    std::ifstream ifile;
    ifile.open(ext_fle.c_str());
    if(ifile.good()){
        yacco2::UINT lno(1);yacco2::UINT dlno(E_sym->tok_co_ords__.line_no__);
        for(;lno<=dlno;++lno){
          getline(ifile,line_of_data);
          if(lno == dlno) break;
          line_of_data.clear();
        }      
    }      

    std::string space(" ");
    std::string::size_type f = line_of_data.find_first_of('\t');
    for(;f != std::string::npos;){
     line_of_data.replace(f,1,space);
     f = line_of_data.find_first_of('\t');
    }
    
    yacco2::lrclog << "Error in file#: " << E_sym->tok_co_ords__.external_file_id__
		<< " \"" << ext_fle.c_str() << "\"" << std::endl;
	yacco2::lrclog << line_of_data.c_str() << std::endl;
    std::cout << "Error in file#: " << E_sym->tok_co_ords__.external_file_id__
		<< " \"" << ext_fle.c_str() << "\"" << std::endl;
	std::cout << line_of_data.c_str() << std::endl;
	for(int pos = 1;pos < E_sym->tok_co_ords__.pos_in_line__;++pos){
	 yacco2::lrclog << ' ';
	 std::cout << ' ';
	}
	yacco2::lrclog << '^' << std::endl;
	yacco2::lrclog << "\tfpos: " << E_sym->tok_co_ords__.rc_pos__
		<< " line#: " << E_sym->tok_co_ords__.line_no__
		<< " cpos: " << E_sym->tok_co_ords__.pos_in_line__
		<< std::endl;
	std::cout << '^' << std::endl;
	std::cout << "\tfpos: " << E_sym->tok_co_ords__.rc_pos__
		<< " line#: " << E_sym->tok_co_ords__.line_no__
		<< " cpos: " << E_sym->tok_co_ords__.pos_in_line__
		<< std::endl;
		if(E_sym->tok_co_ords__.who_file__ != 0){
			yacco2::lrclog << "\twho thru it: " << E_sym->tok_co_ords__.who_file__
				<< " line#: " << E_sym->tok_co_ords__.who_line_no__
				<< std::endl;
			std::cout << "\twho thru it: " << E_sym->tok_co_ords__.who_file__
				<< " line#: " << E_sym->tok_co_ords__.who_line_no__
				<< std::endl;
		}
    ifile.close();
  };
  
  public:
  void sr1();
  void sr2();
  void sr3();
  void sr4();
  void sr5();
  void sr6();
  void sr7();
  void sr8();
  void sr9();
  void sr10();
  void sr11();
  void sr12();
  void sr13();
  void sr14();
  void sr15();
  void sr16();
  void sr17();
  void sr18();
};

} // end of namespace

#endif
