/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  parallel_parser_ph_th.lex
Dates:		  15 Mar 2004
Purpose:	  parse parallel-parser phrase
Output:       parallel-parser-phrase
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |parallel_parser_phrase_th| thread.\fbreak
Parse parallel-parser phrase.
\fbreak
Example of a parallel-parser construct to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/ppprsr.txt"}

@/
fsm	
(fsm-id "parallel_parser_ph_th.lex"
,fsm-filename parallel_parser_ph_th
,fsm-namespace NS_parallel_parser_ph_th
,fsm-class Cparallel_parser_ph_th{
  user-prefix-declaration
#include "lint_balls.h"
#include "identifier.h"
#include "o2_sdc.h"
#include "o2_code_end.h"
#include "la_expr_src.h"
  ***
  user-declaration
    public:
    T_parallel_parser_phrase* parallel_parser_phrase_;
  ***
  constructor
    parallel_parser_phrase_ = 0;
  ***
  op
    if(parallel_parser_phrase_ != 0){
      delete parallel_parser_phrase_;
      parallel_parser_phrase_ = 0;
    }
    parallel_parser_phrase_ = new T_parallel_parser_phrase;
    parallel_parser_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*parallel_parser_phrase_);
    parallel_parser_phrase_->phrase_tree(t);
  ***
}
,fsm-version "1.0",fsm-date "11 mar 2004",fsm-debug "false"
,fsm-comments "Parse grammar's parallel-parser construct.")
parallel-parser	
(	
  parallel-thread-function
    TH_parallel_parser_ph_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rparallel_parser_phrase  (){
  -> Rlint 
     Ropen_par 
       Rlint
       Rparameters 
     Rclose_par 
     Rlint {
    op
      Cparallel_parser_ph_th* fsm = 
	(Cparallel_parser_ph_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->parallel_parser_phrase_);
      fsm->parallel_parser_phrase_ = 0;
    ***
    }	
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

Ropen_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}

Rparameters  (){
  -> Rpp_thread_fnct_phrase 
     Rpp_la_bndary_phrase
}

Rpp_thread_fnct_phrase  (){
  ->   Rpp_thread_fnct Rlint 
       Rpp_thread_fnct_id
       Rlint R3asterics Rlint {
    op
      T_parallel_thread_function* pp_fnct = sf->p1__->pp_fnct_;
      pp_fnct->identifier(sf->p3__->id_);
      Cparallel_parser_ph_th* fsm = 
		(Cparallel_parser_ph_th*)rule_info__.parser__->fsm_tbl__;
      fsm->parallel_parser_phrase_->pp_funct(pp_fnct);
    ***
    }
}

Rpp_thread_fnct  (
lhs{
    user-declaration 
        public: T_parallel_thread_function* pp_fnct_;
    ***
    }
){
  ->  ||| "#parallel-thread-function" NS_identifier::TH_identifier {
    op
      pp_fnct_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
        pp_fnct_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_pp_thread_function_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        pp_fnct_ = 0;
        CAbs_lr1_sym* sym = new Err_no_pp_thread_function_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rpp_thread_fnct_id  (
lhs{user-declaration public:T_identifier* id_;***}
){
  ->  ||| "identifier" NS_identifier::TH_identifier {
      op
        id_ = sf->p2__;
      ***
      }  
  ->  ||| |?| NULL {
    op
      sf->p2__->set_auto_delete(true);
        id_ = 0;
        CAbs_lr1_sym* sym = new Err_no_pp_fnct_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        id_ = 0;
        CAbs_lr1_sym* sym = new Err_no_pp_fnct_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

R3asterics  (){
  -> ||| "#***"	NS_o2_code_end::TH_o2_code_end
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_syntax_code_end_present;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rpp_la_bndary_phrase  (
lhs{
	user-declaration 
		public:T_parallel_la_boundary* pp_la_bndary_;
	***
	}
){
  -> Rpp_la_bndary Rlint Rpp_la_bndary_stc Rlint {
    op
      pp_la_bndary_ = sf->p1__->pp_la_bndary_;
      pp_la_bndary_->la_supplier(sf->p3__->la_exp_->la_tok_can());
      sf->p3__->la_exp_->zero_la_tok_can();
      Cparallel_parser_ph_th* fsm = 
		(Cparallel_parser_ph_th*)rule_info__.parser__->fsm_tbl__;
      fsm->parallel_parser_phrase_->la_bndry(pp_la_bndary_);
    ***
    }
}

Rpp_la_bndary  (
lhs{
	user-declaration
		public:T_parallel_la_boundary* pp_la_bndary_;
*** }
){
  ->  ||| "#parallel-la-boundary" NS_identifier::TH_identifier {
    op
      pp_la_bndary_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
		pp_la_bndary_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_pp_bndry_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
		pp_la_bndary_ = 0;
        CAbs_lr1_sym* sym = new Err_no_pp_bndry_present;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rpp_la_bndary_stc  (
lhs{
	user-declaration 
		public:
		T_la_expr_src* la_exp_;
	***
   }
){
  ->  ||| "la-express-source" NS_la_expr_src::TH_la_expr_src {
      op
        la_exp_ = sf->p2__;
      ***
      } 
  ->  ||| |?| NULL {
    op
		la_exp_ = 0;
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
	la_exp_ = 0;
        CAbs_lr1_sym* sym = new Err_no_pp_la_bndary_expr_present;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}
}// end of rules
