/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rhs_component.lex
Dates:		  10 Jun 2004
Purpose:	  a component of subrule
Output:       rule_in_stbl
              T_in_stbl
              "|||"
              assorted errors
              "cweb-marker"             
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rhs_component| Thread.\fbreak
A component of subrule.\fbreak
\fbreak
Note: the forest versus trees on T and \paralleloperator which is a T but
i wanted clarity within {``subrule.lex''} to break out
a regular grammar expression from a thread expression

For clarity within the |subrule_def| grammar, eosubrule is
recognized only by |rhs_bnd| grammar. Well now, $-$$>$ is a T.
So I trap it in |fnd_T_of_chr_str| and abort the parse.
This stops the recognition on RTorRcomponents of |subrule_def|.

I could have used the enumeration approach to test its presence
but what is its value in the sea of Terminals.
It's not like the hardwired \paralleloperator 
lr k terminal that is fixed in place and time.

@/
fsm	
(fsm-id "rhs_component.lex"
,fsm-filename rhs_component
,fsm-namespace NS_rhs_component
,fsm-class Crhs_component{
  user-prefix-declaration
#include "identifier.h"
#include "c_string.h"
#include "cweb_or_c_k.h"
#include "unq_str.h"
#include "yacco2_stbl.h"
  ***
  user-declaration
    public:
      void fnd_T_of_chr_str(const char* Str,yacco2::CAbs_lr1_sym* Tok);
  ***
  user-implementation
      void Crhs_component::fnd_T_of_chr_str(const char* Str,yacco2::CAbs_lr1_sym* Tok){
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        find_sym_in_stbl(report_card,*Str);
        if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
          CAbs_lr1_sym* sym = new Err_subrule_use_undefined_T;
          sym->set_rc(*parser__->start_token__,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true); 
          return; 
        }
        if(report_card.tbl_entry_->type_ != table_entry::terminal){
          CAbs_lr1_sym* sym = new Err_not_T_or_R_in_subrule_expr;
          sym->set_rc(*parser__->start_token__,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true); 
          return; 
        }
		report_card.tbl_entry_->used_ = true;
        CAbs_lr1_sym* sym = report_card.tbl_entry_->symbol_;
        T_in_stbl* T = (T_in_stbl*)sym;
        refered_T* rT = new refered_T(*T);
        rT->set_rc(*Tok,__FILE__,__LINE__);
        
        T->add_T_into_xref(*rT);

        RSVP_FSM(T);
        parser__->set_stop_parse(true);  
      }
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "true"
,fsm-comments "Subule's individual component recognizer except eosubrule.")
parallel-parser	
(	
  parallel-thread-function
    TH_rhs_component
  ***
  parallel-la-boundary
eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rrhs_component (
//lhs,
parallel-control-monitor{
/@
   unquoted-string supersets identifier 
    and also includes other T like $-$$>$ and cweb comments ie cweb-marker.
    Code only gets tried when \# parms in accept queue $>$ 1.
 Single entry is one of identifier or cweb.
@/
  arbitrator-code
	using namespace NS_yacco2_T_enum;
          for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_T_in_stbl_){
	        goto arbitrated_parameter;
             }
	  }
          for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_rule_in_stbl_){
	        goto arbitrated_parameter;
             }
	  }
           for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_T_identifier_){
	        goto arbitrated_parameter;
             }
	  }

          for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_T_c_string_){
	        goto arbitrated_parameter;
             }
	  }
           for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_T_cweb_marker_){
	        goto arbitrated_parameter;
             }
	  }          
          for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_kw_in_stbl_){
	        goto arbitrated_parameter;
             }
	  }
          for(i=1;i<=ie;++i){
	     if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
                == NS_yacco2_T_enum::T_Enum::T_T_unquoted_string_){
	        goto arbitrated_parameter;
             }
	  }
  ***
  }
){
  -> ||| identifier NS_identifier::TH_identifier {
  /@
  Used rule and not defined yet, so create it.
  @/
    op 
        const char* skey = sf->p2__->identifier()->c_str();

        rule_def* rdef = new rule_def(skey);
        rdef->set_rc(*sf->p2__,__FILE__,__LINE__);
        rule_in_stbl* ristbl = new rule_in_stbl(*rdef);
        ristbl->set_rc(*sf->p2__,__FILE__,__LINE__);
        
        refered_rule* rr = new refered_rule(*ristbl);
        rr->set_rc(*sf->p2__,__FILE__,__LINE__);
		ristbl->add_R_into_xref(*rr);
        sf->p2__->set_auto_delete(true);
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        add_sym_to_stbl(report_card,*skey,*ristbl,table_entry::used,table_entry::rule);
	  	if(report_card.status_ != T_sym_tbl_report_card::okay){
			report_card.err_entry_->set_rc(*sf->p2__,__FILE__,__LINE__);
			RSVP(report_card.err_entry_);
			rule_info__.parser__->set_stop_parse(true);
			return;
		}
	  	ristbl->stbl_idx(report_card.pos_);
        RSVP(ristbl);
        rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  -> ||| "c-string" NS_c_string::TH_c_string { 
/@
  Considered a T type.
@/
    op
      Crhs_component* fsm = (Crhs_component*)rule_info__.parser__->fsm_tbl__;
      fsm->fnd_T_of_chr_str(sf->p2__->c_string()->c_str(),sf->p2__);
	  sf->p2__->set_auto_delete(true);
    ***
    }
  -> ||| "unquoted-string" NS_unq_str::TH_unq_str {
/@
  Considered a T type. Why the check on subrule vector: $-$$>$?
  This is a context problem whereby my grammars use it and what happenes when
  a language being defined also has it?
  So i abort on the unprotected $-$$>$ so that |rhs_bnd| grammar
  covers it as one of my grammar's terminals. The quoted version is passed thru as is.
  Fractal logic on self contexts: The inner self and the outer contextual grounds. 
@/
    op // only accept when no identifier
      Crhs_component* fsm = (Crhs_component*)rule_info__.parser__->fsm_tbl__;
	  sf->p2__->set_auto_delete(true);
        string eos_chk("->");
        if(eos_chk == sf->p2__->unquoted_string()->c_str()){
          rule_info__.parser__->set_abort_parse(true);
          return;        
        }        
      fsm->fnd_T_of_chr_str(sf->p2__->unquoted_string()->c_str(),sf->p2__);
    ***
    }
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
    op 
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        AST* cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
      AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);
      RSVP(cw);
      rule_info__.parser__->set_stop_parse(true);       
    ***
   }
  -> ||| |+| NULL {
/@
  Forward the error.
@/
    op
      RSVP(sf->p2__);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  ||| "rule-in-stbl" NULL {
      op 
			using namespace yacco2_stbl;
			T_sym_tbl_report_card report_card;
			find_sym_in_stbl(report_card,*sf->p2__->r_def()->rule_name()->c_str());
			if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
				CAbs_lr1_sym* sym = new Err_rule_not_in_stbl;
				sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
				RSVP(sym);
				rule_info__.parser__->set_stop_parse(true); 
				return;        
			}
			report_card.tbl_entry_->used_ = true;
			refered_rule* rr = new refered_rule(*sf->p2__);
			rr->set_rc(*sf->p2__,__FILE__,__LINE__);
			sf->p2__->add_R_into_xref(*rr);
			RSVP(sf->p2__);
			rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
  ->  ||| "T-in-stbl" NULL {
  /@
  Used T, so indicate its xreference.
  @/
      op 
			using namespace yacco2_stbl;
			T_sym_tbl_report_card report_card;
			find_sym_in_stbl(report_card,*sf->p2__->t_def()->t_name()->c_str());
			if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
				CAbs_lr1_sym* sym = new Err_T_not_in_stbl;
				sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
				RSVP(sym);
				rule_info__.parser__->set_stop_parse(true); 
				return;        
			}
			report_card.tbl_entry_->used_ = true;
			refered_T* rt = new refered_T(*sf->p2__);
			rt->set_rc(*sf->p2__,__FILE__,__LINE__);

		    sf->p2__->add_T_into_xref(*rt);
			RSVP(sf->p2__);
			rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
  ->  ||| "kw-in-stbl" NULL {
      op 
			CAbs_lr1_sym* sym = new Err_not_T_or_R_in_subrule_expr;
			sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
			RSVP(sym);
			rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
}
}// end of rules
