/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  subrule_def.lex
new definition for subrule_def.lex
Dates:		  3 Jun 2004
Purpose:	  parse subrule's expression
Output:       T_subrule_def
              assorted errors
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |subrule_def| Thread.\fbreak
Parse a rule's subrule expression.\fbreak
Example of a parallel-parser construct to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/subrdef.txt"}

@/
fsm	
(fsm-id "subrule_def.lex"
,fsm-filename subrule_def
,fsm-namespace NS_subrule_def
,fsm-class Csubrule_def{
  user-prefix-declaration
using namespace NS_yacco2_terminals;
#include "lint_balls.h"
#include "cweb_or_c_k.h"

#include "subrule_vector.h"
#include "o2_sdc.h"
#include "identifier.h"
#include "dbl_colon.h"
#include "rhs_component.h"
#include "rtn_component.h"
#include "rhs_bnd.h"
#include "parallel_oper.h"
  ***
  user-declaration
    public:
    void add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc);
    T_subrule_def* subrule_def_;
  ***
  user-implementation
    void Csubrule_def::
    add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc){
      using namespace NS_yacco2_T_enum;
      using namespace NS_yacco2_terminals;
      yacco2::INT eid = Dir->enumerated_id__;
      switch (eid){
		case T_Enum::T_T_op_: {
		  T_op* k = (T_op*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		default: {
          CAbs_lr1_sym* sym = new Err_improper_directive;
          sym->set_rc(*Dir,__FILE__,__LINE__);
          
          RSVP_FSM(sym);
          parser__->set_stop_parse(true);
   		}      
      }    
    }
  ***
  op
    if(subrule_def_ != 0){
      delete subrule_def_;
      subrule_def_ = 0;
    }
    subrule_def_ = new T_subrule_def;
    subrule_def_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
  ***
  constructor
      subrule_def_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "true"
,fsm-comments "Parse a subrule: into the valley of sin...")
parallel-parser	
(	
  parallel-thread-function
    TH_subrule_def
  ***
  parallel-la-boundary
    eolr - ||| - |.| - |t|
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rsubrule_def 
/@
Use of \invisibleshift to make grammar lr(1) due to s/r conflict on \PARshift.
@/  
(){
  -> Rvector |.| Rcommon_comments Rrhs_expr {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->subrule_def_->bld_its_tree();
      RSVP(fsm->subrule_def_);
      fsm->subrule_def_ = 0;
    ***
    }	
}

Rvector  (){
  ->  ||| "->" NS_subrule_vector::TH_subrule_vector
}

Rcommon_comments
/@
Basic possible lint balls and a single
 cweb comment fronting the sub rule definition.
@/
(){
  -> Rlint_epi Rcweb_k_epi Rlint_epi 
}

Rrhs_expr
/@
Use of \invisibleshift to make grammar lr(1) due to s/r conflict on \PARshift.
@/  
(
//lhs,
parallel-control-monitor{
/@
Due to my wanting to emphasize a specific 
  versus a general grammar expression, there are 2 threads recognizing
  the same token \paralleloperator{} only at the beginning of subrule 
  so zero out the T-in-stbl from the accept queue as
  this is more general.
@/
  arbitrator-code
    using namespace NS_yacco2_T_enum;
  for(i=1;i<=ie;++i){
    CAbs_lr1_sym* sym = Caller_pp->pp_accept_queue__[i].accept_token__;
   if(sym->enumerated_id__ == NS_yacco2_T_enum::T_Enum::T_LR1_parallel_operator_){
        goto arbitrated_parameter;
   }
   if(sym->enumerated_id__ == NS_yacco2_T_enum::T_Enum::T_LR1_fset_transience_operator_){
        goto arbitrated_parameter;
   }
  }
  ***
  }
){
  ->  
/@
A regular grammar expression containing either \emptyrule{} or an \Alpha{} string
of symbols drawn from the T or R vocabularies.
Why the \INVshift{} symbol following |RTorRcomponents_epi|?
There is a shift / reduce conflict caused by the \PARshift{} so 
let the \emptyrule{} reduce on this meta terminal.
@/
RTorRcomponents_epi |.|  Rmust_eos  Rpotential_codeblk Rlint_epi 
  ->  
/@
Your standard thread call expression.
@/
Rstart_thread Rlint_epi Rbal_thread_expr
                Rlint_epi |.| Rcalled_thd_eos
                Rlint_epi Rpotential_codeblk Rlint_epi
  ->
/@
The new back-to-back chained thread call dispatcher expression.
|Rchained_dispatcher| rule supports nested chained calls.
The returned output from the \TRAshift{} expression becomes the input
to the next |Rchained_dispatcher| \TRAshift{} expression.
@/
Rstart_thread Rlint_epi Rbal_thread_expr
		Rlint_epi |.| Rchained_dispatcher
                Rlint_epi Rcalled_thd_eos
                Rlint_epi Rpotential_codeblk Rlint_epi
  ->  
/@
Your chained procedure call expression.
It can be used against a previous T element.
Note: a R element is not allowed as the chained procedure call
uses the stacked T of the caller parser
as its First set. So what does |Rxxx| mean to it? nada.
@/
Rcalled_proc_op Rlint_epi Rbal_called_proc_expr
                Rlint_epi |.| Rcalled_proc_eos
                Rlint_epi Rpotential_codeblk Rlint_epi
  ->
/@
The new back-to-back chained thread call dispatcher expression.
@/
Rcalled_proc_op Rlint_epi Rbal_called_proc_expr
		Rlint_epi |.| Rchained_dispatcher
                Rlint_epi Rcalled_proc_eos
                Rlint_epi Rpotential_codeblk Rlint_epi
}

Rstart_thread  (
//lhs,
parallel-control-monitor{
/@
Due to my wanting to emphasize a specific 
  versus a general grammar expression, there are 2 threads recognizing
  the same token \paralleloperator{} only at the beginning of subrule 
  so i'll zero out the T-in-stbl from the accept queue to as
  this is more general.
@/
  arbitrator-code
    using namespace NS_yacco2_T_enum;
  for(i=1;i<=ie;++i){
    CAbs_lr1_sym* sym = Caller_pp->pp_accept_queue__[i].accept_token__;
   if(sym->enumerated_id__ == NS_yacco2_T_enum::T_Enum::T_LR1_parallel_operator_){
        goto arbitrated_parameter;
   }
   if(sym->enumerated_id__ == NS_yacco2_T_enum::T_Enum::T_LR1_fset_transience_operator_){
        goto arbitrated_parameter;
   }
  }
  ***
  }
){
  ->  ||| "|||" NS_parallel_oper::TH_parallel_oper {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        find_sym_in_stbl(report_card,*sf->p2__->id__);
        if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
          CAbs_lr1_sym* sym = new Err_subrule_use_undefined_T;
          sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
          RSVP(sym);
          rule_info__.parser__->set_stop_parse(true); 
          return; 
        }
        CAbs_lr1_sym* sym = report_card.tbl_entry_->symbol_;
        T_in_stbl* t = (T_in_stbl*)sym;
        refered_T* rT = *(t->xref_t()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(rT);
      rT->its_subrule_def(fsm->subrule_def_);
    ***
    }
}

Rbal_thread_expr  (){
  ->  Rrtned_T Rlint_epi Rcalled_thread
}

Rrtned_T  (){
  ->  ||| "T-in-stbl" NS_rtn_component::TH_rtn_component {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      refered_T* reft = *(sf->p2__->xref_t()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(reft);
      reft->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  ||| |?| NULL {
  /@
  Other returned types are errors.
  @/
    op
      CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_T_for_rtned_token_from_th();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  ||| ||| NULL {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->subrule_def_->add_elem_to_subrule_vector(sf->p2__);
    ***
    }
}

Rcalled_thread  (){
  -> Rns Rdbl_colon Rth_name {
  op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      T_called_thread_eosubrule* sym = 
		new T_called_thread_eosubrule(sf->p1__->ns_,sf->p3__->thd_nm_); 
      sym->set_rc(*sf->p1__->ns_,__FILE__,__LINE__);
      sym->its_subrule_def(fsm->subrule_def_);
      fsm->subrule_def_->add_elem_to_subrule_vector(sym);
  ***
  } 
  -> RNULL
}

RNULL  (){
  ->  ||| "#NULL" NS_identifier::TH_identifier {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      T_null_call_thread_eosubrule* sym = new T_null_call_thread_eosubrule;
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      sym->its_subrule_def(fsm->subrule_def_);
      fsm->subrule_def_->add_elem_to_subrule_vector(sym);
      sf->p2__->set_auto_delete(true);
    ***
    }
}

Rns  (
lhs {
  user-declaration
  public:
  T_identifier* ns_;
  ***
}
){
  ->  ||| identifier NULL {
    op
      ns_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_id_for_ns_in_th_stmt();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_id_for_ns_in_th_stmt();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rdbl_colon  (){
  ->  ||| "::" NS_dbl_colon::TH_dbl_colon {
    op
      sf->p2__->set_auto_delete(true);
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_dbl_colon_in_th_stmt();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_dbl_colon_in_th_stmt();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rth_name  (
lhs {
  user-declaration
  public:
  T_identifier* thd_nm_;
  ***
}
){
  ->  ||| identifier NS_identifier::TH_identifier {
    op
      thd_nm_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_id_for_th_name_in_th_stmt();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_id_for_th_name_in_th_stmt();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rcalled_proc_op  (
//lhs,
parallel-control-monitor{
/@
Due to my wanting to emphasize a specific 
  versus a general grammar expression, there are 2 threads recognizing
  the same token \TRAshift{} only at the beginning of subrule 
  so i'll zero out the T-in-stbl from the accept queue so as
  this is more general.
@/
  arbitrator-code
    using namespace NS_yacco2_T_enum;
  for(i=1;i<=ie;++i){
   if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
             == NS_yacco2_T_enum::T_Enum::T_LR1_parallel_operator_){
        goto arbitrated_parameter;
   }
   if(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__ 
             == NS_yacco2_T_enum::T_Enum::T_LR1_fset_transience_operator_){
        goto arbitrated_parameter;
   }
  }
  ***
  }
){
  ->  ||| "|t|" NULL {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        find_sym_in_stbl(report_card,*sf->p2__->id__);
        if(report_card.action_ == T_sym_tbl_report_card::not_fnd){
          CAbs_lr1_sym* sym = new Err_subrule_use_undefined_T;
          sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
          RSVP(sym);
          rule_info__.parser__->set_stop_parse(true); 
          return; 
        }
        CAbs_lr1_sym* sym = report_card.tbl_entry_->symbol_;
        T_in_stbl* t = (T_in_stbl*)sym;
        refered_T* rT = *(t->xref_t()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(rT);
      rT->its_subrule_def(fsm->subrule_def_);
    ***
    }
}

Rbal_called_proc_expr  (){
  ->  Rrtned_T Rlint_epi Rcalled_proc_name
}

Rcalled_proc_name  (){
  -> Rns Rdbl_colon Rth_name {
  op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      T_called_thread_eosubrule* sym = 
		new T_called_thread_eosubrule(sf->p1__->ns_,sf->p3__->thd_nm_); 
      sym->set_rc(*sf->p1__->ns_,__FILE__,__LINE__);
      sym->its_subrule_def(fsm->subrule_def_);
      fsm->subrule_def_->add_elem_to_subrule_vector(sym);
  ***
  } 
  -> RNULL
}


RTorRcomponents_epi  (){
  ->  
  ->  RTorRcomponents
}

RTorRcomponents  (){
  ->  RTorRcomponent Rlint_epi
  ->  RTorRcomponents RTorRcomponent  Rlint_epi
}

RTorRcomponent  (){
  ->  ||| "rule-in-stbl" NS_rhs_component::TH_rhs_component {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      refered_rule* refr = *(sf->p2__->xref_r()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(refr);
      refr->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  ||| "T-in-stbl" NULL {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      refered_T* reft = *(sf->p2__->xref_t()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(reft);
      reft->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_T_or_R_in_subrule_expr();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rchained_dispatcher  (){
  ->  ||| "rule-in-stbl" NS_rhs_component::TH_rhs_component {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      refered_rule* refr = *(sf->p2__->xref_r()->rbegin());
      fsm->subrule_def_->add_elem_to_subrule_vector(refr);
      refr->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  ||| "T-in-stbl" NULL {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      CAbs_lr1_sym* sym = new Err_not_a_Rule();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_a_Rule();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rmust_eos  (){
  ->  ||| "eosubrule" NS_rhs_bnd::TH_rhs_bnd {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->subrule_def_->add_elem_to_subrule_vector(sf->p2__);
      sf->p2__->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_eos_in_subrule_expr();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
  ->  ||| |?| NULL {
    op
      CAbs_lr1_sym* sym = new Err_not_eos_in_subrule_expr();
      sym->set_rc(*sf->p2__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
      sf->p2__->set_auto_delete(true);
    ***
    }
}

Rcalled_thd_eos  (){
  ->  ||| "eosubrule" NS_rhs_bnd::TH_rhs_bnd {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->subrule_def_->add_elem_to_subrule_vector(sf->p2__);
      sf->p2__->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_eos_in_subrule_expr();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rcalled_proc_eos  (){
  ->  ||| "eosubrule" NS_rhs_bnd::TH_rhs_bnd {
    op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->subrule_def_->add_elem_to_subrule_vector(sf->p2__);
      sf->p2__->its_subrule_def(fsm->subrule_def_);
    ***
    }
  ->  |?| {
    op
      CAbs_lr1_sym* sym = new Err_not_eos_in_subrule_expr();
      sym->set_rc(*sf->p1__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);       
    ***
    }
}

Rpotential_codeblk  (){
  ->  Rpotential_directives
}

Rpotential_directives  (){
  ->   // no syntax code: end of subsule
  ->  "{" Rlint_epi Rmust_directive_phrase Rmaybe_more_directives Rclose_brace Rlint_epi
}

Rmust_directive_phrase  (){ 
  ->  Rdirective_cweb_k_epi Rlint_epi Rmust_directive Rsyntax_code Rlint_epi {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rmust_directive* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0){
        sdc->syntax_code_->add_cweb_marker(cwebt);
				}
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rmust_directive  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  constructor
    directive_ = 0;
  ***
  op
    if(directive_ == 0) return;
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = 
	fsm->subrule_def_->add_directive_to_subrule(directive_,rule_info__.parser__);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#op" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  -> ||| |?| NULL { 
      op
	directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_bad_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  -> |?|  { 
      op
        CAbs_lr1_sym* sym = new Err_no_directive_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rmaybe_more_directives  (){ 
  ->   
  ->  Rmaybe_directive_phrases 
}

Rmaybe_directive_phrases  (){ 
  ->  Rmaybe_directive_phrase 
  ->  Rmaybe_directive_phrases Rmaybe_directive_phrase 
}

Rmaybe_directive_phrase  (){ 
  ->  Rdirective_cweb_k_epi Rlint_epi Rdirective Rsyntax_code Rlint_epi {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rdirective* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0){
        sdc->syntax_code_->add_cweb_marker(cwebt);
				}

      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
  ->  Rdirective Rsyntax_code Rlint_epi {
    op
      Rdirective* dir = sf->p1__;
      Rsyntax_code* sdc = sf->p2__;
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rdirective_phrase  (){ 
  ->  Rlint_epi Rdirective_cweb_k_epi Rlint_epi Rdirective Rsyntax_code Rlint_epi {
    op
      AST* cwebt = sf->p2__->cweb_t_;
      Rdirective* dir = sf->p4__;
      Rsyntax_code* sdc = sf->p5__;
      if(cwebt != 0){
        sdc->syntax_code_->add_cweb_marker(cwebt);
				}
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rdirective  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  constructor
    directive_ = 0;
  ***
  op
    if(directive_ == 0) return;
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = 
		fsm->subrule_def_->add_directive_to_subrule(directive_,rule_info__.parser__);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#op" NS_identifier::TH_identifier  { 
    op
      directive_ = sf->p2__;
    ***
    }
  -> ||| |?| NULL { 
      op
	directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_bad_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}


Rsyntax_code  (
lhs {
  user-declaration
    T_syntax_code* syntax_code_;
  ***
	constructor
	  syntax_code_ = 0;
	***
 } 
){
  -> ||| "syntax-code" NS_o2_sdc::TH_o2_sdc {
      op
        syntax_code_ = sf->p2__;
      ***
      }
  -> ||| |?| NULL { // catcher in the Rye? These are errors
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint_epi  (){
  ->  ||| "lint" NS_lint_balls::TH_lint_balls
  -> |.| // needed to stop being not lr1
}

Rdirective_cweb_k_epi  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
  -> 
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
        AST::join_pts(*cweb_t_,*cwebk_t_);
        AST::set_content(*cweb_t_,*cw);
	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }      
  ->  ||| "comment" NULL {
      op 
        sf->p2__->set_auto_delete(true);
      ***
      }     
}

Rcweb_k_epi  (){
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
      Csubrule_def* fsm = (Csubrule_def*)rule_info__.parser__->fsm_tbl__;
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        AST* cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
        AST::join_pts(*cweb_t_,*cwebk_t_);

        AST::set_content(*cweb_t_,*cw);
        fsm->subrule_def_->add_cweb_marker(cweb_t_);
	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
  ->  ||| "comment" NULL {
      op 
        sf->p2__->set_auto_delete(true);
      ***
      }     
  ->  
}
}// end of rules
