/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInterfaceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEditInterfaceSection
extends AbstractSection {
    private Group inputsGroup;
    protected TableViewer inputsViewer;
    protected TableViewer outputsViewer;
    protected Table inputsTable;
    protected Table outputsTable;
    private final String NAME = "name";
    private final String TYPE = "type";
    private final String COMMENT = "comment";
    private Button inputUp;
    private Button inputDown;
    private Group outputsGroup;
    private Button outputUp;
    private Button outputDown;
    protected Button createInput;
    protected Button createOutput;
    protected Button deleteInput;
    protected Button deleteOutput;

    protected abstract CreateSubAppInterfaceElementCommand newCommand(boolean var1);

    protected abstract String[] fillTypeCombo();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputEdit(parent);
        this.createOutputEdit(parent);
    }

    private void createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText("name");
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText("type");
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText("comment");
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        table.setLayout((Layout)layout);
    }

    private void createInputEdit(Composite parent) {
        this.inputsGroup = this.getWidgetFactory().createGroup(parent, "Inputs");
        this.inputsGroup.setLayout((Layout)new GridLayout(2, false));
        this.inputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputsViewer = new TableViewer((Composite)this.inputsGroup, 65796);
        this.inputsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputsTable = this.inputsViewer.getTable();
        this.createTableLayout(this.inputsTable);
        this.inputsViewer.setColumnProperties(new String[]{"name", "type", "comment"});
        this.inputsViewer.setCellModifier((ICellModifier)new InterfaceCellModifier(this.inputsViewer));
        this.inputsViewer.setLabelProvider((IBaseLabelProvider)new InterfaceLabelProvider());
        Composite composite = new Composite((Composite)this.inputsGroup, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.createInput = this.getWidgetFactory().createButton(composite, "", 8);
        this.createInput.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.createInput.setToolTipText("Create interface element");
        this.createInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateSubAppInterfaceElementCommand cmd = AbstractEditInterfaceSection.this.newCommand(true);
                AbstractEditInterfaceSection.this.executeCommand((Command)cmd);
                AbstractEditInterfaceSection.this.inputsViewer.refresh();
            }
        });
        this.inputUp = this.getWidgetFactory().createButton(composite, "", 132);
        this.inputUp.setToolTipText("Move interface element up");
        this.inputUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.inputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new ChangeInterfaceOrderCommand((IInterfaceElement)selection, true, true));
                    AbstractEditInterfaceSection.this.inputsViewer.refresh();
                }
            }
        });
        this.inputDown = this.getWidgetFactory().createButton(composite, "", 1028);
        this.inputDown.setToolTipText("Move interface element down");
        this.inputDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.inputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new ChangeInterfaceOrderCommand((IInterfaceElement)selection, true, false));
                    AbstractEditInterfaceSection.this.inputsViewer.refresh();
                }
            }
        });
        this.deleteInput = this.getWidgetFactory().createButton(composite, "", 8);
        this.deleteInput.setToolTipText("Delete selected interface element");
        this.deleteInput.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.deleteInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.inputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new DeleteInterfaceCommand((IInterfaceElement)selection));
                    AbstractEditInterfaceSection.this.inputsViewer.refresh();
                }
            }
        });
    }

    protected void setCellEditors() {
        this.inputsViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.inputsTable), new ComboBoxCellEditor((Composite)this.inputsTable, this.fillTypeCombo(), 8), new TextCellEditor((Composite)this.inputsTable)});
        this.outputsViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.outputsTable), new ComboBoxCellEditor((Composite)this.outputsTable, this.fillTypeCombo(), 8), new TextCellEditor((Composite)this.outputsTable)});
    }

    private void createOutputEdit(Composite parent) {
        this.outputsGroup = this.getWidgetFactory().createGroup(parent, "Outputs");
        this.outputsGroup.setLayout((Layout)new GridLayout(2, false));
        this.outputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputsViewer = new TableViewer((Composite)this.outputsGroup, 65796);
        this.outputsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputsTable = this.outputsViewer.getTable();
        this.createTableLayout(this.outputsTable);
        this.outputsViewer.setColumnProperties(new String[]{"name", "type", "comment"});
        this.outputsViewer.setCellModifier((ICellModifier)new InterfaceCellModifier(this.outputsViewer));
        this.outputsViewer.setLabelProvider((IBaseLabelProvider)new InterfaceLabelProvider());
        Composite composite = new Composite((Composite)this.outputsGroup, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.createOutput = this.getWidgetFactory().createButton(composite, "", 8);
        this.createOutput.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.createOutput.setToolTipText("Create interface element");
        this.createOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateSubAppInterfaceElementCommand cmd = AbstractEditInterfaceSection.this.newCommand(false);
                AbstractEditInterfaceSection.this.executeCommand((Command)cmd);
                AbstractEditInterfaceSection.this.outputsViewer.refresh();
            }
        });
        this.outputUp = this.getWidgetFactory().createButton(composite, "", 132);
        this.outputUp.setToolTipText("Move interface element up");
        this.outputUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.outputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new ChangeInterfaceOrderCommand((IInterfaceElement)selection, false, true));
                    AbstractEditInterfaceSection.this.outputsViewer.refresh();
                }
            }
        });
        this.outputDown = this.getWidgetFactory().createButton(composite, "", 1028);
        this.outputDown.setToolTipText("Move interface element down");
        this.outputDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.outputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new ChangeInterfaceOrderCommand((IInterfaceElement)selection, false, false));
                    AbstractEditInterfaceSection.this.outputsViewer.refresh();
                }
            }
        });
        this.deleteOutput = this.getWidgetFactory().createButton(composite, "", 8);
        this.deleteOutput.setToolTipText("Delete selected interface element");
        this.deleteOutput.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.deleteOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((StructuredSelection)AbstractEditInterfaceSection.this.outputsViewer.getSelection()).getFirstElement();
                if (selection instanceof Event || selection instanceof VarDeclaration || selection instanceof AdapterDeclaration) {
                    AbstractEditInterfaceSection.this.executeCommand((Command)new DeleteInterfaceCommand((IInterfaceElement)selection));
                    AbstractEditInterfaceSection.this.outputsViewer.refresh();
                }
            }
        });
    }

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        if (part instanceof DiagramEditorWithFlyoutPalette) {
            return ((DiagramEditorWithFlyoutPalette)part).getCommandStack();
        }
        return null;
    }

    protected SubApp getInputType(Object input) {
        if (input instanceof SubAppForFBNetworkEditPart) {
            return ((SubAppForFBNetworkEditPart)((Object)input)).getModel();
        }
        if (input instanceof UISubAppNetworkEditPart) {
            return ((UISubAppNetworkEditPart)((Object)input)).getSubApp();
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.inputsViewer.setInput((Object)this.getType());
            this.outputsViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected SubApp getType() {
        return (SubApp)this.type;
    }

    protected static ArrayList<AdapterTypePaletteEntry> getAdapterTypes(Palette systemPalette) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        Palette pal = systemPalette;
        if (pal == null) {
            pal = TypeLibrary.getInstance().getPalette();
        }
        retVal.addAll(AbstractEditInterfaceSection.getAdapterGroup(pal.getRootGroup()));
        return retVal;
    }

    protected static ArrayList<AdapterTypePaletteEntry> getAdapterGroup(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteGroup paletteGroup : group.getSubGroups()) {
            retVal.addAll(AbstractEditInterfaceSection.getAdapterGroup(paletteGroup));
        }
        retVal.addAll(AbstractEditInterfaceSection.getAdapterGroupEntries(group));
        return retVal;
    }

    protected static ArrayList<AdapterTypePaletteEntry> getAdapterGroupEntries(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            if (!(entry instanceof AdapterTypePaletteEntry)) continue;
            retVal.add((AdapterTypePaletteEntry)entry);
        }
        return retVal;
    }

    private class InterfaceCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public InterfaceCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return !"type".equals(property) || !(element instanceof IInterfaceElement) || ((IInterfaceElement)element).getInputConnections().isEmpty() && ((IInterfaceElement)element).getOutputConnections().isEmpty();
        }

        public Object getValue(Object element, String property) {
            if ("name".equals(property)) {
                return ((INamedElement)element).getName();
            }
            if ("type".equals(property)) {
                String type = ((IInterfaceElement)element).getTypeName();
                String[] items = ((ComboBoxCellEditor)this.viewer.getCellEditors()[1]).getItems();
                int i = items.length - 1;
                while (i > 0 && !type.equals(items[i])) {
                    --i;
                }
                return i;
            }
            if ("comment".equals(property)) {
                return ((INamedElement)element).getComment() != null ? ((INamedElement)element).getComment() : "";
            }
            return null;
        }

        private DataType getTypeForSelection(String text) {
            for (AdapterTypePaletteEntry adaptertype : AbstractEditInterfaceSection.getAdapterTypes(AbstractEditInterfaceSection.this.getType().getFbNetwork().getApplication().getAutomationSystem().getPalette())) {
                if (!adaptertype.getAdapterType().getName().equals(text)) continue;
                return adaptertype.getAdapterType();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            ChangeNameCommand cmd = null;
            if ("name".equals(property)) {
                cmd = new ChangeNameCommand((INamedElement)((IInterfaceElement)data), value.toString());
            } else if ("comment".equals(property)) {
                cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
            } else if ("type".equals(property)) {
                String dataTypeName = ((ComboBoxCellEditor)this.viewer.getCellEditors()[1]).getItems()[(Integer)value];
                if (data instanceof AdapterDeclaration) {
                    DataType newType = this.getTypeForSelection(dataTypeName);
                    cmd = new ChangeTypeCommand((VarDeclaration)data, newType);
                } else if (data instanceof VarDeclaration) {
                    cmd = new ChangeTypeCommand((VarDeclaration)data, DataTypeLibrary.getInstance().getType(dataTypeName));
                }
            }
            if (cmd != null) {
                AbstractEditInterfaceSection.this.executeCommand((Command)cmd);
                this.viewer.refresh(data);
            }
        }
    }

    public class InterfaceContentProvider
    implements IStructuredContentProvider {
        private boolean inputs;
        private InterfaceContentProviderType type;

        public InterfaceContentProvider(boolean inputs, InterfaceContentProviderType type) {
            this.inputs = inputs;
            this.type = type;
        }

        private Object[] getInputs(Object inputElement) {
            switch (this.type) {
                case EVENT: {
                    return ((SubApp)inputElement).getInterface().getEventInputs().toArray();
                }
                case ADAPTER: {
                    return ((SubApp)inputElement).getInterface().getSockets().toArray();
                }
            }
            return ((SubApp)inputElement).getInterface().getInputVars().toArray();
        }

        private Object[] getOutputs(Object inputElement) {
            switch (this.type) {
                case EVENT: {
                    return ((SubApp)inputElement).getInterface().getEventOutputs().toArray();
                }
                case ADAPTER: {
                    return ((SubApp)inputElement).getInterface().getPlugs().toArray();
                }
            }
            return ((SubApp)inputElement).getInterface().getOutputVars().toArray();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SubApp) {
                if (this.inputs) {
                    return this.getInputs(inputElement);
                }
                return this.getOutputs(inputElement);
            }
            return new Object[0];
        }
    }

    protected static enum InterfaceContentProviderType {
        EVENT,
        DATA,
        ADAPTER;

    }

    public class InterfaceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IInterfaceElement) {
                switch (columnIndex) {
                    case 0: {
                        result = ((IInterfaceElement)element).getName();
                        break;
                    }
                    case 1: {
                        result = element instanceof Event ? "Event" : ((IInterfaceElement)element).getTypeName();
                        break;
                    }
                    case 2: {
                        result = ((IInterfaceElement)element).getComment() != null ? ((IInterfaceElement)element).getComment() : "";
                    }
                }
            } else {
                result = element.toString();
            }
            return result;
        }
    }
}

