/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InterfaceElementSection
extends org.eclipse.fordiac.ide.gef.properties.InterfaceElementSection {
    private TreeViewer connectionsTree;
    private Button newConnection;
    private Button delConnection;
    private Group group;
    private Combo fbCombo;
    private Combo interfaceCombo;
    private CLabel fbLabel;
    private CLabel interfaceElementLabel;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(3, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConnectionDisplaySection(parent);
        this.createConnectionSection(parent);
    }

    private void createConnectionSection(Composite parent) {
        Group group = this.getWidgetFactory().createGroup(parent, "Create Connection");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fbLabel = this.getWidgetFactory().createCLabel((Composite)group, "");
        this.fbCombo = new Combo((Composite)group, 12);
        this.fbCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InterfaceElementSection.this.fillInterfaceCombo(InterfaceElementSection.this.fbCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.interfaceElementLabel = this.getWidgetFactory().createCLabel((Composite)group, "");
        this.interfaceCombo = new Combo((Composite)group, 12);
        this.interfaceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newConnection = this.getWidgetFactory().createButton((Composite)group, "", 8);
        this.newConnection.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.delConnection.setLayoutData((Object)new GridData(16384, 1024, false, true));
        this.newConnection.setToolTipText("new Connection");
        this.newConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventConnectionCreateCommand cmd = null;
                if (InterfaceElementSection.this.getType() instanceof Event) {
                    cmd = new EventConnectionCreateCommand(InterfaceElementSection.this.getFBNetwork());
                } else if (InterfaceElementSection.this.getType() instanceof AdapterDeclaration) {
                    cmd = new AdapterConnectionCreateCommand(InterfaceElementSection.this.getFBNetwork());
                } else if (InterfaceElementSection.this.getType() instanceof VarDeclaration) {
                    cmd = new DataConnectionCreateCommand(InterfaceElementSection.this.getFBNetwork());
                }
                if (cmd != null) {
                    cmd.setDestination(InterfaceElementSection.this.getSelectedFB().getInterfaceElement(InterfaceElementSection.this.interfaceCombo.getText()));
                    cmd.setSource(InterfaceElementSection.this.getType());
                    InterfaceElementSection.this.executeCommand((Command)cmd);
                    InterfaceElementSection.this.connectionsTree.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private FBNetwork getFBNetwork() {
        if (this.getType().getFBNetworkElement() != null) {
            return this.getType().getFBNetworkElement().getFbNetwork();
        }
        if (this.getType().eContainer().eContainer() instanceof CompositeFBType) {
            return ((CompositeFBType)this.getType().eContainer().eContainer()).getFBNetwork();
        }
        return null;
    }

    private FBNetworkElement getSelectedFB() {
        if (this.getFBNetwork() != null) {
            return this.getFBNetwork().getFBNamed(this.fbCombo.getText());
        }
        return null;
    }

    private void fillFbCombo() {
        this.fbCombo.removeAll();
        if (this.getFBNetwork() != null) {
            this.getFBNetwork().getNetworkElements().forEach(element -> this.fbCombo.add(element.getName()));
        }
    }

    private void fillInterfaceCombo(String fbName) {
        this.interfaceCombo.removeAll();
        FBNetworkElement element = this.getSelectedFB();
        if (element.getName().equals(fbName)) {
            if (this.getType().isIsInput() && this.getType().getFBNetworkElement() != null) {
                if (this.getType() instanceof Event) {
                    element.getInterface().getEventOutputs().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
                if (this.getType() instanceof AdapterDeclaration) {
                    element.getInterface().getPlugs().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
                if (this.getType() instanceof VarDeclaration) {
                    element.getInterface().getOutputVars().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
            } else {
                if (this.getType() instanceof Event) {
                    element.getInterface().getEventInputs().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
                if (this.getType() instanceof AdapterDeclaration) {
                    element.getInterface().getSockets().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
                if (this.getType() instanceof VarDeclaration) {
                    element.getInterface().getInputVars().forEach(port -> this.interfaceCombo.add(port.getName()));
                    return;
                }
            }
        }
    }

    private void createConnectionDisplaySection(Composite parent) {
        this.group = this.getWidgetFactory().createGroup(parent, "Connections");
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionsTree = new TreeViewer((Composite)this.group, 772);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 100;
        gridData.widthHint = 80;
        this.connectionsTree.getTree().setLayoutData((Object)gridData);
        this.connectionsTree.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.connectionsTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        this.connectionsTree.setAutoExpandLevel(-1);
        new AdapterFactoryTreeEditor(this.connectionsTree.getTree(), (AdapterFactory)this.adapterFactory);
        this.delConnection = this.getWidgetFactory().createButton((Composite)this.group, "", 8);
        this.delConnection.setLayoutData((Object)new GridData(131072, 1024, false, true));
        this.delConnection.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.delConnection.setToolTipText("delete Connection");
        this.delConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((TreeSelection)InterfaceElementSection.this.connectionsTree.getSelection()).getFirstElement();
                if (selection instanceof Connection) {
                    InterfaceElementSection.this.executeCommand((Command)new DeleteConnectionCommand((Connection)selection));
                    InterfaceElementSection.this.connectionsTree.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            if (this.getType().isIsInput()) {
                this.group.setText("In-Connections");
                this.fbLabel.setText("Source FB:");
                this.interfaceElementLabel.setText("Source Interface:");
            } else {
                this.group.setText("Out-Connections");
                this.fbLabel.setText("Target FB:");
                this.interfaceElementLabel.setText("Target Interface:");
            }
            this.connectionsTree.setInput((Object)this.getType());
            this.fillFbCombo();
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputCode() {
        this.connectionsTree.setInput(null);
    }

    public class ConnectionContentProvider
    implements ITreeContentProvider {
        private IInterfaceElement element;

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IInterfaceElement) {
                this.element = (IInterfaceElement)inputElement;
                if (this.element.isIsInput() && this.element.getFBNetworkElement() != null || !this.element.isIsInput() && this.element.getFBNetworkElement() == null) {
                    return this.element.getInputConnections().toArray();
                }
                return this.element.getOutputConnections().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Connection) {
                Object[] objects = new Object[2];
                if (this.element.isIsInput()) {
                    objects[0] = ((Connection)parentElement).getSourceElement() != null ? ((Connection)parentElement).getSourceElement() : this.element;
                    objects[1] = ((Connection)parentElement).getSource();
                } else {
                    objects[0] = ((Connection)parentElement).getDestinationElement() != null ? ((Connection)parentElement).getDestinationElement() : this.element;
                    objects[1] = ((Connection)parentElement).getDestination();
                }
                return objects;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Connection) {
                return this.element;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Connection) {
                return ((Connection)element).getSource() != null && ((Connection)element).getDestination() != null;
            }
            return false;
        }
    }
}

