/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateFBInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateFBTypeException;
import org.eclipse.fordiac.ide.deployment.iec61499.DeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.iec61499.EthernetDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.export.forte_lua.ForteLuaExportFilter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.swt.widgets.Display;

public class DynamicTypeLoad_DeploymentExecutor
extends DeploymentExecutor {
    private static final String PROFILE_NAME = "DynamicTypeLoad";

    @Override
    public String getProfileName() {
        return PROFILE_NAME;
    }

    @Override
    public void createFBInstance(FBDeploymentData fbData, Resource res) throws CreateFBInstanceException {
        HashMap<String, AdapterType> adapters = this.getAdapterTypes(fbData.fb.getType().getInterfaceList());
        if (!adapters.isEmpty()) {
            this.queryAdapterTypes(adapters, res);
        }
        this.queryFBTypes(fbData.fb, res);
        super.createFBInstance(fbData, res);
    }

    private HashMap<String, AdapterType> getAdapterTypes(InterfaceList interfaceList) {
        HashMap<String, AdapterType> list = new HashMap<String, AdapterType>();
        interfaceList.getPlugs().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        interfaceList.getSockets().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        return list;
    }

    public void createFBType(FBType fbType, Resource res) throws CreateFBTypeException {
        if (this.devMgmCommHandler.getTypes() != null) {
            this.setAttribute(res.getDevice(), "FBType", this.devMgmCommHandler.getTypes());
        }
        if ((fbType instanceof BasicFBType || fbType instanceof CompositeFBType) && (this.devMgmCommHandler.getTypes() != null && !this.devMgmCommHandler.getTypes().contains(fbType.getName()) || this.devMgmCommHandler.getTypes() == null && !this.isAttribute(res.getDevice(), fbType.getName(), "FBType"))) {
            if (fbType instanceof CompositeFBType) {
                for (FBNetworkElement netelem : ((CompositeFBType)fbType).getFBNetwork().getNetworkElements()) {
                    if (this.devMgmCommHandler.getTypes().contains(netelem.getTypeName())) continue;
                    HashMap<String, AdapterType> adapters = this.getAdapterTypes(netelem.getInterface());
                    if (!adapters.isEmpty()) {
                        this.loopAdapterTypes(adapters, res);
                    }
                    this.createFBType((FBType)netelem.getType(), res);
                }
            }
            ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
            String luaSkript = luaFilter.createLUA((LibraryElement)fbType);
            String request = MessageFormat.format(Messages.DTL_CreateFBType, this.id++, fbType.getName(), luaSkript);
            try {
                if (this.devMgmCommHandler instanceof EthernetDeviceManagementCommunicationHandler) {
                    String result = ((EthernetDeviceManagementCommunicationHandler)this.devMgmCommHandler).sendREQandRESP("", request);
                    if (result.contains("Reason")) {
                        throw new CreateFBTypeException("LUA skript for " + fbType.getName() + " FBType not executed");
                    }
                    this.devMgmCommHandler.getTypes().add(fbType.getName());
                } else {
                    this.sendREQ(res.getName(), request);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isAttribute(Device device, String fbTypeName, String attributeType) {
        if (device.getAttribute(attributeType) != null) {
            String[] stringArray = device.getAttributeValue(attributeType).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (fbTypeName.equals(s.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void setAttribute(final Device device, final String string, final HashSet<String> hashSet) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                device.setAttribute(string, "STRING", String.join((CharSequence)", ", hashSet), "created during deployment");
            }
        });
    }

    public void createAdapterType(String adapterKey, HashMap<String, AdapterType> adapters, Resource res) throws CreateFBTypeException {
        if (this.devMgmCommHandler.getAdapterTypes() != null) {
            this.setAttribute(res.getDevice(), "AdapterType", this.devMgmCommHandler.getAdapterTypes());
        }
        if (this.devMgmCommHandler.getAdapterTypes() != null && !this.devMgmCommHandler.getAdapterTypes().contains(adapterKey) || this.devMgmCommHandler.getAdapterTypes() == null && !this.isAttribute(res.getDevice(), adapterKey, "AdapterType")) {
            ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
            String luaSkript = luaFilter.createLUA((LibraryElement)adapters.get(adapterKey));
            String request = MessageFormat.format(Messages.DTL_CreateAdapterType, this.id++, adapterKey, luaSkript);
            try {
                if (this.devMgmCommHandler instanceof EthernetDeviceManagementCommunicationHandler) {
                    String result = ((EthernetDeviceManagementCommunicationHandler)this.devMgmCommHandler).sendREQandRESP("", request);
                    if (result.contains("Reason")) {
                        throw new CreateFBTypeException("LUA skript for " + adapterKey + " AdapterType not executed");
                    }
                    this.devMgmCommHandler.getAdapterTypes().add(adapterKey);
                } else {
                    this.sendREQ(res.getName(), request);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void queryFBTypes(FB fb, Resource res) {
        if (this.devMgmCommHandler != null && this.devMgmCommHandler.getTypes() == null) {
            String request = MessageFormat.format(Messages.DTL_QueryFBTypes, this.id++);
            try {
                this.sendQUERY(res.getName(), request);
            }
            catch (IOException iOException) {
                System.out.println(MessageFormat.format(Messages.DTL_QueryFailed, "FB Types"));
            }
        }
        FBType fbType = fb.getType();
        try {
            this.createFBType(fbType, res);
        }
        catch (CreateFBTypeException createFBTypeException) {
            System.out.println(MessageFormat.format(Messages.DTL_CreateTypeFailed, fbType.getName()));
        }
    }

    private void queryAdapterTypes(HashMap<String, AdapterType> adapters, Resource res) {
        if (this.devMgmCommHandler != null && this.devMgmCommHandler.getAdapterTypes() == null) {
            String request = MessageFormat.format(Messages.DTL_QueryAdapterTypes, this.id++);
            try {
                this.sendQUERY(res.getName(), request);
            }
            catch (IOException iOException) {
                System.out.println(MessageFormat.format(Messages.DTL_QueryFailed, "Adapter Types"));
            }
        }
        this.loopAdapterTypes(adapters, res);
    }

    private void loopAdapterTypes(HashMap<String, AdapterType> adapters, Resource res) {
        adapters.keySet().forEach(e -> {
            try {
                this.createAdapterType((String)e, adapters, res);
            }
            catch (CreateFBTypeException createFBTypeException) {
                System.out.println(MessageFormat.format(Messages.DTL_CreateTypeFailed, e));
            }
        });
    }
}

