/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.commands.Command;

public class WithCreateCommand
extends Command {
    private Event event;
    private VarDeclaration varDeclaration;
    private boolean forwardCreation;
    private With with;

    public WithCreateCommand() {
    }

    public WithCreateCommand(Event event, VarDeclaration varDeclaration, boolean forwardCreation) {
        this.event = event;
        this.varDeclaration = varDeclaration;
        this.forwardCreation = forwardCreation;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public VarDeclaration getVarDeclaration() {
        return this.varDeclaration;
    }

    public void setVarDeclaration(VarDeclaration varDeclaration) {
        this.varDeclaration = varDeclaration;
    }

    public boolean canExecute() {
        if (this.event == null || this.varDeclaration == null) {
            return false;
        }
        if (this.varDeclaration.getType() instanceof AdapterType) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)Messages.AdapterConnectionNotAllowed);
            return false;
        }
        for (With with : this.varDeclaration.getWiths()) {
            if (!with.eContainer().equals(this.event)) continue;
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)Messages.WithExists);
            return false;
        }
        if (this.varDeclaration.isIsInput() && this.event.isIsInput() || !this.varDeclaration.isIsInput() && !this.event.isIsInput()) {
            Abstract4DIACUIPlugin.statusLineErrorMessage(null);
            return true;
        }
        return false;
    }

    public void execute() {
        this.with = LibraryElementFactory.eINSTANCE.createWith();
        this.event.getWith().add((Object)this.with);
        this.with.setVariables(this.varDeclaration);
    }

    public void undo() {
        this.with.setVariables(null);
        this.event.getWith().remove((Object)this.with);
    }

    public void redo() {
        this.event.getWith().add((Object)this.with);
        this.with.setVariables(this.varDeclaration);
    }

    public boolean isForwardCreation() {
        return this.forwardCreation;
    }

    public void setForwardCreation(boolean forwardCreation) {
        this.forwardCreation = forwardCreation;
    }
}

