/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.gef.commands.Command;

public class ChangeInterfaceOrderCommand
extends Command {
    private boolean isInput;
    private IInterfaceElement selection;
    private EList<? extends IInterfaceElement> interfaces;
    private int oldIndex;
    private int newIndex;

    private ChangeInterfaceOrderCommand(IInterfaceElement selection, boolean isInput) {
        this.isInput = isInput;
        this.selection = selection;
        if (selection != null && selection.eContainer() instanceof InterfaceList) {
            this.setInterfaces((InterfaceList)selection.eContainer());
            this.oldIndex = this.interfaces.indexOf((Object)selection);
        }
    }

    public ChangeInterfaceOrderCommand(IInterfaceElement selection, boolean isInput, boolean moveUp) {
        this(selection, isInput);
        this.newIndex = this.oldIndex > 0 && moveUp ? this.oldIndex - 1 : this.oldIndex + 1;
    }

    public ChangeInterfaceOrderCommand(IInterfaceElement selection, boolean isInput, int newIndex) {
        this(selection, isInput);
        this.newIndex = newIndex;
    }

    private void setInterfaces(InterfaceList interfaceList) {
        this.interfaces = this.isInput ? (this.selection instanceof Event ? interfaceList.getEventInputs() : (this.selection instanceof AdapterDeclaration ? interfaceList.getSockets() : interfaceList.getInputVars())) : (this.selection instanceof Event ? interfaceList.getEventOutputs() : (this.selection instanceof AdapterDeclaration ? interfaceList.getPlugs() : interfaceList.getOutputVars()));
    }

    public boolean canExecute() {
        return this.selection != null && this.interfaces.size() > 1 && this.interfaces.size() >= this.newIndex;
    }

    public void execute() {
        if (this.newIndex > this.interfaces.indexOf((Object)this.selection)) {
            --this.newIndex;
        }
        this.redo();
    }

    public void redo() {
        EList<? extends IInterfaceElement> temp = this.interfaces;
        temp.move(this.newIndex, (Object)this.selection);
    }

    public void undo() {
        EList<? extends IInterfaceElement> temp = this.interfaces;
        temp.move(this.oldIndex, (Object)this.selection);
    }
}

