/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FordiacResourceChangeListener
implements IResourceChangeListener {
    private static final String XML_FILE_EXTENSION = "xml";
    private SystemManager systemManager;
    private Set<String> systemImportWatingList = Collections.synchronizedSet(new HashSet());

    public FordiacResourceChangeListener(SystemManager systemManager) {
        this.systemManager = systemManager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    block0 : switch (delta.getKind()) {
                        case 4: {
                            if (16384 != delta.getFlags()) break;
                            if (delta.getAffectedChildren(1).length != 0) {
                                FordiacResourceChangeListener.this.loadSystem(delta.getResource().getProject());
                            } else if (delta.getAffectedChildren(2).length != 0) {
                                FordiacResourceChangeListener.this.handleProjectRemove(delta);
                                return false;
                            }
                            return false;
                        }
                        case 2: {
                            if (delta.getFlags() == 8192) {
                                return false;
                            }
                            switch (delta.getResource().getType()) {
                                case 1: {
                                    FordiacResourceChangeListener.this.handleFileDelete(delta);
                                    break block0;
                                }
                                case 2: {
                                    FordiacResourceChangeListener.this.handleFolderDelete(delta);
                                    return false;
                                }
                                case 4: {
                                    FordiacResourceChangeListener.this.handleProjectRemove(delta);
                                    return false;
                                }
                            }
                            break;
                        }
                        case 1: {
                            if (4096 == (delta.getFlags() & 0x1000)) {
                                switch (delta.getResource().getType()) {
                                    case 1: {
                                        FordiacResourceChangeListener.this.handleFileMove(delta);
                                        break;
                                    }
                                    case 2: {
                                        FordiacResourceChangeListener.this.handleFolderMove(delta);
                                        return true;
                                    }
                                    case 4: {
                                        FordiacResourceChangeListener.this.handleProjectRename(delta);
                                        return true;
                                    }
                                }
                                return false;
                            }
                            String projectName = delta.getResource().getProject().getName();
                            AutomationSystem system = FordiacResourceChangeListener.this.systemManager.getSystemForName(projectName);
                            if (system == null && !"Tool Library".equals(projectName)) {
                                FordiacResourceChangeListener.this.loadSystem(delta.getResource().getProject());
                            }
                            if (system != null || projectName.equals("Tool Library")) {
                                switch (delta.getResource().getType()) {
                                    case 1: {
                                        FordiacResourceChangeListener.this.handleFileCopy(delta);
                                        break;
                                    }
                                    case 2: {
                                        FordiacResourceChangeListener.this.handleFolderCopy(delta);
                                        return true;
                                    }
                                }
                                return false;
                            }
                            if (1 != delta.getResource().getType()) break;
                            FordiacResourceChangeListener.this.handledCopiedProjectFiles(delta);
                        }
                    }
                    return true;
                }
            };
            try {
                rootDelta.accept(visitor);
            }
            catch (CoreException coreException) {}
        }
    }

    protected void handleFolderDelete(IResourceDelta delta) {
        IFolder folder;
        Palette palette = this.systemManager.getPalette(delta.getResource().getProject());
        PaletteGroup group = TypeLibrary.getPaletteGroup((Palette)palette, (IContainer)(folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(delta.getResource().getFullPath())));
        if (group != null) {
            FordiacResourceChangeListener.removeGroup(group);
        }
    }

    private static void removeGroup(PaletteGroup group) {
        ArrayList subGroups = new ArrayList(group.getSubGroups());
        for (PaletteGroup runner : subGroups) {
            FordiacResourceChangeListener.removeGroup(runner);
        }
        ArrayList containedEntries = new ArrayList(group.getEntries());
        for (PaletteEntry entry : containedEntries) {
            group.getEntries().remove((Object)entry);
        }
        if (group.getParentGroup() != null && group.getParentGroup().getSubGroups() != null) {
            group.getParentGroup().getSubGroups().remove((Object)group);
        }
    }

    protected void handleFileDelete(IResourceDelta delta) {
        PaletteEntry entry;
        IFile file;
        Palette palette = this.systemManager.getPalette(delta.getResource().getProject());
        PaletteGroup group = TypeLibrary.getPaletteGroup((Palette)palette, (IContainer)(file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath())).getParent());
        if (group != null && (entry = group.getEntry(TypeLibrary.getTypeNameFromFile((IFile)file))) != null) {
            FordiacResourceChangeListener.closeAllFBTypeEditor(entry);
            group.getEntries().remove((Object)entry);
        }
    }

    protected void handleFolderCopy(IResourceDelta delta) {
        IFolder file;
        Palette dstPalette = this.systemManager.getPalette(delta.getResource().getProject());
        PaletteGroup parent = TypeLibrary.getPaletteGroupWithAdd((Palette)dstPalette, (IContainer)(file = ResourcesPlugin.getWorkspace().getRoot().getFolder(delta.getResource().getFullPath())).getParent());
        if (parent != null && parent.getGroup(file.getName()) == null) {
            dstPalette.createGroup(parent, file.getName());
        }
    }

    protected void handleFileCopy(IResourceDelta delta) {
        PaletteEntry entry;
        Palette dstPalette = this.systemManager.getPalette(delta.getResource().getProject());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        PaletteGroup dstGroup = TypeLibrary.getPaletteGroupWithAdd((Palette)dstPalette, (IContainer)delta.getResource().getParent());
        if (dstGroup != null && dstGroup.getEntry(TypeLibrary.getTypeNameFromFile((IFile)file)) == null && (entry = TypeLibrary.createPaleteEntry((Palette)dstPalette, (PaletteGroup)dstGroup, (IFile)file)) != null) {
            FordiacResourceChangeListener.updatePaletteEntry(file, entry);
        }
    }

    protected void handledCopiedProjectFiles(IResourceDelta delta) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        if (file != null && file.getFileExtension() != null && XML_FILE_EXTENSION.equalsIgnoreCase(file.getFileExtension())) {
            this.handleSystemFileCopy(file);
        }
    }

    protected void handleSystemFileCopy(final IFile file) {
        try {
            Scanner scanner = new Scanner(file.getContents());
            if (scanner.findWithinHorizon("<libraryElement:AutomationSystem", 0) != null) {
                final IProject project = file.getProject();
                if (!file.getName().equals(String.valueOf(file.getProject().getName()) + ".xml")) {
                    WorkspaceJob job = new WorkspaceJob("Renaming system file"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            IPath path = file.getProjectRelativePath();
                            path = path.removeLastSegments(1);
                            path = path.append(String.valueOf(project.getName()) + ".sys");
                            try {
                                file.move(path, true, null);
                                FordiacResourceChangeListener.this.systemManager.loadProject(project);
                            }
                            catch (Exception e) {
                                Activator.getDefault().logError(e.getMessage(), e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)project);
                    job.schedule();
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void handleFolderMove(IResourceDelta delta) {
        IFolder src = ResourcesPlugin.getWorkspace().getRoot().getFolder(delta.getMovedFromPath());
        Palette srcPalette = this.systemManager.getPalette(src.getProject());
        if (src.getParent().equals((Object)delta.getResource().getParent())) {
            PaletteGroup group = TypeLibrary.getPaletteGroup((Palette)srcPalette, (IContainer)src);
            if (group != null) {
                group.setLabel(delta.getResource().getName());
            }
        } else {
            Palette dstPalette = this.systemManager.getPalette(delta.getResource().getProject());
            FordiacResourceChangeListener.movePaletteGroup((IContainer)src, delta.getResource().getParent(), srcPalette, dstPalette);
        }
    }

    private static void movePaletteGroup(IContainer srcGroupFolder, IContainer dstGroupFolder, Palette srcPalette, Palette dstPalette) {
        PaletteGroup dstGroup = TypeLibrary.getPaletteGroup((Palette)dstPalette, (IContainer)dstGroupFolder);
        PaletteGroup srcGroup = TypeLibrary.getPaletteGroupWithAdd((Palette)srcPalette, (IContainer)srcGroupFolder);
        if (dstGroup != null && srcGroup != null) {
            srcGroup.getParentGroup().getSubGroups().remove((Object)srcGroup);
            dstGroup.getSubGroups().add((Object)srcGroup);
        }
    }

    private void handleFileMove(IResourceDelta delta) {
        IFile src = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
        Palette srcPalette = this.systemManager.getPalette(src.getProject());
        if (src.getParent().equals((Object)delta.getResource().getParent())) {
            this.handleFileRename(delta, src);
        } else {
            this.handleFileMovement(delta, (IResource)src, srcPalette);
        }
        final AutomationSystem system = this.systemManager.getSystemForName(src.getProject().getName());
        if (system != null) {
            WorkspaceJob job = new WorkspaceJob("Save system: " + system.getName() + " after type movement"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    SystemManager.INSTANCE.saveSystem(system);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)src.getProject());
            job.schedule();
        }
    }

    private void handleFileMovement(IResourceDelta delta, IResource src, Palette srcPalette) {
        Palette dstPalette = this.systemManager.getPalette(delta.getResource().getProject());
        PaletteGroup dstGroup = null;
        PaletteGroup srcGroup = null;
        srcGroup = TypeLibrary.getPaletteGroup((Palette)srcPalette, (IContainer)src.getParent());
        dstGroup = TypeLibrary.getPaletteGroupWithAdd((Palette)dstPalette, (IContainer)delta.getResource().getParent());
        PaletteEntry entry = null;
        if (srcGroup != null && dstGroup != null) {
            entry = srcGroup.getEntry(TypeLibrary.getTypeNameFromFileName((String)src.getName()));
            if (entry != null) {
                srcGroup.getEntries().remove((Object)entry);
                dstGroup.addEntry(entry);
            }
        } else if (srcGroup == null) {
            entry = dstGroup.getEntry(TypeLibrary.getTypeNameFromFileName((String)delta.getResource().getName()));
        }
        if (entry != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
            entry.setFile(file);
        }
    }

    private void handleFileRename(IResourceDelta delta, IFile src) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        Palette dstPalette = this.systemManager.getPalette(file.getProject());
        PaletteEntry entry = TypeLibrary.getPaletteEntry((Palette)dstPalette, (IFile)src);
        FordiacResourceChangeListener.updatePaletteEntry(file, entry);
    }

    private static void updatePaletteEntry(IFile newFile, final PaletteEntry entry) {
        if (entry != null) {
            final String newTypeName = TypeLibrary.getTypeNameFromFile((IFile)newFile);
            entry.setLabel(newTypeName);
            entry.setFile(newFile);
            WorkspaceJob job = new WorkspaceJob("Save Renamed type: " + entry.getLabel()){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    LibraryElement type = entry.getType();
                    if (type != null && !newTypeName.equals(type.getName())) {
                        type.setName(newTypeName);
                        CommonElementExporter.saveType((PaletteEntry)entry);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)newFile.getProject());
            job.schedule();
        }
    }

    private void loadSystem(final IProject project) {
        final String projectName = project.getName();
        if (!this.systemImportWatingList.contains(projectName)) {
            this.systemImportWatingList.add(projectName);
            WorkspaceJob job = new WorkspaceJob("Load system: " + projectName){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    AutomationSystem system = FordiacResourceChangeListener.this.systemManager.loadProject(project);
                    if (system != null && !system.getName().equals(projectName)) {
                        FordiacResourceChangeListener.this.renameSystem(system, project);
                    }
                    FordiacResourceChangeListener.this.systemManager.notifyListeners();
                    FordiacResourceChangeListener.this.systemImportWatingList.remove(projectName);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)project);
            job.schedule();
        }
    }

    private void handleProjectRename(IResourceDelta delta) {
        IPath srcPath = delta.getMovedFromPath();
        if (srcPath != null) {
            IProject src = ResourcesPlugin.getWorkspace().getRoot().getProject(srcPath.lastSegment());
            AutomationSystem system = this.systemManager.getSystemForName(src.getName());
            IProject project = delta.getResource().getProject();
            if (system != null) {
                this.renameSystem(system, project);
            }
        }
    }

    protected void renameSystem(final AutomationSystem system, IProject project) {
        final IFile oldSystemFile = project.getFile(String.valueOf(system.getName()) + ".sys");
        String newProjectName = project.getName();
        system.setName(newProjectName);
        system.setProject(project);
        WorkspaceJob job = new WorkspaceJob("Save system configuration: " + newProjectName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    oldSystemFile.delete(true, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
                SystemManager.INSTANCE.saveSystem(system);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    protected void handleProjectRemove(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        AutomationSystem system = this.systemManager.getSystemForName(project.getName());
        if (system != null) {
            FordiacResourceChangeListener.closeAllEditors(system);
            this.systemManager.removeSystem(system);
        }
    }

    private static void closeAllEditors(final AutomationSystem refSystem) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorUtils.closeEditorsFiltered(editor -> editor instanceof ISystemEditor && refSystem.equals(((ISystemEditor)editor).getSystem()));
            }
        });
    }

    private static void closeAllFBTypeEditor(final PaletteEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IFile file = entry.getFile();
                EditorUtils.closeEditorsFiltered(editor -> {
                    IEditorInput input = editor.getEditorInput();
                    return input instanceof FileEditorInput && file.equals((Object)((FileEditorInput)input).getFile());
                });
            }
        });
    }
}

