/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LREAL;

public class IEC_REAL
extends IEC_ANY {
    protected float value;

    public IEC_REAL() {
        this.value = 0.0f;
    }

    public IEC_REAL(float initial) {
        this.value = initial;
    }

    public IEC_REAL(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readFloat();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{74};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeFloat(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public boolean equals(Object data) {
        if (data instanceof IEC_REAL) {
            return ((IEC_REAL)data).value == this.value;
        }
        if (data instanceof IEC_LREAL) {
            return ((IEC_LREAL)data).value == (double)this.value;
        }
        return false;
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_REAL)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.value = Float.parseFloat(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

