/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.IndentAction;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CodeFormatFix
implements ICleanUpFix {
    private final CompilationUnitChange fChange;

    public static ICleanUpFix createCleanUp(ICompilationUnit cu, IRegion[] regions, boolean format, boolean removeTrailingWhitespacesAll, boolean removeTrailingWhitespacesIgnorEmpty, boolean correctIndentation) throws CoreException {
        TextEdit resultEdit;
        if (!(format || removeTrailingWhitespacesAll || removeTrailingWhitespacesIgnorEmpty || correctIndentation)) {
            return null;
        }
        ArrayList<CategorizedTextEditGroup> groups = new ArrayList<CategorizedTextEditGroup>();
        MultiTextEdit formatEdit = new MultiTextEdit();
        if (format) {
            TextEdit edit;
            HashMap formatterSettings = new HashMap(cu.getJavaProject().getOptions(true));
            String content = cu.getBuffer().getContents();
            Document document = new Document(content);
            String lineDelemiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            int kind = (JavaModelUtil.isModuleInfo((ICompilationUnit)cu) ? 128 : 8) | 0x1000;
            if (regions == null) {
                edit = CodeFormatterUtil.reformat((int)kind, (String)content, (int)0, (String)lineDelemiter, formatterSettings);
            } else {
                if (regions.length == 0) {
                    return null;
                }
                edit = CodeFormatterUtil.reformat((int)kind, (String)content, (IRegion[])regions, (int)0, (String)lineDelemiter, formatterSettings);
            }
            if (edit != null && (!(edit instanceof MultiTextEdit) || edit.hasChildren())) {
                formatEdit.addChild(edit);
                if (!TextEditUtil.isPacked((TextEdit)formatEdit)) {
                    formatEdit = TextEditUtil.flatten((TextEdit)formatEdit);
                }
                String label = MultiFixMessages.CodeFormatFix_description;
                CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
                group.addTextEdit(edit);
                groups.add(group);
            }
        }
        MultiTextEdit otherEdit = new MultiTextEdit();
        if (removeTrailingWhitespacesAll || removeTrailingWhitespacesIgnorEmpty || correctIndentation) {
            try {
                Document document = new Document(cu.getBuffer().getContents());
                if (removeTrailingWhitespacesAll || removeTrailingWhitespacesIgnorEmpty) {
                    String label = MultiFixMessages.CodeFormatFix_RemoveTrailingWhitespace_changeDescription;
                    CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
                    int lineCount = document.getNumberOfLines();
                    int i = 0;
                    while (i < lineCount) {
                        IRegion region = document.getLineInformation(i);
                        if (region.getLength() != 0) {
                            DeleteEdit edit;
                            int lineStart = region.getOffset();
                            int lineExclusiveEnd = lineStart + region.getLength();
                            int j = CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(lineStart, lineExclusiveEnd - 1, (IDocument)document);
                            if (removeTrailingWhitespacesAll) {
                                if (++j < lineExclusiveEnd && !TextEditUtil.overlaps((TextEdit)formatEdit, (TextEdit)(edit = new DeleteEdit(j, lineExclusiveEnd - j)))) {
                                    otherEdit.addChild((TextEdit)edit);
                                    group.addTextEdit((TextEdit)edit);
                                }
                            } else if (removeTrailingWhitespacesIgnorEmpty && j >= lineStart) {
                                if (document.getChar(j) == '*' && CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(lineStart, j - 1, (IDocument)document) < lineStart) {
                                    ++j;
                                }
                                if (++j < lineExclusiveEnd && !TextEditUtil.overlaps((TextEdit)formatEdit, (TextEdit)(edit = new DeleteEdit(j, lineExclusiveEnd - j)))) {
                                    otherEdit.addChild((TextEdit)edit);
                                    group.addTextEdit((TextEdit)edit);
                                }
                            }
                        }
                        ++i;
                    }
                    if (otherEdit.hasChildren()) {
                        groups.add(group);
                    }
                }
                if (correctIndentation && (!format || regions != null)) {
                    JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
                    TextEdit edit = IndentAction.indent((IDocument)document, cu.getJavaProject());
                    if (edit != null) {
                        String label = MultiFixMessages.CodeFormatFix_correctIndentation_changeGroupLabel;
                        CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
                        if (edit instanceof MultiTextEdit) {
                            TextEdit[] children = ((MultiTextEdit)edit).getChildren();
                            int i = 0;
                            while (i < children.length) {
                                TextEdit child = children[i];
                                edit.removeChild(child);
                                if (!TextEditUtil.overlaps((TextEdit)formatEdit, (TextEdit)child) && !TextEditUtil.overlaps((TextEdit)otherEdit, (TextEdit)child)) {
                                    otherEdit.addChild(child);
                                    group.addTextEdit(child);
                                }
                                ++i;
                            }
                        } else if (!TextEditUtil.overlaps((TextEdit)formatEdit, (TextEdit)edit) && !TextEditUtil.overlaps((TextEdit)otherEdit, (TextEdit)edit)) {
                            otherEdit.addChild(edit);
                            group.addTextEdit(edit);
                        }
                        groups.add(group);
                    }
                }
            }
            catch (BadLocationException x) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)x));
            }
        }
        if (!(resultEdit = TextEditUtil.merge((TextEdit)formatEdit, (TextEdit)otherEdit)).hasChildren()) {
            return null;
        }
        CompilationUnitChange change = new CompilationUnitChange("", cu);
        change.setEdit(resultEdit);
        int i = 0;
        int size = groups.size();
        while (i < size) {
            TextEditGroup group = (TextEditGroup)groups.get(i);
            change.addTextEditGroup(group);
            ++i;
        }
        return new CodeFormatFix(change);
    }

    private static int getIndexOfRightMostNoneWhitspaceCharacter(int start, int end, IDocument document) throws BadLocationException {
        int position = end;
        while (position >= start && Character.isWhitespace(document.getChar(position))) {
            --position;
        }
        return position;
    }

    public CodeFormatFix(CompilationUnitChange change) {
        this.fChange = change;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return this.fChange;
    }
}

