/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.util.List;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.elk.FordiacLayoutMapping;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.gef.GraphicalEditPart;

public class FordiacGraphDataHelper {
    public static void calculate(FordiacLayoutMapping mapping) {
        mapping.getLayoutGraph().getChildren().forEach(child -> {
            GraphicalEditPart ep = (GraphicalEditPart)mapping.getGraphMap().get(child);
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            pos.setX((double)((int)child.getX()));
            pos.setY((double)((int)child.getY()));
            mapping.getLayoutData().addPosition((FBNetworkElement)ep.getModel(), pos);
        });
        mapping.getLayoutGraph().getContainedEdges().forEach(edge -> FordiacGraphDataHelper.processConnection(mapping, edge));
    }

    private static void processConnection(FordiacLayoutMapping mapping, ElkEdge edge) {
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty() || edge.getSections().isEmpty()) {
            return;
        }
        ConnectionEditPart connEp = (ConnectionEditPart)mapping.getGraphMap().get((Object)edge);
        ElkPort startPort = (ElkPort)edge.getSources().get(0);
        ElkPort endPort = (ElkPort)edge.getTargets().get(0);
        ElkEdgeSection elkEdgeSection = (ElkEdgeSection)edge.getSections().get(0);
        EList bendPoints = elkEdgeSection.getBendPoints();
        mapping.getLayoutData().addConnectionPoints(connEp.getModel(), FordiacGraphDataHelper.createPointList(mapping, startPort, endPort, (List<ElkBendPoint>)bendPoints));
    }

    private static PointList createPointList(FordiacLayoutMapping mapping, ElkPort startPort, ElkPort endPort, List<ElkBendPoint> bendPoints) {
        PointList list = new PointList();
        ElkNode layoutGraph = mapping.getLayoutGraph();
        ElkNode startNode = startPort.getParent();
        if (startNode == layoutGraph) {
            startNode = ElkGraphFactory.eINSTANCE.createElkNode();
        }
        int startX = (int)(startPort.getX() + startNode.getX() + layoutGraph.getX());
        int startY = (int)(startPort.getY() + startNode.getY() + layoutGraph.getY());
        list.addPoint(startX, startY);
        for (ElkBendPoint point : bendPoints) {
            list.addPoint((int)(point.getX() + layoutGraph.getX()), (int)(point.getY() + layoutGraph.getY()));
        }
        ElkNode endNode = endPort.getParent();
        int endX = (int)(endPort.getX() + endNode.getX() + layoutGraph.getX());
        int endY = (int)(endPort.getY() + endNode.getY() + layoutGraph.getY());
        list.addPoint(endX, endY);
        return list;
    }

    private FordiacGraphDataHelper() {
    }
}

