/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.libavoid.options;

import org.eclipse.elk.alg.libavoid.LibavoidLayoutProvider;
import org.eclipse.elk.alg.libavoid.options.LibavoidMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class LibavoidOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.alg.libavoid";
    private static final boolean DEBUG_MODE_DEFAULT = false;
    public static final IProperty<Boolean> DEBUG_MODE = new Property(CoreOptions.DEBUG_MODE, (Object)false);
    public static final IProperty<PortSide> PORT_SIDE = CoreOptions.PORT_SIDE;
    public static final IProperty<Direction> DIRECTION = CoreOptions.DIRECTION;
    private static final EdgeRouting EDGE_ROUTING_DEFAULT = EdgeRouting.ORTHOGONAL;
    public static final IProperty<EdgeRouting> EDGE_ROUTING = new Property(CoreOptions.EDGE_ROUTING, (Object)EDGE_ROUTING_DEFAULT);
    private static final PortConstraints PORT_CONSTRAINTS_DEFAULT = PortConstraints.FREE;
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = new Property(CoreOptions.PORT_CONSTRAINTS, (Object)PORT_CONSTRAINTS_DEFAULT);
    public static final IProperty<Boolean> OMIT_NODE_MICRO_LAYOUT = CoreOptions.OMIT_NODE_MICRO_LAYOUT;
    public static final IProperty<Double> SEGMENT_PENALTY = LibavoidMetaDataProvider.SEGMENT_PENALTY;
    public static final IProperty<Double> ANGLE_PENALTY = LibavoidMetaDataProvider.ANGLE_PENALTY;
    public static final IProperty<Double> CROSSING_PENALTY = LibavoidMetaDataProvider.CROSSING_PENALTY;
    public static final IProperty<Double> CLUSTER_CROSSING_PENALTY = LibavoidMetaDataProvider.CLUSTER_CROSSING_PENALTY;
    public static final IProperty<Double> FIXED_SHARED_PATH_PENALTY = LibavoidMetaDataProvider.FIXED_SHARED_PATH_PENALTY;
    public static final IProperty<Double> PORT_DIRECTION_PENALTY = LibavoidMetaDataProvider.PORT_DIRECTION_PENALTY;
    public static final IProperty<Double> SHAPE_BUFFER_DISTANCE = LibavoidMetaDataProvider.SHAPE_BUFFER_DISTANCE;
    public static final IProperty<Double> IDEAL_NUDGING_DISTANCE = LibavoidMetaDataProvider.IDEAL_NUDGING_DISTANCE;
    public static final IProperty<Double> REVERSE_DIRECTION_PENALTY = LibavoidMetaDataProvider.REVERSE_DIRECTION_PENALTY;
    public static final IProperty<Boolean> NUDGE_ORTHOGONAL_SEGMENTS_CONNECTED_TO_SHAPES = LibavoidMetaDataProvider.NUDGE_ORTHOGONAL_SEGMENTS_CONNECTED_TO_SHAPES;
    public static final IProperty<Boolean> IMPROVE_HYPEREDGE_ROUTES_MOVING_JUNCTIONS = LibavoidMetaDataProvider.IMPROVE_HYPEREDGE_ROUTES_MOVING_JUNCTIONS;
    public static final IProperty<Boolean> PENALISE_ORTHOGONAL_SHARED_PATHS_AT_CONN_ENDS = LibavoidMetaDataProvider.PENALISE_ORTHOGONAL_SHARED_PATHS_AT_CONN_ENDS;
    public static final IProperty<Boolean> NUDGE_ORTHOGONAL_TOUCHING_COLINEAR_SEGMENTS = LibavoidMetaDataProvider.NUDGE_ORTHOGONAL_TOUCHING_COLINEAR_SEGMENTS;
    public static final IProperty<Boolean> PERFORM_UNIFYING_NUDGING_PREPROCESSING_STEP = LibavoidMetaDataProvider.PERFORM_UNIFYING_NUDGING_PREPROCESSING_STEP;
    public static final IProperty<Boolean> IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS = LibavoidMetaDataProvider.IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS;
    public static final IProperty<Boolean> NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT = LibavoidMetaDataProvider.NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT;
    public static final IProperty<Boolean> ENABLE_HYPEREDGES_FROM_COMMON_SOURCE = LibavoidMetaDataProvider.ENABLE_HYPEREDGES_FROM_COMMON_SOURCE;
    public static final IProperty<Boolean> IS_CLUSTER = LibavoidMetaDataProvider.IS_CLUSTER;
    public static final IProperty<Integer> PROCESS_TIMEOUT = LibavoidMetaDataProvider.PROCESS_TIMEOUT;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Libavoid").description("libavoid is a cross-platform C++ library providing fast, object-avoiding orthogonal and polyline connector routing for use in interactive diagram editors.").providerFactory((IFactory)new LibavoidFactory()).category("org.eclipse.elk.alg.libavoid.edge").melkBundleName("Libavoid Connector Routing").definingBundleId(ALGORITHM_ID).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", (Object)false);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.port.side", PORT_SIDE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.direction", DIRECTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.edgeRouting", (Object)EDGE_ROUTING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.portConstraints", (Object)PORT_CONSTRAINTS_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.omitNodeMicroLayout", OMIT_NODE_MICRO_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.segmentPenalty", SEGMENT_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.anglePenalty", ANGLE_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.crossingPenalty", CROSSING_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.clusterCrossingPenalty", CLUSTER_CROSSING_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.fixedSharedPathPenalty", FIXED_SHARED_PATH_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.portDirectionPenalty", PORT_DIRECTION_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.shapeBufferDistance", SHAPE_BUFFER_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.idealNudgingDistance", IDEAL_NUDGING_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.reverseDirectionPenalty", REVERSE_DIRECTION_PENALTY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.nudgeOrthogonalSegmentsConnectedToShapes", NUDGE_ORTHOGONAL_SEGMENTS_CONNECTED_TO_SHAPES.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.improveHyperedgeRoutesMovingJunctions", IMPROVE_HYPEREDGE_ROUTES_MOVING_JUNCTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.penaliseOrthogonalSharedPathsAtConnEnds", PENALISE_ORTHOGONAL_SHARED_PATHS_AT_CONN_ENDS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.nudgeOrthogonalTouchingColinearSegments", NUDGE_ORTHOGONAL_TOUCHING_COLINEAR_SEGMENTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.performUnifyingNudgingPreprocessingStep", PERFORM_UNIFYING_NUDGING_PREPROCESSING_STEP.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.improveHyperedgeRoutesMovingAddingAndDeletingJunctions", IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.nudgeSharedPathsWithCommonEndPoint", NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.enableHyperedgesFromCommonSource", ENABLE_HYPEREDGES_FROM_COMMON_SOURCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.isCluster", IS_CLUSTER.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.alg.libavoid.processTimeout", PROCESS_TIMEOUT.getDefault());
    }

    public static class LibavoidFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            LibavoidLayoutProvider provider = new LibavoidLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

