/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.acute.debug.DebuggersRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DebuggerTab
extends AbstractLaunchConfigurationTab {
    static final String ATTR_DEFAULT_DEBUGGER = String.valueOf(DebuggerTab.class.getName()) + ".ATTR_DEFAULT_DEBUGGER";
    private Text debugCommandText;
    private Text debugArgsText;
    private Button defaultDebuggerCheckbox;
    private Button browseDebuggerButton;
    private Set<Control> toDisableWhenDefault = new HashSet<Control>();

    public void createControl(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(3, false));
        this.defaultDebuggerCheckbox = this.createCheckButton(res, Messages.DebuggerTab_useDefaultDebugger);
        this.defaultDebuggerCheckbox.setLayoutData((Object)new GridData(4, -1, false, false, 3, 1));
        Label debuggerPathLabel = new Label(res, 0);
        debuggerPathLabel.setText(Messages.DebuggerTab_debuggerPath);
        this.toDisableWhenDefault.add((Control)debuggerPathLabel);
        this.debugCommandText = new Text(res, 2048);
        this.debugCommandText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration debugCommandDecoration = new ControlDecoration((Control)this.debugCommandText, 16512);
        debugCommandDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.debugCommandText.addModifyListener(e -> {
            this.setDirty(true);
            File file = new File(this.debugCommandText.getText());
            if (!file.isFile()) {
                this.setErrorMessage(Messages.DebuggerTab_invalidFile_message);
                debugCommandDecoration.setDescriptionText(Messages.DebuggerTab_invalidFile_title);
                debugCommandDecoration.show();
                this.getLaunchConfigurationDialog().updateButtons();
            } else if (!file.canExecute()) {
                this.setErrorMessage(Messages.DebuggerTab_nonExecutableFileMessage);
                debugCommandDecoration.setDescriptionText(Messages.DebuggerTab_nonExecutableFile_title);
                debugCommandDecoration.show();
                this.getLaunchConfigurationDialog().updateButtons();
            } else {
                this.setErrorMessage(null);
                debugCommandDecoration.hide();
            }
            this.updateLaunchConfigurationDialog();
        });
        this.toDisableWhenDefault.add((Control)this.debugCommandText);
        this.browseDebuggerButton = new Button(res, 8);
        this.browseDebuggerButton.setText(Messages.DotnetRunTab_browse);
        this.browseDebuggerButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setText(Messages.DebuggerTab_selectDebugger);
            String currentCommand = this.debugCommandText.getText();
            if (currentCommand != null && !currentCommand.trim().isEmpty()) {
                File file = new File(currentCommand.trim());
                if (file.isDirectory()) {
                    dialog.setFilterPath(file.getAbsolutePath());
                } else if (file.isFile()) {
                    dialog.setFilterPath(file.getParentFile().getAbsolutePath());
                    dialog.setFileName(file.getName());
                } else if (file.getParentFile().exists()) {
                    dialog.setFilterPath(file.getParentFile().getAbsolutePath());
                }
            }
            boolean cancel = false;
            boolean valid = false;
            File file = null;
            do {
                valid = false;
                cancel = false;
                String path = dialog.open();
                if (path != null) {
                    file = new File(path);
                    if (!file.isFile()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.DebuggerTab_invalidFile_title, (String)Messages.DebuggerTab_invalidFile_message);
                        continue;
                    }
                    if (!file.canExecute()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.DebuggerTab_nonExecutableFile_title, (String)Messages.DebuggerTab_nonExecutableFileMessage);
                        continue;
                    }
                    valid = true;
                    continue;
                }
                cancel = true;
            } while (!cancel && !valid);
            if (valid && !file.getAbsolutePath().equals(this.debugCommandText.getText())) {
                this.debugCommandText.setText(file.getAbsolutePath());
                this.setDirty(valid);
            }
        }));
        this.toDisableWhenDefault.add((Control)this.browseDebuggerButton);
        Label debuggerArgsLabel = new Label(res, 0);
        debuggerArgsLabel.setText(Messages.DebuggerTab_debuggerArgs);
        this.toDisableWhenDefault.add((Control)debuggerArgsLabel);
        this.debugArgsText = new Text(res, 2048);
        this.debugArgsText.addModifyListener(e -> this.setDirty(true));
        this.debugArgsText.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.toDisableWhenDefault.add((Control)this.debugArgsText);
        this.defaultDebuggerCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.setDirty(true);
            this.toDisableWhenDefault.forEach(widget -> widget.setEnabled(!this.defaultDebuggerCheckbox.getSelection()));
            this.updateLaunchConfigurationDialog();
        }));
        this.setControl((Control)res);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_DEFAULT_DEBUGGER, true);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", "");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.defaultDebuggerCheckbox.setSelection(configuration.getAttribute(ATTR_DEFAULT_DEBUGGER, true));
            if (this.defaultDebuggerCheckbox.getSelection()) {
                DebuggersRegistry.DebuggerInfo info = DebuggersRegistry.getDefaultDebugger();
                this.debugCommandText.setText(info.debugger.getAbsolutePath());
                this.debugArgsText.setText(String.join((CharSequence)" ", info.args));
                this.toDisableWhenDefault.forEach(control -> control.setEnabled(false));
            } else {
                this.defaultDebuggerCheckbox.setSelection(false);
                this.debugCommandText.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", ""));
                List args = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Collections.emptyList());
                this.debugArgsText.setText(String.join((CharSequence)" ", args.toArray(new String[args.size()])));
                this.toDisableWhenDefault.forEach(control -> control.setEnabled(true));
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_DEFAULT_DEBUGGER, this.defaultDebuggerCheckbox.getSelection());
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", this.getAttributeValueFrom(this.debugCommandText));
        String arg = this.getAttributeValueFrom(this.debugArgsText);
        if (arg == null) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
        } else {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Arrays.asList(arg.split("\\s+")));
        }
    }

    protected String getAttributeValueFrom(Text text) {
        String value = text.getText().trim();
        if (!value.isEmpty()) {
            return value;
        }
        return null;
    }

    public String getName() {
        return Messages.DebuggerTab_title;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            return super.isValid(launchConfig) && new File(launchConfig.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", "/letshopenofileevergetthisname")).canExecute();
        }
        catch (CoreException e) {
            AcutePlugin.logError(e);
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }
}

