/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.awt.Color;
import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.CellOccupant;
import org.ascape.model.LocatedAgent;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class HostCell
extends Cell {
    private static final long serialVersionUID = 1L;
    public static final Conditional IS_AVAILABLE = new Conditional(){
        private static final long serialVersionUID = 1L;

        public final boolean meetsCondition(Object o) {
            return ((HostCell)o).isAvailable();
        }
    };
    public static final Conditional IS_OCCUPIED = new Conditional(){
        private static final long serialVersionUID = 1L;

        public final boolean meetsCondition(Object o) {
            return !((HostCell)o).isAvailable();
        }
    };
    protected CellOccupant occupant = null;
    private int[] neighborsAvailableIndices = new int[0];

    public boolean isAvailable() {
        return this.occupant == null;
    }

    public Node getOccupant() {
        return this.occupant;
    }

    public void setNeighborsList(List neighbors) {
        super.setNeighborsList(neighbors);
        if (this.neighborsAvailableIndices.length < neighbors.size()) {
            this.neighborsAvailableIndices = new int[neighbors.size()];
        }
    }

    public boolean isNeighborAvailable() {
        int i = 0;
        while (i < this.neighbors.size()) {
            if (((HostCell)this.neighbors.get(i)).isAvailable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public HostCell findRandomAvailableNeighbor() {
        int count = 0;
        int i = 0;
        while (i < this.neighbors.size()) {
            if (((HostCell)this.neighbors.get(i)).isAvailable()) {
                this.neighborsAvailableIndices[count] = i;
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            return (HostCell)this.neighbors.get(this.neighborsAvailableIndices[this.randomToLimit(count)]);
        }
        return null;
    }

    public void setOccupant(Node occupant) {
        if (this.occupant == null) {
            if (occupant == null) {
                throw new RuntimeException("Can't assign a null occupant to a host cell. Use removeOccupant first.");
            }
        } else {
            throw new RuntimeException("Tried to assign an occupant to an allready occupied cell.");
        }
        this.occupant = (CellOccupant)occupant;
        this.requestUpdate();
    }

    public void removeOccupant() {
        if (this.occupant == null) {
            throw new RuntimeException("No occupant to remove.");
        }
        this.occupant = null;
        this.requestUpdate();
    }

    public List findNeighboringOccupants() {
        return Discrete.findOccupants(this.neighbors);
    }

    public List findOccupantsWithin(Conditional condition, double distance) {
        return this.findOccupantsWithin(condition, false, distance);
    }

    public List findOccupantsWithin(double distance) {
        return this.findOccupantsWithin(null, false, distance);
    }

    public List findOccupantsWithin(Conditional condition, boolean includeSelf, double distance) {
        Conditional hostedCondition = HostCell.hostedCondition(condition);
        return HostCell.findOccupants(this.findWithin(hostedCondition, includeSelf, distance));
    }

    public LocatedAgent findNearestOccupants() {
        return this.findNearestOccupants(null, false, Double.MAX_VALUE);
    }

    public LocatedAgent findNearestOccupants(double distance) {
        return this.findNearestOccupants(null, false, distance);
    }

    public LocatedAgent findNearestOccupants(Conditional condition) {
        return this.findNearestOccupants(condition, false, Double.MAX_VALUE);
    }

    public LocatedAgent findNearestOccupants(Conditional condition, double distance) {
        return this.findNearestOccupants(condition, false, distance);
    }

    public LocatedAgent findNearestOccupants(Conditional condition, boolean includeSelf, double distance) {
        Conditional hostedCondition = HostCell.hostedCondition(condition);
        LocatedAgent nearest = this.getScape().findNearest(this.getCoordinate(), hostedCondition, includeSelf, distance);
        if (nearest != null) {
            return (LocatedAgent)((Object)((HostCell)nearest).getOccupant());
        }
        return null;
    }

    public List findAvailableNeighbors() {
        return ((Discrete)this.getScape().getSpace()).findAvailable(this.neighbors);
    }

    public Object clone() {
        Agent clone = (Agent)super.clone();
        this.occupant = null;
        return clone;
    }

    public Color getColor() {
        return Color.green;
    }
}

