/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.CellOccupant;
import org.ascape.model.LocatedAgent;
import org.ascape.model.engine.ExecutionStrategy;
import org.ascape.model.engine.StrategyFactory;
import org.ascape.model.event.ControlEvent;
import org.ascape.model.event.ControlListener;
import org.ascape.model.event.DrawFeatureEvent;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;
import org.ascape.model.event.ScapeListenerDelegate;
import org.ascape.model.rule.CollectStats;
import org.ascape.model.rule.ExecuteThenUpdate;
import org.ascape.model.rule.NotifyViews;
import org.ascape.model.rule.PropogateScapeOnly;
import org.ascape.model.rule.Rule;
import org.ascape.model.rule.SearchRule;
import org.ascape.model.space.Array2DBase;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Continuous;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.ListBase;
import org.ascape.model.space.ListSpace;
import org.ascape.model.space.Location;
import org.ascape.model.space.Singleton;
import org.ascape.model.space.Space;
import org.ascape.model.space.SpaceContext;
import org.ascape.model.space.SpatialTemporalException;
import org.ascape.model.space.SubSpace;
import org.ascape.runtime.AbstractUIEnvironment;
import org.ascape.runtime.NonGraphicRunner;
import org.ascape.runtime.Runner;
import org.ascape.runtime.RuntimeEnvironment;
import org.ascape.util.Conditional;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.RandomIterator;
import org.ascape.util.ResetableIterator;
import org.ascape.util.Utility;
import org.ascape.util.VectorSelection;
import org.ascape.util.data.DataGroup;
import org.ascape.util.data.DataPoint;
import org.ascape.util.data.DataPointConcrete;
import org.ascape.util.data.StatCollector;
import org.ascape.util.vis.PlatformDrawFeature;

public class Scape
extends CellOccupant
implements SpaceContext,
Collection,
ControlListener,
ScapeListener {
    static final long serialVersionUID = 7686992038072599524L;
    public static final String version = "3.1";
    public static final String copyrightAndCredits = "<B>Ascape version 3.1</B><BR></BR>Portions copyright 2000-2007, NuTech Solutions, Inc.<BR></BR>Portions copyright 1998-2000, The Brookings Institution<BR></BR>JFreeChart Copyright (c) 2000, 2001, Simba Management Limited and others. (See licence-LGPL.txt)<BR></BR>Icons (C)1998 Dean S. Jones<BR></BR>Use subject to license agreement - see License.txt.<BR></BR>Government Users -- Commercial Software subject to 48 C.F.R. \u00df12.212 or 48 C.F.R. \u00df\u00df227.7202-1 through 227.7202-4.";
    public static final Rule CREATE_RULE = new PropogateScapeOnly("Create Scape"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            if (((Scape)agent).isAutoCreate()) {
                ((Scape)agent).createScape();
            }
            super.execute(agent);
        }

        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule CREATE_VIEW_RULE = new PropogateScapeOnly("Create Views"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((Scape)agent).createViews();
            super.execute(agent);
        }

        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule CREATE_GRAPHIC_VIEW_RULE = new PropogateScapeOnly("Create Graphic Views"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((Scape)agent).createGraphicViews();
            super.execute(agent);
        }

        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule CREATE_SCAPE_RULE = new Rule("Create Scape"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((Scape)agent).createScape();
        }

        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule INITIAL_RULES_RULE = new PropogateScapeOnly("Initial Rules"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            super.execute(agent);
            int iterations = 0;
            int style = 0;
            if (((Scape)agent).getSpace() instanceof Discrete) {
                iterations = ((Scape)agent).getAgentsPerIteration();
                style = ((Scape)agent).getExecutionStyle();
                ((Scape)agent).setExecutionStyle(1);
                ((Scape)agent).setAgentsPerIteration(-1);
            }
            ((Scape)agent).executeOnMembers(((Scape)agent).getInitialRules());
            if (((Scape)agent).getSpace() instanceof Discrete) {
                ((Scape)agent).setAgentsPerIteration(iterations);
                ((Scape)agent).setExecutionStyle(style);
            }
        }

        public boolean isIterateAll() {
            return true;
        }
    };
    public static final Rule EXECUTE_RULES_RULE = new PropogateScapeOnly("Iterate Scape"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((Scape)agent).executeOnMembers();
            super.execute(agent);
        }
    };
    public static final Rule CLEAR_STATS_RULE = new PropogateScapeOnly("Iterate Scape"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            CollectStats collectStats = ((Scape)agent).getCollectStats();
            if (collectStats != null) {
                collectStats.clear();
            }
            super.execute(agent);
        }
    };
    public static final Rule COLLECT_STATS_RULE = new PropogateScapeOnly("Iterate Scape"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            CollectStats collectStats = ((Scape)agent).getCollectStats();
            if (collectStats != null) {
                collectStats.setPhase(1);
                ((Scape)agent).executeOnMembers(collectStats);
                collectStats.setPhase(2);
                ((Scape)agent).executeOnMembers(collectStats);
            }
            super.execute(agent);
            if (collectStats != null) {
                collectStats.calculateValues();
            }
            if (((Scape)agent).isRoot() && ((Scape)agent).getRunner().getData() != null) {
                ((Scape)agent).getRunner().getData().update();
            }
        }
    };
    public static final int ALL_AGENTS = -1;
    public static final int AGENT_ORDER = -2;
    public static final int RULE_ORDER = -1;
    public static final int COMPLETE_TOUR = 1;
    public static final int REPEATED_DRAW = 2;
    private Runner runner;
    private Space space;
    protected Agent prototypeAgent;
    private VectorSelection rules = new VectorSelection(new Vector());
    protected VectorSelection initialRules = new VectorSelection(new Vector());
    private ArrayList scapeListeners = new ArrayList();
    protected int agentsPerIteration = -1;
    private int executionOrder = -2;
    private int executionStyle = 1;
    private boolean membersActive = true;
    private boolean autoCreate = true;
    private boolean populateOnCreate = true;
    private boolean cellsRequestUpdates = false;
    private CollectStats collectStats = null;
    private ScapeListener selfView;
    private Vector drawFeatures = new Vector();
    private boolean listenersAndMembersCurrent = false;
    private int iterationsPerRedraw = 1;
    private int updatedListeners = 0;
    private int updatedMembers = 0;
    private boolean serializable = true;
    private static SearchRule defaultSearch;
    private DrawFeatureObservable drawFeatureObservable = new DrawFeatureObservable();
    public static final Comparator COMPARE_ORDERED_QUALIFIERS;
    private ExecutionStrategy strategy;
    private static int threadCount;

    static {
        COMPARE_ORDERED_QUALIFIERS = new Comparator(){

            public int compare(Object o1, Object o2) {
                return Utility.orderedQualifiers(((PropertyAccessor)o1).getLongName()).compareTo(Utility.orderedQualifiers(((PropertyAccessor)o2).getLongName()));
            }
        };
        threadCount = 1;
    }

    public Scape() {
        this(new ListSpace());
    }

    public Scape(CollectionSpace space) {
        this(space, null, null);
    }

    public Scape(String name, Agent prototypeAgent) {
        this(null, name, prototypeAgent);
    }

    public Scape(CollectionSpace space, String name, Agent prototypeAgent) {
        this.setSpace(space);
        this.setName(name);
        this.setPrototypeAgent(prototypeAgent);
        this.scapeListeners = new ArrayList();
        this.listenersAndMembersCurrent = true;
    }

    public int getSize() {
        return this.space.getSize();
    }

    public void setPrototypeAgent(Agent prototypeAgent) {
        this.prototypeAgent = prototypeAgent;
        if (prototypeAgent != null && prototypeAgent.getScape() == null) {
            prototypeAgent.setScape(this);
            prototypeAgent.scapeCreated();
        }
        this.setInitialized(false);
    }

    public Agent getPrototypeAgent() {
        return this.prototypeAgent;
    }

    public int getAgentsPerIteration() {
        return this.agentsPerIteration;
    }

    public void setAgentsPerIteration(int agentsPerIteration) {
        this.agentsPerIteration = agentsPerIteration;
    }

    public int getIterationsPerRedraw() {
        return this.iterationsPerRedraw;
    }

    public void setIterationsPerRedraw(int iterationsPerRedraw) {
        this.setIterationsPerRedraw(iterationsPerRedraw, true);
    }

    public void setIterationsPerRedraw(int iterationsPerRedraw, boolean propagate) {
        this.iterationsPerRedraw = iterationsPerRedraw;
        if (propagate) {
            this.executeOnRoot(new NotifyViews(-7){
                private static final long serialVersionUID = 1L;

                public void execute(Agent agent) {
                    ((Scape)agent).setIterationsPerRedraw(agent.getRoot().getIterationsPerRedraw(), false);
                    super.execute(agent);
                }
            });
        }
    }

    public int getExecutionOrder() {
        return this.executionOrder;
    }

    public void setExecutionOrder(int symbol) {
        this.executionOrder = symbol;
    }

    public int getExecutionStyle() {
        return this.executionStyle;
    }

    public void setExecutionStyle(int symbol) {
        this.executionStyle = symbol;
    }

    public Coordinate getExtent() {
        return this.space.getExtent();
    }

    public void setExtent(Coordinate extent) {
        if (this.getRunner() != null && this.getRunner().isRunning()) {
            throw new RuntimeException("Tried to modfiy extent while scape was running");
        }
        this.space.setExtent(extent);
    }

    public void setExtent(int xval) {
        if (this.runner != null && this.runner.isRunning()) {
            throw new RuntimeException("Tried to modfiy extent while scape was running");
        }
        if (this.getSpace().getGeometry().getDimensionCount() != 1) {
            throw new RuntimeException("Tried to set extent as 1-dimension for a scape that isn't 1-dimensional.");
        }
        ((CollectionSpace)this.getSpace()).setExtent(xval);
    }

    public void setExtent(int xval, int yval) {
        if (this.runner != null && this.runner.isRunning()) {
            throw new RuntimeException("Tried to modfiy extent while scape was running");
        }
        try {
            ((Array2DBase)this.getSpace()).setExtent(xval, yval);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Can't set extent as x, y; underlying scape doesn't support it.");
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getClass().getName();
    }

    private void loadDescriptions() {
        if (this.getRunner().getDescription() == null || this.getRunner().getHTMLDescription() == null) {
            String fileName = "About" + Utility.getClassNameOnly(this.getClass()) + ".html";
            URL aboutFile = this.getClass().getResource(fileName);
            if (aboutFile != null) {
                this.getRunner().setDescription("");
                try {
                    BufferedInputStream is = (BufferedInputStream)aboutFile.getContent();
                    BufferedReader ir = new BufferedReader(new InputStreamReader(is));
                    String nextLine = ir.readLine();
                    StringBuffer htmlFragBuffer = new StringBuffer();
                    while (nextLine != null) {
                        htmlFragBuffer.append(nextLine);
                        nextLine = ir.readLine();
                    }
                    StringBuffer plainTextBuffer = new StringBuffer();
                    String htmlString = htmlFragBuffer.toString();
                    boolean done = false;
                    int pos = 0;
                    while (!done) {
                        int anglePos = htmlString.indexOf("<", pos);
                        if (anglePos >= 0) {
                            plainTextBuffer.append(htmlFragBuffer.substring(pos, anglePos));
                            if (htmlFragBuffer.substring(anglePos, anglePos + 4).equalsIgnoreCase("<BR>")) {
                                plainTextBuffer.append("\n");
                            }
                            pos = htmlString.indexOf(">", anglePos) + 1;
                            continue;
                        }
                        plainTextBuffer.append(htmlFragBuffer.substring(pos, htmlFragBuffer.length()));
                        done = true;
                    }
                    this.setHTMLDescription(htmlFragBuffer.toString());
                    this.setDescription(plainTextBuffer.toString());
                }
                catch (IOException e) {
                    this.getEnvironment().getConsole().println("Non-critical exception: couldn't read \"About\" file: " + e);
                    this.getRunner().setDescription(this.toString());
                }
            } else {
                this.getRunner().setDescription(this.toString());
            }
        }
    }

    public String getDescription() {
        try {
            this.loadDescriptions();
            return this.getRunner().getDescription();
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    public void setDescription(String description) {
        this.getRunner().setDescription(description);
    }

    public String getHTMLDescription() {
        this.loadDescriptions();
        return this.getRunner().getHTMLDescription();
    }

    public void setHTMLDescription(String description) {
        this.getRunner().setHTMLDescription(description);
    }

    public final Scape getRoot() {
        if (this.scape == null) {
            return this;
        }
        return this.scape.getRoot();
    }

    public boolean isRoot() {
        return this.scape == null;
    }

    public boolean isUpdateNeeded() {
        return this.isUpdateNeeded(this.getIterationsPerRedraw());
    }

    public void construct() {
        this.space.construct();
        if (this.getSpace() instanceof Discrete && this.getPrototypeAgent() == null) {
            this.setPrototypeAgent(new Cell());
        }
    }

    public void populate() {
        this.space.populate();
    }

    public void createScape() {
        if (this.isRoot()) {
            if (this.getPrototypeAgent() == null) {
                this.setPrototypeAgent(new Scape());
            }
            if (this.getRunner() == null) {
                new NonGraphicRunner().setRootScape(this);
            }
        }
        this.construct();
        if (this.isPopulateOnCreate()) {
            this.populate();
        }
    }

    public void initialize() {
        if (this.isRoot()) {
            this.setAutoCreate(false);
        }
        if (this.isAutoCreate()) {
            this.createScape();
        }
        super.initialize();
        this.getSpace().initialize();
        if (!(this.getSpace() instanceof Continuous) && this.getPrototypeAgent() != null && this.getPrototypeAgent().getScape() == this && !this.getSpace().isMutable()) {
            this.executeOnMembers(Cell.CALCULATE_NEIGHBORS_RULE);
        }
    }

    public final int getIteration() {
        return this.getRunner().getIteration();
    }

    public final int getPeriod() {
        return this.getRunner().getPeriod();
    }

    public String getPeriodName() {
        return this.getRunner().getPeriodName();
    }

    public String getPeriodDescription() {
        return String.valueOf(this.getPeriodName()) + " " + Integer.toString(this.getPeriod());
    }

    public void setPeriodName(String name) {
        this.getRunner().setPeriodName(name);
    }

    public synchronized void addRule(Rule rule) {
        this.addRule(rule, true);
    }

    public synchronized void addRule(Rule rule, boolean select) {
        if (rule instanceof ExecuteThenUpdate && this.getExecutionOrder() != -1) {
            throw new RuntimeException("Tried to add execute and update rule to AGENT_ORDER Scape. Set Scape to RULE_ORDER execution first.");
        }
        if (rule.getScape() == null) {
            rule.setScape(this);
        }
        this.rules.addElement(rule, select);
    }

    public VectorSelection getRules() {
        return this.rules;
    }

    public synchronized void addInitialRule(Rule rule) {
        this.addInitialRule(rule, true);
    }

    public synchronized void addInitialRule(Rule rule, boolean select) {
        if (rule.getScape() == null) {
            rule.setScape(this);
        }
        this.initialRules.addElement(rule, select);
    }

    public VectorSelection getInitialRules() {
        return this.initialRules;
    }

    public void setInitialRules(VectorSelection initialRules) {
        this.initialRules = initialRules;
    }

    public synchronized void addView(ScapeListener view) {
        this.addView(view, true);
    }

    public synchronized void addView(ScapeListener view, boolean createFrame, boolean forceGUI) {
        if (forceGUI || Runner.isDisplayGraphics() || !view.isGraphic() || Runner.isServeGraphics()) {
            try {
                this.addScapeListener(view);
                view.scapeAdded(new ScapeEvent(this, -5));
            }
            catch (TooManyListenersException e) {
                throw new RuntimeException("Tried to add a view to more than one scape:\n" + e);
            }
            if (createFrame && view.isGraphic() && !Runner.isServeGraphics()) {
                this.getEnvironment().addView(view);
            }
        }
    }

    public synchronized void addView(ScapeListener view, boolean createFrame) {
        this.addView(view, createFrame, false);
    }

    public synchronized void addViews(ScapeListener[] views) {
        this.addViews(views, true);
    }

    public synchronized void addViews(ScapeListener[] views, boolean createFrame, boolean forceGUI) {
        if (forceGUI || Runner.isDisplayGraphics() || !views[0].isGraphic()) {
            try {
                int i = 0;
                while (i < views.length) {
                    this.addScapeListener(views[i]);
                    views[i].scapeAdded(new ScapeEvent(this, -5));
                    ++i;
                }
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new RuntimeException("Tried to add a view to more than one scape");
            }
            boolean allGraphic = false;
            int i = 0;
            while (i < views.length) {
                if (!views[i].isGraphic()) {
                    allGraphic = false;
                    break;
                }
                allGraphic = true;
                ++i;
            }
            if (createFrame && allGraphic) {
                this.getEnvironment().addViews(views);
            }
        }
    }

    public synchronized void addViews(ScapeListener[] views, boolean createFrame) {
        this.addViews(views, createFrame, false);
    }

    public synchronized void addScapeListener(ScapeListener listener) {
        if (listener == null) {
            throw new RuntimeException("Tried to add a null listener to Scape.");
        }
        this.scapeListeners.add(listener);
        ++this.updatedListeners;
        this.listenerOrMemberUpdated();
    }

    public synchronized void addScapeListenerFirst(ScapeListener listener) {
        if (listener == null) {
            throw new RuntimeException("Tried to add a null listener to Scape.");
        }
        this.scapeListeners.add(0, listener);
        ++this.updatedListeners;
        this.listenerOrMemberUpdated();
    }

    public boolean isScapeListener(ScapeListener listener) {
        return this.scapeListeners.contains(listener);
    }

    public synchronized void removeScapeListener(ScapeListener listener) {
        boolean success = this.scapeListeners.remove(listener);
        if (!success) {
            this.getEnvironment().getConsole().println("WARNING: Tried to remove unregistered scape listener " + listener + " from scape " + this + ".");
        }
        listener.scapeRemoved(new ScapeEvent(this, -6));
        this.listenerOrMemberUpdated();
    }

    public ArrayList getScapeListeners() {
        return this.scapeListeners;
    }

    public void notifyViews(int id) {
        this.notifyViews(new ScapeEvent(this, id));
    }

    public void notifyViews(ScapeEvent event) {
        this.listenersAndMembersCurrent = false;
        this.updatedListeners = 0;
        this.updatedMembers = 0;
        if (this.scapeListeners.size() > 0) {
            ArrayList currentListeners = (ArrayList)this.scapeListeners.clone();
            for (Object listener : currentListeners) {
                this.getRunner().notify(event, (ScapeListener)listener);
            }
        } else {
            this.listenerOrMemberUpdated();
        }
    }

    public final boolean isAllViewsUpdated() {
        return this.listenersAndMembersCurrent;
    }

    protected synchronized void listenerOrMemberUpdated() {
        if (!(this.updatedListeners < this.scapeListeners.size() || this.updatedMembers < this.getSize() && this.getPrototypeAgent() instanceof Scape && !(this.getSpace() instanceof Singleton) && ((Scape)this.getPrototypeAgent()).isMembersActive())) {
            this.listenersAndMembersCurrent = true;
            this.updatedListeners = 0;
            this.updatedMembers = 0;
            if (this.scape != null) {
                this.scape.memberUpdated(this);
            }
        }
    }

    public synchronized void listenerUpdated(ScapeListener listener) {
        ++this.updatedListeners;
        this.listenerOrMemberUpdated();
    }

    public synchronized void memberUpdated(Scape member) {
        ++this.updatedMembers;
        this.listenerOrMemberUpdated();
    }

    public void respondControl(ControlEvent control) {
        if (control.getID() == 1) {
            this.listenerUpdated((ScapeListener)control.getSource());
        } else {
            this.getRunner().respondControl(control);
        }
    }

    public void respondDrawFeature(DrawFeatureEvent event) {
        throw new RuntimeException("The client or worker scape should define their own version of this!");
    }

    public void setRunning(boolean running) {
        this.getRunner().setRunning(running);
    }

    public boolean isRunning() {
        return this.getRunner() != null && this.getRunner().isRunning();
    }

    public void setPaused(boolean pause) {
        if (pause) {
            this.getRunner().pause();
        } else {
            this.getRunner().resume();
        }
    }

    public boolean isPaused() {
        return this.getRunner().isPaused();
    }

    public void setEarliestPeriod(int earliestPeriod) {
        this.getRunner().setEarliestPeriod(earliestPeriod);
    }

    public void setLatestPeriod(int latestPeriod) {
        this.getRunner().setLatestPeriod(latestPeriod);
    }

    public boolean isValidPeriod(int period) {
        return this.getRunner().isValidPeriod(period);
    }

    public int getStartPeriod() {
        return this.getRunner().getStartPeriod();
    }

    public void setStartPeriod(int startPeriod) throws SpatialTemporalException {
        this.getRunner().setStartPeriod(startPeriod);
    }

    public int getStopPeriod() {
        return this.getRunner().getStopPeriod();
    }

    public void setStopPeriod(int stopPeriod) throws SpatialTemporalException {
        this.getRunner().setStopPeriod(stopPeriod);
    }

    public int getPausePeriod() {
        return this.getRunner().getPausePeriod();
    }

    public void setPausePeriod(int pausePeriod) {
        this.getRunner().setPausePeriod(pausePeriod);
    }

    public boolean isStartOnOpen() {
        return Runner.isStartOnOpen();
    }

    public void setStartOnOpen(boolean startOnOpen) {
        Runner.setStartOnOpen(startOnOpen);
    }

    public void setAutoRestart(boolean autoRestart) {
        this.getRunner().setAutoRestart(autoRestart);
    }

    public Runner getModel() {
        return this.getRunner();
    }

    public Runner getRunner() {
        return this.getRoot().runner;
    }

    public void setRunner(Runner _runner) {
        this.runner = _runner;
    }

    public String getHome() {
        return this.getRunner().getHome();
    }

    public void setHome(String home) {
        this.getRunner().setHome(home);
    }

    public boolean isMembersActive() {
        return this.membersActive;
    }

    public void setMembersActive(boolean membersActive) {
        this.membersActive = membersActive;
    }

    public boolean isCellsRequestUpdates() {
        return this.cellsRequestUpdates;
    }

    public void setCellsRequestUpdates(boolean cellsRequestUpdates) {
        this.cellsRequestUpdates = cellsRequestUpdates;
    }

    public void execute(List rules, List agents) {
        Agent[] agentArray = new Agent[agents.size()];
        agents.toArray(agentArray);
        int[] order = CollectionSpace.createOrder(agentArray.length);
        if (this.executionOrder == -2) {
            order = CollectionSpace.randomizeOrder(order, this.getRandom());
            int i = 0;
            while (i < agentArray.length) {
                for (Rule rule : rules) {
                    rule.execute(agentArray[order[i]]);
                }
                ++i;
            }
        } else {
            for (Rule rule : rules) {
                if (rule.isRandomExecution()) {
                    order = CollectionSpace.randomizeOrder(order, this.getRandom());
                }
                int i = 0;
                while (i < agentArray.length) {
                    rule.execute(agentArray[order[i]]);
                    ++i;
                }
                if (!(rule instanceof ExecuteThenUpdate)) continue;
                if (rule.isRandomExecution()) {
                    order = CollectionSpace.randomizeOrder(order, this.getRandom());
                }
                i = 0;
                while (i < agentArray.length) {
                    ((ExecuteThenUpdate)rule).update(agentArray[order[i]]);
                    ++i;
                }
            }
        }
    }

    public void execute(Rule rule, List agents) {
        ArrayList<Rule> rules = new ArrayList<Rule>(1);
        rules.add(rule);
        this.execute(rules, agents);
    }

    public void executeOnMembers() {
        this.executeOnMembers(this.rules);
    }

    public void executeOnMembers(VectorSelection ruleSelection) {
        this.executeOnMembers(ruleSelection.getSelection());
    }

    public void executeOnMembers(Rule rule) {
        Object[] rules = new Rule[]{rule};
        this.executeOnMembers(rules);
    }

    public void executeOnMembers(Object[] rules) {
        if (rules.length > 0) {
            this.strategy = new StrategyFactory(this, rules, threadCount).getStrategy();
            this.strategy.execute();
        }
    }

    public Iterator iterator() {
        return this.space.iterator();
    }

    public void executeOnRoot(Rule[] rules) {
        if (this.scape == null) {
            this.execute(rules);
        } else {
            this.scape.executeOnRoot(rules);
        }
    }

    public void executeOnRoot(Rule rule) {
        Rule[] rules = new Rule[]{rule};
        this.executeOnRoot(rules);
    }

    public Agent search(Comparator comparator, Object key) {
        if (defaultSearch == null) {
            defaultSearch = new SearchRule("Default Scape Search Rule");
        }
        defaultSearch.setComparator(comparator);
        defaultSearch.setKey(key);
        defaultSearch.setSearchType(1);
        defaultSearch.clear();
        this.executeOnMembers(defaultSearch);
        return defaultSearch.getFoundAgent();
    }

    public Agent searchMin(Comparator comparator) {
        if (defaultSearch == null) {
            defaultSearch = new SearchRule("Default Scape Search Rule");
        }
        defaultSearch.setComparator(comparator);
        defaultSearch.setSearchType(2);
        defaultSearch.clear();
        this.executeOnMembers(defaultSearch);
        return defaultSearch.getFoundAgent();
    }

    public Agent searchMax(Comparator comparator) {
        if (defaultSearch == null) {
            defaultSearch = new SearchRule("Default Scape Search Rule");
        }
        defaultSearch.setComparator(comparator);
        defaultSearch.setSearchType(3);
        defaultSearch.clear();
        this.executeOnMembers(defaultSearch);
        return defaultSearch.getFoundAgent();
    }

    public void setCollectStats(boolean collect) {
        if (collect) {
            this.collectStats = new CollectStats();
            this.collectStats.setScape(this);
        } else {
            this.collectStats = null;
        }
    }

    public CollectStats getCollectStats() {
        return this.collectStats;
    }

    public void setCollectStats(CollectStats collectStats) {
        this.collectStats = collectStats;
        collectStats.setScape(this);
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isPopulateOnCreate() {
        return this.populateOnCreate;
    }

    public void setPopulateOnCreate(boolean populateOnCreate) {
        this.populateOnCreate = populateOnCreate;
    }

    public void addStatCollectors(StatCollector[] stats) {
        int i = 0;
        while (i < stats.length) {
            stats[i].setDataGroup(this.getRunner().getData());
            ++i;
        }
        this.getRunner().getData().add(stats);
        if (this.collectStats == null) {
            this.setCollectStats(true);
        }
        this.collectStats.addStatCollectors(stats);
    }

    public StatCollector addStatCollectorIfNew(StatCollector stat) {
        StatCollector foundStat = this.getRunner().getData().getStatCollector(stat.getName());
        if (foundStat == null) {
            this.addStatCollector(stat);
            foundStat = stat;
        }
        return foundStat;
    }

    public void addStatCollector(StatCollector stat) {
        StatCollector[] stats = new StatCollector[]{stat};
        this.addStatCollectors(stats);
    }

    public StatCollector[] getStatCollectors() {
        if (this.collectStats != null) {
            return this.collectStats.getStatCollectors();
        }
        throw new RuntimeException("Tried to get stats but they are not being collected");
    }

    public void addDrawFeature(PlatformDrawFeature feature) {
        for (PlatformDrawFeature drawFeature : this.drawFeatures) {
            if (!drawFeature.getName().equals(feature.getName())) continue;
            return;
        }
        this.drawFeatures.addElement(feature);
        this.drawFeatureObservable.setChanged();
        this.drawFeatureObservable.notifyObservers();
    }

    public boolean removeDrawFeature(PlatformDrawFeature feature) {
        PlatformDrawFeature found = null;
        for (PlatformDrawFeature drawFeature : this.drawFeatures) {
            if (!drawFeature.getName().equals(feature.getName())) continue;
            found = feature;
        }
        if (found != null) {
            this.drawFeatures.removeElement(found);
            this.drawFeatureObservable.setChanged();
            this.drawFeatureObservable.notifyObservers();
            return true;
        }
        return false;
    }

    public Observable getDrawFeaturesObservable() {
        return this.drawFeatureObservable;
    }

    public Vector getDrawFeatures() {
        return this.drawFeatures;
    }

    public AbstractUIEnvironment getUIEnvironment() {
        if (this.getRunner() != null && this.getRunner().getEnvironment() instanceof AbstractUIEnvironment) {
            return (AbstractUIEnvironment)this.getRunner().getEnvironment();
        }
        return null;
    }

    public RuntimeEnvironment getEnvironment() {
        return this.getRunner() != null ? this.getRunner().getEnvironment() : null;
    }

    private List retrieveAllAccessorsBase() {
        RetrieveAllAccessorsRule retrieveRule = new RetrieveAllAccessorsRule();
        this.executeOnRoot(retrieveRule);
        retrieveRule.accessors.add(new PropertyAccessor((Object)this, "RandomSeed"));
        retrieveRule.accessors.add(new PropertyAccessor((Object)this, "StartPeriod"));
        retrieveRule.accessors.add(new PropertyAccessor((Object)this, "StopPeriod"));
        retrieveRule.accessors.add(new PropertyAccessor((Object)this, "PausePeriod"));
        retrieveRule.accessors.add(new PropertyAccessor((Object)this, "ThreadCount"));
        return retrieveRule.accessors;
    }

    public List retrieveAllAccessors() {
        List accessors = this.retrieveAllAccessorsBase();
        return accessors;
    }

    public List retrieveAllAccessorsOrdered() {
        List accessors = this.retrieveAllAccessorsBase();
        Collections.sort(accessors, COMPARE_ORDERED_QUALIFIERS);
        return accessors;
    }

    public List retrieveModelAccessorsOrdered() {
        List accessors = this.retrieveAllAccessorsOrdered();
        Iterator iterator = accessors.iterator();
        while (iterator.hasNext()) {
            PropertyAccessor accessor = (PropertyAccessor)iterator.next();
            if (!accessor.getName().equalsIgnoreCase("size")) continue;
            iterator.remove();
        }
        return accessors;
    }

    public List getAllScapes() {
        RetrieveAllScapesRule retrieveRule = new RetrieveAllScapesRule();
        this.executeOnRoot(retrieveRule);
        return retrieveRule.scapes;
    }

    public boolean isViewSelf() {
        return this.selfView != null;
    }

    public void setViewSelf(boolean viewSelf) {
        if (viewSelf && !this.isViewSelf()) {
            this.createSelfView();
        } else if (!viewSelf && this.isViewSelf()) {
            this.removeScapeListener(this.selfView);
        }
    }

    public void createSelfView() {
        this.selfView = new ScapeListenerDelegate(this){
            private static final long serialVersionUID = 1L;

            public String getName() {
                return this + " Self-View";
            }
        };
        this.addView(this.selfView);
    }

    public void createViews() {
        if (this.isRoot() && this.getRunner().getEnvironment() == null) {
            this.getRunner().createEnvironment();
            this.addView(this.getRunner().getEnvironment());
        }
        this.createNonGraphicViews();
        if (Runner.isDisplayGraphics() || Runner.isServeGraphics()) {
            this.createGraphicViews();
        }
    }

    public void createGraphicViews() {
    }

    public void createNonGraphicViews() {
        if (this.isRoot()) {
            this.createSelfView();
            this.getEnvironment().getConsole().println("Ascape Model: " + this.getName());
            this.getEnvironment().getConsole().println(this.getDescription());
        }
    }

    public void scapeInitialized(ScapeEvent scapeEvent) {
    }

    public void scapeSetup(ScapeEvent scapeEvent) {
    }

    public void scapeIterated(ScapeEvent scapeEvent) {
    }

    public void scapeStarted(ScapeEvent scapeEvent) {
    }

    public void scapeStopped(ScapeEvent scapeEvent) {
    }

    public void scapeNotification(ScapeEvent scapeEvent) {
    }

    public void scapeClosing(ScapeEvent scapeEvent) {
    }

    public void environmentQuiting(ScapeEvent scapeEvent) {
    }

    public void scapeDeserialized(ScapeEvent scapeEvent) {
        if (Runner.isDisplayGraphics() && this.isRoot()) {
            this.getRunner().createEnvironment();
            this.addView(this.getRunner().getEnvironment());
        }
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
    }

    public void scapeRemoved(ScapeEvent scapeEvent) {
    }

    public boolean isGraphic() {
        return false;
    }

    public boolean isLifeOfScape() {
        return true;
    }

    public void save(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        this.save(os);
    }

    public void save(OutputStream os) throws IOException {
        ScapeListener l;
        if (!this.isSerializable()) {
            throw new RuntimeException("Tried to save a model that is not serializable.");
        }
        this.getRunner().setInternalRunning(false);
        GZIPOutputStream gzos = new GZIPOutputStream(os);
        ObjectOutputStream oos = new ObjectOutputStream(gzos);
        boolean needToAddCustomizer = false;
        if (this.getUIEnvironment() != null && this.getUIEnvironment().getCustomizer() != null && this.isScapeListener(this.getUIEnvironment().getCustomizer())) {
            this.removeScapeListener(this.getUIEnvironment().getCustomizer());
            needToAddCustomizer = true;
        }
        int i = 0;
        while (i < this.getEnvironment().getEnvironmentViews().size()) {
            l = (ScapeListener)this.getEnvironment().getEnvironmentViews().get(i);
            l.getScape().removeScapeListener(l);
            ++i;
        }
        try {
            oos.writeObject(this);
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
            System.err.println("");
            System.err.println("************************************");
            throw new RuntimeException("PLEASE INCREASE STACK SIZE, e.g. by using java's -Xss command line paramter.");
        }
        oos.close();
        if (needToAddCustomizer) {
            this.addScapeListener(this.getUIEnvironment().getCustomizer());
        }
        i = 0;
        while (i < this.getEnvironment().getEnvironmentViews().size()) {
            l = (ScapeListener)this.getEnvironment().getEnvironmentViews().get(i);
            this.addView(l, false);
            ++i;
        }
        try {
            this.setStartPeriod(this.getPeriod() + 1);
        }
        catch (SpatialTemporalException spatialTemporalException) {
            try {
                this.setStartPeriod(this.getPeriod());
            }
            catch (SpatialTemporalException spatialTemporalException2) {
                try {
                    this.setStartPeriod(this.getPeriod());
                }
                catch (SpatialTemporalException spatialTemporalException3) {
                    throw new RuntimeException("Internal Error");
                }
            }
        }
        this.getRunner().setInternalRunning(true);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getRunner().getData() != null) {
            this.getRunner().getData().getPeriods().clear();
        }
        this.getRunner().write(out);
    }

    public void assignParameters(String[] args, boolean reportNotFound) {
        List allAccessors = null;
        try {
            allAccessors = PropertyAccessor.determineReadWriteAccessors(this, Scape.class, false);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String paramName = PropertyAccessor.paramName(arg);
            if (paramName != null) {
                boolean found = false;
                String paramValue = PropertyAccessor.paramValue(arg);
                for (PropertyAccessor accessor : allAccessors) {
                    block20: {
                        if (!accessor.getName().equalsIgnoreCase(paramName)) continue;
                        try {
                            accessor.setAsText(paramValue);
                        }
                        catch (InvocationTargetException e) {
                            if (!reportNotFound) break block20;
                            throw new RuntimeException("Exception in called method: " + e.getTargetException());
                        }
                    }
                    found = true;
                }
                boolean bl = found = found || Runner.assignEnvironmentParameter(paramName, paramValue);
                if (!found) {
                    if (paramName.equalsIgnoreCase("RandomSeed")) {
                        try {
                            this.setRandomSeed(PropertyAccessor.paramValueLong(arg));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.getEnvironment().getConsole().println("Couldn't decode random seed value: " + paramValue);
                        }
                        found = true;
                    } else if (paramName.equalsIgnoreCase("StopPeriod")) {
                        try {
                            this.setStopPeriod(PropertyAccessor.paramValueInt(arg));
                            found = true;
                        }
                        catch (SpatialTemporalException e) {
                            e.printStackTrace();
                        }
                    } else if (paramName.equalsIgnoreCase("PausePeriod")) {
                        this.setPausePeriod(PropertyAccessor.paramValueInt(arg));
                        found = true;
                    } else if (paramName.equalsIgnoreCase("AutoRestart")) {
                        this.setAutoRestart(PropertyAccessor.paramValueBoolean(arg));
                        found = true;
                    }
                }
                if (!found && reportNotFound) {
                    this.getEnvironment().getConsole().println("***WARNING: Parameter not found: " + paramName + " in " + this.getName());
                }
            }
            ++n2;
        }
    }

    public void createViews(String[] args) {
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ScapeListener newView;
                String arg = stringArray[n2];
                if (PropertyAccessor.paramName(arg).equals("view") && (newView = (ScapeListener)this.getRunner().instanceFromName(PropertyAccessor.paramValue(arg))) != null) {
                    this.addView(newView);
                }
                ++n2;
            }
        }
    }

    public void assignParameters(String[] args) {
        this.assignParameters(args, true);
    }

    public final void moveAway(LocatedAgent origin, Coordinate target, double distance) {
        this.getSpace().moveAway(origin, target, distance);
    }

    public final void moveToward(LocatedAgent origin, Coordinate target, double distance) {
        this.getSpace().moveToward(origin, target, distance);
    }

    public double calculateDistance(LocatedAgent origin, LocatedAgent target) {
        return this.calculateDistance(origin.getCoordinate(), target.getCoordinate());
    }

    public final double calculateDistance(Coordinate origin, Coordinate target) {
        return this.getSpace().calculateDistance(origin, target);
    }

    public final List find(Conditional condition) {
        return this.space.find(condition);
    }

    public final LocatedAgent findMaximum(Iterator iter, DataPoint dataPoint) {
        ArrayList<LocatedAgent> multipleMaxObjects = null;
        double maxValue = -1.7976931348623157E308;
        LocatedAgent maxObject = null;
        while (iter.hasNext()) {
            Object next = iter.next();
            if (dataPoint.getValue(next) > maxValue) {
                maxValue = dataPoint.getValue(next);
                maxObject = (LocatedAgent)next;
                multipleMaxObjects = null;
                continue;
            }
            if (!DataPointConcrete.equals(dataPoint.getValue(next), maxValue)) continue;
            if (multipleMaxObjects == null) {
                multipleMaxObjects = new ArrayList<LocatedAgent>();
                multipleMaxObjects.add(maxObject);
            }
            multipleMaxObjects.add((LocatedAgent)next);
        }
        if (multipleMaxObjects == null) {
            return maxObject;
        }
        return (LocatedAgent)multipleMaxObjects.get(this.randomToLimit(multipleMaxObjects.size()));
    }

    public final LocatedAgent findMinimumWithin(Coordinate coordinate, DataPoint dataPoint, Conditional condition, boolean includeSelf, double distance) {
        return (LocatedAgent)this.getSpace().findMinimumWithin(coordinate, dataPoint, condition, includeSelf, distance);
    }

    public final LocatedAgent findMaximumWithin(Coordinate coordinate, DataPoint dataPoint, Conditional condition, boolean includeSelf, double distance) {
        return (LocatedAgent)this.getSpace().findMaximumWithin(coordinate, dataPoint, condition, includeSelf, distance);
    }

    public final LocatedAgent findMinimum(Iterator iter, DataPoint dataPoint) {
        ArrayList<LocatedAgent> multipleMinObjects = null;
        double minValue = Double.MAX_VALUE;
        LocatedAgent minObject = null;
        while (iter.hasNext()) {
            Object next = iter.next();
            if (dataPoint.getValue(next) < minValue) {
                minValue = dataPoint.getValue(next);
                minObject = (LocatedAgent)next;
                multipleMinObjects = null;
                continue;
            }
            if (!DataPointConcrete.equals(dataPoint.getValue(next), minValue)) continue;
            if (multipleMinObjects == null) {
                multipleMinObjects = new ArrayList<LocatedAgent>();
                multipleMinObjects.add(minObject);
            }
            multipleMinObjects.add((LocatedAgent)next);
        }
        if (multipleMinObjects == null) {
            return minObject;
        }
        return (LocatedAgent)multipleMinObjects.get(this.randomToLimit(multipleMinObjects.size()));
    }

    public final Iterator withinIterator(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.getSpace().withinIterator(origin, condition, includeSelf, distance);
    }

    public LocatedAgent findMinimum(DataPoint point) {
        return this.findMinimum(this.iterator(), point);
    }

    public LocatedAgent findMaximum(DataPoint point) {
        return this.findMaximum(this.iterator(), point);
    }

    public final LocatedAgent findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        return (LocatedAgent)this.getSpace().findNearest(origin, condition, includeOrigin, distance);
    }

    public final Coordinate findRandomCoordinate() {
        return this.getSpace().findRandomCoordinate();
    }

    public final List findWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.getSpace().findWithin(origin, condition, includeSelf, distance);
    }

    public final int countWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.getSpace().countWithin(origin, condition, includeSelf, distance);
    }

    public final boolean hasWithin(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.getSpace().hasWithin(origin, condition, includeSelf, distance);
    }

    public final boolean isMutable() {
        return this.getSpace().isMutable();
    }

    public String contentsToString() {
        String contents = "";
        Iterator iterator = this.space.iterator();
        while (iterator.hasNext()) {
            Agent agent = (Agent)iterator.next();
            contents = String.valueOf(contents) + agent.toString();
            if (!iterator.hasNext()) continue;
            contents = String.valueOf(contents) + ", ";
        }
        return contents;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.isRoot()) {
            return "Root Scape";
        }
        if (this.prototypeAgent != null) {
            return "Scape of " + this.prototypeAgent.toString() + "(s)";
        }
        return "Scape of agents of unspecified type";
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public Object clone() {
        Scape clone = (Scape)super.clone();
        clone.scapeListeners = new ArrayList();
        for (ScapeListener thisListener : this.scapeListeners) {
            try {
                ScapeListener newListener = (ScapeListener)thisListener.clone();
                this.removeScapeListener(newListener);
                newListener.scapeRemoved(new ScapeEvent(this, -6));
                newListener.scapeAdded(new ScapeEvent(clone, -5));
                clone.addScapeListener(newListener);
            }
            catch (TooManyListenersException e) {
                throw new RuntimeException("Internal error in Scape.clone " + e);
            }
        }
        if (this.prototypeAgent != null) {
            clone.prototypeAgent = (Agent)this.prototypeAgent.clone();
        }
        if (this.rules != null) {
            clone.rules = (VectorSelection)this.rules.clone();
        }
        if (this.initialRules != null) {
            clone.initialRules = (VectorSelection)this.initialRules.clone();
        }
        clone.drawFeatures = (Vector)this.drawFeatures.clone();
        clone.space = (CollectionSpace)this.space.clone();
        return clone;
    }

    public final LocatedAgent findRandom() {
        return (LocatedAgent)this.getSpace().findRandom();
    }

    public Agent findRandom(Location excludeAgent) {
        return (LocatedAgent)this.getSpace().findRandom(excludeAgent);
    }

    public final Agent findRandom(Conditional condition) {
        return (LocatedAgent)this.getSpace().findRandom(condition);
    }

    public synchronized Agent newAgent() {
        return this.newAgent(false);
    }

    public synchronized Agent newAgent(boolean randomLocation) {
        LocatedAgent newAgent = (LocatedAgent)this.getSpace().newLocation(randomLocation);
        LinkedList<LocatedAgent> agents = new LinkedList<LocatedAgent>();
        agents.add(newAgent);
        this.execute(this.getInitialRules().getVector(), agents);
        return newAgent;
    }

    public int size() {
        return this.getSize();
    }

    public final boolean isEmpty() {
        return this.getSpace().isEmpty();
    }

    public final boolean contains(Object o) {
        return this.getSpace().contains(o);
    }

    public final Object[] toArray() {
        return this.getSpace().toArray();
    }

    public final Object[] toArray(Object[] a) {
        return this.getSpace().toArray(a);
    }

    public final boolean containsAll(Collection c) {
        return this.getSpace().containsAll(c);
    }

    public final boolean addAll(Collection c) {
        return this.getSpace().addAll(c);
    }

    public final boolean removeAll(Collection c) {
        return this.getSpace().removeAll(c);
    }

    public final boolean retainAll(Collection c) {
        return this.getSpace().retainAll(c);
    }

    public final void clear() {
        this.getSpace().clear();
    }

    public boolean add(Object a) {
        return this.add(a, true);
    }

    public final boolean add(Object agent, boolean isParent) {
        if (!(agent instanceof Agent)) {
            throw new ClassCastException("Scape collections expect Agents only.");
        }
        boolean success = this.getSpace().add(agent, isParent);
        if (isParent) {
            ((Agent)agent).setScape(this);
        }
        return success;
    }

    public final void add(int index, Object a) {
        this.add(index, a, true);
    }

    public final void add(int index, Object o, boolean isParent) {
        try {
            ((ListSpace)this.getSpace()).add(index, o, isParent);
            if (isParent) {
                ((Agent)o).setScape(this);
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public boolean remove(Object o) {
        return this.space.remove(o);
    }

    public final Object remove(int index) {
        try {
            return ((List)((Object)this.getSpace())).remove(index);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public final LocatedAgent get(Coordinate coordinate) {
        return (LocatedAgent)this.getSpace().get(coordinate);
    }

    public final void set(Coordinate coordinate, LocatedAgent agent, boolean isParent) {
        this.getSpace().set(coordinate, agent);
        if (isParent) {
            agent.setScape(this.getScape());
            agent.setCoordinate(coordinate);
        }
    }

    public void set(Coordinate coordinate, LocatedAgent agent) {
        this.set(coordinate, agent, true);
    }

    public final Object get(int index) {
        try {
            return ((ListBase)this.getSpace()).get(index);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public void set(int index, Object agent) {
        this.set(index, agent, true);
    }

    public void set(int index, Object agent, boolean isParent) {
        try {
            ((ListBase)this.getSpace()).set(index, (LocatedAgent)agent, isParent);
            if (isParent) {
                ((Agent)agent).setScape(this);
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Underlying space is not a list and cannot be accessed randomly.");
        }
    }

    public final ResetableIterator scapeIterator() {
        return this.getSpace().safeIterator();
    }

    public final RandomIterator scapeRandomIterator() {
        return this.getSpace().safeRandomIterator();
    }

    protected final ResetableIterator scapeIterator(int start, int limit) {
        return this.getSpace().safeIterator(start, limit);
    }

    public boolean isPeriodic() {
        return this.getSpace().isPeriodic();
    }

    public void setPeriodic(boolean periodic) {
        this.getSpace().setPeriodic(periodic);
    }

    public Scape getSuperScape() {
        return this.getSpace() instanceof SubSpace ? (Scape)((SubSpace)((Object)this.getSpace())).getSuperSpace().getContext() : null;
    }

    public void setSuperScape(Scape superScape) {
        try {
            ((SubSpace)((Object)this.getSpace())).setSuperSpace(superScape.getSpace());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Underlying scape is no a SubSpace.");
        }
    }

    public final ResetableIterator[] scapeIterators(int count) {
        return this.getSpace().safeIterators(count);
    }

    public boolean isListenersAndMembersCurrent() {
        return this.listenersAndMembersCurrent;
    }

    public final Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
        space.setContext(this);
        space.setRandom(this.getRandom());
    }

    public void setSize(int size) {
        if (this.runner != null && this.runner.isRunning()) {
            throw new RuntimeException("Tried to set size while scape was running");
        }
        this.space.setSize(size);
    }

    public int getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(int threadCount) {
        Scape.threadCount = threadCount;
    }

    public Location getPrototype() {
        return (Location)((Object)this.getPrototypeAgent());
    }

    public boolean isHome(Location a) {
        return ((Agent)((Object)a)).getScape() == this;
    }

    public DataGroup getData() {
        return this.getRunner().getData();
    }

    public AbstractUIEnvironment getUserEnvironment() {
        return this.getUIEnvironment();
    }

    public class ConditionalIterator
    implements Iterator {
        Iterator iter;
        Conditional condition;
        Object next;

        public ConditionalIterator(Iterator iter, Conditional condition) {
            this.iter = iter;
            this.condition = condition;
            this.loadNext();
        }

        private void loadNext() {
            this.next = null;
            while (this.iter.hasNext() && this.next == null) {
                Object o = this.iter.next();
                if (!this.condition.meetsCondition(o)) continue;
                this.next = o;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next != null) {
                Object currentNext = this.next;
                this.loadNext();
                return currentNext;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove from a conditional iterator.");
        }
    }

    public class DrawFeatureObservable
    extends Observable
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void setChanged() {
            super.setChanged();
        }
    }

    class RetrieveAccessorsRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        List accessors;

        public RetrieveAccessorsRule() {
            super("Retrieve Accessors Rule");
        }

        public void execute(Agent agent) {
            try {
                this.accessors.addAll(PropertyAccessor.determineReadWriteAccessors(this, Scape.class, false));
            }
            catch (IntrospectionException e) {
                Scape.this.getEnvironment().getConsole().println("An introspection exception occured while trying to determine model properties: " + e.getMessage());
            }
        }
    }

    class RetrieveAllAccessorsRule
    extends Rule {
        private static final long serialVersionUID = 1L;
        List accessors;

        public RetrieveAllAccessorsRule() {
            super("Retrieve Accessors Rule");
            this.accessors = new ArrayList();
        }

        public void execute(Agent agent) {
            if (((Scape)agent).isMembersActive()) {
                try {
                    this.accessors.addAll(PropertyAccessor.determineReadWriteAccessors(agent, Scape.class, false));
                }
                catch (IntrospectionException e) {
                    Scape.this.getEnvironment().getConsole().println("An introspection exception occured while trying to determine model properties: " + e.getMessage());
                }
            }
        }
    }

    class RetrieveAllScapesRule
    extends PropogateScapeOnly {
        private static final long serialVersionUID = 1L;
        Vector scapes;

        public RetrieveAllScapesRule() {
            super("Retrieve Scapes Rule");
            this.scapes = new Vector();
        }

        public void execute(Agent agent) {
            this.scapes.addElement(agent);
            super.execute(agent);
        }
    }
}

