/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.runtime;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.ascape.model.Scape;
import org.ascape.model.event.ControlEvent;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;
import org.ascape.model.rule.NotifyViews;
import org.ascape.model.space.SpatialTemporalException;
import org.ascape.runtime.AbstractUIEnvironment;
import org.ascape.runtime.RuntimeEnvironment;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.data.DataGroup;

public abstract class Runner
implements Serializable,
Runnable {
    private static final long serialVersionUID = 6924379091134591724L;
    private Scape scape;
    private DataGroup dataGroup;
    private static boolean startOnOpen = true;
    protected transient RuntimeEnvironment environment;
    private String periodName = "Iteration";
    private String description;
    private String HTMLDescription;
    private int startPeriod = 0;
    private int stopPeriod = Integer.MAX_VALUE;
    private int pausePeriod = Integer.MAX_VALUE;
    private String home;
    private int earliestPeriod;
    private int latestPeriod = Integer.MAX_VALUE;
    private List restartingViews = new Vector();
    private int iteration;
    private int period;
    private boolean paused = false;
    private boolean running = false;
    private boolean step = false;
    private boolean closeAndOpenNewRequested = false;
    private boolean closeAndOpenSavedRequested = false;
    private boolean restartRequested = false;
    private boolean closeRequested = false;
    private boolean quitRequested = false;
    private boolean openRequested = false;
    private boolean saveRequested = false;
    private boolean inMainLoop = false;
    private boolean beginningDeserializedRun = false;
    private boolean autoRestart = true;
    private static boolean displayGraphics = true;
    private static boolean serveGraphics = false;
    private static boolean muiltWinEnvironment;
    private Thread modelThread;

    public Runner() {
        this(new RuntimeEnvironment());
    }

    public Runner(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    protected void initialize() {
        this.setInternalRunning(false);
        this.getData().clear();
        this.scape.reseed();
        this.scape.execute(new NotifyViews(-1));
        this.waitForViewsUpdate();
        this.setIteration(0);
        this.setPeriod(this.getStartPeriod());
        this.scape.execute(Scape.INITIALIZE_RULE);
        this.scape.execute(new NotifyViews(-4));
        this.waitForViewsUpdate();
        this.scape.execute(Scape.INITIAL_RULES_RULE);
        this.setInternalRunning(true);
    }

    protected synchronized void runMainLoop() {
        this.inMainLoop = true;
        this.restartRequested = false;
        if (this.beginningDeserializedRun) {
            this.beginningDeserializedRun = false;
            this.saveRequested = false;
            this.initialize();
            this.scape.executeOnRoot(new NotifyViews(5));
            this.waitForViewsUpdate();
            this.scape.reseed();
            this.getEnvironment().getConsole().println("\nNew Random Seed: " + this.scape.getRandomSeed() + "\n");
        } else {
            this.scape.executeOnRoot(Scape.CLEAR_STATS_RULE);
            this.initialize();
            this.scape.executeOnRoot(Scape.COLLECT_STATS_RULE);
            this.scape.executeOnRoot(new NotifyViews(1));
            this.waitForViewsUpdate();
        }
        while (this.running) {
            if (this.scape.isListenersAndMembersCurrent() && (!this.paused || this.step)) {
                this.scape.executeOnRoot(Scape.CLEAR_STATS_RULE);
                ++this.iteration;
                ++this.period;
                if (this.period == this.getPausePeriod() && !this.paused) {
                    this.pause();
                }
                this.scape.executeOnRoot(Scape.EXECUTE_RULES_RULE);
                this.scape.executeOnRoot(Scape.COLLECT_STATS_RULE);
                this.scape.executeOnRoot(new NotifyViews(3));
                this.step = false;
            } else if (this.paused) {
                this.waitForViewsUpdate();
                this.scape.executeOnRoot(new NotifyViews(4));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.period >= this.getStopPeriod()) {
                this.waitForViewsUpdate();
                this.running = false;
                if (this.isAutoRestart()) {
                    this.restartRequested = true;
                }
            }
            if (this.closeAndOpenNewRequested) {
                new Thread((Runnable)this, "Ascape Main Execution Loop"){

                    public void run() {
                        Runner.this.closeAndOpenNewFinally(Runner.this.scape);
                    }
                }.start();
                this.closeAndOpenNewRequested = false;
            }
            if (this.closeAndOpenSavedRequested) {
                new Thread((Runnable)this, "Ascape Main Execution Loop"){

                    public void run() {
                        Runner.this.closeAndOpenSavedFinally(Runner.this.scape);
                    }
                }.start();
                this.closeAndOpenSavedRequested = false;
            }
            if (this.saveRequested) {
                this.waitForViewsUpdate();
                this.saveChoose();
                this.saveRequested = false;
            }
            if (!this.openRequested) continue;
            this.waitForViewsUpdate();
            this.openChoose();
            this.openRequested = false;
        }
        this.scape.executeOnRoot(new NotifyViews(2));
        this.waitForViewsUpdate();
        if (this.restartRequested) {
            this.scape.respondControl(new ControlEvent(this, 2));
        }
        if (this.closeRequested) {
            this.closeFinally();
            this.closeRequested = false;
        }
        if (this.quitRequested) {
            this.quitFinally();
        }
        this.inMainLoop = false;
    }

    public void respondControl(ControlEvent control) {
        switch (control.getID()) {
            case -5: {
                this.close();
                break;
            }
            case -6: {
                this.closeAndOpenNew();
                break;
            }
            case -7: {
                this.closeAndOpenSaved();
                break;
            }
            case -4: {
                this.save();
                break;
            }
            case 2: {
                this.start();
                break;
            }
            case 3: {
                this.stop();
                break;
            }
            case 4: {
                this.setStep(true);
                break;
            }
            case 5: {
                this.restart();
                break;
            }
            case -1: {
                this.pause();
                break;
            }
            case -2: {
                this.resume();
                break;
            }
            case -3: {
                this.quit();
                break;
            }
            default: {
                throw new RuntimeException("Unknown control event sent to Agent scape: " + control + " [" + control.getID() + "]");
            }
        }
    }

    public void waitForViewsUpdate() {
        while (!this.scape.isAllViewsUpdated() && this.inMainLoop) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void closeAndOpenNew() {
        if (this.running) {
            this.closeAndOpenNewRequested = true;
        } else {
            this.closeAndOpenNewFinally(this.scape);
        }
    }

    public void closeAndOpenSaved() {
        if (this.isRunning()) {
            this.setCloseAndOpenNewRequested(true);
        } else {
            new Thread((Runnable)this){

                public void run() {
                    Runner.this.closeAndOpenSavedFinally(Runner.this.getRootScape());
                }
            }.start();
        }
    }

    public void closeAndOpenNewFinally(Scape oldScape) {
        boolean oldWasPaused = oldScape.isPaused();
        if (!oldWasPaused) {
            oldScape.getRunner().pause();
        }
        final String modelName = ((AbstractUIEnvironment)this.environment).openDialog();
        if (!oldWasPaused) {
            oldScape.getRunner().resume();
        }
        if (modelName != null) {
            oldScape.addView(new DefaultScapeListener(){
                private static final long serialVersionUID = 1L;

                public void scapeClosing(ScapeEvent scapeEvent) {
                    Runner.this.openInstance(modelName);
                }
            });
            oldScape.getRunner().close();
        }
    }

    public static Scape openSavedRun(InputStream is) throws IOException {
        Scape newScape = null;
        GZIPInputStream gis = new GZIPInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(gis);
        try {
            newScape = (Scape)ois.readObject();
            ois.close();
            try {
                newScape.setStartPeriod(newScape.getPeriod() + 1);
            }
            catch (SpatialTemporalException spatialTemporalException) {
                try {
                    newScape.setStartPeriod(newScape.getPeriod());
                }
                catch (SpatialTemporalException spatialTemporalException2) {
                    try {
                        newScape.setStartPeriod(newScape.getPeriod());
                    }
                    catch (SpatialTemporalException spatialTemporalException3) {
                        throw new RuntimeException("Internal Error");
                    }
                }
            }
            newScape.getRunner().beginningDeserializedRun = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return newScape;
    }

    public Scape openSavedRun(String fileName, String[] args) throws IOException {
        Scape newScape = this.openSavedRun(new File(fileName));
        if (newScape != null) {
            if (args.length > 0) {
                newScape.assignParameters(args, true);
            }
            newScape.getRunner().createEnvironment();
            if (newScape.isPaused() && newScape.isStartOnOpen()) {
                newScape.getRunner().resume();
            }
            newScape.getRunner().runMainLoop();
        }
        return newScape;
    }

    public Scape openSavedRun(File savedRunFile) throws IOException {
        Scape newScape = null;
        FileInputStream is = new FileInputStream(savedRunFile);
        newScape = Runner.openSavedRun(is);
        return newScape;
    }

    public void testRun() {
        try {
            this.scape.executeOnRoot(Scape.CREATE_RULE);
            this.run();
        }
        catch (RuntimeException e) {
            if (this.scape.getUIEnvironment() != null) {
                this.scape.getUIEnvironment().showErrorDialog(this.scape, e);
            }
            throw e;
        }
    }

    public void save() {
        if (this.scape.isRoot()) {
            this.saveRequested = true;
        } else {
            this.save();
        }
    }

    public synchronized void run() {
        this.run(false);
    }

    public static boolean assignEnvironmentParameters(String[] args) {
        boolean found = args.length == 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String paramName = PropertyAccessor.paramName(arg);
            found = found || Runner.assignEnvironmentParameter(arg, paramName);
            ++n2;
        }
        return found;
    }

    public static boolean assignEnvironmentParameter(String arg, String paramName) {
        boolean found = false;
        if (paramName != null) {
            if (paramName.equalsIgnoreCase("DisplayGraphics")) {
                Runner.setDisplayGraphics(PropertyAccessor.paramValueBoolean(arg));
                found = true;
            } else if (paramName.equalsIgnoreCase("ServeGraphics")) {
                Runner.setServeGraphics(PropertyAccessor.paramValueBoolean(arg));
                found = true;
            } else if (paramName.equalsIgnoreCase("MultiWin")) {
                Runner.setMultiWinEnvironment(PropertyAccessor.paramValueBoolean(arg));
                found = true;
            } else if (paramName.equalsIgnoreCase("RedirectConsole")) {
                AbstractUIEnvironment.setRedirectConsole(PropertyAccessor.paramValueBoolean(arg));
                found = true;
            } else if (paramName.equalsIgnoreCase("ShowNavigator")) {
                AbstractUIEnvironment.setShowNavigator(PropertyAccessor.paramValueBoolean(arg));
                found = true;
            }
        }
        return found;
    }

    public void launch(String[] args) throws IOException {
        if (args.length > 0 && args[0].indexOf("=") == -1) {
            Runner.assignEnvironmentParameters(args);
            String[] argsRem = new String[args.length - 1];
            System.arraycopy(args, 1, argsRem, 0, argsRem.length);
            this.open(args[0], argsRem);
        } else {
            String fileName = null;
            LinkedList<String> argsList = new LinkedList<String>(Arrays.asList(args));
            ListIterator li = argsList.listIterator();
            while (li.hasNext()) {
                String arg = (String)li.next();
                int equalAt = arg.lastIndexOf("=");
                if (equalAt < 1) {
                    this.getEnvironment().getConsole().println("Syntax error in command line: " + arg);
                    continue;
                }
                String paramName = arg.substring(0, equalAt);
                if (!paramName.equalsIgnoreCase("SavedRun")) continue;
                fileName = arg.substring(equalAt + 1);
                li.remove();
            }
            if (fileName != null) {
                this.scape = this.openSavedRun(fileName, argsList.toArray(new String[0]));
            } else {
                this.scape = this.openChoose(args);
                if (this.scape != null) {
                    this.scape.getRunner().createEnvironment();
                } else {
                    System.exit(0);
                }
            }
        }
    }

    public void run(boolean singlethread) {
        if (this.scape.getUIEnvironment() != null && this.scape.getUIEnvironment().getRuntimeMode() == 1) {
            try {
                this.runMainLoop();
            }
            catch (RuntimeException e) {
                this.scape.getUIEnvironment().showErrorDialog(this.scape, e);
            }
        } else {
            this.runMainLoop();
        }
    }

    public void start() {
        if (!this.isRunning()) {
            this.modelThread = new Thread((Runnable)this, "Ascape Main Execution Loop");
            this.modelThread.start();
        } else {
            System.out.println("Warning: Tried to start an already running scape.");
        }
    }

    public void notify(ScapeEvent event, ScapeListener listener) {
        listener.scapeNotification(event);
    }

    public void write(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public void stop() {
        this.setInternalRunning(false);
    }

    public void pause() {
        this.setPaused(true);
    }

    public void resume() {
        this.setPaused(false);
    }

    public void requestRestart() {
        this.restartRequested = true;
    }

    public void restart() {
        if (this.running) {
            this.stop();
            this.restartRequested = true;
        } else {
            this.start();
        }
    }

    public void openImplementation(String[] args, boolean block) {
        try {
            if (args != null) {
                this.scape.assignParameters(args, false);
            }
            this.scape.executeOnRoot(Scape.CREATE_RULE);
            if (args != null) {
                this.scape.assignParameters(args, true);
            }
            if (this.scape.getEnvironment() != null) {
                this.scape.addView(this.scape.getEnvironment());
            }
            this.scape.executeOnRoot(Scape.CREATE_VIEW_RULE);
            this.scape.createViews(args);
            if (Runner.isStartOnOpen()) {
                if (!block) {
                    this.start();
                } else {
                    this.run();
                }
            }
        }
        catch (RuntimeException e) {
            if (this.getEnvironment() instanceof AbstractUIEnvironment) {
                ((AbstractUIEnvironment)this.getEnvironment()).showErrorDialog(this.scape, e);
            }
            throw e;
        }
    }

    public void open(Object applet, String[] args, boolean block) {
        this.openImplementation(args, block);
    }

    public void open(Object applet, String[] args) {
        this.openImplementation(args, false);
    }

    public void open(String[] args, boolean block) {
        this.openImplementation(args, block);
    }

    public void open(String[] args) {
        this.openImplementation(args, false);
    }

    public void open() {
        this.openImplementation(null, false);
    }

    public void open(boolean block) {
        this.openImplementation(null, block);
    }

    public void openSavedChoose() {
        this.closeAndOpenSavedFinally(null);
    }

    public abstract void closeAndOpenSavedFinally(Scape var1);

    public Object instanceFromName(String modelName) {
        Object newObject;
        try {
            newObject = Thread.currentThread().getContextClassLoader().loadClass(modelName).newInstance();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("An error ocurred while attempting to read " + modelName + ": " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("An error ocurred while attempting to read " + modelName + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("An error ocurred while attempting to read " + modelName + ": " + e.getMessage(), e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> c = Class.forName(modelName);
                newObject = c.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't find class: " + modelName);
            }
        }
        return newObject;
    }

    public Scape open(String modelName, Object applet, String[] args, boolean block) {
        return this.open(modelName, args, block);
    }

    public Scape open(String modelName, String[] args) {
        return this.open(modelName, args, false);
    }

    public Scape open(String modelName, String[] args, boolean block) {
        Scape newAgent = (Scape)this.instanceFromName(modelName);
        this.setRootScape(newAgent);
        this.open(args, block);
        return this.getRootScape();
    }

    public Scape open(String modelName, Object applet) {
        return this.open(modelName, null, null, false);
    }

    public Scape open(String modelName, boolean block) {
        return this.open(modelName, null, null, block);
    }

    public Scape openInstance(String modelName) {
        return this.open(modelName, null, new String[0], false);
    }

    public Scape openChoose() {
        return this.openChoose(null);
    }

    public Scape openChoose(String[] args) {
        String modelName = ((AbstractUIEnvironment)this.environment).openDialog();
        Scape scape = null;
        if (modelName != null) {
            scape = this.open(modelName, args);
        }
        return scape;
    }

    public abstract void saveChoose();

    public void close() {
        this.closeRequested = true;
        if (this.running) {
            this.stop();
        } else {
            this.closeFinally();
        }
    }

    public void closeFinally() {
        this.dataGroup = null;
        this.scape.executeOnRoot(new NotifyViews(-2));
        this.waitForViewsUpdate();
    }

    public void quit() {
        if (this.inMainLoop) {
            this.quitRequested = true;
            this.stop();
        } else if (!this.quitRequested) {
            this.quitFinally();
        }
    }

    public void quitFinally() {
        this.closeFinally();
        this.scape.executeOnRoot(new NotifyViews(-3));
        this.waitForViewsUpdate();
        Runner.exit();
    }

    public static void exit() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            System.out.println("Can't quit in this security context. (Scape is probably running in browser or viewer; quit or change that.)");
        }
    }

    public void createEnvironment() {
        if (this.environment == null) {
            this.environment = new RuntimeEnvironment();
        }
    }

    public static boolean isDisplayGraphics() {
        try {
            return displayGraphics && !GraphicsEnvironment.isHeadless();
        }
        catch (HeadlessException headlessException) {
            return false;
        }
    }

    public static void setDisplayGraphics(boolean displayGraphics) {
        Runner.displayGraphics = displayGraphics;
    }

    public static boolean isServeGraphics() {
        return serveGraphics;
    }

    public static void setServeGraphics(boolean serveGraphics) {
        Runner.serveGraphics = serveGraphics;
    }

    public static boolean isMultiWinEnvironment() {
        return muiltWinEnvironment;
    }

    public static void setMultiWinEnvironment(boolean muiltWinEnvironment) {
        Runner.muiltWinEnvironment = muiltWinEnvironment;
    }

    public String getPeriodName() {
        return this.periodName;
    }

    public void setPeriodName(String periodName) {
        this.periodName = periodName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHTMLDescription() {
        return this.HTMLDescription;
    }

    public void setHTMLDescription(String HTMLdescription) {
        this.HTMLDescription = HTMLdescription;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public static boolean isStartOnOpen() {
        return startOnOpen;
    }

    public static void setStartOnOpen(boolean _startOnOpen) {
        startOnOpen = _startOnOpen;
    }

    public void setStartPeriod(int startPeriod) throws SpatialTemporalException {
        if (startPeriod < this.earliestPeriod) {
            throw new SpatialTemporalException("Tried to set start period before earliest period");
        }
        this.startPeriod = startPeriod;
    }

    public int getStopPeriod() {
        return this.stopPeriod;
    }

    public void setStopPeriod(int stopPeriod) throws SpatialTemporalException {
        if (stopPeriod > this.latestPeriod) {
            throw new SpatialTemporalException("Tried to set stop period after latest period");
        }
        this.stopPeriod = stopPeriod;
    }

    public int getPausePeriod() {
        return this.pausePeriod;
    }

    public void setPausePeriod(int pausePeriod) {
        this.pausePeriod = pausePeriod;
    }

    public int getEarliestPeriod() {
        return this.earliestPeriod;
    }

    public void setEarliestPeriod(int earliestPeriod) {
        this.earliestPeriod = earliestPeriod;
        if (this.startPeriod < earliestPeriod) {
            try {
                this.setStartPeriod(earliestPeriod);
            }
            catch (SpatialTemporalException spatialTemporalException) {
                throw new RuntimeException("Internal Logic Error");
            }
        }
    }

    public int getLatestPeriod() {
        return this.latestPeriod;
    }

    public void setLatestPeriod(int latestPeriod) {
        this.latestPeriod = latestPeriod;
        if (this.stopPeriod > latestPeriod) {
            try {
                this.setStopPeriod(latestPeriod);
            }
            catch (SpatialTemporalException spatialTemporalException) {
                throw new RuntimeException("Internal Logic Error");
            }
        }
    }

    public List getRestartingViews() {
        return this.restartingViews;
    }

    public void setRestartingViews(List restartingViews) {
        this.restartingViews = restartingViews;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    public boolean isValidPeriod(int period) {
        return period >= this.earliestPeriod && period <= this.latestPeriod;
    }

    public String getHome() {
        if (this.home == null) {
            this.home = "./";
            try {
                this.home = System.getProperty("ascape.home", this.home);
            }
            catch (SecurityException securityException) {}
        }
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean isBeginningDeserializedRun() {
        return this.beginningDeserializedRun;
    }

    public void setBeginningDeserializedRun(boolean beginningDeserializedRun) {
        this.beginningDeserializedRun = beginningDeserializedRun;
    }

    public boolean isCloseAndOpenNewRequested() {
        return this.closeAndOpenNewRequested;
    }

    public void setCloseAndOpenNewRequested(boolean closeAndOpenNewRequested) {
        this.closeAndOpenNewRequested = closeAndOpenNewRequested;
    }

    public boolean isCloseAndOpenSavedRequested() {
        return this.closeAndOpenSavedRequested;
    }

    public void setCloseAndOpenSavedRequested(boolean closeAndOpenSavedRequested) {
        this.closeAndOpenSavedRequested = closeAndOpenSavedRequested;
    }

    public boolean isCloseRequested() {
        return this.closeRequested;
    }

    public void setCloseRequested(boolean closeRequested) {
        this.closeRequested = closeRequested;
    }

    public boolean isInMainLoop() {
        return this.inMainLoop;
    }

    public void setInMainLoop(boolean inMainLoop) {
        this.inMainLoop = inMainLoop;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public boolean isOpenRequested() {
        return this.openRequested;
    }

    public void setOpenRequested(boolean openRequested) {
        this.openRequested = openRequested;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public boolean isQuitRequested() {
        return this.quitRequested;
    }

    public void setQuitRequested(boolean quitRequested) {
        this.quitRequested = quitRequested;
    }

    public boolean isRestartRequested() {
        return this.restartRequested;
    }

    public void setRestartRequested(boolean restartRequested) {
        this.restartRequested = restartRequested;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void setInternalRunning(boolean running) {
        this.running = running;
    }

    public boolean isSaveRequested() {
        return this.saveRequested;
    }

    public void setSaveRequested(boolean saveRequested) {
        this.saveRequested = saveRequested;
    }

    public boolean isStep() {
        return this.step;
    }

    public void setStep(boolean step) {
        this.step = step;
    }

    public DataGroup getData() {
        return this.dataGroup;
    }

    public void setRootScape(Scape scape) {
        this.scape = scape;
        scape.setRunner(this);
        this.dataGroup = new DataGroup();
        this.dataGroup.setScape(scape);
    }

    public Scape getRootScape() {
        return this.scape;
    }

    public void setEnvironment(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public Thread getModelThread() {
        return this.modelThread;
    }
}

