/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.EventDispatcher3D;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.ConnectionLayerFactory;
import org.eclipse.draw3d.DummyGraphics;
import org.eclipse.draw3d.Figure3DFriend;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.PickingUpdateManager3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.VoidSurface;
import org.eclipse.draw3d.camera.FirstPersonCamera;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.ICameraListener;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.NullPosition3D;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.ParaxialBoundingBoxImpl;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DImpl;
import org.eclipse.draw3d.geometry.Transformable;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.draw3d.util.DebugPrimitives;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.widgets.Canvas;

public class LightweightSystem3D
extends LightweightSystem
implements ICameraListener,
DisposeListener,
IScene {
    private static final Logger log = Logger.getLogger(LightweightSystem3D.class.getName());
    private ICamera m_camera;
    protected GLCanvas m_canvas;
    private final float[] m_clearColor = new float[]{0.6f, 0.6f, 0.6f, 1.0f};
    private boolean m_debug = false;
    private boolean m_drawAxes;
    private List<ISceneListener> m_listeners;
    private RenderContext m_renderContext;

    public void addSceneListener(ISceneListener i_listener) {
        if (i_listener != null && !this.m_listeners.contains(i_listener)) {
            this.m_listeners.add(i_listener);
        }
    }

    public void cameraChanged() {
        this.render(false);
    }

    protected void controlResized() {
        super.controlResized();
        this.updateViewport();
    }

    protected LightweightSystem.RootFigure createRootFigure() {
        RootFigure3D f = new RootFigure3D();
        f.addNotify();
        f.setOpaque(true);
        f.setLayoutManager((LayoutManager)new StackLayout());
        return f;
    }

    public ICamera getCamera() {
        return this.m_camera;
    }

    protected EventDispatcher getEventDispatcher() {
        return super.getEventDispatcher();
    }

    public Picker getPicker() {
        return this.getUpdateManager3D().getPicker();
    }

    public RenderContext getRenderContext() {
        return this.m_renderContext;
    }

    public PickingUpdateManager3D getUpdateManager3D() {
        return (PickingUpdateManager3D)this.getUpdateManager();
    }

    protected void init() {
        this.m_listeners = new ArrayList<ISceneListener>();
        this.m_renderContext = new RenderContext();
        this.setUpdateManager((UpdateManager)new PickingUpdateManager3D(this));
        this.setCamera(new FirstPersonCamera());
        super.init();
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void removeSceneListener(ISceneListener i_listener) {
        if (i_listener != null && this.m_listeners.contains(i_listener)) {
            this.m_listeners.remove(i_listener);
        }
    }

    public void render(boolean i_redraw2d) {
        if (i_redraw2d) {
            this.m_renderContext.setRedraw2DContent();
        }
        this.getUpdateManager().addInvalidFigure(this.getRootFigure());
        this.getUpdateManager().performUpdate();
    }

    public void setBackgroundColor(Color i_backgroundColor) {
        ColorConverter.toFloatArray(i_backgroundColor, 1, this.m_clearColor);
    }

    public void setCamera(ICamera i_camera) {
        if (i_camera != this.m_camera) {
            if (this.m_camera != null) {
                this.m_camera.transferListeners(i_camera);
            } else {
                i_camera.addCameraListener(this);
            }
            for (ISceneListener listener : this.m_listeners) {
                listener.cameraChanged(this.m_camera, i_camera);
            }
            this.m_camera = i_camera;
            this.updateViewport();
        }
    }

    public void setControl(Canvas i_canvas) {
        if (!(i_canvas instanceof GLCanvas)) {
            throw new IllegalArgumentException("Control of LWS3D must be a GLCanvas, was " + i_canvas);
        }
        GLCanvas glCanvas = (GLCanvas)i_canvas;
        this.m_renderContext.setCanvas(glCanvas);
        PickingUpdateManager3D updateManager = this.getUpdateManager3D();
        updateManager.setCanvas(glCanvas);
        this.m_canvas = glCanvas;
        super.setControl(i_canvas);
        updateManager.setGraphicsSource(new GraphicsSource(){
            Graphics graphics = new DummyGraphics();

            public void flushGraphics(Rectangle i_region) {
            }

            public Graphics getGraphics(Rectangle i_region) {
                return this.graphics;
            }
        });
    }

    public void setDebug(boolean i_debug) {
        this.m_debug = i_debug;
    }

    public void setDrawAxes(boolean i_drawAxes) {
        this.m_drawAxes = i_drawAxes;
    }

    public void setEventDispatcher(EventDispatcher i_dispatcher) {
        EventDispatcher dispatcher = i_dispatcher;
        if (!(dispatcher instanceof EventDispatcher3D)) {
            dispatcher = new EventDispatcher3D(dispatcher, this);
        }
        super.setEventDispatcher(dispatcher);
    }

    public void setFontAntialias(IScene.FontAntialias i_antialias) {
        switch (i_antialias) {
            case ON: {
                this.m_renderContext.getGraphics3D().setProperty("fontAntialias", Boolean.toString(true));
                break;
            }
            case OFF: {
                this.m_renderContext.getGraphics3D().setProperty("fontAntialias", Boolean.toString(false));
                break;
            }
            default: {
                this.m_renderContext.getGraphics3D().setProperty("fontAntialias", null);
            }
        }
    }

    public void setUpdateManager(UpdateManager i_um) {
        ISceneListener listener;
        if (this.getUpdateManager() instanceof ISceneListener) {
            listener = (ISceneListener)this.getUpdateManager();
            this.removeSceneListener(listener);
        }
        super.setUpdateManager(i_um);
        if (i_um instanceof ISceneListener) {
            listener = (ISceneListener)i_um;
            this.addSceneListener(listener);
        }
    }

    private void updateViewport() {
        if (this.m_canvas == null || this.m_camera == null) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle bounds = this.m_canvas.getBounds();
        this.m_camera.setViewport(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void widgetDisposed(DisposeEvent i_e) {
        this.getRenderContext().dispose();
    }

    static /* synthetic */ List access$1(LightweightSystem3D lightweightSystem3D) {
        return lightweightSystem3D.m_listeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RootFigure3D
    extends LightweightSystem.RootFigure
    implements IFigure3D {
        private static final String DL_AXES = "coordinate_axes";
        private final Figure3DHelper helper;
        private ParaxialBoundingBox m_paraxialBounds;
        private ISurface m_surface;
        private Position3DImpl universe;

        RootFigure3D() {
            super((LightweightSystem)LightweightSystem3D.this);
            this.m_surface = new VoidSurface(this, LightweightSystem3D.this, 0.1f);
            this.universe = new NullPosition3D((IHost3D)this);
            this.helper = new Figure3DHelper(new Figure3DFriend(this){

                public Font getLocalFont() {
                    return RootFigure3D.this.getLocalFont();
                }

                public boolean is2DContentDirty() {
                    return false;
                }
            });
        }

        @Override
        public void collectRenderFragments(RenderContext i_renderContext) {
        }

        private void drawCoordinateAxes() {
            RenderContext renderContext = this.getRenderContext();
            DisplayListManager displayListManager = renderContext.getGraphics3D().getDisplayListManager();
            if (!displayListManager.isDisplayList(new Object[]{DL_AXES})) {
                displayListManager.createDisplayList((Object)DL_AXES, new Runnable(){

                    public void run() {
                        int length = 1000;
                        int x = 0;
                        int y = 0;
                        int z = 0;
                        Graphics3D g3d = RootFigure3D.this.getRenderContext().getGraphics3D();
                        g3d.glLineWidth(1.0f);
                        float c = 0.5882353f;
                        float a = 0.7f;
                        g3d.glBegin(1);
                        g3d.glColor4f(c, 0.0f, 0.0f, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)(x + length), (float)y, (float)z);
                        g3d.glColor4f(0.0f, c, 0.0f, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)x, (float)(y + length), (float)z);
                        g3d.glColor4f(0.0f, 0.0f, c, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)x, (float)y, (float)(z + length));
                        g3d.glEnd();
                        g3d.glLineStipple(1, (short)85);
                        g3d.glEnable(2852);
                        g3d.glBegin(1);
                        g3d.glColor4f(c, 0.0f, 0.0f, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)(x - length), (float)y, (float)z);
                        g3d.glColor4f(0.0f, c, 0.0f, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)x, (float)(y - length), (float)z);
                        g3d.glColor4f(0.0f, 0.0f, c, a);
                        g3d.glVertex3f((float)x, (float)y, (float)z);
                        g3d.glVertex3f((float)x, (float)y, (float)(z - length));
                        g3d.glEnd();
                        g3d.glDisable(2852);
                    }
                });
            }
            displayListManager.executeDisplayList((Object)DL_AXES);
        }

        public IFigure findFigureAt(int i_x, int i_y, TreeSearch i_search) {
            return this.helper.findFigureAt(i_x, i_y, i_search);
        }

        public IFigure findMouseEventTargetAt(int i_sx, int i_sy) {
            Picker picker = this.getScene().getPicker();
            ISurface surface = picker.getCurrentSurface();
            return surface.findFigureAt(i_sx, i_sy, null);
        }

        @Override
        public int getAlpha() {
            return -1;
        }

        @Override
        public IFigure3D getAncestor3D() {
            return null;
        }

        @Override
        public IBoundingBox getBounds3D() {
            return null;
        }

        @Override
        public List<IFigure> getChildren2D() {
            return this.helper.getChildren2D();
        }

        @Override
        public List<IFigure3D> getChildren3D() {
            return this.helper.getChildren3D();
        }

        @Override
        public ConnectionLayer getConnectionLayer(ConnectionLayerFactory i_clfactory) {
            return null;
        }

        @Override
        public List<IFigure3D> getDescendants3D() {
            return this.helper.getDescendants3D(true);
        }

        @Override
        public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
            return Float.NaN;
        }

        @Override
        public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
            ParaxialBoundingBox paraxialBoundingBox;
            ParaxialBoundingBox result = o_result;
            if (o_result == null) {
                result = new ParaxialBoundingBoxImpl();
            }
            Vector3f location = Draw3DCache.getVector3f();
            Vector3f size = Draw3DCache.getVector3f();
            try {
                if (this.m_paraxialBounds == null) {
                    this.m_paraxialBounds = new ParaxialBoundingBoxImpl();
                    this.helper.unionWithChildParaxialBounds(this.m_paraxialBounds);
                }
                this.m_paraxialBounds.getLocation(location);
                this.m_paraxialBounds.getSize(size);
                result.setLocation((IVector3f)location);
                result.setSize((IVector3f)size);
                paraxialBoundingBox = result;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            return paraxialBoundingBox;
        }

        public IHost3D getParentHost3D() {
            return this.getAncestor3D();
        }

        public Position3D getPosition3D() {
            return this.universe;
        }

        @Override
        public IVector3f getPreferredSize3D() {
            return null;
        }

        @Override
        public RenderContext getRenderContext() {
            return LightweightSystem3D.this.m_renderContext;
        }

        @Override
        public IScene getScene() {
            return LightweightSystem3D.this;
        }

        @Override
        public ISurface getSurface() {
            return this.m_surface;
        }

        public void invalidate() {
            this.invalidateParaxialBoundsTree();
            super.invalidate();
        }

        @Override
        public void invalidateParaxialBounds() {
            this.m_paraxialBounds = null;
        }

        @Override
        public void invalidateParaxialBoundsTree() {
            this.helper.invalidateParaxialBoundsTree();
        }

        /*
         * Unable to fully structure code
         */
        public void paint(Graphics i_graphics) {
            renderContext = this.getRenderContext();
            renderContext.setScene(LightweightSystem3D.this);
            graphics = i_graphics;
            if (!(graphics instanceof DummyGraphics)) {
                graphics = new DummyGraphics();
            }
            try {
                for (ISceneListener listener : LightweightSystem3D.access$1(LightweightSystem3D.this)) {
                    listener.renderPassStarted(this.getRenderContext());
                }
                this.prepareRender(renderContext);
                this.paintBorder(graphics);
                this.paintClientArea(graphics);
                renderContext.renderFragments();
            }
            finally {
                ** for (listener : LightweightSystem3D.access$1((LightweightSystem3D)LightweightSystem3D.this))
            }
lbl-1000:
            // 1 sources

            {
                listener.renderPassFinished(this.getRenderContext());
                continue;
            }
lbl19:
            // 1 sources

            renderContext.clear();
        }

        protected final void paintBorder(Graphics i_graphics) {
            this.helper.paintBorder(i_graphics);
        }

        protected final void paintChildren(Graphics i_graphics) {
            this.helper.paintChildren(i_graphics);
        }

        protected void paintFigure(Graphics i_graphics) {
            this.helper.paintFigure(i_graphics);
        }

        public void positionChanged(EnumSet<IPosition3D.PositionHint> i_hint, IVector3f i_delta) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("positionChanged on root figure, this must not happen");
            }
        }

        protected void prepareRender(RenderContext i_renderContext) {
            i_renderContext.activate();
            Graphics3D g3d = this.getRenderContext().getGraphics3D();
            g3d.glClearColor(LightweightSystem3D.this.m_clearColor[0], LightweightSystem3D.this.m_clearColor[1], LightweightSystem3D.this.m_clearColor[2], LightweightSystem3D.this.m_clearColor[3]);
            g3d.glClear(16640);
            LightweightSystem3D.this.m_camera.render(i_renderContext);
            if (LightweightSystem3D.this.m_drawAxes) {
                this.drawCoordinateAxes();
            }
            if (LightweightSystem3D.this.isDebug() && DebugPrimitives.hasInstance()) {
                DebugPrimitives.getInstance().render(i_renderContext);
            }
        }

        public void revalidate() {
            super.revalidate();
            this.helper.revalidate();
        }

        @Override
        public void setAlpha(int i_alpha) {
        }

        @Override
        public void setBounds(Rectangle i_rect) {
            super.setBounds(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        @Override
        public void setPreferredSize3D(IVector3f i_preferredSize3D) {
        }

        @Override
        public void transformFromParent(Transformable i_transformable) {
        }

        @Override
        public void transformToAbsolute(Transformable i_transformable) {
        }

        @Override
        public void transformToParent(Transformable i_transformable) {
        }

        @Override
        public void transformToRelative(Transformable i_transformable) {
        }
    }
}

