/**
 * <copyright>
 *
 * Copyright (c) 2007-2009 Metascape, LLC
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Metascape - Initial development and maintenance
 *
 * </copyright>
 */
package org.eclipse.amp.amf.ide.ascape;

import java.util.List;

import org.eclipse.amp.amf.gen.ide.DocumentModelBuilder;
import org.eclipse.amp.amf.gen.ide.GenIDEPlugin;
import org.eclipse.amp.amf.gen.ide.PluginTemplateProjectWizard;
import org.eclipse.jdt.core.JavaCore;

public class AscapeProjectWizard extends PluginTemplateProjectWizard {

    public String getProjectTypeName() {
        return "MetaABM for Ascape";
    }

    @Override
    public String[] getNatures() {
        return new String[] { JavaCore.NATURE_ID, "org.eclipse.pde.PluginNature" };
    }

    public String getPluginID() {
        return AscapeIDEActivator.PLUGIN_ID;
    }

    public void addBuilders(List<String> builderIDs) {
        builderIDs.add(AscapeIDEActivator.PLUGIN_ID + "." + AscapeModelBuilder.ASCAPE_BUILDER_ID);
        builderIDs.add(GenIDEPlugin.PLUGIN_ID + "." + DocumentModelBuilder.DOCUMENT_BUILDER_ID);
        super.addBuilders(builderIDs);
    }

    public String getSourceDirName() {
        return "srcgen";
    }
}
