/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util.converter;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ConversionPolicy;
import org.eclipse.draw3d.util.converter.ConversionPolicySpecs;
import org.eclipse.draw3d.util.converter.ImageInfo;
import org.eclipse.draw3d.util.converter.ImageToLuminanceAlphaPolicy;
import org.eclipse.draw3d.util.converter.ImageToRgbaPolicy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageConverter {
    private static final ImageConverter INSTANCE = new ImageConverter();
    private Map<ConversionPolicySpecs, ConversionPolicy> m_policies = new HashMap<ConversionPolicySpecs, ConversionPolicy>();

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    private ImageConverter() {
        this.registerPolicy(new ImageToRgbaPolicy());
        this.registerPolicy(new ImageToLuminanceAlphaPolicy());
    }

    public Image bufferToImage(ColorBufferInfo i_bufferInfo, ByteBuffer i_buffer, ImageInfo i_imageInfo) {
        int depth;
        int dataType;
        if (i_bufferInfo == null) {
            throw new NullPointerException("i_info must not be null");
        }
        if (i_buffer == null) {
            throw new NullPointerException("i_buffer must not be null");
        }
        if (i_imageInfo == null) {
            throw new NullPointerException("i_imageInfo must not be null");
        }
        ConversionPolicySpecs.ConversionDirection direction = ConversionPolicySpecs.ConversionDirection.BUFFER_TO_IMAGE;
        int pixelFormat = i_bufferInfo.getPixelFormat();
        ConversionPolicySpecs specs = new ConversionPolicySpecs(direction, pixelFormat, dataType = i_bufferInfo.getDataType(), depth = i_imageInfo.getDepth());
        ConversionPolicy policy = this.m_policies.get(specs);
        if (policy == null) {
            throw new IllegalArgumentException("no conversion policy registered for " + policy);
        }
        throw new UnsupportedOperationException();
    }

    public void dump(ImageData i_imageData, String i_directory, String i_fileName, int i_fileType) {
        File dirFile;
        if (i_imageData == null) {
            throw new NullPointerException("i_imageData must not be null");
        }
        if (i_fileName == null) {
            throw new NullPointerException("i_fileName must not be null");
        }
        String fileName = i_fileName.trim();
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("invalid filename: " + i_fileName);
        }
        String directory = i_directory;
        if (directory == null) {
            directory = System.getProperty("user.home");
        }
        if (!(dirFile = new File(directory)).exists() && !dirFile.mkdirs()) {
            throw new IllegalArgumentException("could not create directory " + dirFile);
        }
        File filePath = new File(dirFile, fileName);
        if (filePath.exists() && !filePath.delete()) {
            throw new IllegalArgumentException("could not delete file " + filePath);
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{i_imageData};
        imageLoader.save(filePath.toString(), i_fileType);
    }

    public ByteBuffer imageToBuffer(Image i_image, ColorBufferInfo i_info, ByteBuffer io_buffer, boolean i_flip) {
        if (i_image == null) {
            throw new NullPointerException("i_image must not be null");
        }
        if (i_info == null) {
            throw new NullPointerException("i_info must not be null");
        }
        ConversionPolicySpecs.ConversionDirection direction = ConversionPolicySpecs.ConversionDirection.IMAGE_TO_BUFFER;
        int pixelFormat = i_info.getPixelFormat();
        int dataType = i_info.getDataType();
        ImageData imageData = i_image.getImageData();
        int depth = imageData.depth;
        ConversionPolicySpecs specs = new ConversionPolicySpecs(direction, pixelFormat, dataType, depth);
        ConversionPolicy policy = this.m_policies.get(specs);
        if (policy == null) {
            throw new IllegalArgumentException("no conversion policy registered for " + policy);
        }
        return policy.toBuffer(i_info, imageData, io_buffer, i_flip);
    }

    public void registerPolicy(ConversionPolicy i_policy) {
        if (i_policy == null) {
            throw new NullPointerException("i_policy must not be null");
        }
        ConversionPolicySpecs[] conversionPolicySpecsArray = i_policy.getSpecs();
        int n = conversionPolicySpecsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConversionPolicySpecs spec = conversionPolicySpecsArray[n2];
            this.m_policies.put(spec, i_policy);
            ++n2;
        }
    }
}

