/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.gen.util;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.JavaConventions;
import org.metaabm.SImplementation;
import org.metaabm.impl.SImplementationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtils {
    public static String timestamp() {
        Date time = new Date();
        return String.valueOf(DateFormat.getDateInstance(2).format(time)) + " " + DateFormat.getTimeInstance(1).format(time);
    }

    public static int timesec() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return c.get(13);
    }

    public static String timelapse(Integer start) {
        return String.valueOf(GeneratorUtils.timesec() - start) + " sec";
    }

    public static String getPackageLocation(EObject obj) {
        SImplementation impl = (SImplementation)obj;
        return SImplementationImpl.addDir((String)SImplementationImpl.addDir((String)impl.getDerivedPath(), (String)impl.getDerivedSrcDir()), (String)impl.getPackagePath());
    }

    public static List<EStructuralFeature> getMissingFeatures(EObject object) {
        ArrayList<EStructuralFeature> missing = new ArrayList<EStructuralFeature>();
        EClass referenceClass = object.eClass();
        for (EStructuralFeature feature : referenceClass.getEStructuralFeatures()) {
            if (!feature.isRequired() || object.eGet(feature) != null) continue;
            System.out.println(feature);
            System.out.println(object.eGet(feature));
            missing.add(feature);
        }
        return missing;
    }

    public static final List<String> getMissingNames(EObject object) {
        ArrayList<String> missing = new ArrayList<String>();
        EClass referenceClass = object.eClass();
        for (EStructuralFeature feature : referenceClass.getEStructuralFeatures()) {
            if (!feature.isRequired() || object.eGet(feature) != null) continue;
            missing.add(feature.getName());
        }
        return missing;
    }

    public static final boolean isValidID(String id) {
        return GeneratorUtils.validateID(id).isOK();
    }

    public static final void workItemDone(IProgressMonitor monitor) {
        monitor.worked(1);
    }

    public static final void workName(IProgressMonitor monitor, String name) {
        monitor.setTaskName(name);
    }

    public static final void workBegin(IProgressMonitor monitor, String name, Integer count) {
        monitor.beginTask(name, count.intValue());
    }

    public static final void workRemaining(IProgressMonitor monitor, Integer count) {
        ((SubMonitor)monitor).setWorkRemaining(count.intValue());
    }

    private static final IStatus validateID(String id) {
        return JavaConventions.validateIdentifier((String)id, (String)"1.5", (String)"1.5");
    }
}

